
#ifndef IIRSCRAM_CONTRIBUTION_ATTRIBUTE_HH
#define IIRSCRAM_CONTRIBUTION_ATTRIBUTE_HH

// Copyright (c) 2002-2003 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Author: Harish Venkataramani venkath@ececs.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_ContributionAttribute.hh"

template <class type> class dl_list;

class IIR_ContributionAttribute;

/** The extension base for contribution attribute of terminals
    (T'contribution).  This class describes T'Contribution. For a terminal
    T, the attribute T'Contribution yields a through quantity, whose plus
    terminal is T and whose minus terminal is the reference terminal of
    nature of T. */
class IIRScram_ContributionAttribute : public IIRBase_ContributionAttribute {

public:

  /** @name Method for publishing VHDL code. */
  void _publish_vhdl(ostream &);
  
  /** @name C++ publishing methods.  These methods relate to the publishing
      of C++.*/
  void _publish_cc_lvalue( published_file &_cc_out );

 /** Uses the index assigned to each quantity and publishes the quantities
     present in the simultaneous statement. */
  void _publish_cc_ams_function(published_file &);
  
  /** This returns an IIR_TextLiteral when a Contribution attribute is
    instantiated. */
  IIR_TextLiteral *_build_attribute_name();

  /** Returns a pointer to the Quantity created by the build free quantity
     declaration. */
  IIR_Declaration *_get_implicit_declaration( const string & , IIR_TypeDefinition * );
  
  /** Adds the implicit quantity declaration to the symbol table
      cgen_arch_sym_tab */
  void _set_stmt_qty_index(IIR_Int32 *, set<IIR_Declaration> *);
  
  /** Returns the "through" type of the nature of the terminal. The
      implicit quantity is of the through type of the nature of terminal
      T. */
  IIR_TypeDefinition *get_subtype();
  
  /** Checks if a T'contribution is found in a Simultaneous Statement. If
      so, an implicit quantity has to be created. */
  IIR_Boolean _contribution_quantity_found();

  /** If one or more T'contribution is present in a Simultaneous Statement,
      a free quantity is implicitly created for each and all such
      quantities are appended to a list. */
  void _build_contribution_quantity_list(dl_list<IIR_ContributionAttribute>*);
  
protected:
  IIRScram_ContributionAttribute() {}
  virtual ~IIRScram_ContributionAttribute() = 0;
  
private:
  
};
#endif

