#ifndef IIRSCRAM_PACKAGE_BODY_DECLARATION_HH
#define IIRSCRAM_PACKAGE_BODY_DECLARATION_HH
// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIRBase_PackageBodyDeclaration.hh"

class IIRScram_PackageBodyDeclaration : public IIRBase_PackageBodyDeclaration {

public:

  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl_decl(ostream &);

  void _publish_cc();
  void _publish_cc_elaborate(){}
  void _publish_cc_hh_file();
  void _publish_cc_cc_file();

  void _publish_cc_headers( published_file &_cc_out );
  void _publish_cc_package_name( ostream & );
  void _publish_cc_binding_name( ostream & );
  void _publish_cc_include_decls_prefix( ostream & );
  /**
     Not needed for package bodies.
  */
  void _publish_cc_include_decls( published_file & ){}

  /**
     No elaboration is needed for package bodies.
   */
  void _publish_cc_include_elab( published_file & ){}

  declaration_type _get_type();
  
  IIR_Boolean _is_secondary_unit(){ return TRUE; }
  IIR_Boolean _is_iir_package_body_declaration(){ return TRUE; }

protected:
  IIRScram_PackageBodyDeclaration();
  virtual ~IIRScram_PackageBodyDeclaration() = 0;
    
private:
  /** Returns a string, allocated with new, with the base of the filename
      for CC publishing this node. */
  const string _get_cc_filename();
};
#endif
