/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2003 Ron Steinke <rsteinke@w-link.net>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#ifndef _WFTK_FILLER_H
#define _WFTK_FILLER_H

#include <wftk/screenarea.h>

namespace wftk {
    
/** Filler Class.
 *
 * Used to create empty space in a UI that can maintain its
 * relative size if a resize event occurs.
 */
class Filler : public ScreenArea
{
 public:
  /// Orientation sets the direction that we are filling.  Options are \c HORIZONTAL,
  /// \c VERTICAL, \c BOTH.
  enum Orientation {
   HORIZONTAL = 1 << 0,
   VERTICAL = 1 << 1,
   BOTH = HORIZONTAL | VERTICAL
  };

  /** constructor
   *
   * \param o Orientation of this Filler (from enum, above)
   * \param min_size Minimum size of this Filler in pixels
   * \param weight Sets the precedence when multiple fillers used
   */
  explicit Filler(Orientation o, Uint16 min_size = 0,
	unsigned char weight = PackingInfo::Expander::FILL)
	: orient_(o), min_(min_size), weight_(weight)
	{setPackingInfo();}

 protected:
  virtual void setPackingInfo()
  {
    // set defaults
    ScreenArea::setPackingInfo();

    if(orient_ & HORIZONTAL) {
      packing_info_.x.filler = weight_;
      packing_info_.x.min = min_;
      packing_info_.x.pref = min_;
    }
    if(orient_ & VERTICAL) {
      packing_info_.y.filler = weight_;
      packing_info_.y.min = min_;
      packing_info_.y.pref = min_;
    }
  }

 private:
  Orientation orient_;
  Uint16 min_;
  unsigned char weight_;
};

} // namespace wftk

#endif // _WFTK_FILLER_H
