/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2002 Malcolm Walker <malcolm@worldforge.org>
  Based on code copyright  (C) 1999-2002  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#ifndef WFTK_SDL_HANDLER_H
#define WFTK_SDL_HANDLER_H

#include <SDL/SDL_events.h>

#include <wftk/refobj.h>
#include <wftk/application.h>
#include <wftk/marshal.h>

namespace wftk {

/// a fatal error generated by SDL's behavior (usually out of memory)
class SDLFatal : public Fatal
{
 public:
  /// constructor takes a reason, to which will be appended the SDL error message
  SDLFatal(const std::string& reason);
  virtual ~SDLFatal() throw() {}

  /// the error message returned by SDL_GetError()
  const std::string& error() const throw() {return sdl_error_;}

 private:
  std::string sdl_error_;
};

// SDLEvent might be a better name, but we already have
// SDL_Event, and it would be confusing
/// SDL_Event wrapper class
class SDLHandler : public Application::Event
{
 public:
  /// wrap an SDL_Event
  SDLHandler(const SDL_Event&);

  /// emit this event
  virtual void operator()();

  /// poll SDL for events to add to the queue
  static void queueEvents();

  /// unhandled user event
  static SigC::Signal1<bool,const SDL_UserEvent&,BoolMarshal> userEvent;

 private:
  SDL_Event event_;
};

} // namespace

#endif // WFTK_SDL_HANDLER_H
