// part of KSUDOKU - by Francesco Rossi <redsh@email.it> 2005

#ifndef _KSUDOKU_H_
#define _KSUDOKU_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapplication.h>
#include <kmainwindow.h>

#include "ksudokuview.h"
#include "glwindow.h"


class KPrinter;
class KURL;

/**
 * This class serves as the main window for ksudoku.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author Francesco Rossi <redsh@email.it>
 * @version 0.3
 */
class ksudoku : public KMainWindow
{
    Q_OBJECT
public:
	int order;
	int difficulty;
	int type;
	int simmetry;
	glWindow* glwin;
	bool donebyhimself;
	void checkCompleted();
public:
    /**
     * Default Constructor
     */
    ksudoku(bool dub = false, bool load = false, KURL path = "");

    /**
     * Default Destructor
     */
    virtual ~ksudoku();

    /**
     * Use this method to load whatever file/URL you have
     */
	void load(const KURL& url);

protected:
    /**
     * Overridden virtuals for Qt drag 'n drop (XDND)
     */
    virtual void dragEnterEvent(QDragEnterEvent *event);
    virtual void dropEvent(QDropEvent *event);

protected:
    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */
    void saveProperties(KConfig *);

    /**
     * This function is called when this app is restored.  The KConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    void readProperties(KConfig *);


private slots:
	void push();
	void pop();
    void fileNew();
    void fileOpen();
    void fileSave();
    void fileSaveAs();
    void filePrint();

	void giveHint();
	void autoSolve();
	void dubPuzzle();
	void genMultiple();
	
	void set0();
	void set1();
	void set2();
	void set3();
	void set4();
	void set5();
	void set6();
	void set7();
	void set8();
	void set9();
	void set10();
	void set11();
	void set12();
	void set13();
	void set14();
	void set15();
	void set16();

	void set17();
	void set18();
	void set19();
	void set20();
	void set21();
	void set22();
	void set23();
	void set24();
	void set25();
	
    void optionsPreferences();
	void setShowTracker();
    void changeStatusbar(const QString& text);
    void changeCaption(const QString& text);
	
	//web
	void checkForUpdates();
	void homepage();
	void support();
	void sendComment();
	//settings
	void mouseOnlySuperscript();
	void setGuidedMode();

	void updateStatusBar();
private:
    void setupAccel();
    void setupActions();
public:
	QTime t;
private:
    ksudokuView *m_view;
	bool dub;

	KURL myURL;
    KPrinter   *m_printer;
};

#endif // _KSUDOKU_H_

