// vs_multiplex.h                       (This is -*-c++-*-)
// Copyright 1999,2000 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  This file defines a widget with the behavior of the old vscreen class.
//  In essence, this widget can multiplex multiple sub-widgets.  When a
// subwidget emits the "hide" signal, the vscreen does what vscreen_hide()
// used to do.  "shown" is actually emitted by a vscreen when a particular
// subwidget becomes visible.  (strange but true)
// (you can no longer show/hide at a particular point in the stack, at least
//  not right now.  I don't think there's much point)

#ifndef VSMULTIPLEX_H
#define VSMULTIPLEX_H

#include "curses++.h"
#include "vs_passthrough.h"

#include <assert.h>

#include <list>

class vs_multiplex:public vs_passthrough
{
  std::list<vscreen_widget *> children;

  std::list<vscreen_widget *>::iterator visible_child;

  void show_widget(vscreen_widget *widget);
  // Used to bring a widget to the front
  void hide_widget(vscreen_widget *widget);
  // Used to hide a widget

  void got_focus();
  void lost_focus();
protected:
  bool winavail() {return get_win();}
public:
  vs_multiplex();
  virtual ~vs_multiplex();

  size size_request();
  void layout_me();

  virtual vscreen_widget *get_focus();
  vscreen_widget *visible_widget();
  unsigned int num_children();
  // Returns the number of widgets in the multiplexer.
  unsigned int num_visible();

  virtual void paint();
  void dispatch_mouse(short id, int x, int y, int z, mmask_t bstate);

  void show_all();

  void add_widget(vscreen_widget *widget);
  void add_widget_after(vscreen_widget *widget, vscreen_widget *after);
  void rem_widget(vscreen_widget *widget);

  // These cycle forward and backwards through the list of visible items.
  void cycle_forward();
  void cycle_backward();
};

#endif
