#include <stdio.h>
#include <stdlib.h>
#include <string.h>

char *
tutf8 (unsigned char ch)
{
  char *ret = malloc (3);
  memset (ret, 0, 3);

  if (ch < 0x80)
    {
      sprintf (ret, "%c", ch);
      return ret;
    }
  if (ch < 0x800)
    {
      sprintf (ret, "%c%c", (0xc0 | (ch >> 6 & 0x1f)), (0x80 | (ch & 0x3f)));
      return ret;
    }
}
unsigned char
fUTF8 (unsigned char lead, unsigned char ch2)
{
  if ((lead & 0x80) == 0)
    return (lead & 0x7f);
  if ((lead & 0xe0) == 0xc0)
    return ((lead & 0x1f) << 6) | (ch2 & 0x3f);
  return lead;
}

char *
fromUTF8 (const char *src)
{
  int i = 0;
  int max = strlen (src) - 1;
  char *ret = malloc (strlen (src) + 1);
  char *aux = ret;

  memset (ret, 0, strlen (src) + 1);
  while (i < max)
    {
      *aux =
	fUTF8 ((unsigned char) (char) src[i],
	       (unsigned char) (char) src[i + 1]);
      if (*aux > 0)
	i++;
      else
	i += 2;
      aux++;
    }
  *aux = fUTF8 (src[i], 0);
  return ret;
}

char *
toUTF8 (const char *src)
{
  int i;
  char *ret = malloc ((strlen (src) * 2) + 1);

  memset (ret, 0, (strlen (src) * 2) + 1);
  for (i = 0; i < strlen (src); i++)
    {
      strcat (ret, tutf8 ((unsigned char) (char) src[i]));
    }
  return ret;
}
