import re
from dosage.modules.helpers import BasicComicModule as bcm

class Fallen(bcm.BasicComicModule, bcm.IndirectLatestMixin):
    baseUrl = 'http://www.fallencomic.com/fal-page.htm'
    imageUrl = 'http://www.fallencomic.com/pages/part%s/%s-p%s.htm'
    imageSearch = re.compile(r'<IMG SRC="(page/\d+-p\d+\..+?)"', re.IGNORECASE)
    prevSearch = re.compile(r'<A HREF="(\d+-p\d+.htm)"><FONT FACE="Courier">Back', re.IGNORECASE)
    latestSearch = re.compile(r'\(NEW \d{2}/\d{2}/\d{2}\)\s*\n\s*<a href="(pages/part\d+/\d+-p\d+\.htm)">\d+</a>', re.MULTILINE)
    help = 'Index format: nn-m (comicNumber-partNumber)'

    def getFilename(self, imageUrl, pageUrl):
        return imageUrl.split('/')[-1].split('.')[0]

    def setStrip(self, index):
        index, part = index.split('-')
        self.currentUrl = self.imageUrl % (part, index, part)
