import os

disabled = []
def extendDisabled(filename):
    filename = os.path.expanduser(filename)
    if os.path.exists(filename):
        disabled.extend([line.rstrip('\n') for line in open(filename)])

extendDisabled('/etc/dosage/disabled')
extendDisabled('~/.dosage/disabled')

class DisabledComicError(ValueError): pass

def get(moduleName):
    """Returns a comic module object."""

    name = moduleName.split('/', 2)
    if moduleName in disabled:
        raise DisabledComicError, 'comic "%s" is disabled' % moduleName
    module =  __import__(name[0], globals(), locals(), (name[0],))
    return getattr(module, name[0])(*name[1:])

def items(path):
    l = []
    exclude = ['__init__'] + disabled

    for f in os.listdir(path):
	name = os.path.splitext(f)
	if name[1].endswith('.py') and name[0] not in exclude:
            module =  __import__(name[0], globals(), locals(), (name[0],))
            cls = getattr(module, name[0])
            if hasattr(cls, 'submodules'):
                l.extend([name[0] + '/' + submodule for submodule in cls.submodules])
            else:
                l.append(name[0])

    l.sort()
    return l
