/* Copyright (C) 2004 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYING distributed with the source files.

*/

#include <algorithm>

#include "selected_rows_handle.h"


// this is a functor for converting a Gtk::TreeModel::Path to a TreeModelRowReference
// and is suitable for use with std::transform()
class PathToTMRR {
  Glib::RefPtr<Gtk::TreeModel> model_r;
public:
  TreeModelRowReference operator() (const Gtk::TreeModel::Path& path) {
    return TreeModelRowReference(model_r, path);
  }
  PathToTMRR(Glib::RefPtr<Gtk::TreeModel> model_r_): model_r(model_r_) {}
};

void SelectedRowsHandle::fill(const Gtk::TreeView& tree_view) {

  path_list.clear();
#if GTKMM_VERSION >= 24
  tree_view.get_selection()->selected_foreach_path(sigc::mem_fun(*this, &SelectedRowsHandle::add));
#else
  const_cast<Gtk::TreeView&>(tree_view).get_selection()->selected_foreach(sigc::mem_fun(*this, &SelectedRowsHandle::add));
#endif
}

void SelectedRowsHandle::get_ref_list(Glib::RefPtr<Gtk::TreeModel> model_r,
				      RowRefList& row_ref_list) const {

  row_ref_list.clear();
  std::transform(path_list.begin(), path_list.end(),
		 std::back_inserter(row_ref_list), PathToTMRR(model_r));
}

