/* Copyright (C) 2004 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYING distributed with the source files.

*/

#ifndef SOCKET_NOTIFY_H
#define SOCKET_NOTIFY_H

#include "prog_defs.h"

#include <string>
#include <utility>

#include <gtkmm/window.h>
#include <gtkmm/label.h>
#include <gtkmm/button.h>
#include <gtkmm/buttonbox.h>
#include <gtkmm/box.h>
#include <gtkmm/entry.h>
#include <glibmm/ustring.h>


class SocketNotifyDialog: public Gtk::Window {

private:
  const int standard_size;
  bool is_modal;
  std::pair<Glib::ustring, std::string> fax_name;

  Gtk::Label label;
  Gtk::Button number_button;
  Gtk::Button send_button;
  Gtk::Button queue_button;
  Gtk::HButtonBox button_box;
  Gtk::VBox window_box;
  Gtk::HBox number_box;
  Gtk::Entry number_entry;
  Gtk::Window& parent;

  void addressbook_slot(void);
  void set_number_slot(const Glib::ustring&);
  void selected(bool);
  void send_signals(void);
protected:
  virtual bool on_delete_event(GdkEventAny*);
public:
  sigc::signal1<void, const std::pair<Glib::ustring, std::string>&> fax_name_sig;
  sigc::signal1<void, const Glib::ustring&> fax_number_sig;
  sigc::signal0<void> sendfax_sig;

  SocketNotifyDialog(const int standard_size, const std::pair<std::string, unsigned int>&,
		     Gtk::Window& window, bool modal = true);
};

#endif
