/* Copyright (C) 2004 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYING distributed with the source files.

*/

#ifndef TREE_MODEL_ROW_REFERENCE_H
#define TREE_MODEL_ROW_REFERENCE_H

#include "prog_defs.h"

#include <gtkmm/treepath.h>
#include <gtkmm/treemodel.h>
#include <glibmm/refptr.h>

#include <gtk/gtktreemodel.h>

#include "shared_handle.h"

/*
  The version of Gtk::TreeRowReference class which comes with gtkmm-2.0 does not 
  provide a copy constructor or an assignment operator.  To keep compatibility
  TreeModelRowReference provides a wrapper class with a reference counted implementation
  using the Shared_handle manager class
  At the point where gtkmm-2.0 is entirely irrelevant we can just do a textual substitution
  of Gtk::TreeRowReference for any reference to TreeModelRowReference in fax_list.h and
  fax_list.cpp - TreeModelRowReference provides the same interface that Gtk::TreeRowReference
  does in gtkmm-2.2 and gtkmm-2.4
*/


// this class is a functor which frees the memory of the GtkTreeRowReference
// object handled by the Shared_handle object in TreeModelRowReference - it is
// passed as a type to the second template parameter of the Shared_handle
// object in the TreeModelRowReference class
class Gtk_tree_row_ref_free {
public:
  void operator()(GtkTreeRowReference* obj_p) {
    gtk_tree_row_reference_free(obj_p);
  }
};


class TreeModelRowReference {
  Shared_handle<GtkTreeRowReference*, Gtk_tree_row_ref_free> gtk_row_ref_h;
public:
  bool is_valid(void) const {
    return gtk_row_ref_h.get() ? gtk_tree_row_reference_valid(gtk_row_ref_h.get()) : 0;
  }

  Gtk::TreeModel::Path get_path(void) const {
    return Gtk::TreeModel::Path(gtk_tree_row_reference_get_path(gtk_row_ref_h.get()), false);
    //return Glib::wrap(gtk_tree_row_reference_get_path(gtk_row_ref_h.get()), false);
  }

  operator bool() const {return is_valid();}

  TreeModelRowReference& operator=(const TreeModelRowReference& row_ref) {
    gtk_row_ref_h = row_ref.gtk_row_ref_h;
    return *this;
  }

  TreeModelRowReference(const Glib::RefPtr<Gtk::TreeModel> model_r, const Gtk::TreeModel::Path& path):
    gtk_row_ref_h(gtk_tree_row_reference_new(model_r->gobj(), const_cast<GtkTreePath*>(path.gobj()))) {}

  TreeModelRowReference(const TreeModelRowReference& row_ref) {
    gtk_row_ref_h = row_ref.gtk_row_ref_h;
  }

  TreeModelRowReference(void) {}
};

#endif
