//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: Not.hpp,v 1.4 2004/02/08 18:44:19 delpinux Exp $


#ifndef _NOT_HPP_
#define _NOT_HPP_


#include <Shape.hpp>
#include <Object.hpp>

/*!  \class Not

  This is the class which defines a Virtual Reality set operation: the \p not.

  \author Stphane Del Pino.
*/
class Not
  : public Shape
{
private:
  //! The Shape on which the \p not is applied.
  ReferenceCounting<Object> __object;

  //! Returns \p true is the point \a p is \b not in the Object \a o.
  inline bool inShape (const TinyVector<3, real_t>& p) const;

  //! Prints the Union informations using the stream \a s.
  std::ostream& put(std::ostream& s) const;

public:
  ReferenceCounting<Object> object() const
  {
    return __object;
  }

  //! Constructs the Not for a given Object \a o.
  Not(ReferenceCounting<Object> s)
    : Shape(not_),
      __object(s)
  {
    ;
  }

  //! Copy constructor.
  Not(const Not& N)
    : Shape(N),
      __object(N.__object)
  {
    ;
  }

  //! Destructor.
  ~Not()
  {
    ;
  }

};

/*! Returns \p true if the point \a p is inside the Not (ie: if the point \a p
  is \b not inside the Shape \p __shape).
*/
inline bool Not::inShape (const TinyVector<3, real_t>& p) const
{
  return (! (*__object).inside(p));
}

#endif // _NOT_HPP_

