//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: Scale.hpp,v 1.2 2003/05/04 18:09:01 delpinux Exp $


#ifndef SCALE
#define SCALE

#include <Transform.hpp>
#include <TinyVector.hpp>

/*!
  \class Scale
  This class defines scalings using the same description that \p POV-Ray.
  It means that scales are performed using:
  \li an scale of \a angles[0] by the X axis;
  \li an scale of \a angles[1] by the Y axis;
  \li an scale of \a angles[2] by the Z axis.

  \author Stphane Del Pino
*/
class Scale
  : public Transform
{
private:
  //! The scales values.
  TinyVector<3> __scale;

public:
  //! Applies the scale to a vector \a v.
  TinyVector<3>& operator()(TinyVector<3>& v) const;

  //! Applies the inverse scale to a vector \a v.
  TinyVector<3>& inverse(TinyVector<3>& V) const;

  //! Prints scale informations to a std::string.
  std::string povWrite() const;

  //! Default Constructor.
  Scale();

  //! Constructs a Scale for a given set of scalings passed by \a v.
  Scale(const TinyVector<3>& v);

  //! Copy constructor.
  Scale(const Scale& S);

  //! Destructor.
  ~Scale()
  {
    ;
  }
};

#endif // SCALE

