//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: Dirichlet.hpp,v 1.1.1.1 2003/02/17 16:32:51 delpinux Exp $

// this class allows to define Dirichlet Boundary Conditions

#ifndef _DIRICHLET_HPP_
#define _DIRICHLET_HPP_

#include <PDECondition.hpp>
#include <UserFunction.hpp>
/*!
  \class Dirichlet
  Dirichlet conditons

  \author Stphane Del Pino
*/
class Dirichlet
  : public PDECondition
{
private:
  //! The function to impose as a Dirichlet Boundary Condition.
  ReferenceCounting<UserFunction> __g;

public:

  const real_t g(const TinyVector<3>& X) const
  {
    return (*__g)(X);
  }

  const std::string typeName() const
  {
    return std::string("Dirichlet");
  }

  //! Constructs a DirichletPenalized.
  Dirichlet(ReferenceCounting<UserFunction> g,
	    const size_t unknownNumber)
    : PDECondition(PDECondition::dirichlet,
		   unknownNumber),
      __g(g)
  {
    ;
  }

  //! Copy constructor.
  Dirichlet(const Dirichlet& D)
    : PDECondition(D),
      __g(D.__g)
  {
    ;
  }

  //! Destructor.
  ~Dirichlet()
  {
    ;
  }
};

#endif // _DIRICHLET_HPP_

