//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: TetrahedronByEdges.hpp,v 1.1.1.1 2003/02/17 16:32:51 delpinux Exp $


#ifndef TETRAHEDRONBYEDGES_HPP
#define TETRAHEDRONBYEDGES_HPP

#include <CellByEdges.hpp>

/**
 * @file   TetrahedronByEdges.hpp
 * @author Stephane Del Pino
 * @date   Mon Feb 10 18:14:56 2003
 * 
 * @brief  describes a Tetrahedron (using 6 edges).
 * 
 * 
 */


class TetrahedronByEdges
  : public CellByEdges
{
public:
  inline const size_t numberOfEdges() const
  {
    return 6;
  }

  TetrahedronByEdges()
    : CellByEdges(6)
  {
    ;
  }

  const TetrahedronByEdges& operator = (const TetrahedronByEdges& T)
  {
    for (size_t i=0; i<6; ++i)
      __edges[i] = const_cast<Edge*>(T.__edges[i]);
    return *this;
  }

  TetrahedronByEdges(const Edge& e0,
		     const Edge& e1,
		     const Edge& e2,
		     const Edge& e3,
		     const Edge& e4,
		     const Edge& e5)
    : CellByEdges(6)
  {
    __edges[0] = const_cast<Edge*>(&e0);
    __edges[1] = const_cast<Edge*>(&e1);
    __edges[2] = const_cast<Edge*>(&e2);
    __edges[3] = const_cast<Edge*>(&e3);
    __edges[4] = const_cast<Edge*>(&e4);
    __edges[5] = const_cast<Edge*>(&e5);
  }

  //! Copy constructor.
  TetrahedronByEdges(const TetrahedronByEdges& T)
    : CellByEdges(T)
  {
    ;
  }

  //! Destructor.
  ~TetrahedronByEdges()
  {
    ;
  }
};

#endif // _TETRAHEDRONBYEDGES_HPP_

