//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: VariationalOperatorFV.hpp,v 1.2 2003/09/21 15:44:53 delpinux Exp $

#ifndef VARIATIONAL_OPERATOR_FV_HPP
#define VARIATIONAL_OPERATOR_FV_HPP

#include <VariationalLinearOperator.hpp>

#include <UserFunction.hpp>

/**
 * @file   VariationalOperatorFV.hpp
 * @class  VariationalOperatorFV
 * @author Stephane Del Pino
 * @date   Sun Jun  2 21:55:49 2002
 * 
 * @brief  \f$ l(v) = \int fv \f$
 * 
 */
class VariationalOperatorFV
  : public VariationalLinearOperator
{
private:
  ReferenceCounting<UserFunction> __f; /**< the \f$ f\f$ function */

public:
  /** 
   * 
   * Access to \f$ f\f$
   * 
   * @return *__f
   */
  const UserFunction& f() const
  {
    return *__f;
  }

  /** 
   * "Multiplies" the operator by a function
   * 
   * @param u the given function
   * 
   * @return the new operator
   */
  ReferenceCounting<VariationalLinearOperator>
  operator * (ConstReferenceCounting<UserFunction> u) const
  {
    VariationalOperatorFV* newOperator = new VariationalOperatorFV(*this);
    (*newOperator).__f = new MulUserFunction(__f, u);
    return newOperator;
  }

  /** 
   * Constructor
   * 
   * @param testFunctionNumber 
   * @param f 
   * 
   */
  VariationalOperatorFV(const size_t testFunctionNumber,
			ReferenceCounting<UserFunction> f)
    : VariationalLinearOperator(VariationalLinearOperator::FV,
				testFunctionNumber),
      __f(f)
  {
    ;
  }

  /** 
   * Copy constructor
   * 
   * @param fv another VariationalOperatorFV
   * 
   */
  VariationalOperatorFV(const VariationalOperatorFV& fv)
    : VariationalLinearOperator(fv),
      __f(fv.__f)
  {
    ;
  }

  /** 
   * Destructor
   * 
   * 
   */
  ~VariationalOperatorFV()
  {
    ;
  }
};

#endif // VARIATIONAL_OPERATOR_FV_HPP

