//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: EnumParameter.hpp,v 1.1.1.1 2003/02/17 16:32:50 delpinux Exp $


#ifndef _ENUM_PARAMETER_HPP_
#define _ENUM_PARAMETER_HPP_

#include <Parameter.hpp>
#include <LabeledEnum.hpp>

#include <IdentifierSet.hpp>
/*!
  \class EnumParameter
  This is the base describes Enum Parameters.

  \author Stphane Del Pino.
*/
template <typename EnumType>
class EnumParameter
  : public Parameter
{
private:
  LabeledEnum<EnumType> __switch;

  void reset()
  {
    __enumValue = __defaultEnumValue;
  }

  const EnumType __defaultEnumValue;
  EnumType __enumValue;

  std::ostream& put (std::ostream& os) const
  {
    os << __enumValue;
    return os;
  }

public:
  //! Possible enums are added to the language.
  void get(IdentifierSet& I)
  {
    __switch.get(I);
  }

  void addSwitch(const char* c, const EnumType t)
  {
    __switch.add(c,t);
  }

  void set(const real_t d)
  {
    fferr(2) << "cannot assignate the real_t \'" << d << "\' to an enum parameter\n";
    std::exit(1);
  }

  void set(const int i)
  {
    fferr(2) << "cannot assignate the int \'" << i << "\' to an enum parameter\n";
    std::exit(1);
  }

  void set(const char* c)
  {
    __enumValue = __switch(c);
  }

  operator EnumType&()
  {
    return __enumValue;
  }

  operator const EnumType&() const
  {
    return __enumValue;
  }

  const std::string typeName() const
  {
    return "enum";
  }

  EnumParameter(const EnumParameter& sp)
    : Parameter(sp),
      __switch(sp.__switch),
      __defaultEnumValue(sp.__defaultEnumValue),
      __enumValue(sp.__enumValue)
  {
    ;
  }

  EnumParameter(const EnumType defaultEnum , const char* label)
    : Parameter(Parameter::Enum, label),
      __defaultEnumValue(defaultEnum),
      __enumValue(defaultEnum)
  {
    ;
  }

  ~EnumParameter()
  {
    ;
  }
};

#endif // _ENUM_PARAMETER_HPP_

