C Gabriele FIORENTINI, Giorgio CALZOLARI, Lorenzo PANATTONI
C Journal of APPLIED ECONOMETRICS, 1996
C
C ALTERNATIVE ESTIMATES OF VARIANCES AND COVARIANCES
C
C GARCH(P,Q) ESTIMATES OF A LINEAR EQUATION
C SEE BOLLERSLEV, JOE 31(1986),307-327.
C
C RIMEMBER TO PUT ENOUGH LAGGED OBSERVATIONS IN THE DATA FILE
C (AT LEAST =MAX(P,Q)) TO HAVE RESIDUALS AT TIME 0, -1, ETC.
C***********************************************************************
C***********************************************************************
C MAXIMUM DIMENSION (IF NOT ENOUGH, ENLARGE USING 'CHANGE GLOBAL'
C NUMBER OF EXOGENOUS VARIABLES                                    0005
C SAMPLE (OR SIMULATION) PERIOD INCLUDING LAGGED INITIAL OBSERV. 003009
C NUMBER OF REGRESSION COEFFICIENTS                                0007
C NUMBER OF PARAMETERS (COEFF.+ALFAS+BETAS)                        0013
C***********************************************************************
C**********************************************************************
C VC = MATR DI COMODO CHE SERVE AL CALCOLO --- INOLTRE SI USA COME
C      INVERSA DELLA MAT. DI COV. DEI SOLI COEFF. PER LA MAT. DI INF.
C VC5= HESSIAN
C VC6= OUTER PRODUCT
C VC9= INFORMATION MATRIX
C VC10=MATRIX AS IN WHITE (1982,P.....), COMPUTED USING THE COMPLETE
C      INVERSE OF VC9 AND THE FULL VC6 MATRIX.
C VC'I-2' IS THE INVERSE OF VC'I'.
C VC13=SAME AS VC8 (WHITE), BUT THE INVERSE OF THE HESSIAN IS REPLACED
C      WITH THE INVERSE OF THE INF.MAT BLOCK-DIAG(BOLLERSLEV AND
C      WOOLDRIDGE, ECONOMETRIC REVIEW, 1992)
C VC15=INVERSE OF VC13, TO BE USED IN WALD TEST.
C DHTDP SONO LE DERIVATE DI HT RISPETTO A TUTTI I PARAMETRI
      SUBROUTINE VSANAL(NINIT,NFINSM,IFROM,YOBS,NEND,IREAD,
     ,XOBS,NEXO,UMC,NSTOCH,YDET,YY,COEFF,NCOEFF,D,OLDC,
     ,GGG,VC,OMEGA,EXONAM,ENDNAM,RES2,NPEND,NPEXO,
     ,UN01,RES,SIGMA,INYEAR,ISEME,INRES,NFRES,ZLRES,A,NREP,YSTOC,
     ,IDYNAM,YFIX,NPRINT,AMAX,AMIN,MPREND,ICOEFF,MAXDER,UCONTR,
     ,UTHCNT,BCONTR,NENDTG,NEXOCN,LENGSM,INEXO,NFEXO,
     ,INEND,NFEND,B,NCOEFB)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION YOBS(NEND,IREAD),XOBS(NEXO,IREAD),UMC(NSTOCH),
     ,YDET(NEND,IREAD),YY(NEND),COEFF(NCOEFF),D(MAXDER,NCOEFF),
     ,B(NCOEFB),
     ,OLDC(NEND),GGG(MAXDER,NCOEFF),
     ,VC(NCOEFF,NCOEFF),OMEGA(NEND),
     ,YSTOC(NEND,IREAD),
     ,YFIX(NEND,IREAD),
     ,RES2(NEND,IREAD),AMAX(NEND,IREAD),AMIN(NEND,IREAD),
     ,NPEND(NEND),NPEXO(NEXO),SIGMA(NSTOCH,NSTOCH),
     ,UN01(IREAD),
     ,A(NEND,NEND),RES(NSTOCH,IREAD),ICOEFF(NSTOCH),INRES(NSTOCH),
     ,NFRES(NSTOCH),ZLRES(NSTOCH),INEXO(NEXO),NFEXO(NEXO),
     ,INEND(NEND),NFEND(NEND)
      DIMENSION AUX(0013),NAM(0001),AUX2(0013,0013),
     ,AUX3(0013),C(0013),CPREC(0013),VC5(0013,0013),
     ,VC6(0013,0013),SVC3(0013),VC7(0013,0013),SVC7(0013),
     ,SVC4B(0013),SVC8B(0013),
     ,SVC8(0013),VC3(0013,0013),VC4(0013,0013),SVC4(0013),
     ,PARSUM(0013),PARSU2(0013),
     ,VC13(0013,0013),VC15(0013,0013),
     ,SVC13(0013),
     ,VC8(0013,0013),VV(0013,0013),VC9(0013,0013),VC10(0013,0013),
     ,SIGFIX(0003,0003),OO(0003,0003),PARFIX(0013),PARAM(0013),
     ,PP(00141),SIGFID(0003,0003),O(0001,0003),
     ,VC1(0007,0007),VC2(0007,0007),VC11(0007,0007),VC12(0007,0007),
     ,MAGWHI(0013),MAGOUT(0013),MAGINF(0013),
     ,MAGWHB(0013),MAGOPB(0013),
     ,ZLEXO(0005),AMEANX(0005),XFIX(0005,003009),ZLEND(0001),
     ,AMEANY(0001),G(0013,003009),GF(0013,0003),
     ,DERCOP(0013),PARPRE(0013),STDERR(0013)
      DIMENSION ALFA(0004),BETA(0004),HT(003009),
     ,ALFFIX(0004),BETFIX(0004),DHTDP(0013,003009),ZT(0006),
     ,FLIKEL(0050),IPLOT(0050),SUMLOG(0050),
     ,PARTRC(0013,0050)
      CHARACTER*8 EXONAM(NEXO),ENDNAM(NEND)
C
C
C LETTURA DAL FILE DEI PARAMETRI GARCH
      READ(1,101)NTSTUD
C (STUDENT.T DEGREES OF FREED. 0=NORMAL)
101   FORMAT(I5)
      READ(1,102)ALFIX0
102   FORMAT(5G15.6)
      READ(1,101)NALFA
      IF(NALFA.GT.0)READ(1,102)(ALFFIX(I),I=1,NALFA)
      READ(1,101)NBETA
      IF(NBETA.GT.0)READ(1,102)(BETFIX(I),I=1,NBETA)
C ********************************************************************
      WRITE(6,1080)
      WRITE(8,1080)
1080  FORMAT(//,' Gabriele FIORENTINI',/,
     ,' Giorgio  CALZOLARI',/,
     ,' Lorenzo  PANATTONI',/,
     ,' Journal of APPLIED ECONOMETRICS, 1996',//)
C ********************************************************************
C NUMBER OF PARAMETERS OF UNCONCENTRATED LIKELIHOOD
      NABET1=NALFA+NBETA+1
      WRITE(8,443) NABET1
443   FORMAT(' TOTAL NUMBER OF GARCH PARAMETERS:',I3)
      IF(NALFA.GT.0)WRITE(8,102)(ALFFIX(I),I=1,NALFA)
      IF(NBETA.GT.0)WRITE(8,102)(BETFIX(I),I=1,NBETA)
      NPARAM=NCOEFF+NABET1
      IF(NEXO.LE.0005.AND.IREAD.LE.003009.AND.NCOEFF.LE.0007.
     .AND.NEND.LE.0001.
     .AND.NPARAM.LE.0013.AND.(NPARAM*NPARAM+NPARAM)/2.LE.00141.
     .AND.NSTOCH.LE.0003)
     ,GO TO 2
      WRITE(6,100)
      WRITE(8,100)
100   FORMAT(' VSGARCH: INSUFFICIENT DIMENSIONS')
      GO TO 6999
C******TRUCCO DISGUSTOSO. DOVREBBE ESSERE UN GO TO 999, MA SICCOME
C LA LABEL 999 E' TROPPO LONTANA, IL PROFORT DEL PS/2 NON RIESCE A
C COMPILARLO, QUINDI SI FA IL SALTO IN DUE TEMPI
2     CONTINUE
      RELY=1.D-2
      EPSIL=1.D-5
      NSEME=ISEME
      MINEXO=99999999
      MAXEXO=-99999999
      MINEND=MINEXO
      MAXEND=MAXEXO
      IF(NEXO.LE.0)GO TO 10
      DO 4 I=1,NEXO
      AMEANX(I)=0.
      NAB=INEXO(I)-INYEAR+1
      NOB=NFEXO(I)-INYEAR+1
      ITIME=NFEXO(I)-INEXO(I)+1
      IF(NAB.LT.MINEXO)MINEXO=NAB
      IF(NOB.GT.MAXEXO)MAXEXO=NOB
      ZTIME=ITIME
      ZLEXO(I)=DSQRT(ZTIME)
      DO 5 IC=NAB,NOB
      XFIX(I,IC)=XOBS(I,IC)
      AMEANX(I)=AMEANX(I)+XOBS(I,IC)
5     CONTINUE
      AMEANX(I)=AMEANX(I)/ZTIME
4     CONTINUE
      MAXLEX=MAXEXO-MINEXO+1
10    CONTINUE
      MINEND=99999
      MAXEND=-99999
      DO 14 I=1,NEND
      AMEANY(I)=0.
      NAB=INEND(I)-INYEAR+1
      NOB=NFEND(I)-INYEAR+1
      ITIME=NFEND(I)-INEND(I)+1
      IF(NAB.LT.MINEND)MINEND=NAB
      IF(NOB.GT.MAXEND)MAXEND=NOB
      ZTIME=ITIME
      ZLEND(I)=DSQRT(ZTIME)
      DO 15 IC=NAB,NOB
      YSTOC(I,IC)=YOBS(I,IC)
      YFIX(I,IC)=YOBS(I,IC)
      AMEANY(I)=AMEANY(I)+YOBS(I,IC)
15    CONTINUE
      AMEANY(I)=AMEANY(I)/ZTIME
14    CONTINUE
      MAXLEY=MAXEND-MINEND+1
C EXPERIMENTAL OPTIMAL CHOICE FOR TOLER1 ON MODEL VSSER2
      TOLER1=5.D-02
      TOLER2=1.D-08
      TOLER3=1.D-09
      TOLLOG=DLOG10(TOLER2)
      DO 1555 IK=1,NCOEFF
1555  C(IK)=COEFF(IK)
      DO 1603 IK=1,NPARAM
      SVC3(IK)=0.
      SVC4(IK)=0.
      SVC8(IK)=0.
      SVC7(IK)=0.
      SVC4B(IK)=0.
      SVC8B(IK)=0.
      SVC13(IK)=0.
      PARSUM(IK)=0.
      PARSU2(IK)=0.
      MAGWHI(IK)=0
      MAGOUT(IK)=0
      MAGINF(IK)=0
      MAGOPB(IK)=0.
      MAGWHB(IK)=0.
1603  CONTINUE
C SUL 486 LA DUE RIGA SEGUENTI DANNO ERRORE IN COMPILAZIONE. TOLTE.
      DO 2731 I=1,50
      IPLOT(I)=0
      SUMLOG(I)=0.
2731  FLIKEL(I)=0.
C STORE ALL THE FIXED PARAMETERS (COEFFICIENTS AND ALFA'S AND
C BETA'S READ FROM FILE)INTO THE VECTOR PARFIX
      DO 270 I=1,NCOEFF
270   PARAM(I)=COEFF(I)
      PARAM(NCOEFF+1)=ALFIX0
      IF(NALFA.LE.0)GO TO 260
      DO 261 I=1,NALFA
261   PARAM(NCOEFF+1+I)=ALFFIX(I)
260   CONTINUE
      IF(NBETA.LE.0)GO TO 262
      DO 263 I=1,NBETA
263   PARAM(NCOEFF+1+NALFA+I)=BETFIX(I)
262   CONTINUE
      DO 1814 I=1,NPARAM
1814  PARFIX(I)=PARAM(I)
C NUMBER OF ITERATIONS USING FULHESSIAN OR AMEMIYA'S MATRIX
C THE VARIABLE APPEARING ON
C THE LEFT HAND SIDE MUST BE Y(1)
      MAXC=NCOEFF
      CALL VSRSTR(C,NCOEFF,B,NCOEFB,ICOEFF,NSTOCH)
C DIMENSIONS CONTROL
      IF(MAXC.GT.0007)GO TO 99
C IF EVERITHING IS OK:
      GO TO 1
99    WRITE(6,1000)
      WRITE(8,1000)
1000  FORMAT(//' DIMENSION INSUFFICIENT.',/,' COMPUT.IMPOSSIBLE',//)
      GO TO 6999
C******TRUCCO DISGUSTOSO. DOVREBBE ESSERE UN GO TO 999, MA SICCOME
C LA LABEL 999 E' TROPPO LONTANA, IL PROFORT DEL PS/2 NON RIESCE A
C COMPILARLO, QUINDI SI FA IL SALTO IN DUE TEMPI
1     CONTINUE
      NOCONV=0
      NSEME=ISEME
      IVOLTA=0
      IVOLT2=0
C*************************TO GENERATE HISTORICAL VALUES IF NREP=0
C*************************
      IF(NREP.GT.0)GO TO 1651
C      DO 1661 IK=1,NCOEFF
C1661  C(IK)=COEFF(IK)
      NREP=1
      NPRINT=1
      LOOP=1
      GO TO 2650
C**************************
C**************************
1651  LOOP=0
630   IF(LOOP.GE.NREP)GO TO 6600
C******TRUCCO DISGUSTOSO. DOVREBBE ESSERE UN GO TO 600, MA SICCOME
C LA LABEL 600 E' TROPPO LONTANA, IL PROFORT DEL PS/2 NON RIESCE A
C COMPILARLO, QUINDI SI FA IL SALTO IN DUE TEMPI
      DO 1600 IK=1,NCOEFF
1600  C(IK)=COEFF(IK)
      CALL VSRSTR(C,NCOEFF,B,NCOEFB,ICOEFF,NSTOCH)
      LOOP=LOOP+1
C    PERFORM THE MC-CARTHY ALGORITHM
C    TO OBTAIN RANDOM VALUES OF THE EXOGENOUS VARIABLES.
C***********************************************************
C ACTIVATE IF RANDOM EXOGENOUS AND INITIAL LAGGED ENDOGENOUS
C MUST BE GENERATED
C ONLY AT THE FIRST REPLICATION, AND THEN KEPT ALWAYS FIXED.
      IF(LOOP.GT.1)GO TO 234
C***********************************************************
C ACTIVATE IF EXOGENOUS VARIABLES MUST BE KEPT AT THEIR HISTORICAL
C VALUES AND REPLICATED CONSECUTIVELY OVER TIME, IF THE PERIOD IS LONGER
      IF(I.EQ.I)GO TO 2130
C***********************************************************
      IF(I.EQ.I)GO TO 2131
2130  CONTINUE
      IF(NEXO.LE.0)GO TO 2134
      DO 2132 J=1,NEXO
      NAB=INEXO(J)-INYEAR+1
      NOB=NFEXO(J)-INYEAR+1
      L=NOB-NAB+1
      N1=NAB-1
      N=N1-(N1/L)*L
      K=NAB
      IF(N.GT.0)K=NOB+1-N
      M1=0
      M2=K-1
2135  CONTINUE
      DO 2133 IC=NAB,NOB
      M1=M1+1
      IF(M1.GT.IREAD)GO TO 2132
      M2=M2+1
      IF(M2.GT.NOB)M2=NAB
      XOBS(J,M1)=XFIX(J,M2)
2133  CONTINUE
      GO TO 2135
2132  CONTINUE
2134  CONTINUE
      DO 2142 J=1,NEND
      NAB=INEND(J)-INYEAR+1
      NOB=NFEND(J)-INYEAR+1
      L=NOB-NAB+1
      N1=NAB-1
      N=N1-(N1/L)*L
      K=NAB
      IF(N.GT.0)K=NOB+1-N
      M1=0
      M2=K-1
2145  CONTINUE
      DO 2143 IC=NAB,NOB
      M1=M1+1
      IF(M1.GT.IREAD)GO TO 2142
      M2=M2+1
      IF(M2.GT.NOB)M2=NAB
      YOBS(J,M1)=YFIX(J,M2)
2143  CONTINUE
      GO TO 2145
2142  CONTINUE
C      DO 77777 I=1,NEND
C77777 WRITE(6,77778)(YOBS(I,IC),IC=1,IREAD)
C      DO 77779 I=1,NEXO
C77779 WRITE(6,77778)(XOBS(I,IC),IC=1,IREAD)
C77778 FORMAT(10G13.5)
      GO TO 235
2131  CONTINUE
      IESPON=1
C***********************************************************************
C ACTIVATE WITH IESPON=2, OR 3, OR 4, OR 5, OR MORE, IF LARGE KURTOSIS
C FOR EXOGENOUS AND INITIAL LAGGED ENDOGENOUS IS DESIRED
C      IESPON=5
C IT MUST BE A POSITIVE INTEGER (UP TO 11)
C***********************************************************************
C THE VARIANCE OF A N(0,1)**IESPON, WITH SIGN + OR - ALSO FOR EVEN EXPON
C IS 1*3*5*...*(2*IESPON-1)
C***********************************************************************
      MINMIN=MINEXO
      IF(MINEND.LT.MINMIN)MINMIN=MINEND
      MAXLEN=MAXLEX
      IF(MAXLEN.LT.MAXLEY)MAXLEN=MAXLEY
      IVAR=1
      DO 80 IES=1,IESPON
80    IVAR=IVAR*(2*IES-1)
      VAR=IVAR
      STE=DSQRT(VAR)
      ESPON=IESPON
C    PERFORM THE MC CARTHY ALGORITHM TO GENERATE RANDOM
C    EXOGENOUS AND INITIAL LAGGED ENDOGENOUS VARIABLES
      DO 133 IC=1,IREAD
      CALL VSRAND(ISEME,UN01,MAXLEN)
      IF(NEXO.LE.0)GO TO 131
      DO 31 J=1,NEXO
      NAB=INEXO(J)-INYEAR+1
      NOB=NFEXO(J)-INYEAR+1
      PIPPO=0.
      DO 6 I=NAB,NOB
      UNORM=UN01(I+1-MINMIN)
      SEGNO=1.
      IF(UNORM.LT.0.)SEGNO=-1.
      IF(UNORM.LT.0.)UNORM=-UNORM
      PEPPO=SEGNO*UNORM**ESPON
6     PIPPO=PIPPO+PEPPO*(XFIX(J,I)-AMEANX(J))
      XOBS(J,IC)=PIPPO/(STE*ZLEXO(J))+AMEANX(J)
31    CONTINUE
131   CONTINUE
      DO 231 J=1,NEND
      NAB=INEND(J)-INYEAR+1
      NOB=NFEND(J)-INYEAR+1
      PIPPO=0.
      DO 16 I=NAB,NOB
      UNORM=UN01(I+1-MINMIN)
      SEGNO=1.
      IF(UNORM.LT.0.)SEGNO=-1.
      IF(UNORM.LT.0.)UNORM=-UNORM
      PEPPO=SEGNO*UNORM**ESPON
16    PIPPO=PIPPO+PEPPO*(YFIX(J,I)-AMEANY(J))
      YOBS(J,IC)=PIPPO/(STE*ZLEND(J))+AMEANY(J)
231   CONTINUE
133   CONTINUE
235   CONTINUE
C COMPUTES AND PRINTS MEANS, VARIANCE AND KURTOSIS
      IF(NEXO.LE.0)GO TO 236
      DO 237 J=1,NEXO
      NAB=INEXO(J)-INYEAR+1
      NOB=NFEXO(J)-INYEAR+1
      ALENGT=NOB-NAB+1
      S1=0.
      S2=0.
      S3=0.
      S4=0.
      DO 238 IC=NAB,NOB
      S1=S1+XOBS(J,IC)
      S2=S2+XOBS(J,IC)**2
      S3=S3+XOBS(J,IC)**3
      S4=S4+XOBS(J,IC)**4
238   CONTINUE
      AMEAN=S1/ALENGT
      AVAR=(S2-S1*S1/ALENGT)/(ALENGT-1.)
      AMOM4=(S4-3.*ALENGT*AMEAN**4+6.*AMEAN**2*S2-4.*AMEAN*S3)/
     /(ALENGT-1.)
      AKURT=AMOM4/(AVAR**2)
      WRITE(6,239)J,AMEAN,AVAR,AKURT
      WRITE(8,239)J,AMEAN,AVAR,AKURT
239   FORMAT(' MEAN, VAR, KURT X',I2,'=',3G15.6)
237   CONTINUE
236   CONTINUE
      DO 247 J=1,NEND
      NAB=INEND(J)-INYEAR+1
      NOB=NFEND(J)-INYEAR+1
      ALENGT=NOB-NAB+1
      S1=0.
      S2=0.
      S3=0.
      S4=0.
      DO 248 IC=NAB,NOB
      S1=S1+YOBS(J,IC)
      S2=S2+YOBS(J,IC)**2
      S3=S3+YOBS(J,IC)**3
      S4=S4+YOBS(J,IC)**4
248   CONTINUE
      AMEAN=S1/ALENGT
      AVAR=(S2-S1*S1/ALENGT)/(ALENGT-1.)
      AMOM4=(S4-3.*ALENGT*AMEAN**4+6.*AMEAN**2*S2-4.*AMEAN*S3)/
     /(ALENGT-1.)
      AKURT=AMOM4/(AVAR**2)
      WRITE(6,249)J,AMEAN,AVAR,AKURT
      WRITE(8,249)J,AMEAN,AVAR,AKURT
249   FORMAT(' MEAN, VAR, KURT Y',I2,'=',3G15.6)
247   CONTINUE
234   CONTINUE
      DO 1604 IC=1,IREAD
      DO 1604 I=1,NEND
1604  YSTOC(I,IC)=YOBS(I,IC)
C GENERATE RANDOM ERRORS WITH GARCH STRUCTURE.
C PARAMETERS ALFA'S AND BETA'S ARE READ FROM FILE.
C INITIALIZATION OF HT AND RES2 IN PRE-SAMPLE PERIODS IS DONE USING
C THEORETICAL UNCONDITIONAL VARIANCE (ALFA0/1.-ALFA1-BETA1-..)
C<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
C QUESTA CHIAMATA NELLA VECCHIA VERSIONE (GARCOLD) SERVIVA PER
C INIZIALIZZARE HT E RES2. QUI VIENE LASCIATA PER EVITARE ERRORI
C NEL CALCOLO DELLA STATISTICA DI WALD (IL PERCHE' NON E' CHIARO).
C      FU=VALUNC(IDYNAM,C,NCOEFF,IFLAG,RES2,RES,
C     ,YDET,YOBS,YSTOC,XOBS,NEND,IREAD,NEXO,UMC,NSTOCH,NINIT,
C     ,NFINSM,PARFIX,NPARAM,ICOEFF,B,NCOEFB,
C     ,ALFIX0,ALFFIX,BETFIX,NALFA,NBETA,HT)
C<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
      DENOM=1.
      IF(NALFA.LE.0)GO TO 360
      DO 361 I=1,NALFA
361   DENOM=DENOM-ALFFIX(I)
360   CONTINUE
      IF(NBETA.LE.0)GO TO 362
      DO 363 I=1,NBETA
363   DENOM=DENOM-BETFIX(I)
362   CONTINUE
      IF(DENOM.GT.0.)GO TO 364
      WRITE(6,365)
365   FORMAT(' SUM OF ALFAS AND BETAS PARAMETERS MUST BE LESS THAN 1')
      GO TO 999
364   CONTINUE
      UNCVAR=ALFIX0/DENOM
      INDIET=NALFA
      IF(NBETA.GT.NALFA)INDIET=NBETA
      I1=NINIT-INDIET
      I2=NINIT-1
      DO 366 IC=I1,I2
      RES2(1,IC)=UNCVAR
      HT(IC)=UNCVAR
366   CONTINUE
      DO 2060 IC=NINIT,NFINSM
      CALL NAGAR2(UN01,IREAD,NSTOCH,UMC,NEND,ISEME,IC,
     ,ALFIX0,ALFFIX,BETFIX,NALFA,NBETA,HT,RES2,NTSTUD)
      IF(IDYNAM.NE.0)GO TO 610
C      DO 14567 I=1,NEXO
C      DO 15678 J=1,IREAD
C      WRITE(6,1234) XOBS(I,J)
C15678 CONTINUE
C14567 CONTINUE
C      DO 19191 I=1,NCOEFF
C19191 WRITE(6,1234) C(I)
C1234  FORMAT (1X,G12.6)
      CALL VSGAUS(YOBS,YOBS,NEND,IREAD,XOBS,NEXO,UMC,
     ,NSTOCH,IC,YSTOC(1,IC),YY,IFLAG,B,1.D-05,NCOEFB)
      IF(IFLAG.EQ.0)GO TO 611
      LOOP=LOOP-1
      GO TO 630
610   CONTINUE
C  DYNAMIC SIMULATION
      CALL VSGAUS(YOBS,YSTOC,NEND,IREAD,XOBS,NEXO,UMC,
     ,NSTOCH,IC,YSTOC(1,IC),YY,IFLAG,B,1.D-05,NCOEFB)
      IF(IFLAG.EQ.0)GO TO 611
      LOOP=LOOP-1
      GO TO 630
611   CONTINUE
2060  CONTINUE
2650  CONTINUE
      DO 2062 I=1,NSTOCH
2062  UMC(I)=0.
C OLS ESTIMATION
C COMPUTES COEFFICIENTS (C)
C     IF(I.EQ.I) GO TO 7521
      CALL OLS(NINIT,NFINSM,YOBS,NEND,IREAD,
     ,XOBS,NEXO,UMC,NSTOCH,YY,C,NCOEFF,OLDC,VC,
     ,YSTOC,IDYNAM,AMAX,ICOEFF,
     ,AUX,IFLAG,B,NCOEFB,G)
C STIMA DELLA VARIANZA NONCONDIZIONATA USANDO UNA STIMA OLS
C PRODUCE VALORI DI ALFA0, ALFA E BETA
      CALL SIG(NINIT,NFINSM,YOBS,NEND,IREAD,UMC,XOBS,NEXO,NSTOCH,
     ,YY,C,NCOEFF,RES,SIGMA,YSTOC,IDYNAM,B,NCOEFB,
     ,ALFA0,ALFA,BETA,NALFA,NBETA)
7521  CONTINUE
      DO 670 I=1,NCOEFF
670   PARAM(I)=C(I)
      PARAM(NCOEFF+1)=ALFA0
      IF(NALFA.LE.0)GO TO 660
      DO 661 I=1,NALFA
661   PARAM(NCOEFF+1+I)=ALFA(I)
660   CONTINUE
      IF(NBETA.LE.0)GO TO 662
      DO 663 I=1,NBETA
663   PARAM(NCOEFF+1+NALFA+I)=BETA(I)
662   CONTINUE
C      WRITE(6,671)
C      WRITE(8,671)
671   FORMAT(' PARAMETRI DOPO CALL OLS E CALL SIG, PRIMA DI FULHESS')
C      WRITE(6,102)(PARAM(I),I=1,NPARAM)
C      WRITE(8,102)(PARAM(I),I=1,NPARAM)
1650  CONTINUE
C**********************************************************************
C ACTIVATE IF ONLY OLS ESTIMATION IS TO BE PERFORMED
C      IF(I.EQ.I)GO TO 7766
C**********************************************************************
C ITERATIVE ESTIMATION
C***********************************************************************
      IVOLTA=0
      NZO=0
      DO 8765 IZO=1,100
      IH=0
C      IF(IZO.GT.50)IH=1
C IF NOT ENOUGH, FOR ITERATIONS WITH INFORMATION'S MATRIX,
C REPLACE WITH DO 8765 IZO=1,300
C COMPUTE RESIDUALS FOR COVARIANCE MATRIX
C*******I PARAMETRI SONO PASSATI DENTRO 'PARAM' ***********************
      FU=VALUNC(IDYNAM,C,NCOEFF,IFLAG,RES2,RES,
     ,YDET,YOBS,YSTOC,XOBS,NEND,IREAD,NEXO,UMC,NSTOCH,NINIT,
     ,NFINSM,PARAM,NPARAM,ICOEFF,B,NCOEFB,
     ,ALFA0,ALFA,BETA,NALFA,NBETA,HT)
C      WRITE(6,7500)FU
7500  FORMAT(' LOG-LIKELIHOOD=',G15.6,/)
      NZO=NZO+1
      IF(NZO.GT.50)NZO=50
      FLIKEL(NZO)=FU
C STORE PREVIOUS COEFFICIENTS
      DO 300 I=1,NPARAM
      PARPRE(I)=PARAM(I)
300   PARTRC(I,NZO)=PARAM(I)
C*******I PARAMETRI SONO PASSATI DENTRO 'PARAM' ***********************
      CALL GARCIM(NINIT,NFINSM,LOOP,YOBS,NEND,IREAD,
     ,XOBS,NEXO,UMC,NSTOCH,YDET,C,NCOEFF,RES2,
     ,RES,INRES,NFRES,YSTOC,
     ,IDYNAM,ICOEFF,TOLER1,
     ,NZO,NAM,IVOLTA,IFLAG,VC5,IH,
     ,G,PP,AUX3,
     ,PARAM,NPARAM,B,NCOEFB,
     ,ALFA0,ALFA,BETA,NALFA,NBETA,HT,DHTDP,ZT)
      IF(IFLAG.EQ.0)GO TO 1003
      LOOP=LOOP-1
      GO TO 630
1003  CONTINUE
C*********************************************************************
C IF RELATIVE EUCLIDEAN DISTANCE IS USED AS CONVERG.
      SUNO=0.
      SDUE=0.
      DO 3 I=1,NPARAM
      SUNO=SUNO+PARPRE(I)*PARPRE(I)
      PAPPO=(PARAM(I)-PARPRE(I))
      SDUE=SDUE+PAPPO*PAPPO
3     CONTINUE
      IF(SUNO.EQ.0.)SUNO=1.D-10
      IF(SDUE/SUNO.GT.TOLER1*TOLER1)GO TO 8765
C*********************************************************************
CC*********************************************************************
CC IF SQ.ROOT OF SUM OF SQUARED RELATIVE CHANGES IS USED AS CONVERG.
C      STRE=0.
C      DO 3 I=1,NPARAM
C      PIPPO=PARPRE(I)
C      IF(PIPPO.EQ.0.)PIPPO=1.D-10
C      PAPPO=(PARAM(I)-PARPRE(I))/PIPPO
C      STRE=STRE+PAPPO*PAPPO
C      IF(STRE.GT.TOLER1*TOLER1)GO TO 8765
C3     CONTINUE
CC*********************************************************************
      GO TO 8766
8765  CONTINUE
8766  CONTINUE
C      WRITE(6,222)NZO,TOLER1
C      IF(LOOP.LE.1)WRITE(8,222)NZO,TOLER1
C222   FORMAT(' INF. MATR. CONVERG. REACHED, ITER=',I3,'; TOLER1=',G15.6
C FULHESSIAN AND SEARCH
      IVOLT2=0
      DO 6765 IZO=1,100
      IH=0
C      IF(IZO.GT.50)IH=1
C IF NOT ENOUGH, FOR ITERATIONS WITH FULL HESSIAN MATRIX,
C REPLACE WITH DO 6765 IZO=1,300
C COMPUTE RESIDUALS FOR COVARIANCE MATRIX
C*******I PARAMETRI SONO PASSATI DENTRO 'PARAM' ***********************
      FU=VALUNC(IDYNAM,C,NCOEFF,IFLAG,RES2,RES,
     ,YDET,YOBS,YSTOC,XOBS,NEND,IREAD,NEXO,UMC,NSTOCH,NINIT,
     ,NFINSM,PARAM,NPARAM,ICOEFF,B,NCOEFB,
     ,ALFA0,ALFA,BETA,NALFA,NBETA,HT)
C      WRITE(6,7500)FU
      NZO=NZO+1
      IF(NZO.GT.50)NZO=50
      FLIKEL(NZO)=FU
C STORE PREVIOUS COEFFICIENTS
      DO 301 I=1,NPARAM
      PARPRE(I)=PARAM(I)
301   PARTRC(I,NZO)=PARAM(I)
C*******I PARAMETRI SONO PASSATI DENTRO 'PARAM' ***********************
      CALL GARCFH(NINIT,NFINSM,LOOP,YOBS,NEND,IREAD,
     ,XOBS,NEXO,UMC,NSTOCH,YDET,C,NCOEFF,RES2,
     ,RES,INRES,NFRES,YSTOC,
     ,IDYNAM,ICOEFF,TOLER2,
     ,NZO,NAM,IVOLT2,IFLAG,VC5,IH,
     ,G,PP,AUX3,
     ,PARAM,NPARAM,B,NCOEFB,
     ,ALFA0,ALFA,BETA,NALFA,NBETA,HT,DHTDP,ZT)
      IF(IFLAG.EQ.0)GO TO 1013
      LOOP=LOOP-1
      GO TO 630
1013  CONTINUE
C*********************************************************************
C IF RELATIVE EUCLIDEAN DISTANCE IS USED AS CONVERG.
      SUNO=0.
      SDUE=0.
      DO 13 I=1,NPARAM
      SUNO=SUNO+PARPRE(I)*PARPRE(I)
      PAPPO=(PARAM(I)-PARPRE(I))
      SDUE=SDUE+PAPPO*PAPPO
13    CONTINUE
      IF(SUNO.EQ.0.)SUNO=1.D-10
      IF(SDUE/SUNO.GT.TOLER2*TOLER2)GO TO 6765
C*********************************************************************
CC*********************************************************************
CC IF SQ.ROOT OF SUM OF SQUARED RELATIVE CHANGES IS USED AS CONVERG.
C      STRE=0.
C      DO 13 I=1,NPARAM
C      PIPPO=PARPRE(I)
C      IF(PIPPO.EQ.0.)PIPPO=1.D-10
C      PAPPO=(PARAM(I)-PARPRE(I))/PIPPO
C      STRE=STRE+PAPPO*PAPPO
C      IF(STRE.GT.TOLER2*TOLER2)GO TO 6765
C13    CONTINUE
CC*********************************************************************
      SUMGRA=0.
      DO 411 I=1,NPARAM
411   SUMGRA=SUMGRA+AUX3(I)*AUX3(I)
      IF(SUMGRA.LT.1.D-04)GO TO 511
      WRITE(6,8733)
      WRITE(8,8733)
8733  FORMAT(' ************NO CONVERG. DUE TO GRADIENT')
      WRITE(6,8734)NZO
C      WRITE(8,8734)NZO
8734  FORMAT(' AT ITERATION NO.',I4,/,' GRADIENT,PARAMETERS=')
      WRITE(6,102)(AUX3(I),I=1,NPARAM)
C      WRITE(8,102)(AUX3(I),I=1,NPARAM)
      WRITE(6,102)(PARAM(I),I=1,NPARAM)
C      WRITE(8,102)(PARAM(I),I=1,NPARAM)
      NOCONV=NOCONV+1
      LOOP=LOOP-1
      GO TO 630
511   CONTINUE
C      WRITE(6,221)NZO,TOLER2
C      IF(LOOP.LE.1)WRITE(8,221)NZO,TOLER2
C221   FORMAT(' FULL HESS. CONVERG. REACHED, ITER=',I3,'; TOLER2=',G15.6
      WRITE(35,8900)NZO
      WRITE(35,8901)(FLIKEL(I),I=1,NZO)
8900  FORMAT(I5)
8901  FORMAT(4G19.12)
      WRITE(67,8901) (PARAM(IPARAM),IPARAM=1,NPARAM)
      IPLOT(NZO)=IPLOT(NZO)+1
      TOLLOG=0.
      TOTDIS=0.
      DO 310 J=1,NPARAM
310   TOTDIS=TOTDIS+(PARAM(J)-PARTRC(J,1))**2
      TOTDIS=DSQRT(TOTDIS)
      DO 8910 I=1,NZO
CC*********************************************************************
CC IF SQ.ROOT OF SUM OF SQUARED RELATIVE CHANGES IS USED
C      STRE=0.
C      DO 311 J=1,NPARAM
C      PIPPO=PARAM(J)
C      IF(PIPPO.EQ.0.)PIPPO=1.D-10
C      PAPPO=(PARAM(J)-PARTRC(J,I))/PIPPO
C311   STRE=STRE+PAPPO*PAPPO
C      RELDIS=DSQRT(STRE)
CC*********************************************************************
C*********************************************************************
C IF EUCLEDEAN DISTANCE OR DISTANCE IN LOG-LIKEL. IS USED
      SDUE=0.
      DO 311 J=1,NPARAM
311   SDUE=SDUE+(PARAM(J)-PARTRC(J,I))**2
      SDUE=DSQRT(SDUE)
C      RELDIS=(FLIKEL(NZO)-FLIKEL(I))/(FLIKEL(NZO)-FLIKEL(1))
      RELDIS=0.
      IF(TOTDIS.NE.0.)RELDIS=SDUE/TOTDIS
C*********************************************************************
      RELLOG=TOLLOG
      IF(RELDIS.NE.0.)RELLOG=RELDIS
C      WRITE(6,500)RELLOG
C500   FORMAT(' RELLOG=',G15.6)
      SUMLOG(I)=SUMLOG(I)+RELLOG
8910  CONTINUE
      NZO1=NZO+1
      IF(NZO1.GT.50)GO TO 8767
      DO 8911 I=NZO1,50
8911  SUMLOG(I)=SUMLOG(I)+TOLLOG
8767  CONTINUE
      GO TO 6766
6765  CONTINUE
      WRITE(6,8744)
      WRITE(8,8744)
8744  FORMAT(' ************NO CONVERG. OF ITERAT.LIKELIHOOD MAXIM')
      NOCONV=NOCONV+1
      LOOP=LOOP-1
      GO TO 630
C
6766  CONTINUE
CC SI METTE PROVVISORIO, NEL PROGRAMMA SERIO CI VUOLE LA COVART
C      DO 118 I=1,NPARAM
C      STDERR(I)=0.
C      IF(VC5(I,I).GT.0.)STDERR(I)=DSQRT(VC5(I,I))
C118   CONTINUE
C      WRITE(6,119)
C      WRITE(6,102)(STDERR(I),I=1,NPARAM)
C      WRITE(8,119)
C      WRITE(8,102)(STDERR(I),I=1,NPARAM)
C119   FORMAT(' STD. ERR. OF PARAMETERS')
C**********************************************************************
C**********************************************************************
C
7766  CONTINUE
C ********TRUCCO DISGUSTOSO PER IL PS/2
      GO TO 7776
6600  GO TO 600
6999  GO TO 999
7776  CONTINUE
C*********FINE TRUCCO DISGUSTOSO
C***********************************************************************
C
C**********************************************************************
C COMPUTES ALL DIFFERENT ESTIMATES OF THE COVARIANCE MATRIX FOR THE
C COEFFICIENTS WHICH MAXIMISE THE LIKELIHOOD FOR THIS SAMPLE.
C VC5 : HESSIAN
C VC6 : OUTER PRODUCT OF FIRST DERIVATIVES
C VC9 : INFORMATION MATRIX
C
      CALL COVARC(NINIT,NFINSM,LOOP,YOBS,NEND,IREAD,

     ,XOBS,NEXO,UMC,NSTOCH,YDET,C,NCOEFF,RES2,
     ,RES,INRES,NFRES,YSTOC,
     ,IDYNAM,ICOEFF,TOLER2,
     ,NZO,NAM,IVOLT2,IFLAG,VC5,VC6,VC9,IH,
     ,G,PP,AUX3,
     ,PARAM,NPARAM,B,NCOEFB,
     ,ALFA0,ALFA,BETA,NALFA,NBETA,HT,DHTDP,ZT)
C
      IBLOCK=0
C
C      IF (LOOP.GT.1) GO TO 1828
C      DO 7264 I=1,NPARAM
C7264  WRITE(8,7267)I,(VC5(I,J),J=1,NPARAM)
C      DO 7265 I=1,NPARAM
C7265  WRITE(8,7267)I,(VC6(I,J),J=1,NPARAM)
C      DO 7266 I=1,NPARAM
C7266  WRITE(8,7267)I,(VC9(I,J),J=1,NPARAM)
C7267  FORMAT(/I5/(4G16.6))
C
C COMPUTES THE THREE COVARIANCE MATRICES BY INVERSION
C VC4 E' L'INVERSA DELL' O.P., VC3 L'INVERSA DELL'HESSIANO
C E VC7 L'INVERSA DELLA I.M.
1828  DO 1829 I=1,NPARAM
      DO 1829 J=1,NPARAM
      VC3(I,J)=VC5(I,J)
      VC4(I,J)=VC6(I,J)
1829  VC7(I,J)=VC9(I,J)
      CALL VSDMIG (VC3,0013,NPARAM,PP,IER3)
      CALL VSDMIG (VC4,0013,NPARAM,PP,IER4)
      CALL VSDMIG (VC7,0013,NPARAM,PP,IER7)
C COMPUTES THE
C COVARIANCE MATRIX AS IN WHITE:VC8(NPARAM,NPARAM)
      DO 1821 I=1,NPARAM
      DO 1821 J=1,NPARAM
      VV(I,J)=0.
      DO 1822 K=1,NPARAM
1822  VV(I,J)=VV(I,J)+VC3(I,K)*VC6(K,J)
1821  CONTINUE
      DO 1823 I=1,NPARAM
      DO 1823 J=1,NPARAM
      VC8(I,J)=0.
      DO 1824 K=1,NPARAM
1824  VC8(I,J)=VC8(I,J)+VV(I,K)*VC3(K,J)
1823  CONTINUE
      DO 1830 I=1,NPARAM
      DO 1830 J=1,NPARAM
1830  VC10(I,J)=VC8(I,J)
      CALL VSDMIG (VC10,0013,NPARAM,PP,IER10)
C COVARIANCE MATRIX AS IN BOLLERSLEV AND WOOLDRIDGE:VC13(NPARAM,NPARAM)
      DO 1831 I=1,NPARAM
      DO 1831 J=1,NPARAM
      VV(I,J)=0.
      DO 1832 K=1,NPARAM
1832  VV(I,J)=VV(I,J)+VC7(I,K)*VC6(K,J)
1831  CONTINUE
      DO 1833 I=1,NPARAM
      DO 1833 J=1,NPARAM
      VC13(I,J)=0.
      DO 1834 K=1,NPARAM
1834  VC13(I,J)=VC13(I,J)+VV(I,K)*VC7(K,J)
1833  CONTINUE
      DO 1840 I=1,NPARAM
      DO 1840 J=1,NPARAM
1840  VC15(I,J)=VC13(I,J)
      CALL VSDMIG (VC15,0013,NPARAM,PP,IER15)
C COMPUTE WALD STATISTICS (CWA): CHI SQUARED WITH NPARAM DEG.FREED.
      WAHE=0.
      WAOP=0.
      WAWH=0.
      WAIM=0.
      DO 1827 I=1,NPARAM
      DPI=PARAM(I)-PARFIX(I)
C      WRITE(6,6384) I,PARAM(I),PARFIX(I)
C      WRITE(8,6384) I,PARAM(I),PARFIX(I)
6384  FORMAT (I5,2F16.8)
      DO 1827 J=1,NPARAM
      WAOP=WAOP+DPI*VC6(I,J)*(PARAM(J)-PARFIX(J))
      WAHE=WAHE+DPI*VC5(I,J)*(PARAM(J)-PARFIX(J))
      WAIM=WAIM+DPI*VC9(I,J)*(PARAM(J)-PARFIX(J))
      WAWH=WAWH+DPI*VC10(I,J)*(PARAM(J)-PARFIX(J))
1827  CONTINUE
      IF(WAHE.LT.-999.999)WAHE=-999.999
      IF(WAOP.LT.-999.999)WAOP=-999.999
      IF(WAWH.LT.-999.999)WAWH=-999.999
      IF(WAIM.LT.-999.999)WAIM=-999.999
C      WRITE(8,9805)NPARAM,WAHE,WAOP,WAWH,WAIM
C9805  FORMAT (I4,4G18.12)
      WRITE(35,1805)NPARAM,WAHE,WAOP,WAWH,WAIM
1805  FORMAT(I3,' WAHE=',F12.6,
     ,';WAOP=',F12.6,';WAWH=',F12.6,';WAIM=',F12.6)
C
C CONSIDERS ONLY THE FIRST BLOCK IN THE MATRICES
C (ONLY THE COEFFICIENTS OF THE REGRESSORS)
      DO 2829 I=1,NCOEFF
      DO 2829 J=1,NCOEFF
      VC1(I,J)=VC3(I,J)
2829  VC2(I,J)=VC4(I,J)
      CALL VSDMIG (VC1,0007,NCOEFF,PP,IER1)
      CALL VSDMIG (VC2,0007,NCOEFF,PP,IER2)
      DO 2821 I=1,NCOEFF
      DO 2821 J=1,NCOEFF
      VV(I,J)=0.
      DO 2822 K=1,NCOEFF
2822  VV(I,J)=VV(I,J)+VC3(I,K)*VC2(K,J)
2821  CONTINUE
      DO 2823 I=1,NCOEFF
      DO 2823 J=1,NCOEFF
      VC12(I,J)=0.
      DO 2824 K=1,NCOEFF
2824  VC12(I,J)=VC12(I,J)+VV(I,K)*VC3(K,J)
2823  CONTINUE
      DO 2839 I=1,NCOEFF
      DO 2839 J=1,NCOEFF
2839  VC11(I,J)=VC12(I,J)
      CALL VSDMIG (VC11,0007,NCOEFF,PP,IER11)
C
C COMPUTE WALD STATISTICS (CWA): CHI SQUARED WITH NCOEFF DEG.FREED.
      WAHE=0.
      WAOP=0.
      WAWH=0.
      WAIM=0.
      DO 2827 I=1,NCOEFF
      DPI=PARAM(I)-PARFIX(I)
      DO 2827 J=1,NCOEFF
      WAOP=WAOP+DPI*VC2(I,J)*(PARAM(J)-PARFIX(J))
      WAHE=WAHE+DPI*VC1(I,J)*(PARAM(J)-PARFIX(J))
      WAIM=WAIM+DPI*VC9(I,J)*(PARAM(J)-PARFIX(J))
      WAWH=WAWH+DPI*VC11(I,J)*(PARAM(J)-PARFIX(J))
2827  CONTINUE
      IF(WAHE.LT.-999.999)WAHE=-999.999
      IF(WAOP.LT.-999.999)WAOP=-999.999
      IF(WAWH.LT.-999.999)WAWH=-999.999
      IF(WAIM.LT.-999.999)WAIM=-999.999
      WRITE(35,1805)NCOEFF,WAHE,WAOP,WAWH,WAIM
C
C CONSIDERS ONLY THE LAST BLOCK IN THE MATRICES
C (ONLY THE PARAMETERS  ALFA AND BETA)
      DO 2849 I=1,NABET1
      II=I+NCOEFF
      DO 2849 J=1,NABET1
      JJ=J+NCOEFF
      VC1(I,J)=VC3(II,JJ)
2849  VC2(I,J)=VC4(II,JJ)
      CALL VSDMIG (VC1,0007,NABET1,PP,IERA)
      CALL VSDMIG (VC2,0007,NABET1,PP,IERB)
      DO 2841 I=1,NABET1
      II=I+NCOEFF
      DO 2841 J=1,NABET1
      VV(I,J)=0.
      DO 2842 K=1,NABET1
      KK=K+NCOEFF
2842  VV(I,J)=VV(I,J)+VC3(II,KK)*VC2(K,J)
2841  CONTINUE
      DO 2843 I=1,NABET1
      DO 2843 J=1,NABET1
      JJ=J+NCOEFF
      VC12(I,J)=0.
      DO 2844 K=1,NABET1
      KK=K+NCOEFF
2844  VC12(I,J)=VC12(I,J)+VV(I,K)*VC3(KK,JJ)
2843  CONTINUE
      DO 2859 I=1,NABET1
      DO 2859 J=1,NABET1
2859  VC11(I,J)=VC12(I,J)
C
      CALL VSDMIG (VC11,0007,NABET1,PP,IERC)
      IF(IER1.EQ.0.AND.IER2.EQ.0.AND.IER3.EQ.0.AND.IER4.EQ.0.
     .AND.IER7.EQ.0.AND.IER10.EQ.0.AND.IER11.EQ.0.
     .AND.IERA.EQ.0.AND.IERB.EQ.0.AND.IERC.EQ.0)GO TO 1540
      WRITE(6,1541)IER1,IER2,IER3,IER4,IER7,IER10,IER11,IERA,IERB,IERC
      WRITE(8,1541)IER1,IER2,IER3,IER4,IER7,IER10,IER11,IERA,IERB,IERC
1541  FORMAT(' INVERSION ERRORS',10I6)
      LOOP=LOOP-1
      NREJ=NREJ+1
      GO TO 630
1540  CONTINUE
C
C COMPUTE WALD STATISTICS (CWA): CHI SQUARED WITH NABET1 DEG.FREED.
      WAHE=0.
      WAOP=0.
      WAWH=0.
      WAIM=0.
      DO 2847 I=1,NABET1
      II=I+NCOEFF
      DPI=PARAM(II)-PARFIX(II)
      DO 2847 J=1,NABET1
      JJ=J+NCOEFF
      WAOP=WAOP+DPI*VC2(I,J)*(PARAM(JJ)-PARFIX(JJ))
      WAHE=WAHE+DPI*VC1(I,J)*(PARAM(JJ)-PARFIX(JJ))
      WAIM=WAIM+DPI*VC9(II,JJ)*(PARAM(JJ)-PARFIX(JJ))
      WAWH=WAWH+DPI*VC11(I,J)*(PARAM(JJ)-PARFIX(JJ))
2847  CONTINUE
      IF(WAHE.LT.-999.999)WAHE=-999.999
      IF(WAOP.LT.-999.999)WAOP=-999.999
      IF(WAWH.LT.-999.999)WAWH=-999.999
      IF(WAIM.LT.-999.999)WAIM=-999.999
      WRITE(35,1805)NABET1,WAHE,WAOP,WAWH,WAIM
C MEAN VALUES OF THE VARIANCES
C
C      OPEN(21,FILE='SIZE1.DAT')
C      OPEN(22,FILE='SIZE3.DAT')
C4805  FORMAT(6G12.5)
      DO 1706 I=1,NPARAM
      IF (IBLOCK.EQ.0) GO TO 1705
C      IU=25+I
CC      WRITE(IU,1805)I,VC4(I,I),VC8(I,I)
      SVC4B(I)=SVC4B(I)+VC4(I,I)
      SVC8B(I)=SVC8B(I)+VC8(I,I)
      IF(VC4(I,I).GT.VC3(I,I))MAGOPB(I)=MAGOPB(I)+1
      IF(VC8(I,I).GT.VC3(I,I))MAGWHB(I)=MAGWHB(I)+1
      GO TO 1706
1705  CONTINUE
C      IU=35+I
CC      WRITE(IU,1805)I,VC3(I,I),VC4(I,I),VC8(I,I),VC7(I,I)
CC
CC SCRIVE IL PRIMO ED IL TERZO PARAMETRO CON VARIANZE PER CONTROLLARE
CC IL SIZE DEL TEST T (WALD)
CC
C      IF(I.NE.1) GO TO 4572
C      WRITE(21,4805)
C     $        PARAM(I),VC3(I,I),VC4(I,I),VC8(I,I),VC7(I,I),VC13(I,I)
C4572  CONTINUE
C      IF(I.NE.3) GO TO 4573
C      WRITE(22,4805)
C     $        PARAM(I),VC3(I,I),VC4(I,I),VC8(I,I),VC7(I,I),VC13(I,I)
C4573  CONTINUE
      SVC4(I)=SVC4(I)+VC4(I,I)
      SVC3(I)=SVC3(I)+VC3(I,I)
      SVC8(I)=SVC8(I)+VC8(I,I)
      SVC7(I)=SVC7(I)+VC7(I,I)
      SVC13(I)=SVC13(I)+VC13(I,I)
      IF(VC4(I,I).GT.VC3(I,I))MAGOUT(I)=MAGOUT(I)+1
      IF(VC7(I,I).GT.VC3(I,I))MAGINF(I)=MAGINF(I)+1
      IF(VC8(I,I).GT.VC3(I,I))MAGWHI(I)=MAGWHI(I)+1
1706  CONTINUE
C      IF(LOOP.NE.46)GO TO 67676
C      WRITE(21,67677)(YSTOC(1,IC),IC=NINIT,NFINSM)
C67677 FORMAT(4G15.6)
C      STOP
C67676 CONTINUE
C
C THE FIRST TIME (IBLOCK=0) THE FULL O.P. IS USED
C THE SECOND TIME (IBLOCK=1) THE BLOCK DIAGONAL O.P. IS USED
      IF (IBLOCK.EQ.1) GO TO 1200
      IBLOCK=1
      DO 1819 I=1,NCOEFF
      DO 1819 J=1,NABET1
      NCJ=NCOEFF+J
      VC6(I,NCJ)=0.
1819  VC6(NCJ,I)=0.
      GO TO 1828
C
C  TO COMPUTE PARAMETERS MEAN AND VARIANCE
1200  DO 1218 I=1,NPARAM
      PARSUM(I)=PARSUM(I)+PARAM(I)
1218  PARSU2(I)=PARSU2(I)+PARAM(I)*PARAM(I)
C
      WRITE(6,1202)LOOP
1202  FORMAT(' R',I6)
      IF(LOOP/NPRINT*NPRINT.NE.LOOP)GO TO 630
C
600   CONTINUE
      IF(IDYNAM.EQ.0)WRITE(8,2019)
      IF(IDYNAM.NE.0)WRITE(8,2020)
      IF(IDYNAM.EQ.0)WRITE(6,2019)
      IF(IDYNAM.NE.0)WRITE(6,2020)
2019  FORMAT(' ONE-STEP SIMULATION')
2020  FORMAT(' DYNAMIC SIMULATION')
      WRITE(6,2006) NOCONV,LOOP,NREJ,LOOP
      WRITE(8,2006) NOCONV,LOOP,NREJ,LOOP
2006  FORMAT (/' NO CONVERGENCE: ',I4,'/',I4,5X,'REJECTED: ',I4,'/',I4)
      WRITE(6,2318)
      WRITE(8,2318)
2318  FORMAT(/,' PARAMETERS MEAN AND VARIANCE',/,
     ,'     TRUE VALUE    STOCH.MEAN    VARIANCE'/)
      IF(LOOP.LE.0)LOOP=1
      DO 2361 I=1,NPARAM
      PARMEA=PARSUM(I)/LOOP
      IF (LOOP.GT.1) VARMEA=(PARSU2(I)-LOOP*PARMEA*PARMEA)/(LOOP-1)
      WRITE(6,2014)I,PARFIX(I),PARMEA,VARMEA
      WRITE(8,2014)I,PARFIX(I),PARMEA,VARMEA
2361  CONTINUE
      WRITE(6,2018)LOOP
      WRITE(8,2018)LOOP
2018  FORMAT(/,' MEAN OF DIAGONAL TERMS OF INVERTED MATRICES',/,
     ,' COMPUTED WITH STOCHASTIC SIMULATION AND RE-ESTIMATION WITH',/,
     ,/,I5,' REPLICATIONS.',//,
     ,9X,' -HESSIAN       O.P.       WHITE        INF.MAT.',
     ,'  BOLLERS-WOOLDR.'/)
      IF(LOOP.LE.0)LOOP=1
      DO 2061 I=1,NPARAM
      HESMEA=SVC3(I)/LOOP
      AMEMEA=SVC7(I)/LOOP
      OUTMEA=SVC4(I)/LOOP
      WHIMEA=SVC8(I)/LOOP
      WOOMEA=SVC13(I)/LOOP
      WRITE(6,2014)I,HESMEA,OUTMEA,WHIMEA,AMEMEA,WOOMEA
      WRITE(8,2014)I,HESMEA,OUTMEA,WHIMEA,AMEMEA,WOOMEA
2061  CONTINUE
      WRITE(6,2022)
      WRITE(8,2022)
2022  FORMAT (/' O.P. BLOCK DIAGONAL')
      DO 3062 I=1,NPARAM
      HESMEA=SVC3(I)/LOOP
      AMEMEA=SVC7(I)/LOOP
      OUTMEA=SVC4B(I)/LOOP
      WHIMEA=SVC8B(I)/LOOP
      WRITE(6,2014)I,HESMEA,OUTMEA,WHIMEA,AMEMEA
      WRITE(8,2014)I,HESMEA,OUTMEA,WHIMEA,AMEMEA
2014  FORMAT(1X,I3,1X,5G13.5)
3062  CONTINUE
      WRITE(8,5018) LOOP
      WRITE(6,5018) LOOP
5018  FORMAT(
     ,/,I5,' REPLICATIONS.',//12X,
     ,' I.M.GT.HES    O.P.GT.HES    WHI.GT.HES',
     ,/)
      DO 5061 I=1,NPARAM
      WRITE(6,2024)I,MAGINF(I),MAGOUT(I),MAGWHI(I)
      WRITE(8,2024)I,MAGINF(I),MAGOUT(I),MAGWHI(I)
5061  CONTINUE
      WRITE(6,2022)
      WRITE(8,2022)
      DO 5062 I=1,NPARAM
      WRITE(6,2024)I,MAGINF(I),MAGOPB(I),MAGWHB(I)
      WRITE(8,2024)I,MAGINF(I),MAGOPB(I),MAGWHB(I)
2024  FORMAT(1X,I3,1X,3I14)
5062  CONTINUE
C
1201  FORMAT('1')
C      CALL CMS('CP      ','SPOOL   ','PRT     ','CLOSE   ')
C
      IF(LOOP.GT.1)GO TO 1784
      IF(NPARAM.GT.34)GO TO 1784
      WRITE(6,1729)
      WRITE(8,1729)
1729  FORMAT(/,' -HESSIAN ')
      DO 1728 I=1,NCOEFF
      WRITE(6,1711)(VC5(I,J),J=1,I)
1728  WRITE(8,1711)(VC5(I,J),J=1,I)
      WRITE(6,1730)
      WRITE(8,1730)
1730  FORMAT(/,' OUTER PRODUCT ')
      DO 1731 I=1,NCOEFF
      WRITE(6,1711)(VC6(I,J),J=1,I)
1731  WRITE(8,1711)(VC6(I,J),J=1,I)
      WRITE(6,1724)
      WRITE(8,1724)
1724  FORMAT(/,' -INFORMATION MATRIX')
      DO 1725 I=1,NPARAM
      WRITE(6,1711)(VC9(I,J),J=1,I)
1725  WRITE(8,1711)(VC9(I,J),J=1,I)
1711  FORMAT(4G20.12)
1784  CONTINUE
C
      IF(LOOP.LT.NREP)GO TO 630
999   STOP
      END
C
C CALLED BY    VSGARCH  FORTRAN
C FIRST SUBROUTINE IS FOR OLS ESTIMATION
      SUBROUTINE OLS(NINIT,NFINSM,YOBS,NEND,IREAD,
     ,XOBS,NEXO,UMC,NSTOCH,YY,C,NCOEFF,OLDC,VC,
     ,YSTOC,IDYNAM,AMAX,ICOEFF,
     ,AUX,IFLAG,B,NCOEFB,G)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION YOBS(NEND,IREAD),XOBS(NEXO,IREAD),UMC(NSTOCH),
     ,YY(NEND),C(NCOEFF),D(0013),B(NCOEFB),OLDC(NEND),G(0013,003009),
     ,VC(NCOEFF,NCOEFF),YSTOC(NEND,IREAD),AMAX(NEND,IREAD),
     ,ICOEFF(NSTOCH)
      DIMENSION AUX(NCOEFF)
      RELINC=0.5
      IFLAG=0
      CALL VSRSTR(C,NCOEFF,B,NCOEFB,ICOEFF,NSTOCH)
      DO 88 IC=NINIT,NFINSM
      IF(IDYNAM.NE.0)GO TO 188
      CALL VSMODE(YSTOC(1,IC),XOBS,NEXO,IREAD,IC,YOBS,NEND,UMC,B,
     ,AMAX(1,IC),IFLAG,NSTOCH,NCOEFB)
      GO TO 88
188   CONTINUE
      CALL VSMODE(YSTOC(1,IC),XOBS,NEXO,IREAD,IC,YSTOC,NEND,UMC,B,
     ,AMAX(1,IC),IFLAG,NSTOCH,NCOEFB)
88    CONTINUE
      DO 87 I=1,NCOEFF
      AUX(I)=0.
      DO 87 J=1,NCOEFF
87    VC(I,J)=0.
      DO 90 IC=NINIT,NFINSM
      DO 91 IEXPL=1,NCOEFF
      OLDC(1)=C(IEXPL)
      DELTC=RELINC
      IF(OLDC(1).NE.0.)DELTC=OLDC(1)*RELINC
      C(IEXPL)=OLDC(1)+DELTC
      CALL VSRSTR(C,NCOEFF,B,NCOEFB,ICOEFF,NSTOCH)
      IF(IDYNAM.NE.0)GO TO 194
      CALL VSMODE(YSTOC(1,IC),XOBS,NEXO,IREAD,IC,YOBS,NEND,UMC,B,YY,
     ,IFLAG,NSTOCH,NCOEFB)
      GO TO 195
194   CONTINUE
      CALL VSMODE(YSTOC(1,IC),XOBS,NEXO,IREAD,IC,YSTOC,NEND,UMC,B,YY,
     ,IFLAG,NSTOCH,NCOEFB)
195   CONTINUE
      DELTC=C(IEXPL)-OLDC(1)
      DERIVO=(YY(1)-AMAX(1,IC))/DELTC
      C(IEXPL)=OLDC(1)
      G(IEXPL,IC)=DERIVO
91    CONTINUE
      CALL VSRSTR(C,NCOEFF,B,NCOEFB,ICOEFF,NSTOCH)
C  CUMULATES ALL THE W'Z INTO DIAGONAL BLOCKS OF VC
C  AND W'Y INTO ELEMENTS OF AUX
C      WRITE(6,800)YSTOC(1,IC),(G(I,IC),I=1,NCOEFF)
C800   FORMAT(5G14.6)
      DO 71 I=1,NCOEFF
      AUX(I)=AUX(I)+G(I,IC)*YSTOC(1,IC)
      DO 71 J=1,NCOEFF
71    VC(I,J)=VC(I,J)+G(I,IC)*G(J,IC)
90    CONTINUE
      NAB=0
      NC=NCOEFF
      CALL VSDMIG(VC,NCOEFF,NCOEFF,D,IER)
      IF(IER.EQ.0)GO TO 3
      WRITE(6,101)
      WRITE(8,101)
101   FORMAT(' OLS: MATRIX IS SINGULAR',/,
     ,' ITERATION INVALID FOR THIS EQUATION',/,
     ,' INITIAL COEFFICIENTS REMAIN UNCHANGED')
      DO 96 I=1,NC
      DO 96 J=1,NC
96    VC(I,J)=0.
      GO TO 99
3     CONTINUE
C COMPUTES COEFFICIENTS
      DO 135 I=1,NCOEFF
135   C(I)=0.
C      WRITE(8,200)
200   FORMAT(' STIME OLS')
      DO 1 I=1,NCOEFF
      DO 2 J=1,NCOEFF
      C(I)=C(I)+VC(I,J)*AUX(J)
2     CONTINUE
1     CONTINUE
C      WRITE(8,100)(C(I),I=1,NCOEFF)
100   FORMAT(5G15.6)
      CALL VSRSTR(C,NCOEFF,B,NCOEFB,ICOEFF,NSTOCH)
99    RETURN
      END
C
C ALFA0, ALFA E BETA SONO PASSATI DA FUORI.
C GENERA LA UMC AL TEMPO IC, IL SUO QUADRATO
C LO METTE NEL VETTORE (MATRICE) RES2 NELLA POSIZIONE IC,
C E INTANTO CALCOLA L'ELEMENTO IC-ESIMO DEL VETTORE HT
C (E LO METTE IN HT).
C IN ALTRE PAROLE, RES2 E HT SONO CALCOLATI DENTRO (UN ELEMENTO
C AD OGNI CHIAMATA).
      SUBROUTINE NAGAR2(UN01,IREAD,NSTOCH,UMC,NEND,ISEME,IC,
     ,ALFA0,ALFA,BETA,NALFA,NBETA,HT,RES2,NTSTUD)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION UN01(IREAD),UMC(NSTOCH),
     ,RES2(NEND,IREAD),
     ,ALFA(NALFA),BETA(NBETA),HT(IREAD)
      NUMCAS=NSTOCH
      IF(NTSTUD.LE.0)GO TO 1
C GENERATE STANDARDIZED STUDENT'S T WITH NTSTUD DEG.OF FREED.
C CHECK FOR DIMENSION
      IF(NTSTUD.LE.IREAD-1.AND.NTSTUD.GT.2)GO TO 2
      WRITE(6,100)NTSTUD,IREAD
      WRITE(8,100)NTSTUD,IREAD
100   FORMAT(' SUBROUTINE NAGAR2 INSUF.DIM.',/,
     ,' OR DGF.LE.2, NTSTUD,IREAD=',2I5)
      STOP
2     CONTINUE
      NUMCAS=NTSTUD+1
      CALL VSRAND(ISEME,UN01,NUMCAS)
      CHI2=0.
      DO 3 I=1,NTSTUD
3     CHI2=CHI2+UN01(I)*UN01(I)
      CHI2DF=CHI2/NTSTUD
      TSTUD=UN01(NUMCAS)/DSQRT(CHI2DF)
      A=NTSTUD
      AA=NTSTUD-2
      STANDT=TSTUD/DSQRT(A/AA)
      UN01(1)=STANDT
      GO TO 4
1     CALL VSRAND(ISEME,UN01,NUMCAS)
4     SEGNO=1.
      IF(UN01(1).LT.0.)SEGNO=-1.
      PIPPO=UN01(1)
      IF(PIPPO.LT.0.)PIPPO=-PIPPO
      UN01(1)=PIPPO**1.0*SEGNO
      HT(IC)=ALFA0
      IF(NALFA.LE.0)GO TO 270
      DO 271 I=1,NALFA
271   HT(IC)=HT(IC)+RES2(1,IC-I)*ALFA(I)
270   CONTINUE
      IF(NBETA.LE.0)GO TO 272
      DO 273 I=1,NBETA
273   HT(IC)=HT(IC)+HT(IC-I)*BETA(I)
272   CONTINUE
      IF(HT(IC).LT.0.)WRITE(6,101)HT(IC)
101   FORMAT(' HT NEGATIVO=',G15.6)
C ARBITRARIO
      IF(HT(IC).LT.0.)HT(IC)=0.0000001
      UMC(1)=UN01(1)*DSQRT(HT(IC))
      RES2(1,IC)=UMC(1)*UMC(1)
      RETURN
      END
C**********************************************************************
C COMPUTE MATRIX OF RESIDUALS (RES) AND THEIR COVARIANCE MATRIX (SIGMA)
C**********************************************************************
C COMPUTE THE LOG-LIKELIHOOD FUNCTION
C I PARAMETRI SONO PASSATI NEL VETTORE PARAM(NPARAM).
C ALFA0, ALFA E BETA VENGONO RICAVATI DAL VETTORE PARAM IN VALUNC
C RES, RES2 E HT DEVONO ESSERE CALCOLATI DENTRO VALUNC
C RES2 CONTIENE I RESIDUI AL QUADRATO
C**********************************************************************
      FUNCTION VALUNC(IDYNAM,C,NCOEFF,IFLAG,RES2,RES,
     ,YDET,YOBS,YSTOC,XOBS,NEND,IREAD,NEXO,UMC,NSTOCH,NINIT,NFINSM,
     ,PARAM,NPARAM,ICOEFF,B,NCOEFB,
     ,ALFA0,ALFA,BETA,NALFA,NBETA,HT)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION
     ,YDET(NEND,IREAD),YOBS(NEND,IREAD),RES2(NEND,IREAD),
     ,YSTOC(NEND,IREAD),
     ,RES(NSTOCH,IREAD),
     ,UMC(NSTOCH),XOBS(NEXO,IREAD),C(NCOEFF),
     ,B(NCOEFB),
     ,PARAM(NPARAM),ICOEFF(NSTOCH)
      DIMENSION ALFA(NALFA),BETA(NBETA),HT(IREAD)
      DO 1 I=1,NCOEFF
1     C(I)=PARAM(I)
      ALFA0=PARAM(NCOEFF+1)
      IF(NALFA.LE.0)GO TO 660
      DO 661 I=1,NALFA
661   ALFA(I)=PARAM(NCOEFF+1+I)
660   CONTINUE
      IF(NBETA.LE.0)GO TO 662
      DO 663 I=1,NBETA
663   BETA(I)=PARAM(NCOEFF+1+NALFA+I)
662   CONTINUE
600   FORMAT(G15.6)
C CALCOLA RESIDUI ECC. NEL PERIODO VERO DI STIMA
      CALL VSRSTR(C,NCOEFF,B,NCOEFB,ICOEFF,NSTOCH)
      DO 506 IC=NINIT,NFINSM
      IF(IDYNAM.NE.0)GO TO 606
      CALL VSMODE(YSTOC(1,IC),XOBS,NEXO,IREAD,IC,YOBS,NEND,UMC,B,
     ,YDET(1,IC),IFLAG,NSTOCH,NCOEFB)
      GO TO 506
606   CONTINUE
      CALL VSMODE(YSTOC(1,IC),XOBS,NEXO,IREAD,IC,YSTOC,NEND,UMC,B,
     ,YDET(1,IC),IFLAG,NSTOCH,NCOEFB)
506   CONTINUE
      DO 501 IC=NINIT,NFINSM
      RES(1,IC)=YSTOC(1,IC)-YDET(1,IC)
      RES2(1,IC)=RES(1,IC)*RES(1,IC)
501   CONTINUE
C COME VALORE INIZIALE (AI TEMPI 0, -1, -2, ECC.)
C DEL RESIDUO AL QUADRATO E DI HT SI IMPIEGA LA VARIANZA NONCONDIZIONAT
C CALCOLATA DAL CAMPIONE.
C COME VALORE INIZIALE DEI RESIDUI SI USA ZERO.
C      DENOM=1.
C      IF(NALFA.LE.0)GO TO 260
C      DO 261 I=1,NALFA
C261   DENOM=DENOM-ALFA(I)
C260   CONTINUE
C      IF(NBETA.LE.0)GO TO 262
C      DO 263 I=1,NBETA
C263   DENOM=DENOM-BETA(I)
C262   CONTINUE
C      IF(DENOM.LT.0.)WRITE(6,200)ALFA0,ALFA(1),BETA(1)
200   FORMAT(' ALFA0, ALFA1, BETA1=',3G15.6)
C      IF(DENOM.LT.0.)WRITE(6,100)DENOM
C100   FORMAT(' 1-ALFA-BETA=',G15.6)
C ARBITRARIO
C      IF(DENOM.LT.0.)DENOM=0.0001
C      UNCVAR=ALFA0/DENOM
      INDIET=NALFA
      UNCVAR=0.0D0
      DO 131 IC=NINIT,NFINSM
131   UNCVAR=UNCVAR+RES(1,IC)*RES(1,IC)
      ICULO=NFINSM-NINIT+1
      UNCVAR=UNCVAR/ICULO
      IF(NBETA.GT.NALFA)INDIET=NBETA
      I1=NINIT-INDIET
      I2=NINIT-1
      DO 2 IC=I1,I2
      RES(1,IC)=0.
      RES2(1,IC)=UNCVAR
      HT(IC)=UNCVAR
2     CONTINUE
      DO 3 IC=NINIT,NFINSM
      HT(IC)=ALFA0
      IF(NALFA.LE.0)GO TO 270
      DO 271 I=1,NALFA
271   HT(IC)=HT(IC)+RES2(1,IC-I)*ALFA(I)
270   CONTINUE
      IF(NBETA.LE.0)GO TO 272
      DO 273 I=1,NBETA
273   HT(IC)=HT(IC)+HT(IC-I)*BETA(I)
272   CONTINUE
      IF(HT(IC).LT.0.)WRITE(6,200)ALFA0,ALFA(1),BETA(1)
      IF(HT(IC).LE.0.)WRITE(6,101)HT(IC)
101   FORMAT(' VALUNC: HT NEGATIVO=',G15.6)
C ARBITRARIO
      IF(HT(IC).LE.0.)HT(IC)=0.0000001
3     CONTINUE
      VALUNC=0.
      DO 4 IC=NINIT,NFINSM
      VALUNC=VALUNC-0.5*DLOG(HT(IC))-0.5*RES2(1,IC)/HT(IC) - .9189385
4     CONTINUE
      RETURN
      END
C**********************************************************************
C COMPUTE MATRIX OF RESIDUALS (RES) AND THEIR COVARIANCE MATRIX (SIGMA)
C**********************************************************************
      SUBROUTINE SIG(NINIT,NFINSM,YOBS,NEND,IREAD,UMC,
     ,XOBS,NEXO,NSTOCH,YY,C,NCOEFF,
     ,RES,SIGMA,YSTOC,IDYNAM,B,NCOEFB,
     ,ALFA0,ALFA,BETA,NALFA,NBETA)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION YOBS(NEND,IREAD),XOBS(NEXO,IREAD),
     ,YY(NEND),C(NCOEFF),UMC(NSTOCH),
     ,B(NCOEFB),
     ,YSTOC(NEND,IREAD),
     ,SIGMA(NSTOCH,NSTOCH),
     ,RES(NSTOCH,IREAD)
      DIMENSION ALFA(NALFA),BETA(NBETA)
      CALL VSRSTR(C,NCOEFF,B,NCOEFB,ICOEFF,NSTOCH)
      DO 1035 IC=NINIT,NFINSM
      IF(IDYNAM.NE.0)GO TO 1235
      CALL VSMODE(YSTOC(1,IC),XOBS,NEXO,IREAD,IC,YOBS,NEND,UMC,B,
     ,YY,IFLAG,NSTOCH,NCOEFB)
      GO TO 1335
1235  CONTINUE
      CALL VSMODE(YSTOC(1,IC),XOBS,NEXO,IREAD,IC,YSTOC,NEND,UMC,B,
     ,YY,IFLAG,NSTOCH,NCOEFB)
1335  CONTINUE
      RES(1,IC)=YSTOC(1,IC)-YY(1)
1035  CONTINUE
C COMPUTE VARIANCE OF RESIDUALS (HOMOSKEDASTIC)
      SIGMA(1,1)=0.
      DO 1098 K=NINIT,NFINSM
1098  SIGMA(1,1)=SIGMA(1,1)+RES(1,K)*RES(1,K)
      SIGMA(1,1)=SIGMA(1,1)/(NFINSM-NINIT+1)
C      WRITE(8,1037)
1037  FORMAT ( '   STIMA DI SIGMA ')
C      WRITE(8,1038) SIGMA(1,1)
1038  FORMAT(G15.6)
CC********************TEMPORANEO: ASSEGNA AD ALFA0 SIGMA(1,1),
CC E METTE A ZERO GLI ALTRI ALFA E BETA
C      ALFA0=SIGMA(1,1)
C      IF(NALFA.LE.0)GO TO 1
C      DO 2 I=1,NALFA
C2     ALFA(I)=0.
C1     CONTINUE
C      IF(NBETA.LE.0)GO TO 3
C      DO 4 I=1,NBETA
C4     BETA(I)=0.
C3     CONTINUE
C********************TEMPORANEO: ASSEGNA VALORI A PERA
C E METTE A XXXX GLI ALTRI ALFA E BETA
      IF(NALFA.LE.0)GO TO 1
      DO 2 I=1,NALFA
2     ALFA(I)=0.15/NALFA
1     CONTINUE
      IF(NBETA.GT.0)GO TO 6
      DO 7 I=1,NALFA
7     ALFA(I)=0.7/NALFA
      IF(NBETA.LE.0)GO TO 3
6     DO 4 I=1,NBETA
4     BETA(I)=.55/NBETA
3     CONTINUE
      ALFA0=SIGMA(1,1)*0.3
C SI NOTI CHE SOMME DI ALFA' PIU SOMME DI BETA E' SEMPRE UGUALE 0.7
      RETURN
      END
C**********************************************************************
C******           MATRICE DI INFORMAZIONE
C******
C******  I PARAMETRI SONO PASSATI DENTRO IL VETTORE PARAM
C******  C, ALFA E BETA SI RICAVANO ALL'INIZIO DA PARAM
C******
C******
C**********************************************************************
C********************HESSTOBI******************************************
C
C
      SUBROUTINE CHECK(PARAM,NCOEFF,NPARAM)
C
C
C     THIS ROUTINE CONTROLL THAT THE VALUES OF THE PARAMETERS OF THE
C     CONDITIONAL VARIANCE HT ARE IN THE SET OF THE ADMISSIBLE VALUES
C     IF ALFA0 IS LESS OR EQUAL THAN ZERO IT IS SET TO 0.0000001
C     IF ALFA AND BETA ARE LESS THAN ZERO THEY ARE SET TO ZERO
C     ALSO THE SUM OF ALFA AND BETA IS CONTROLLED AND IF IT IS BIGGER
C     THAN ONE THE ALFA AND BETA ARE NORMALIZED (DIVIDED BY SUM)

C
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION PARAM(NPARAM)
C
C
      NABET1=NPARAM-NCOEFF
      SUM=0.0D0
      IF(PARAM(NCOEFF+1).LE.0) PARAM(NCOEFF+1)=0.0000001
      IF (NABET1.LE.1) GO TO 2
      ICULO=NABET1-1
      DO 1 I=1,ICULO
      IF(PARAM(NCOEFF+1+I).LT.0) PARAM(NCOEFF+1+I)=0.0
      SUM=SUM+PARAM(NCOEFF+1+I)
 1    CONTINUE
 2    CONTINUE
      IF(SUM.LE.1.0) GO TO 4
      DO 3 I=1,ICULO
      PARAM(NCOEFF+1+I)=PARAM(NCOEFF+1+I)/SUM
 3    CONTINUE
 4    CONTINUE
      RETURN
      END
C**********************************************************************
C******           MATRICE DI INFORMAZIONE DIAGONALE A BLOCCHI
C******
C******  I PARAMETRI SONO PASSATI DENTRO IL VETTORE PARAM
C******  C, ALFA E BETA SI RICAVANO ALL'INIZIO DA PARAM
C******
C******
C**********************************************************************
      SUBROUTINE GARCIM(NINIT,NFINSM,LOOP,YOBS,NEND,IREAD,
     ,XOBS,NEXO,UMC,NSTOCH,YDET,C,NCOEFF,RES2,
     ,RES,INRES,NFRES,YSTOC,
     ,IDYNAM,ICOEFF,TOLER,
     ,IZO,NAM,IVOLTA,IFLAG,VC5,IH,
     ,G,PP,AUX3,
     ,PARAM,NPARAM,B,NCOEFB,
     ,ALFA0,ALFA,BETA,NALFA,NBETA,HT,DHTDP,ZT)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION YOBS(NEND,IREAD),XOBS(NEXO,IREAD),UMC(NSTOCH),
     ,YDET(NEND,IREAD),C(NCOEFF),
     ,B(NCOEFB),YSTOC(NEND,IREAD),NAM(NEND),
     ,RES2(NEND,IREAD),RES(NSTOCH,IREAD),ICOEFF(NSTOCH),
     ,INRES(NSTOCH),NFRES(NSTOCH),PARAM(0013)
      DIMENSION VC5(0013,0013),AUX3(NPARAM)
      DIMENSION ALFA(NALFA),BETA(NBETA),HT(IREAD)
      DIMENSION DHTDP(0013,003009),ZT(0006),
     ,G(0013,003009),ASUM2(0013)
      DIMENSION STEP(0013),GG(0013),PP(00141)
      IV=0
      IFLAG=0
      ISECDE=0
C      IF(IVOLTA.GT.0)GO TO 1011
      IT1=0
      IT2=0
      IT3=0
      IT4=0
      IT5=0
      OLDSTP=9.D39
      RELC=0.5
      RELU=0.5D-00
      RELY=0.5D-00
      NABET=NALFA+NBETA
      NABET1=NABET+1
      NCOEF1=NCOEFF+1
1011  IVOLTA=IVOLTA+1
C     IF (IVOLTA.GT.11) STOP
      DO 28 I=1,NCOEFF
28    C(I)=PARAM(I)
      ALFA0=PARAM(NCOEFF+1)
      IF(NALFA.LE.0)GO TO 660
      DO 661 I=1,NALFA
661   ALFA(I)=PARAM(NCOEFF+1+I)
660   CONTINUE
      IF(NBETA.LE.0)GO TO 662
      DO 663 I=1,NBETA
663   BETA(I)=PARAM(NCOEFF+1+NALFA+I)
662   CONTINUE
C      WRITE(6,671)
C671   FORMAT(' PARAMETRI ALL''INIZIO DI MATINF')
C      WRITE(6,102)(PARAM(I),I=1,NPARAM)
C      WRITE(6,672)
C672   FORMAT(' C, ALFA E BETA ALL''INIZIO DI MATINF')
C      WRITE(6,102)(C(I),I=1,NCOEFF)
C      WRITE(6,102)ALFA0,ALFA(1),BETA(1)
C *********************************************
C INIZIO DEL CALCOLO DI DHTDP
C PARTE RELATIVA AI PARAMETRI ALFA E BETA
C SI COMINCIA CALCOLANDO LE DERIVATE DEI VALORI INIZIALI
C AVENDO SCELTO COME VAL. INIZIALI LA VARIANZA NONCONDIZIONATA
C COME VALORE INIZIALE (AI TEMPI 0, -1, -2, ECC.)
C DI HT SI IMPIEGA LA VARIANZA NONCONDIZIONATA
C CALCOLATA DAI RESIDUI.
      IF(NBETA.LE.0)GO TO 121
      DO 21 IC=1,NBETA
      DO 31 I=1,NABET1
      DHTDP(NCOEFF+I,NINIT-IC)=0.0D0
31    CONTINUE
21    CONTINUE
121   CONTINUE
C COSTRUZIONE MATRICE DHTDP, PARTE RELATIVA A ALFA E BETA (EQ.21)
      DO 4 IC=NINIT,NFINSM
C SI RIEMPIE ZT AL TEMPO IC (PAG.315)
      ZT(1)=1.
      IF(NALFA.LE.0)GO TO 270
      DO 271 I=1,NALFA
271   ZT(1+I)=RES2(1,IC-I)
270   CONTINUE
      IF(NBETA.LE.0)GO TO 272
      DO 273 I=1,NBETA
273   ZT(1+NALFA+I)=HT(IC-I)
272   CONTINUE
C  SI RIEMPIE DHTDP AL TEMPO IC
C  LA PARTE RELATIVA AI PARAMETRI ALFA E BETA (EQ.21 PAG.316)
      DO 5 I=1,NABET1
      DHTDP(NCOEFF+I,IC)=0.
5     CONTINUE
      DO 6 I=1,NABET1
      DHTDP(NCOEFF+I,IC)=DHTDP(NCOEFF+I,IC)+ZT(I)
6     CONTINUE
      IF(NBETA.LE.0)GO TO 7
      DO 8 I=1,NABET1
      DO 8 J=1,NBETA
8     DHTDP(NCOEFF+I,IC)=DHTDP(NCOEFF+I,IC)+DHTDP(NCOEFF+I,IC-J)*BETA(J)
7     CONTINUE
4     CONTINUE
C COSTRUZIONE MATRICE DHTDP, PARTE RELATIVA AI COEFFICIENTI (EQ.24)
C COME VALORI INIZIALI (TEMPO 0, -1, ECC.) DELLE DERIVATE DI HT
C RISPETTO AI COEFFICIENTI SI PRENDE ZERO.
C COME VALORI INIZIALI DEI RESIDUI SI PRENDE ZERO
C (GIA' FATTO DENTRO VALUNC)
      INDIET=NALFA
      IF(NBETA.GT.NALFA)INDIET=NBETA
      I1=NINIT-INDIET
      I2=NINIT-1
      ICULO=NFINSM-NINIT+1
      DO 10 IC=I1,I2
      DO 10 I=1,NCOEFF
      ASUM2(I)=0.0
      DO 45 ISP=NINIT,NFINSM
      ASUM2(I)=ASUM2(I)-2.*RES(1,ISP)*G(I,ISP)
 45   CONTINUE
      ASUM2(I)=ASUM2(I)/ICULO
10    DHTDP(I,IC)=ASUM2(I)
      DO 9 IC=NINIT,NFINSM
      DO 11 I=1,NCOEFF
      DHTDP(I,IC)=0.
11    CONTINUE
      IF(NALFA.LE.0)GO TO 15
      DO 12 I=1,NCOEFF
      DO 12 J=1,NALFA
      IF(IC-NALFA.LT.NINIT) GO TO 376
      DHTDP(I,IC)=DHTDP(I,IC)-2.*ALFA(J)*G(I,IC-J)*RES(1,IC-J)
      GO TO 12
376   CONTINUE
      DHTDP(I,IC)=DHTDP(I,IC)+ALFA(J)*ASUM2(I)
12    CONTINUE
15    CONTINUE
      IF(NBETA.LE.0)GO TO 13
      DO 14 I=1,NCOEFF
      DO 14 J=1,NBETA
14    DHTDP(I,IC)=DHTDP(I,IC)+DHTDP(I,IC-J)*BETA(J)
13    CONTINUE
9     CONTINUE
C
C  SI INIZIA IL CALCOLO DEL GRADIENTE AUX3
C
      DO 20 I=1,NPARAM
      AUX3(I)=0.
20    CONTINUE
      DO 61 IC=NINIT,NFINSM
C
C  PRIMA PARTE RELATIVA AI COEFFICIENTI (EQ. 22 PAG. 316) ERR. DI STAMP
CNEL SECONDO TERMINE C'E' UN *HT INVECE DI /HT
      RSUH=RES(1,IC)/HT(IC)
      R2SUH=RSUH*RES(1,IC)
      DO 22 I=1,NCOEFF
      AUX3(I)=AUX3(I)+RSUH*G(I,IC)+0.5/HT(IC)*DHTDP(I,IC)*(R2SUH-1.)
22    CONTINUE
C
C SECONDA PARTE RELATIVA AD ALFA E BETA (EQ. 19 PAG. 315)
C
      DO 23 I=1,NABET1
      AUX3(NCOEFF+I)=AUX3(NCOEFF+I)+0.5/HT(IC)*DHTDP(NCOEFF+I,IC)*
     *(R2SUH-1.)
23    CONTINUE
61    CONTINUE
C
C     ORA SI RIEMPIE LA MATINF
C
      DO 24 I=1,NPARAM
      DO 24 J=1,NPARAM
24    VC5(I,J)=0.
C
      DO 25 IC=NINIT,NFINSM
      RSUH=RES(1,IC)/HT(IC)
      R2SUH=RSUH*RES(1,IC)
      R2SUH3=R2SUH/(HT(IC)*HT(IC))
C
C  PARTE RELATIVA AI COEFFICIENTI (EQ. 23 PAG. 316)
C  SI RICORDA CHE SI PRENDE IL VALORE ATTESO E RESTANO SOLO I PRIMI
C  DUE TERMINI
      DO 26 I=1,NCOEFF
      DO 26 J=1,NCOEFF
26    VC5(I,J)=VC5(I,J)-G(I,IC)*G(J,IC)/HT(IC)-
     -0.5*DHTDP(I,IC)*DHTDP(J,IC)/(HT(IC)*HT(IC))
C
C  PARTE RELATIVA AD ALFA E BETA  (EQ. 20 PAG. 315)
C  SI RICORDA CHE SI PRENDE IL VALORE ATTESO E RESTA SOLO IL SECONDO
C  TERMINE
      DO 27 I=NCOEF1,NPARAM
      DO 27 J=NCOEF1,NPARAM
27    VC5(I,J)=VC5(I,J)-0.5*DHTDP(I,IC)*DHTDP(J,IC)/(HT(IC)*HT(IC))
25    CONTINUE
C *********************************************************************
C ADESSO SI INVERTE LA MATINF
C *********************************************************************
C      DO 690 I=1,NPARAM
C      IF(LOOP.LE.1)WRITE(8,5000)(VC5(I,J),J=1,NPARAM)
C690   IF(LOOP.LE.1)WRITE(6,5000)(VC5(I,J),J=1,NPARAM)
      CALL VSDMIG(VC5,0013,NPARAM,PP,IER5)
      IF(IER5.NE.0)WRITE(6,640)IER5
640   FORMAT(' IER5=' ,I5)
C      DO 690 I=1,NPARAM
C690   WRITE(6,5000)(VC5(I,J),J=1,NPARAM)
5000  FORMAT(4G18.8)
C      WRITE(6,3300)
C3300  FORMAT(' GRAD. OF LOG-LIKELIHOOD=')
C      WRITE(6,3301)(AUX3(I),I=1,NPARAM)
C3301  FORMAT(6G12.5)
C *********************************************************************
C ADESSO SI COMINCIA CON LE ITERAZIONI
C *********************************************************************
C CALCOLARE LO STEP PER I NUOVI COEFFICENTI
      SDUE=0.
      DO 56 I=1,NPARAM
      GG(I)=PARAM(I)
      STEP(I)=0.
      DO 57 J=1,NPARAM
57    STEP(I)=STEP(I)-VC5(I,J)*AUX3(J)
      SDUE=SDUE+STEP(I)*STEP(I)
56    CONTINUE
C*********************************************************************
C IF RELATIVE EUCLIDEAN DISTANCE IS USED AS CONVERG.
      SUNO=0.
      DO 3 I=1,NPARAM
      SUNO=SUNO+PARAM(I)*PARAM(I)
3     CONTINUE
      IF(SUNO.EQ.0.)SUNO=1.D-10
      STRE=SDUE/SUNO
C*********************************************************************
CC*********************************************************************
CC IF SQ.ROOT OF SUM OF SQUARED RELATIVE CHANGES IS USED AS CONVERG.
C      STRE=0.
C      DO 3 I=1,NPARAM
C      PIPPO=PARAM(I)
C      IF(PIPPO.EQ.0.)PIPPO=1.D-10
C      PAPPO=STEP(I)/PIPPO
C      STRE=STRE+PAPPO*PAPPO
C3     CONTINUE
CC*********************************************************************
C      WRITE(6,7700)(GG(I),I=1,NPARAM)
C7700  FORMAT('  GG(I)=',6G12.5)
      IF(IH.EQ.0)GO TO 5656
      DO 5657 I=1,NPARAM
5657  PARAM(I)=GG(I)+STEP(I)*1.00000
      CALL CHECK(PARAM,NCOEFF,NPARAM)
C      WRITE(6,7700)
C7700  FORMAT(' PARAM DENTRO MATINF DOPO STEP')
C      WRITE(6,102)(PARAM(I),I=1,NPARAM)
      GO TO 299
5656  SDUE=DSQRT(SDUE)
      STRE=DSQRT(STRE)
C      IF(LOOP.LE.1)WRITE(6,8976) SDUE,STRE
C      IF(LOOP.LE.1)WRITE(8,8976) SDUE,STRE
C8976  FORMAT(' MODULO=',2G20.12)
58    OLDSTP=SDUE
      DO 48 I=1,NPARAM
48    STEP(I)=STEP(I)/SDUE
C      CALL CTIME (IV,IT)
      IT4=IT4+IV
      DS=SDUE
      IF(STRE.LE.TOLER)GO TO 496
C
      NCALL=0
      NEXP=IVOLTA/5
      IF(NEXP.GT.5) NEXP=5
      CAPPA=2.**NEXP
      D0=SDUE
      D0=D0/CAPPA
      DAC=.001*D0
      DUB=4.*D0
C      IF(LOOP.LE.1)WRITE(6,604) D0,DAC,DUB
C      IF(LOOP.LE.1)WRITE(8,604) D0,DAC,DUB
C604   FORMAT(' D0,DAC,DUB =',3G16.8/)
      IF(IVOLTA.EQ.1)
     ,F1=-VALUNC(IDYNAM,C,NCOEFF,IFLAG,RES2,RES,
     ,YDET,YOBS,YSTOC,XOBS,NEND,IREAD,NEXO,UMC,NSTOCH,NINIT,
     ,NFINSM,PARAM,NPARAM,ICOEFF,B,NCOEFB,
     ,ALFA0,ALFA,BETA,NALFA,NBETA,HT)
      DO 300 I=1,NPARAM
300   PARAM(I)=GG(I)+STEP(I)*D0
      CALL CHECK(PARAM,NCOEFF,NPARAM)
C      WRITE(6,7700)
C      WRITE(6,102)(PARAM(I),I=1,NPARAM)
      F2=-VALUNC(IDYNAM,C,NCOEFF,IFLAG,RES2,RES,
     ,YDET,YOBS,YSTOC,XOBS,NEND,IREAD,NEXO,UMC,NSTOCH,NINIT,
     ,NFINSM,PARAM,NPARAM,ICOEFF,B,NCOEFB,
     ,ALFA0,ALFA,BETA,NALFA,NBETA,HT)
      IF(F2.GT.F1) GO TO 307
      D1=0.
      D2=D0
      D3=D0+D0
      DO 301 I=1,NPARAM
301   PARAM(I)=GG(I)+STEP(I)*D3
      CALL CHECK(PARAM,NCOEFF,NPARAM)
C      WRITE(6,7700)
C      WRITE(6,102)(PARAM(I),I=1,NPARAM)
      F3=-VALUNC(IDYNAM,C,NCOEFF,IFLAG,RES2,RES,
     ,YDET,YOBS,YSTOC,XOBS,NEND,IREAD,NEXO,UMC,NSTOCH,NINIT,
     ,NFINSM,PARAM,NPARAM,ICOEFF,B,NCOEFB,
     ,ALFA0,ALFA,BETA,NALFA,NBETA,HT)
      GO TO 325
307   D1=-D0
      D2=0.
      D3=D0
      F3=F2
      F2=F1
      DO 315 I=1,NPARAM
315   PARAM(I)=GG(I)+STEP(I)*D1
      CALL CHECK(PARAM,NCOEFF,NPARAM)
C      WRITE(6,7700)
C      WRITE(6,102)(PARAM(I),I=1,NPARAM)
      F1=-VALUNC(IDYNAM,C,NCOEFF,IFLAG,RES2,RES,
     ,YDET,YOBS,YSTOC,XOBS,NEND,IREAD,NEXO,UMC,NSTOCH,NINIT,
     ,NFINSM,PARAM,NPARAM,ICOEFF,B,NCOEFB,
     ,ALFA0,ALFA,BETA,NALFA,NBETA,HT)
325   D23=D2-D3
      D31=D3-D1
      D12=D1-D2
      DI=D23*F1+D31*F2+D12*F3
      BIGD=-2.*DI/(D23*D31*D12)
      IF(BIGD.GT.0.)GO TO 400
C      IF(LOOP.LE.1)WRITE(6,605) BIGD,DI,F1,F2,F3
C      IF(LOOP.LE.1)WRITE(8,605) BIGD
C605   FORMAT(' SECOND DERIVATIVE =',5G12.5)
      IF(F3.LE.F1) GO TO 341
329   D3=D2
      F3=F2
      D2=D1
      F2=F1
      D1=D1-DUB
      DO 334 I=1,NPARAM
334   PARAM(I)=GG(I)+D1*STEP(I)
      CALL CHECK(PARAM,NCOEFF,NPARAM)
C      WRITE(6,7700)
C      WRITE(6,102)(PARAM(I),I=1,NPARAM)
      F1=-VALUNC(IDYNAM,C,NCOEFF,IFLAG,RES2,RES,
     ,YDET,YOBS,YSTOC,XOBS,NEND,IREAD,NEXO,UMC,NSTOCH,NINIT,
     ,NFINSM,PARAM,NPARAM,ICOEFF,B,NCOEFB,
     ,ALFA0,ALFA,BETA,NALFA,NBETA,HT)
      NCALL=NCALL+1
      IF(NCALL.GT.100) GO TO 490
      GO TO 325
341   D1=D2
      F1=F2
      D2=D3
      F2=F3
      D3=D3+DUB
      DO 355 I=1,NPARAM
355   PARAM(I)=GG(I)+D3*STEP(I)
      CALL CHECK(PARAM,NCOEFF,NPARAM)
C      WRITE(6,7700)
C      WRITE(6,102)(PARAM(I),I=1,NPARAM)
      F3=-VALUNC(IDYNAM,C,NCOEFF,IFLAG,RES2,RES,
     ,YDET,YOBS,YSTOC,XOBS,NEND,IREAD,NEXO,UMC,NSTOCH,NINIT,
     ,NFINSM,PARAM,NPARAM,ICOEFF,B,NCOEFB,
     ,ALFA0,ALFA,BETA,NALFA,NBETA,HT)
      NCALL=NCALL+1
      IF(NCALL.GT.100) GO TO 490
      GO TO 325
400   D23S=D23*(D2+D3)
      D31S=D31*(D3+D1)
      D12S=D12*(D1+D2)
      DS=.5*(D23S*F1+D31S*F2+D12S*F3)/DI
      DO 411 I=1,NPARAM
411   PARAM(I)=GG(I)+STEP(I)*DS
      CALL CHECK(PARAM,NCOEFF,NPARAM)
C      WRITE(6,7700)
C      WRITE(6,102)(PARAM(I),I=1,NPARAM)
      FS=-VALUNC(IDYNAM,C,NCOEFF,IFLAG,RES2,RES,
     ,YDET,YOBS,YSTOC,XOBS,NEND,IREAD,NEXO,UMC,NSTOCH,NINIT,
     ,NFINSM,PARAM,NPARAM,ICOEFF,B,NCOEFB,
     ,ALFA0,ALFA,BETA,NALFA,NBETA,HT)
      NCALL=NCALL+1
      IF(NCALL.GT.100) GO TO 490
      A1S=DABS(D1-DS)
      A2S=DABS(D2-DS)
      A3S=DABS(D3-DS)
C      IF(LOOP.LE.1)WRITE(6,603) D1,D2,D3,DS,F1,F2,F3,FS
C      IF(LOOP.LE.1)WRITE(8,603) D1,D2,D3,DS,F1,F2,F3,FS
C603   FORMAT (' D1,D2,D3,DS =',4G16.6/' F1,F2,F3,FS =',4G16.6/)
      DM=A1S
      IF(A3S.LT.DM) DM=A3S
      IF(DUB.GE.DM) GO TO 422
      IF(DS.LT.D1-DUB) GO TO 329
      IF(DS.GT.D3+DUB) GO TO 341
422   IF(A1S.LT.DAC.OR.A2S.LT.DAC.OR.A3S.LT.DAC) GO TO 490
      IF(F1.LT.F2.OR.F1.LT.F3) GO TO 434
      D1=DS
      F1=FS
      GO TO 459
434   IF(F2.LT.F3.OR.F2.LT.F1) GO TO 447
      D2=DS
      F2=FS
      GO TO 459
447   D3=DS
      F3=FS
459   IF(D2.LE.D3) GO TO 463
      DD=D2
      FF=F2
      D2=D3
      F2=F3
      D3=DD
      F3=FF
463   IF(D1.LE.D2) GO TO 325
      DD=D1
      FF=F1
      D1=D2
      F1=F2
      D2=DD
      F2=FF
      GO TO 459
490   IF(FS.LE.F1) GO TO 491
      FS=F1
      DS=D1
491   IF(FS.LE.F2) GO TO 492
      FS=F2
      DS=D2
492   IF(FS.LE.F3) GO TO 496
      FS=F3
      DS=D3
496   DO 497 I=1,NPARAM
497   PARAM(I)=GG(I)+DS*STEP(I)
      CALL CHECK(PARAM,NCOEFF,NPARAM)
C      WRITE(6,7700)
C      WRITE(6,102)(PARAM(I),I=1,NPARAM)
      F1=FS
      FS=-FS
C      IF(LOOP.LE.1)WRITE(6,601) DS,FS
C      IF(LOOP.LE.1)WRITE(8,601) DS,FS
601   FORMAT (' DS=',G16.8,'  FS=',G16.8)
C      CALL CTIME (IV,IT)
      IT5=IT5+IV
      IF (IVOLTA/1*1.NE.IVOLTA) GO TO 133
C      IF(LOOP.LE.1)WRITE (8,8777) IT1,IT2,IT3,IT4,IT5
C      IF(LOOP.LE.1)WRITE (6,8777) IT1,IT2,IT3,IT4,IT5
C8777  FORMAT (' TEMPI... :',5I8)
C
133   NAB=0
      IF(NAB.EQ.0)GO TO 299
      DO 34 IEQ=1,NSTOCH
      IDPNDN=NAM(IEQ)
      NC=ICOEFF(IEQ)
      WRITE(6,134)IEQ,IZO
C      WRITE(8,134)IEQ,IZO
134   FORMAT(///,' EQUATION ',I3,'; ',I5,'TH STAGE')
      WRITE(6,135)IDPNDN
C      WRITE(8,135)IDPNDN
135   FORMAT(' DEPENDENT VARIABLE IS Y(',I3,')')
      WRITE(6,1202)
C      WRITE(8,1202)
1202  FORMAT(' INITIAL COEFFICIENTS')
      WRITE(6,102)(GG(NAB+I),I=1,NC)
C      WRITE(8,102)(GG(NAB+I),I=1,NC)
102   FORMAT(5G15.6)
      WRITE(6,1204)INRES(IEQ),NFRES(IEQ)
C      WRITE(8,1204)INRES(IEQ),NFRES(IEQ)
1204  FORMAT(' ESTIMATION PERIOD',2I5)
      WRITE(6,1203)
C      WRITE(8,1203)
1203  FORMAT(/,' COMPUTED COEFFICIENTS')
      WRITE(6,102)(C(NAB+K),K=1,NC)
C      WRITE(8,102)(C(NAB+K),K=1,NC)
      NAB=NAB+NC
34    CONTINUE
299   CONTINUE
C      WRITE(6,1000) (PARAM(I),I=1,NPARAM)
C1000  FORMAT(' PARAMETERS VALUES=',2X,5G15.6)
C
C SI CAMBIA IL SEGNO ALLA MATRICE
C
      DO 692 I=1,NPARAM
      DO 692 J=1,NPARAM
692   VC5(I,J)=-VC5(I,J)
C
      RETURN
      END
C**********************************************************************
C******           MATRICE HESSIANA PIENA PER LE STIME GARCH
C******           E' CHIAMATA DA: VSGARCH FORTRAN
C******
C******  I PARAMETRI SONO PASSATI DENTRO IL VETTORE PARAM
C******  C, ALFA E BETA SI RICAVANO ALL'INIZIO DA PARAM
C******
C******
C**********************************************************************
      SUBROUTINE GARCFH(NINIT,NFINSM,LOOP,YOBS,NEND,IREAD,
     ,XOBS,NEXO,UMC,NSTOCH,YDET,C,NCOEFF,RES2,
     ,RES,INRES,NFRES,YSTOC,
     ,IDYNAM,ICOEFF,TOLER,
     ,IZO,NAM,IVOLTA,IFLAG,VC5,IH,
     ,G,PP,AUX3,
     ,PARAM,NPARAM,B,NCOEFB,
     ,ALFA0,ALFA,BETA,NALFA,NBETA,HT,DHTDP,ZT)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION YOBS(NEND,IREAD),XOBS(NEXO,IREAD),UMC(NSTOCH),
     ,YDET(NEND,IREAD),C(NCOEFF),
     ,B(NCOEFB),YSTOC(NEND,IREAD),NAM(NEND),
     ,RES2(NEND,IREAD),RES(NSTOCH,IREAD),ICOEFF(NSTOCH),
     ,INRES(NSTOCH),NFRES(NSTOCH),PARAM(0013)
      DIMENSION VC5(0013,0013),AUX3(NPARAM)
      DIMENSION ALFA(NALFA),BETA(NBETA),HT(IREAD)
      DIMENSION DHTDP(0013,003009),ZT(0006),
     ,G(0013,003009),DHDPDP(0013,0013,00000004),ASUM2(0013)
      DIMENSION STEP(0013),GG(0013),PP(00141)
      IV=0
      IFLAG=0
      ISECDE=0
C      IF(IVOLTA.GT.0)GO TO 1011
      IT1=0
      IT2=0
      IT3=0
      IT4=0
      IT5=0
      OLDSTP=9.D39
      RELC=0.5
      RELU=0.5D-00
      RELY=0.5D-00
      NABET=NALFA+NBETA
      NABET1=NABET+1
      NCOEF1=NCOEFF+1
1011  IVOLTA=IVOLTA+1
C     IF (IVOLTA.GT.11) STOP
      DO 28 I=1,NCOEFF
28    C(I)=PARAM(I)
      ALFA0=PARAM(NCOEFF+1)
      IF(NALFA.LE.0)GO TO 660
      DO 661 I=1,NALFA
661   ALFA(I)=PARAM(NCOEFF+1+I)
660   CONTINUE
      IF(NBETA.LE.0)GO TO 662
      DO 663 I=1,NBETA
663   BETA(I)=PARAM(NCOEFF+1+NALFA+I)
662   CONTINUE
C      WRITE(6,671)
C671   FORMAT(' PARAMETRI ALL''INIZIO DI HESS')
C      WRITE(6,102)(PARAM(I),I=1,NPARAM)
C *********************************************
C INIZIO DEL CALCOLO DI DHTDP E DHDPDP
C PARTE RELATIVA AI PARAMETRI ALFA E BETA
C SI COMINCIA CALCOLANDO LE DERIVATE DEI VALORI INIZIALI
C AVENDO SCELTO COME VAL. INIZIALI LA VARIANZA NONCONDIZIONATA
C COME VALORE INIZIALE (AI TEMPI 0, -1, -2, ECC.)
C DI HT SI IMPIEGA LA VARIANZA NONCONDIZIONATA
C CALCOLATA DAI RESIDUI.
      IF(NBETA.LE.0)GO TO 121
      DO 21 IC=1,NBETA
      DO 31 I=1,NABET1
      DHTDP(NCOEFF+I,NINIT-IC)=0.0D0
      DO 33 J=1,NABET1
33    DHDPDP(NCOEFF+I,NCOEFF+J,1+IC)=0.0D0
31    CONTINUE
21    CONTINUE
121   CONTINUE
C COSTRUZIONE MATRICE DHTDP, PARTE RELATIVA A ALFA E BETA (EQ.21)
      DO 4 IC=NINIT,NFINSM
C SI RIEMPIE ZT AL TEMPO IC (PAG.315)
      ZT(1)=1.
      IF(NALFA.LE.0)GO TO 270
      DO 271 I=1,NALFA
271   ZT(1+I)=RES2(1,IC-I)
270   CONTINUE
      IF(NBETA.LE.0)GO TO 272
      DO 273 I=1,NBETA
273   ZT(1+NALFA+I)=HT(IC-I)
272   CONTINUE
C  SI RIEMPIE DHTDP AL TEMPO IC
C  LA PARTE RELATIVA AI PARAMETRI ALFA E BETA (EQ.21 PAG.316)
      DO 5 I=1,NABET1
      DHTDP(NCOEFF+I,IC)=0.
5     CONTINUE
      DO 6 I=1,NABET1
      DHTDP(NCOEFF+I,IC)=DHTDP(NCOEFF+I,IC)+ZT(I)
6     CONTINUE
      IF(NBETA.LE.0)GO TO 7
      DO 8 I=1,NABET1
      DO 8 J=1,NBETA
8     DHTDP(NCOEFF+I,IC)=DHTDP(NCOEFF+I,IC)+DHTDP(NCOEFF+I,IC-J)*BETA(J)
7     CONTINUE
4     CONTINUE
C COSTRUZIONE MATRICE DHTDP, PARTE RELATIVA AI COEFFICIENTI (EQ.24)
C COME VALORI INIZIALI (TEMPO 0, -1, ECC.) DELLE DERIVATE DI HT
C RISPETTO AI COEFFICIENTI SI PRENDE DER DI UNCVAR RISPETTO AI COEFF
C COME VALORI INIZIALI DEI RESIDUI SI PRENDE ZERO
C (GIA' FATTO DENTRO VALUNC)
C COSTRUZIONE DELLA MATRICE DHDPDP INIZIALE
C
C      IF (NALFA.LE.0) GO TO 141
C      DO 148 I=1,NALFA
C      DO 149 J=1,NCOEFF
C      G(J,NINIT-I)=0.0D0
C149   CONTINUE
C148   CONTINUE
C141   CONTINUE
      INDIET=NALFA
      IF(NBETA.GT.NALFA)INDIET=NBETA
      I1=NINIT-INDIET
      I2=NINIT-1
      ICULO=NFINSM-NINIT+1
      DO 10 IC=I1,I2
      DO 10 I=1,NCOEFF
      ASUM2(I)=0.0
      DO 45 ISP=NINIT,NFINSM
      ASUM2(I)=ASUM2(I)-2.*RES(1,ISP)*G(I,ISP)
 45   CONTINUE
      ASUM2(I)=ASUM2(I)/ICULO
10    DHTDP(I,IC)=ASUM2(I)
C
C  I VALORI INIZIALI DI DHDPDP SONO 2/T X'X
C  E ZERO PER I BLOCCHI FUORI DIAGONALE
C
      DO 51 IC=1,INDIET
      DO 52 I=1,NCOEFF
      DO 52 J=1,NCOEFF
52    DHDPDP(I,J,1+IC)=0.0D0
      DO 53 ISP=NINIT,NFINSM
      DO 54 I=1,NCOEFF
      DO 54 J=1,NCOEFF
54    DHDPDP(I,J,1+IC)=DHDPDP(I,J,1+IC)+G(I,ISP)*G(J,ISP)*2./ICULO
53    CONTINUE
      DO 211 I=1,NCOEFF
      DO 212 J=1,NABET1
      DHDPDP(I,NCOEFF+J,1+IC)=0.0D0
212   CONTINUE
211   CONTINUE
51    CONTINUE
      DO 9 IC=NINIT,NFINSM
      DO 11 I=1,NCOEFF
      DHTDP(I,IC)=0.
11    CONTINUE
      IF(NALFA.LE.0)GO TO 15
      DO 12 I=1,NCOEFF
      DO 12 J=1,NALFA
      IF(IC-NALFA.LT.NINIT) GO TO 376
      DHTDP(I,IC)=DHTDP(I,IC)-2.*ALFA(J)*G(I,IC-J)*RES(1,IC-J)
      GO TO 12
376   CONTINUE
      DHTDP(I,IC)=DHTDP(I,IC)+ALFA(J)*ASUM2(I)
12    CONTINUE
15    CONTINUE
      IF(NBETA.LE.0)GO TO 13
      DO 14 I=1,NCOEFF
      DO 14 J=1,NBETA
14    DHTDP(I,IC)=DHTDP(I,IC)+DHTDP(I,IC-J)*BETA(J)
13    CONTINUE
9     CONTINUE
C
C  SI INIZIA IL CALCOLO DEL GRADIENTE AUX3
C
      DO 20 I=1,NPARAM
      AUX3(I)=0.
20    CONTINUE
      DO 61 IC=NINIT,NFINSM
C
C  PRIMA PARTE RELATIVA AI COEFFICIENTI (EQ. 22 PAG. 316) ERR. DI STAMP
C  NEL SECONDO TERMINE C'E' UN *HT INVECE DI /HT
      RSUH=RES(1,IC)/HT(IC)
      R2SUH=RSUH*RES(1,IC)
      DO 22 I=1,NCOEFF
      AUX3(I)=AUX3(I)+RSUH*G(I,IC)+0.5/HT(IC)*DHTDP(I,IC)*(R2SUH-1.)
22    CONTINUE
C
C SECONDA PARTE RELATIVA AD ALFA E BETA (EQ. 19 PAG. 315)
C
      DO 23 I=1,NABET1
      AUX3(NCOEFF+I)=AUX3(NCOEFF+I)+0.5/HT(IC)*DHTDP(NCOEFF+I,IC)*
     *(R2SUH-1.)
23    CONTINUE
61    CONTINUE
C
C     ORA SI RIEMPIE LA HESS
C
      DO 24 I=1,NPARAM
      DO 24 J=1,NPARAM
24    VC5(I,J)=0.
C
      DO 25 IC=NINIT,NFINSM
      RSUH=RES(1,IC)/HT(IC)
      R2SUH=RSUH*RES(1,IC)
      R2SUH3=R2SUH/(HT(IC)*HT(IC))
      USUH2=1./(HT(IC)*HT(IC))
      DO 71 I=1,NPARAM
      DO 71 J=1,NPARAM
71    DHDPDP(I,J,1)=0.0
      IF(INDIET.LE.0) GO TO 90
      DO 91 II=1,NALFA
      DO 92 I=1,NCOEFF
      DO 92 J=1,NCOEFF
      IF(IC-NALFA.LT.NINIT) GO TO 377
      DHDPDP(I,J,1)=DHDPDP(I,J,1)+2.*G(I,IC-II)*G(J,IC-II)*ALFA(II)
      GO TO 92
377   CONTINUE
      DHDPDP(I,J,1)=DHDPDP(I,J,1)+DHDPDP(I,J,1+NALFA)*ALFA(II)
92    CONTINUE
91    CONTINUE
      DO 93 II=1,NBETA
      DO 94 I=1,NCOEFF
      DO 94 J=1,NCOEFF
94    DHDPDP(I,J,1)=DHDPDP(I,J,1)+
     +DHDPDP(I,J,1+II)*BETA(II)
93    CONTINUE
      DO 213 I=1,NCOEFF
      DO 214 II=1,NALFA
      IF(IC-NALFA.LT.NINIT) GO TO 477
      DHDPDP(I,NCOEFF+1+II,1)=DHDPDP(I,NCOEFF+1+II,1)-
     -2*G(I,IC-II)*RES(1,IC-II)
      GO TO 214
477   CONTINUE
      DHDPDP(I,NCOEFF+1+II,1)=DHDPDP(I,NCOEFF+1+II,1)+ASUM2(I)
214   CONTINUE
      DO 215 II=1,NBETA
      DHDPDP(I,NCOEFF+1+NALFA+II,1)=DHDPDP(I,NCOEFF+1+NALFA+II,1)+
     +DHTDP(I,IC-II)
215   CONTINUE
213   CONTINUE
      DO 216 II=1,NBETA
      DO 217 I=1,NCOEFF
      DO 218 J=1,NABET1
      DHDPDP(I,NCOEFF+J,1)=DHDPDP(I,NCOEFF+J,1)+
     +DHDPDP(I,NCOEFF+J,1+II)*BETA(II)
218   CONTINUE
217   CONTINUE
216   CONTINUE
90    CONTINUE
C
C  PARTE RELATIVA AI COEFFICIENTI (EQ. 23 PAG. 316)
C  SI RICORDA CHE SI PRENDE IL VALORE ATTESO E RESTANO SOLO I PRIMI
C  DUE TERMINI
      DO 26 I=1,NCOEFF
      DO 26 J=1,NCOEFF
26    VC5(I,J)=VC5(I,J)-G(I,IC)*G(J,IC)/HT(IC)-
     -0.5*R2SUH3*DHTDP(I,IC)*DHTDP(J,IC)-
     -(RSUH*G(J,IC)*DHTDP(I,IC))/HT(IC)-
     -(RSUH*G(I,IC)*DHTDP(J,IC))/HT(IC)+
     +0.5*(R2SUH-1.)*(DHDPDP(I,J,1)/HT(IC)-DHTDP(I,IC)*DHTDP(J,IC)/
     /(HT(IC)*HT(IC)))
C
C  PARTE RELATIVA AD ALFA E BETA  (EQ. 20 PAG. 315)
C  SI RICORDA CHE SI PRENDE IL VALORE ATTESO E RESTA SOLO IL SECONDO
C  TERMINE
C
C
C  CALCOLO DI DHDPDP AL TEMPO IC CHE VA' NEL POSTO 1 DEL TERZO INDICE
C
      IF(NBETA.LE.0) GO TO 80
C
      DO 72 I=1,NABET1
      DO 73 J=1,NBETA
      DHDPDP(NCOEFF+I,NCOEFF+NALFA+1+J,1)=
     =DHDPDP(NCOEFF+I,NCOEFF+NALFA+1+J,1)+
     +DHTDP(NCOEFF+I,IC-J)
73    CONTINUE
72    CONTINUE
      DO 82 I=1,NBETA
      DO 83 J=1,NABET1
      DHDPDP(NCOEFF+NALFA+1+I,NCOEFF+J,1)=
     =DHDPDP(NCOEFF+NALFA+1+I,NCOEFF+J,1)+
     +DHTDP(NCOEFF+J,IC-I)
83    CONTINUE
82    CONTINUE
      DO 74 II=1,NBETA
      DO 75 I=1,NABET1
      DO 75 J=1,NABET1
75    DHDPDP(NCOEFF+I,NCOEFF+J,1)=DHDPDP(NCOEFF+I,NCOEFF+J,1)+
     +BETA(II)*DHDPDP(NCOEFF+I,NCOEFF+J,1+II)
74    CONTINUE
80    CONTINUE
      DO 27 I=NCOEF1,NPARAM
      DO 27 J=NCOEF1,NPARAM
27    VC5(I,J)=VC5(I,J)+0.5*USUH2*DHTDP(I,IC)*DHTDP(J,IC)-
     -R2SUH3*DHTDP(I,IC)*DHTDP(J,IC)+
     +0.5*(R2SUH-1.0)/HT(IC)*DHDPDP(I,J,1)
C
C
C
C  PARTE MISTA IN ALTO DESTRA
C
C
      DO 226 I=1,NCOEFF
      DO 226 J=1,NABET1
226   VC5(I,NCOEFF+J)=VC5(I,NCOEFF+J)-G(I,IC)*RSUH*
     *DHTDP(NCOEFF+J,IC)/HT(IC)-
     -0.5*(R2SUH-1.)*DHTDP(NCOEFF+J,IC)*DHTDP(I,IC)/
     /(HT(IC)*HT(IC))+
     +0.5*(R2SUH-1.)*DHDPDP(I,NCOEFF+J,1)/HT(IC)-
     -0.5*R2SUH*USUH2*DHTDP(I,IC)*DHTDP(NCOEFF+J,IC)
C
C PRIMA DI USCIRE DAL TEMPO T=IC, SI RISISTEMA LA DHDPDP
C
      IF(INDIET.LE.0) GO TO 190
      DO 111 II=1,INDIET
      DO 112 I=1,NPARAM
      DO 112 J=1,NPARAM
112   DHDPDP(I,J,2+INDIET-II)=DHDPDP(I,J,1+INDIET-II)
111   CONTINUE
190   CONTINUE
25    CONTINUE
C
C  IL DO 25 SUL TEMPO E' FINITO E ALLORA SI RIEMPIE LA PARTE
C  MISTA IN BASSO A SINISTRA
C
      DO 227 I=1,NCOEFF
      DO 227 J=1,NABET1
227   VC5(NCOEFF+J,I)=VC5(I,NCOEFF+J)
C
C
C *********************************************************************
C ADESSO SI INVERTE LA HESS
C *********************************************************************
C      DO 690 I=1,NPARAM
C      WRITE(8,5000)(VC5(I,J),J=1,NPARAM)
C690   WRITE(6,5000)(VC5(I,J),J=1,NPARAM)
      CALL VSDMIG(VC5,0013,NPARAM,PP,IER5)
      IF(IER5.NE.0)WRITE(6,640)IER5
640   FORMAT(' IER5=' ,I5)
C      DO 691 I=1,NPARAM
C691   WRITE(6,5000)(VC5(I,J),J=1,NPARAM)
5000  FORMAT(5G16.8)
C      WRITE(6,3300)
C3300  FORMAT(' GRAD. OF LOG-LIKELIHOOD=')
C      WRITE(6,3301)(AUX3(I),I=1,NPARAM)
C3301  FORMAT(6G13.5)
C *********************************************************************
C ADESSO SI COMINCIA CON LE ITERAZIONI
C *********************************************************************
C CALCOLARE LO STEP PER I NUOVI COEFFICENTI
      SDUE=0.
      DO 56 I=1,NPARAM
      GG(I)=PARAM(I)
      STEP(I)=0.
      DO 57 J=1,NPARAM
57    STEP(I)=STEP(I)-VC5(I,J)*AUX3(J)
      SDUE=SDUE+STEP(I)*STEP(I)
56    CONTINUE
C*********************************************************************
C IF RELATIVE EUCLIDEAN DISTANCE IS USED AS CONVERG.
      SUNO=0.
      DO 3 I=1,NPARAM
      SUNO=SUNO+PARAM(I)*PARAM(I)
3     CONTINUE
      IF(SUNO.EQ.0.)SUNO=1.D-10
      STRE=SDUE/SUNO
C*********************************************************************
CC*********************************************************************
CC IF SQ.ROOT OF SUM OF SQUARED RELATIVE CHANGES IS USED AS CONVERG.
C      STRE=0.
C      DO 3 I=1,NPARAM
C      PIPPO=PARAM(I)
C      IF(PIPPO.EQ.0.)PIPPO=1.D-10
C      PAPPO=STEP(I)/PIPPO
C      STRE=STRE+PAPPO*PAPPO
C3     CONTINUE
CC*********************************************************************
C      WRITE(6,7700)(GG(I),I=1,NPARAM)
C7700  FORMAT('  GG(I)=',6G12.5)
      IF(IH.EQ.0)GO TO 5656
      DO 5657 I=1,NPARAM
5657  PARAM(I)=GG(I)+STEP(I)*1.00000
      CALL CHECK(PARAM,NCOEFF,NPARAM)
C      WRITE(6,7700)
C7700  FORMAT(' PARAM DENTRO HESS DOPO STEP')
C      WRITE(6,102)(PARAM(I),I=1,NPARAM)
      GO TO 299
5656  SDUE=DSQRT(SDUE)
      STRE=DSQRT(STRE)
C      IF(LOOP.LE.1)WRITE(6,8976) SDUE,STRE
C      IF(LOOP.LE.1)WRITE(8,8976) SDUE,STRE
C8976  FORMAT(' MODULO=',2G20.12)
58    OLDSTP=SDUE
      DO 48 I=1,NPARAM
48    STEP(I)=STEP(I)/SDUE
C      CALL CTIME (IV,IT)
      IT4=IT4+IV
      DS=SDUE
      IF(STRE.LE.TOLER)GO TO 496
C
      NCALL=0
      NEXP=IVOLTA/5
      IF(NEXP.GT.5) NEXP=5
      CAPPA=2.**NEXP
      D0=SDUE
      D0=D0/CAPPA
      DAC=.001*D0
      DUB=4.*D0
C      IF(LOOP.LE.1)WRITE(6,604) D0,DAC,DUB
C      IF(LOOP.LE.1)WRITE(8,604) D0,DAC,DUB
C604   FORMAT(' D0,DAC,DUB =',3G16.8/)
      IF(IVOLTA.EQ.1)
     ,F1=-VALUNC(IDYNAM,C,NCOEFF,IFLAG,RES2,RES,
     ,YDET,YOBS,YSTOC,XOBS,NEND,IREAD,NEXO,UMC,NSTOCH,NINIT,
     ,NFINSM,PARAM,NPARAM,ICOEFF,B,NCOEFB,
     ,ALFA0,ALFA,BETA,NALFA,NBETA,HT)
      DO 300 I=1,NPARAM
300   PARAM(I)=GG(I)+STEP(I)*D0
      CALL CHECK(PARAM,NCOEFF,NPARAM)
C      WRITE(6,7700)
C      WRITE(6,102)(PARAM(I),I=1,NPARAM)
      F2=-VALUNC(IDYNAM,C,NCOEFF,IFLAG,RES2,RES,
     ,YDET,YOBS,YSTOC,XOBS,NEND,IREAD,NEXO,UMC,NSTOCH,NINIT,
     ,NFINSM,PARAM,NPARAM,ICOEFF,B,NCOEFB,
     ,ALFA0,ALFA,BETA,NALFA,NBETA,HT)
      IF(F2.GT.F1) GO TO 307
      D1=0.
      D2=D0
      D3=D0+D0
      DO 301 I=1,NPARAM
301   PARAM(I)=GG(I)+STEP(I)*D3
      CALL CHECK(PARAM,NCOEFF,NPARAM)
C      WRITE(6,7700)
C      WRITE(6,102)(PARAM(I),I=1,NPARAM)
      F3=-VALUNC(IDYNAM,C,NCOEFF,IFLAG,RES2,RES,
     ,YDET,YOBS,YSTOC,XOBS,NEND,IREAD,NEXO,UMC,NSTOCH,NINIT,
     ,NFINSM,PARAM,NPARAM,ICOEFF,B,NCOEFB,
     ,ALFA0,ALFA,BETA,NALFA,NBETA,HT)
      GO TO 325
307   D1=-D0
      D2=0.
      D3=D0
      F3=F2
      F2=F1
      DO 315 I=1,NPARAM
315   PARAM(I)=GG(I)+STEP(I)*D1
      CALL CHECK(PARAM,NCOEFF,NPARAM)
C      WRITE(6,7700)
C      WRITE(6,102)(PARAM(I),I=1,NPARAM)
      F1=-VALUNC(IDYNAM,C,NCOEFF,IFLAG,RES2,RES,
     ,YDET,YOBS,YSTOC,XOBS,NEND,IREAD,NEXO,UMC,NSTOCH,NINIT,
     ,NFINSM,PARAM,NPARAM,ICOEFF,B,NCOEFB,
     ,ALFA0,ALFA,BETA,NALFA,NBETA,HT)
325   D23=D2-D3
      D31=D3-D1
      D12=D1-D2
      DI=D23*F1+D31*F2+D12*F3
      BIGD=-2.*DI/(D23*D31*D12)
      IF(BIGD.GT.0.)GO TO 400
C      IF(LOOP.LE.1)WRITE(6,605) BIGD,DI,F1,F2,F3
C      IF(LOOP.LE.1)WRITE(8,605) BIGD
C605   FORMAT(' SECOND DERIVATIVE =',5G12.5)
      IF(F3.LE.F1) GO TO 341
329   D3=D2
      F3=F2
      D2=D1
      F2=F1
      D1=D1-DUB
      DO 334 I=1,NPARAM
334   PARAM(I)=GG(I)+D1*STEP(I)
      CALL CHECK(PARAM,NCOEFF,NPARAM)
C      WRITE(6,7700)
C      WRITE(6,102)(PARAM(I),I=1,NPARAM)
      F1=-VALUNC(IDYNAM,C,NCOEFF,IFLAG,RES2,RES,
     ,YDET,YOBS,YSTOC,XOBS,NEND,IREAD,NEXO,UMC,NSTOCH,NINIT,
     ,NFINSM,PARAM,NPARAM,ICOEFF,B,NCOEFB,
     ,ALFA0,ALFA,BETA,NALFA,NBETA,HT)
      NCALL=NCALL+1
      IF(NCALL.GT.100) GO TO 490
      GO TO 325
341   D1=D2
      F1=F2
      D2=D3
      F2=F3
      D3=D3+DUB
      DO 355 I=1,NPARAM
355   PARAM(I)=GG(I)+D3*STEP(I)
      CALL CHECK(PARAM,NCOEFF,NPARAM)
C      WRITE(6,7700)
C      WRITE(6,102)(PARAM(I),I=1,NPARAM)
      F3=-VALUNC(IDYNAM,C,NCOEFF,IFLAG,RES2,RES,
     ,YDET,YOBS,YSTOC,XOBS,NEND,IREAD,NEXO,UMC,NSTOCH,NINIT,
     ,NFINSM,PARAM,NPARAM,ICOEFF,B,NCOEFB,
     ,ALFA0,ALFA,BETA,NALFA,NBETA,HT)
      NCALL=NCALL+1
      IF(NCALL.GT.100) GO TO 490
      GO TO 325
400   D23S=D23*(D2+D3)
      D31S=D31*(D3+D1)
      D12S=D12*(D1+D2)
      DS=.5*(D23S*F1+D31S*F2+D12S*F3)/DI
      DO 411 I=1,NPARAM
411   PARAM(I)=GG(I)+STEP(I)*DS
      CALL CHECK(PARAM,NCOEFF,NPARAM)
C      WRITE(6,7700)
C      WRITE(6,102)(PARAM(I),I=1,NPARAM)
      FS=-VALUNC(IDYNAM,C,NCOEFF,IFLAG,RES2,RES,
     ,YDET,YOBS,YSTOC,XOBS,NEND,IREAD,NEXO,UMC,NSTOCH,NINIT,
     ,NFINSM,PARAM,NPARAM,ICOEFF,B,NCOEFB,
     ,ALFA0,ALFA,BETA,NALFA,NBETA,HT)
      NCALL=NCALL+1
      IF(NCALL.GT.100) GO TO 490
      A1S=DABS(D1-DS)
      A2S=DABS(D2-DS)
      A3S=DABS(D3-DS)
C      IF(LOOP.LE.1)WRITE(6,603) D1,D2,D3,DS,F1,F2,F3,FS
C      IF(LOOP.LE.1)WRITE(8,603) D1,D2,D3,DS,F1,F2,F3,FS
C603   FORMAT (' D1,D2,D3,DS =',4G16.6/' F1,F2,F3,FS =',4G16.6/)
      DM=A1S
      IF(A3S.LT.DM) DM=A3S
      IF(DUB.GE.DM) GO TO 422
      IF(DS.LT.D1-DUB) GO TO 329
      IF(DS.GT.D3+DUB) GO TO 341
422   IF(A1S.LT.DAC.OR.A2S.LT.DAC.OR.A3S.LT.DAC) GO TO 490
      IF(F1.LT.F2.OR.F1.LT.F3) GO TO 434
      D1=DS
      F1=FS
      GO TO 459
434   IF(F2.LT.F3.OR.F2.LT.F1) GO TO 447
      D2=DS
      F2=FS
      GO TO 459
447   D3=DS
      F3=FS
459   IF(D2.LE.D3) GO TO 463
      DD=D2
      FF=F2
      D2=D3
      F2=F3
      D3=DD
      F3=FF
463   IF(D1.LE.D2) GO TO 325
      DD=D1
      FF=F1
      D1=D2
      F1=F2
      D2=DD
      F2=FF
      GO TO 459
490   IF(FS.LE.F1) GO TO 491
      FS=F1
      DS=D1
491   IF(FS.LE.F2) GO TO 492
      FS=F2
      DS=D2
492   IF(FS.LE.F3) GO TO 496
      FS=F3
      DS=D3
496   DO 497 I=1,NPARAM
497   PARAM(I)=GG(I)+DS*STEP(I)
      CALL CHECK(PARAM,NCOEFF,NPARAM)
C      WRITE(6,7700)
C      WRITE(6,102)(PARAM(I),I=1,NPARAM)
      F1=FS
      FS=-FS
C      IF(LOOP.LE.1)WRITE(6,601) DS,FS
C      IF(LOOP.LE.1)WRITE(8,601) DS,FS
601   FORMAT (' DS=',G16.8,'  FS=',G16.8)
C      CALL CTIME (IV,IT)
      IT5=IT5+IV
      IF (IVOLTA/1*1.NE.IVOLTA) GO TO 133
C      IF(LOOP.LE.1)WRITE (8,8777) IT1,IT2,IT3,IT4,IT5
C      IF(LOOP.LE.1)WRITE (6,8777) IT1,IT2,IT3,IT4,IT5
C8777  FORMAT (' TEMPI... :',5I8)
C
133   NAB=0
      IF(NAB.EQ.0)GO TO 299
      DO 34 IEQ=1,NSTOCH
      IDPNDN=NAM(IEQ)
      NC=ICOEFF(IEQ)
      WRITE(6,134)IEQ,IZO
C      WRITE(8,134)IEQ,IZO
134   FORMAT(///,' EQUATION ',I3,'; ',I5,'TH STAGE')
      WRITE(6,135)IDPNDN
C      WRITE(8,135)IDPNDN
135   FORMAT(' DEPENDENT VARIABLE IS Y(',I3,')')
      WRITE(6,1202)
C      WRITE(8,1202)
1202  FORMAT(' INITIAL COEFFICIENTS')
      WRITE(6,102)(GG(NAB+I),I=1,NC)
C      WRITE(8,102)(GG(NAB+I),I=1,NC)
102   FORMAT(5G15.6)
      WRITE(6,1204)INRES(IEQ),NFRES(IEQ)
C      WRITE(8,1204)INRES(IEQ),NFRES(IEQ)
1204  FORMAT(' ESTIMATION PERIOD',2I5)
      WRITE(6,1203)
C      WRITE(8,1203)
1203  FORMAT(/,' COMPUTED COEFFICIENTS')
      WRITE(6,102)(C(NAB+K),K=1,NC)
C      WRITE(8,102)(C(NAB+K),K=1,NC)
      NAB=NAB+NC
34    CONTINUE
299   CONTINUE
C      WRITE(6,1000) (PARAM(I),I=1,NPARAM)
C1000  FORMAT(' PARAMETERS VALUES=',2X,5G15.6)
C
C SI CAMBIA IL SEGNO ALLA MATRICE
C
      DO 692 I=1,NPARAM
      DO 692 J=1,NPARAM
692   VC5(I,J)=-VC5(I,J)
C
      RETURN
      END
C
C COMPUTES THE COEFFICIENTS COVARIANCE MATRICES BEFORE THE INVERSION
C VC5 : HESSIAN
C VC6 : OUTER PRODUCT OF FIRST DERIVATIVES
C VC9 : INFORMATION MATRIX
C WHILE WHITHE MATRIX (VC10) IS COMPUTED IN THE CALLING ROUTINE
C
      SUBROUTINE COVARC(NINIT,NFINSM,LOOP,YOBS,NEND,IREAD,
     ,XOBS,NEXO,UMC,NSTOCH,YDET,C,NCOEFF,RES2,
     ,RES,INRES,NFRES,YSTOC,
     ,IDYNAM,ICOEFF,TOLER,
     ,IZO,NAM,IVOLTA,IFLAG,VC5,VC6,VC9,IH,
     ,G,PP,AUX3,
     ,PARAM,NPARAM,B,NCOEFB,
     ,ALFA0,ALFA,BETA,NALFA,NBETA,HT,DHTDP,ZT)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION YOBS(NEND,IREAD),XOBS(NEXO,IREAD),UMC(NSTOCH),
     ,YDET(NEND,IREAD),C(NCOEFF),
     ,B(NCOEFB),YSTOC(NEND,IREAD),NAM(NEND),
     ,RES2(NEND,IREAD),RES(NSTOCH,IREAD),ICOEFF(NSTOCH),
     ,INRES(NSTOCH),NFRES(NSTOCH),PARAM(0013)
      DIMENSION VC5(0013,0013),AUX3(NPARAM),
     ,VC6(0013,0013),VC9(0013,0013)
      DIMENSION ALFA(NALFA),BETA(NBETA),HT(IREAD)
      DIMENSION DHTDP(0013,003009),ZT(0006),
     ,G(0013,003009),DHDPDP(0013,0013,00000004),ASUM2(0013)
      DIMENSION STEP(0013),GG(0013),PP(00141)
      IV=0
      IFLAG=0
      ISECDE=0
C      IF(IVOLTA.GT.0)GO TO 1011
      IT1=0
      IT2=0
      IT3=0
      IT4=0
      IT5=0
      OLDSTP=9.D39
      RELC=0.5
      RELU=0.5D-00
      RELY=0.5D-00
      NABET=NALFA+NBETA
      NABET1=NABET+1
      NCOEF1=NCOEFF+1
1011  IVOLTA=IVOLTA+1
C     IF (IVOLTA.GT.11) STOP
      DO 28 I=1,NCOEFF
28    C(I)=PARAM(I)
      ALFA0=PARAM(NCOEFF+1)
      IF(NALFA.LE.0)GO TO 660
      DO 661 I=1,NALFA
661   ALFA(I)=PARAM(NCOEFF+1+I)
660   CONTINUE
      IF(NBETA.LE.0)GO TO 662
      DO 663 I=1,NBETA
663   BETA(I)=PARAM(NCOEFF+1+NALFA+I)
662   CONTINUE
C      WRITE(6,671)
C671   FORMAT(' PARAMETRI ALL''INIZIO DI HESS')
C      WRITE(6,102)(PARAM(I),I=1,NPARAM)
102   FORMAT (5G15.5)
C *********************************************
C INIZIO DEL CALCOLO DI DHTDP E DHDPDP
C PARTE RELATIVA AI PARAMETRI ALFA E BETA
C SI COMINCIA CALCOLANDO LE DERIVATE DEI VALORI INIZIALI
C AVENDO SCELTO COME VAL. INIZIALI LA VARIANZA NONCONDIZIONATA
C COME VALORE INIZIALE (AI TEMPI 0, -1, -2, ECC.)
C DI HT SI IMPIEGA LA VARIANZA NONCONDIZIONATA
C CALCOLATA DAI RESIDUI.
      IF(NBETA.LE.0)GO TO 121
      DO 21 IC=1,NBETA
      DO 31 I=1,NABET1
      DHTDP(NCOEFF+I,NINIT-IC)=0.0D0
      DO 33 J=1,NABET1
33    DHDPDP(NCOEFF+I,NCOEFF+J,1+IC)=0.0D0
31    CONTINUE
21    CONTINUE
121   CONTINUE
C COSTRUZIONE MATRICE DHTDP, PARTE RELATIVA A ALFA E BETA (EQ.21)
      DO 4 IC=NINIT,NFINSM
C SI RIEMPIE ZT AL TEMPO IC (PAG.315)
      ZT(1)=1.
      IF(NALFA.LE.0)GO TO 270
      DO 271 I=1,NALFA
271   ZT(1+I)=RES2(1,IC-I)
270   CONTINUE
      IF(NBETA.LE.0)GO TO 272
      DO 273 I=1,NBETA
273   ZT(1+NALFA+I)=HT(IC-I)
272   CONTINUE
C  SI RIEMPIE DHTDP AL TEMPO IC
C  LA PARTE RELATIVA AI PARAMETRI ALFA E BETA (EQ.21 PAG.316)
      DO 5 I=1,NABET1
      DHTDP(NCOEFF+I,IC)=0.
5     CONTINUE
      DO 6 I=1,NABET1
      DHTDP(NCOEFF+I,IC)=DHTDP(NCOEFF+I,IC)+ZT(I)
6     CONTINUE
      IF(NBETA.LE.0)GO TO 7
      DO 8 I=1,NABET1
      DO 8 J=1,NBETA
8     DHTDP(NCOEFF+I,IC)=DHTDP(NCOEFF+I,IC)+DHTDP(NCOEFF+I,IC-J)*BETA(J)
7     CONTINUE
4     CONTINUE
C COSTRUZIONE MATRICE DHTDP, PARTE RELATIVA AI COEFFICIENTI (EQ.24)
C COME VALORI INIZIALI (TEMPO 0, -1, ECC.) DELLE DERIVATE DI HT
C RISPETTO AI COEFFICIENTI SI PRENDE DER DI UNCVAR RISPETTO AI COEFF
C COME VALORI INIZIALI DEI RESIDUI SI PRENDE ZERO
C (GIA' FATTO DENTRO VALUNC)
C COSTRUZIONE DELLA MATRICE DHDPDP INIZIALE
C
C      IF (NALFA.LE.0) GO TO 141
C      DO 148 I=1,NALFA
C      DO 149 J=1,NCOEFF
C      G(J,NINIT-I)=0.0D0
C149   CONTINUE
C148   CONTINUE
C141   CONTINUE
      INDIET=NALFA
      IF(NBETA.GT.NALFA)INDIET=NBETA
      I1=NINIT-INDIET
      I2=NINIT-1
      ICULO=NFINSM-NINIT+1
      DO 10 IC=I1,I2
      DO 10 I=1,NCOEFF
      ASUM2(I)=0.0
      DO 45 ISP=NINIT,NFINSM
      ASUM2(I)=ASUM2(I)-2.*RES(1,ISP)*G(I,ISP)
 45   CONTINUE
      ASUM2(I)=ASUM2(I)/ICULO
10    DHTDP(I,IC)=ASUM2(I)
C
C  I VALORI INIZIALI DI DHDPDP SONO 2/T X'X
C  E ZERO PER I BLOCCHI FUORI DIAGONALE
C
      DO 51 IC=1,INDIET
      DO 52 I=1,NCOEFF
      DO 52 J=1,NCOEFF
52    DHDPDP(I,J,1+IC)=0.0D0
      DO 53 ISP=NINIT,NFINSM
      DO 54 I=1,NCOEFF
      DO 54 J=1,NCOEFF
54    DHDPDP(I,J,1+IC)=DHDPDP(I,J,1+IC)+G(I,ISP)*G(J,ISP)*2./ICULO
53    CONTINUE
      DO 211 I=1,NCOEFF
      DO 212 J=1,NABET1
      DHDPDP(I,NCOEFF+J,1+IC)=0.0D0
212   CONTINUE
211   CONTINUE
51    CONTINUE
      DO 9 IC=NINIT,NFINSM
      DO 11 I=1,NCOEFF
      DHTDP(I,IC)=0.
11    CONTINUE
      IF(NALFA.LE.0)GO TO 15
      DO 12 I=1,NCOEFF
      DO 12 J=1,NALFA
      IF(IC-NALFA.LT.NINIT) GO TO 376
      DHTDP(I,IC)=DHTDP(I,IC)-2.*ALFA(J)*G(I,IC-J)*RES(1,IC-J)
      GO TO 12
376   CONTINUE
      DHTDP(I,IC)=DHTDP(I,IC)+ALFA(J)*ASUM2(I)
12    CONTINUE
15    CONTINUE
      IF(NBETA.LE.0)GO TO 13
      DO 14 I=1,NCOEFF
      DO 14 J=1,NBETA
14    DHTDP(I,IC)=DHTDP(I,IC)+DHTDP(I,IC-J)*BETA(J)
13    CONTINUE
9     CONTINUE
C
C  SI INIZIA IL CALCOLO DEL GRADIENTE AUX3 E DELLE MATRICI VC6 E VC9
C
      DO 20 I=1,NPARAM
      AUX3(I)=0.
      DO 19 J=1,NPARAM
      VC6(I,J)=0.
19    VC9(I,J)=0.
20    CONTINUE
      DO 61 IC=NINIT,NFINSM
C
C  PRIMA PARTE RELATIVA AI COEFFICIENTI (EQ. 22 PAG. 316) ERR. DI STAMPA
C  NEL SECONDO TERMINE C'E' UN *HT INVECE DI /HT
      RSUH=RES(1,IC)/HT(IC)
      R2SUH=RSUH*(RES(1,IC))
      US2HQ=0.5/(HT(IC)*HT(IC))
      DO 22 I=1,NCOEFF
      AA=RSUH*G(I,IC)+0.5/HT(IC)*DHTDP(I,IC)*(R2SUH-1.)
      AUX3(I)=AUX3(I)+AA
      DO 522 J=1,I
      VC6(I,J)=VC6(I,J)+
     +AA*(RSUH*G(J,IC)+0.5/HT(IC)*DHTDP(J,IC)*(R2SUH-1.))
      VC6(J,I)=VC6(I,J)
      VC9(I,J)=VC9(I,J)+
     -G(I,IC)*G(J,IC)/HT(IC)+US2HQ*DHTDP(I,IC)*DHTDP(J,IC)
522   VC9(J,I)=VC9(I,J)
C
C  IN QUESTO DO SI RIEMPIONO I DUE BLOCCHI NON DIAGONALI PER L'O.P.
      DO 5522 J=1,NABET1
      NCJ=NCOEFF+J
      VC6(I,NCJ)=VC6(I,NCJ)+
     +AA*(0.5/HT(IC)*DHTDP(NCJ,IC)*(R2SUH-1.))
5522  VC6(NCJ,I)=VC6(I,NCJ)
22    CONTINUE
C
C SECONDA PARTE RELATIVA AD ALFA E BETA (EQ. 19 PAG. 315)
C
      DO 23 I=1,NABET1
      NCI=NCOEFF+I
      AA=0.5/HT(IC)*DHTDP(NCI,IC)*(R2SUH-1.)
      AUX3(NCI)=AUX3(NCI)+AA
      DO 523 J=1,I
      NCJ=NCOEFF+J
      VC6(NCI,NCJ)=VC6(NCI,NCJ)+AA*(0.5/HT(IC)*DHTDP(NCJ,IC)*(R2SUH-1.))
      VC6(NCJ,NCI)=VC6(NCI,NCJ)
      VC9(NCI,NCJ)=VC9(NCI,NCJ)+US2HQ*DHTDP(NCI,IC)*DHTDP(NCJ,IC)
523   VC9(NCJ,NCI)=VC9(NCI,NCJ)
23    CONTINUE
61    CONTINUE
C     ORA SI RIEMPIE LA HESS
C
      DO 24 I=1,NPARAM
      DO 24 J=1,NPARAM
24    VC5(I,J)=0.
C
      DO 25 IC=NINIT,NFINSM
      RSUH=RES(1,IC)/HT(IC)
      R2SUH=RSUH*RES(1,IC)
      R2SUH3=R2SUH/(HT(IC)*HT(IC))
      USUH2=1./(HT(IC)*HT(IC))
      DO 71 I=1,NPARAM
      DO 71 J=1,NPARAM
71    DHDPDP(I,J,1)=0.0
      IF(INDIET.LE.0) GO TO 90
      DO 91 II=1,NALFA
      DO 92 I=1,NCOEFF
      DO 92 J=1,NCOEFF
      IF(IC-NALFA.LT.NINIT) GO TO 377
      DHDPDP(I,J,1)=DHDPDP(I,J,1)+2.*G(I,IC-II)*G(J,IC-II)*ALFA(II)
      GO TO 92
377   CONTINUE
      DHDPDP(I,J,1)=DHDPDP(I,J,1)+DHDPDP(I,J,1+NALFA)*ALFA(II)
92    CONTINUE
91    CONTINUE
      DO 93 II=1,NBETA
      DO 94 I=1,NCOEFF
      DO 94 J=1,NCOEFF
94    DHDPDP(I,J,1)=DHDPDP(I,J,1)+
     +DHDPDP(I,J,1+II)*BETA(II)
93    CONTINUE
      DO 213 I=1,NCOEFF
      DO 214 II=1,NALFA
      IF(IC-NALFA.LT.NINIT) GO TO 477
      DHDPDP(I,NCOEFF+1+II,1)=DHDPDP(I,NCOEFF+1+II,1)-
     -2*G(I,IC-II)*RES(1,IC-II)
      GO TO 214
477   CONTINUE
      DHDPDP(I,NCOEFF+1+II,1)=DHDPDP(I,NCOEFF+1+II,1)+ASUM2(I)
214   CONTINUE
      DO 215 II=1,NBETA
      DHDPDP(I,NCOEFF+1+NALFA+II,1)=DHDPDP(I,NCOEFF+1+NALFA+II,1)+
     +DHTDP(I,IC-II)
215   CONTINUE
213   CONTINUE
      DO 216 II=1,NBETA
      DO 217 I=1,NCOEFF
      DO 218 J=1,NABET1
      DHDPDP(I,NCOEFF+J,1)=DHDPDP(I,NCOEFF+J,1)+
     +DHDPDP(I,NCOEFF+J,1+II)*BETA(II)
218   CONTINUE
217   CONTINUE
216   CONTINUE
90    CONTINUE
C
C  PARTE RELATIVA AI COEFFICIENTI (EQ. 23 PAG. 316)
C  SI RICORDA CHE SI PRENDE IL VALORE ATTESO E RESTANO SOLO I PRIMI
C  DUE TERMINI
      DO 26 I=1,NCOEFF
      DO 26 J=1,NCOEFF
26    VC5(I,J)=VC5(I,J)-G(I,IC)*G(J,IC)/HT(IC)-
     -0.5*R2SUH3*DHTDP(I,IC)*DHTDP(J,IC)-
     -(RSUH*G(J,IC)*DHTDP(I,IC))/HT(IC)-
     -(RSUH*G(I,IC)*DHTDP(J,IC))/HT(IC)+
     +0.5*(R2SUH-1.)*(DHDPDP(I,J,1)/HT(IC)-DHTDP(I,IC)*DHTDP(J,IC)/
     /(HT(IC)*HT(IC)))
C
C  PARTE RELATIVA AD ALFA E BETA  (EQ. 20 PAG. 315)
C  SI RICORDA CHE SI PRENDE IL VALORE ATTESO E RESTA SOLO IL SECONDO
C  TERMINE
C
C
C  CALCOLO DI DHDPDP AL TEMPO IC CHE VA' NEL POSTO 1 DEL TERZO INDICE
C
      IF(NBETA.LE.0) GO TO 80
C
      DO 72 I=1,NABET1
      DO 73 J=1,NBETA
      DHDPDP(NCOEFF+I,NCOEFF+NALFA+1+J,1)=
     =DHDPDP(NCOEFF+I,NCOEFF+NALFA+1+J,1)+
     +DHTDP(NCOEFF+I,IC-J)
73    CONTINUE
72    CONTINUE
      DO 82 I=1,NBETA
      DO 83 J=1,NABET1
      DHDPDP(NCOEFF+NALFA+1+I,NCOEFF+J,1)=
     =DHDPDP(NCOEFF+NALFA+1+I,NCOEFF+J,1)+
     +DHTDP(NCOEFF+J,IC-I)
83    CONTINUE
82    CONTINUE
      DO 74 II=1,NBETA
      DO 75 I=1,NABET1
      DO 75 J=1,NABET1
75    DHDPDP(NCOEFF+I,NCOEFF+J,1)=DHDPDP(NCOEFF+I,NCOEFF+J,1)+
     +BETA(II)*DHDPDP(NCOEFF+I,NCOEFF+J,1+II)
74    CONTINUE
80    CONTINUE
      DO 27 I=NCOEF1,NPARAM
      DO 27 J=NCOEF1,NPARAM
27    VC5(I,J)=VC5(I,J)+0.5*USUH2*DHTDP(I,IC)*DHTDP(J,IC)-
     -R2SUH3*DHTDP(I,IC)*DHTDP(J,IC)+
     +0.5*(R2SUH-1.0)/HT(IC)*DHDPDP(I,J,1)
C
C
C
C  PARTE MISTA IN ALTO DESTRA
C
C
      DO 226 I=1,NCOEFF
      DO 226 J=1,NABET1
226   VC5(I,NCOEFF+J)=VC5(I,NCOEFF+J)-G(I,IC)*RSUH*
     *DHTDP(NCOEFF+J,IC)/HT(IC)-
     -0.5*(R2SUH-1.)*DHTDP(NCOEFF+J,IC)*DHTDP(I,IC)/
     /(HT(IC)*HT(IC))+
     +0.5*(R2SUH-1.)*DHDPDP(I,NCOEFF+J,1)/HT(IC)-
     -0.5*R2SUH*USUH2*DHTDP(I,IC)*DHTDP(NCOEFF+J,IC)
C
C PRIMA DI USCIRE DAL TEMPO T=IC, SI RISISTEMA LA DHDPDP
C
      IF(INDIET.LE.0) GO TO 190
      DO 111 II=1,INDIET
      DO 112 I=1,NPARAM
      DO 112 J=1,NPARAM
112   DHDPDP(I,J,2+INDIET-II)=DHDPDP(I,J,1+INDIET-II)
111   CONTINUE
190   CONTINUE
25    CONTINUE
C
C  IL DO 25 SUL TEMPO E' FINITO E ALLORA SI RIEMPIE LA PARTE
C  MISTA IN BASSO A SINISTRA
C
      DO 227 I=1,NCOEFF
      DO 227 J=1,NABET1
227   VC5(NCOEFF+J,I)=VC5(I,NCOEFF+J)
C
C SI CAMBIA IL SEGNO ALLA MATRICE
C
      DO 692 I=1,NPARAM
      DO 692 J=1,NPARAM
692   VC5(I,J)=-VC5(I,J)
C
      RETURN
      END
