class fvWinKeeper  {
    inherit itk::Toplevel

    constructor {args} {}
    destructor  {}

    private variable namList ""
    private variable winList ""
    private variable typList ""
    private variable extList ""
    private variable objList ""
    private variable tmpWinList ""
    private variable tmpObjList ""
    private variable tmpTypList ""

    public method register {win type fName extNum obj}
    public method signoff {win}
    public method intCheck {type}
    public method setCursor { cursor }
    public method actOn {win}
    public method updateMacWindows { }
    public method updateVisibility { }

    private method hide {}
    private method clean {} 
    private method refresh {}

}

body fvWinKeeper::constructor {args} {
   global isMac
   global env
   
   wm withdraw $itk_interior
    
   if { ! $isMac } {
      itk_component add mainMenu {
         menu $itk_interior.menu -tearoff false -type tearoff -bd 0
      }
      wm title $itk_interior.menu "fv"
      wm geometry $itk_interior.menu +0+0

#      $itk_component(mainMenu) add command -label "fv Desktop Manager" \
#            -background green
#      $itk_component(mainMenu) add separator

      set itk_interior $itk_component(mainMenu)
      
      $itk_component(mainMenu) add command  -label "New File..." \
            -command createNewFITS
      $itk_component(mainMenu) add command  -label "Open File..." \
            -command selFile
      $itk_component(mainMenu) add command -label "SkyView..." \
            -command {
                 global skyvflag
                 if ![info exists skyvflag ] {
                      set skyvflag 1
                      FVSkyview skyv
                 }
                 skyv getskyvfile
            }
      $itk_component(mainMenu) add command -label "Catalogs..." \
            -command {
                 global skyvflag
                 if ![info exists skyvflag ] {
                      set skyvflag 1
                      FVSkyview skyv
                 }
                 skyv getskyvcat
            }
      if { [info exists env(FTOOLS)] || [info exists env(LHEASOFT)] } {  
            $itk_component(mainMenu) add command  -label "Run Ftool..." \
            -command {
                global ftoolflag
                if ![info exists ftoolflag ] {
                      set ftoolflag 1
                      FtoolInstance fvFtool
                }
                fvFtool MainMenu
            }
      }

      $itk_component(mainMenu) add separator

      $itk_component(mainMenu) add command -label "Hide All Windows" \
            -command [code $this actOn all]

      itk_component add summarymenu {
         menu $itk_interior.sm -tearoff false
      }
      $itk_component(mainMenu) add cascade \
	    -menu $itk_component(summarymenu) -label "File Summary"

      itk_component add headermenu {
         menu $itk_interior.hm -tearoff false
      }
      $itk_component(mainMenu) add cascade \
	    -menu $itk_component(headermenu) -label "Header"

      itk_component add tablemenu {
         menu $itk_interior.tm -tearoff false
      }
      $itk_component(mainMenu) add cascade \
	    -menu $itk_component(tablemenu) -label "Table"

      itk_component add itablemenu {
         menu $itk_interior.itm -tearoff false
      }
      $itk_component(mainMenu) add cascade \
	    -menu $itk_component(itablemenu) -label "Image Table"

      itk_component add vtablemenu {
         menu $itk_interior.vtm -tearoff false
      }
      $itk_component(mainMenu) add cascade \
	    -menu $itk_component(vtablemenu) -label "Vector Table"


      $itk_component(mainMenu) add separator
      $itk_component(mainMenu) add command -label "Clipboard" \
            -command {fvClipBoard toggleView}
      
      $itk_component(mainMenu) add separator
      $itk_component(mainMenu) add command -label "Help" \
            -command {hhelp deskTopManager}   

      $itk_component(mainMenu) add command -label "Quit" \
            -command "doMenuEvent <<Quit>> ."

      updateVisibility

   } else {

      set itk_component(summarymenu) .mbar.wind.sm
      set itk_component(headermenu)  .mbar.wind.hm
      set itk_component(tablemenu)   .mbar.wind.tm
      set itk_component(vtablemenu)  .mbar.wind.vtm
      set itk_component(itablemenu)  .mbar.wind.itm

   }
   wm protocol $itk_interior WM_DELETE_WINDOW [code $this hide]
   refresh
}

body fvWinKeeper::destructor {} {
}

body fvWinKeeper::clean {} {
    $itk_component(summarymenu) delete 0 last
    $itk_component(headermenu)  delete 0 last
    $itk_component(tablemenu)   delete 0 last
    $itk_component(vtablemenu)  delete 0 last
    $itk_component(itablemenu)  delete 0 last
}

body fvWinKeeper::refresh {} {

    set hcount  0
    set tcount  0
    set vtcount 0
    set itcount 0
    set scount  0

    for {set i 0} {$i < [llength $winList]} {incr i} {
	set win    [lindex $winList  $i]
	set type   [lindex $typList  $i]
	set name   [lindex $namList  $i]
# starts with 0
	set ext    [expr [lindex $extList  $i] -1] 
	
	switch $type {
	    "Header" {
		$itk_component(headermenu) add command -label ${name}\[$ext\] \
		    -command [code $this actOn $win] 
		incr hcount
	    } 
	    "Table" {
		$itk_component(tablemenu) add command -label ${name}\[$ext\] \
		    -command [code $this actOn $win]
		incr tcount
	    }
	    "Vector Table" {
		$itk_component(vtablemenu) add command -label ${name}\[$ext\] \
		    -command [code $this actOn $win]
		incr vtcount
	    }	    
	    "Image Table" {
		$itk_component(itablemenu) add command -label ${name}\[$ext\] \
		    -command [code $this actOn $win]
		incr itcount
	    }	 
	    "Highlight" {
		$itk_component(summarymenu) add command -label $name \
		    -command [code $this actOn $win]
		incr scount
	    }	 
	    default {
		error "Unknown type of window to manage: $type"
		return
	    }
	}
    }
    foreach {var menu} [list hcount header tcount table vtcount vtable \
                        itcount itable scount summary] {
        if { [expr $$var] == 0 } {
            $itk_component(${menu}menu) add command -label none \
                -state disabled
        }
    }
}

body fvWinKeeper::updateMacWindows { } {
    clean
    refresh
}

body fvWinKeeper::actOn {win} {
    if {$win == "all"} {
	if {[llength $winList ] == 0} {
	    set tmpwinlist ".fD"
	} else {
	    set tmpwinlist $winList
	    lappend tmpwinlist ".fD"
	}
	foreach w $tmpwinlist {
	    wm withdraw $w
	}	
    } else {
	if { [winfo viewable $win] == 1} {
	    wm withdraw $win
	} else {
	    wm deiconify $win
	}	 
    }
}


body fvWinKeeper::setCursor { cursor } {
   foreach w $winList {
      catch {$w configure -cursor $cursor}
   }
   $this configure -cursor $cursor
}

body fvWinKeeper::register {win type fName extNum obj} {
    
    set tmpWinList $winList
    set tmpObjList $objList
    set tmpTypList $typList

    catch {intCheck $type}
    
    clean 

    if { [lsearch $winList $win] == -1} {
	lappend winList $win
	lappend namList $fName
	lappend typList $type
	lappend extList $extNum
	lappend objList $obj
    }

    refresh
}

body fvWinKeeper::signoff {win} {
#   if { ![winfo exists $itk_component(mainMenu)] } return
    clean
    set idx [lsearch $winList $win]
    if { $idx !=-1} {
	set winList [lreplace  $winList $idx $idx]
	set typList [lreplace  $typList $idx $idx]
	set namList [lreplace  $namList $idx $idx]
	set extList [lreplace  $extList $idx $idx]
	set objList [lreplace  $objList $idx $idx]
    } 
    refresh
    if { [llength $winList]==0 } {
       event generate . <<CheckExit>> -when tail
    }
}

body fvWinKeeper::intCheck {t} {

    switch $fvPref::winManagement {
	"Keep" {
	    return
	}
	"Hide" {
           for {set i 0} { $i< [llength $tmpWinList]} {incr i} {
              set win [lindex $tmpWinList $i]
              set tmpName [lindex $tmpTypList $i]
              if { $tmpName == $t } {
                 wm withdraw $win
              }
           }	
	}
	"Close" {
           for {set i 0} { $i< [llength $tmpWinList]} {incr i} {
              set win [lindex $tmpWinList $i]
              set tmpName [lindex $tmpTypList $i]
              if { $tmpName == $t } {
                 event generate $win <<CloseWindow>>
              }
           }	
	}
	default {
	    puts "fv Error: unknown type of window handling"
	}
    }

}


body fvWinKeeper::updateVisibility { } {
   global isMac

   if { !$isMac && $fvPref::ifUseManager } {
      wm deiconify $itk_interior
      if { ! [winfo ismapped $itk_component(mainMenu)] } {
         $itk_component(mainMenu) post 0 0
      }
   } else {
      wm withdraw $itk_interior
   }

}


body fvWinKeeper::hide { } {
   global isMac

   set fvPref::ifUseManager 0
   updateVisibility
   if { !$isMac && [llength $winList]==0 } {
      checkForExit
   }
}
