/* GDA Manager
 * Copyright (C) 1998,1999 Michael Lausch
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gnomedb-mgr.h"
#include <bonobo/bonobo-generic-factory.h>

static guint prepare_app (void);

static BonoboGenericFactory* manager_factory = NULL;
static gint owner_count = 0;

int
main (int argc, char *argv[])
{
	bindtextdomain(PACKAGE, GNOMELOCALEDIR);
	textdomain(PACKAGE);
	
	gnome_db_init("gnomedb-mgr", VERSION, argc, argv);
	
	/* run application */
	gnome_db_main((GtkFunction) prepare_app);
	return 0;
}

static void
owner_set_cb (GnomeDbControl *control, gpointer user_data)
{
	owner_count++;
}

static void
owner_unset_cb (GnomeDbControl *control, gpointer user_data)
{
	owner_count--;
	if (owner_count == 0)
		gnome_db_main_quit ();
}

static BonoboObject *
manager_factory_func (BonoboGenericFactory *factory, const char *id, gpointer closure)
{
	BonoboObject *object = NULL;

	g_return_val_if_fail(BONOBO_IS_GENERIC_FACTORY(factory), NULL);
	g_return_val_if_fail(id != NULL, NULL);

	if (!strcmp(id, GNOME_DB_OAFIID_MANAGER))
		object = manager_control_new();

	/* connect to set/get_owner signals */
	if (BONOBO_IS_OBJECT (object)) {
		gtk_signal_connect (GTK_OBJECT (object),
				    "set_owner",
				    GTK_SIGNAL_FUNC (owner_set_cb),
				    NULL);
		gtk_signal_connect (GTK_OBJECT (object),
				    "unset_owner",
				    GTK_SIGNAL_FUNC (owner_unset_cb),
				    NULL);
	}

	return object;
}

static guint
prepare_app (void)
{
	/* create component factory */
	manager_factory = bonobo_generic_factory_new_multi(GNOME_DB_OAFIID_MANAGER_FACTORY,
	                                                   manager_factory_func,
	                                                   NULL);
	bonobo_running_context_auto_exit_unref(BONOBO_OBJECT(manager_factory));

	return FALSE;
}
