/** $Header: /cvsroot/gprolog/contribs/gplmysql/mysqlwrap.c,v 1.2 2002/01/29 05:53:18 oommoo Exp $
 *
 * MySQL is a very fast, multi-threaded, multi-user, and robust SQL (Structured Query Language) database server.  Brief comments are listed here as a reference alignment from the original documentation.
 * http://www.mysql.com/documentation/
 *
 * These wrapper functions allow low level access to the mysql function.  The pointers to various mysql structure types are masked as int pointers for ease of reference.  Where appropriate, wrapper function will return a value, gprc, set to the recturn code from called mysql function.
 *
 */
#define GPLSQL_IMPL
#define GPCDECL 

#include "mysqlwrap.h"

/** sql_init will return 1 if sucessful and 0 otherwise.
 * the input could be the pointer to a int that will be fixed 
 * up with the address of the MYSQL structure.  
 * Currently we just cast the address as a int and return it.
 */
Bool GPCDECL sql_init( int * address ) {
  MYSQL * mysql = NULL;
  printf( "Calling mysql_init\n");
  mysql = mysql_init( NULL );
  if( !mysql ) {
    Pl_Err_System( Create_Allocate_Atom( "sql_init failed." ) );
  }
  printf( "mysql_init() => %p\n", mysql );
  *address = (int) mysql;
  printf( "*address = %d\n", *address );
  return ( mysql ? TRUE : FALSE );
}

/** sql_real_connect/4 attempts to establish a connection to 
 * a MySQL database engine running on the gpecified host.
 * if an error occurs it will return the contents of mysql_errno
 * and zero otherwise.
 */
Bool GPCDECL sql_real_connect( int * gpsql, 
			   char * gphost,
                           char * gpuser,
			   char * gppasswd,
			   int * gprc
                         ) {
  int rc = RC_DEFAULT;
  MYSQL * sql;
  sql = (MYSQL *) gpsql;
  printf( "Calling mysql_real_connect( %p, %s, %s, %s )\n", 
	  sql, gphost, gpuser, gppasswd);
  if ( ! mysql_real_connect( sql, gphost, gpuser, gppasswd, 
                             NULL, 0, NULL, 0) ) {
    *gprc = rc = mysql_errno( sql );
    Pl_Err_System( Create_Allocate_Atom( "trouble in sql_real_connect." ) );
    printf("trouble in sql_real_connect w/ %d\n%s\n", rc, mysql_error( sql ) );
  }
  return ( rc ? FALSE : TRUE );
}

/** Causes the database gpecified by db to become the default 
 * (current) database on the connection gpecified.  If not
 * successful one of the follwoing should be returned :
 * CR_COMMANDS_OUT_OF_SYNC 
 *     Commands were executed in an improper order. 
 * CR_SERVER_GONE_ERROR 
 *     The MySQL server has gone away. 
 * CR_SERVER_LOST 
 *     The connection to the server was lost during the query. 
 * CR_UNKNOWN_ERROR 
 *     An unknown error occurred. 
 */
Bool GPCDECL sql_select_db( int * gpref, 
                        char * gpdb,
			int * gprc
                      ) {
  int rc = RC_DEFAULT;
  MYSQL * sql;
  sql = (MYSQL *) gpref;

  if ( mysql_select_db( sql, gpdb ) ) {
    *gprc = rc = mysql_errno( sql );
    printf("trouble in sql_select_db w/ %d\n%s\n", rc, mysql_error( sql ) );
    Pl_Err_System( Create_Allocate_Atom( "trouble in sql_select_db." ) );
  }
  return ( rc ? FALSE : TRUE );
}

/** Executes the SQL query pointed to by the null-terminated string query.
 * If not successful one of the follwoing should be returned :
 * CR_COMMANDS_OUT_OF_SYNC 
 *     Commands were executed in an improper order. 
 * CR_SERVER_GONE_ERROR 
 *     The MySQL server has gone away. 
 * CR_SERVER_LOST 
 *     The connection to the server was lost during the query. 
 * CR_UNKNOWN_ERROR 
 *     An unknown error occurred. 
 */
Bool GPCDECL sql_query( int * gpref, 
                          char * gpquery,
			   int * gprc
                          ) {
  int rc = RC_DEFAULT;
  MYSQL * sql;
  sql = (MYSQL *) gpref;
  if ( mysql_query( sql, gpquery ) ) {
    *gprc = rc = mysql_errno( sql );
    printf("trouble in sql_query w/ %d\n%s\n", rc, mysql_error( sql ) );
    Pl_Err_System( Create_Allocate_Atom( "trouble in sql_query." ) );
  }
  return  ( rc ? FALSE : TRUE );
}

/** close a database connection allocated with mysql_init.
 * future (refactoring) should check for possible errors.
 */
Bool GPCDECL sql_close( int * gpsql ) {
  MYSQL * sql;
  sql = (MYSQL *) gpsql;
  mysql_close( sql );
  return TRUE;
}

/** reads the entire result of a query to the client, allocates
 * a MYSQL_RES structure, and places the result into this structure. 
 * An empty result set is returned if there are no rows returned.
 */
Bool GPCDECL sql_store_result( int * gpref, int * gpres ) {
  MYSQL * sql = NULL;
  MYSQL_RES * gresult = NULL;
  sql = (MYSQL *) gpref;
  *gpres = (int) gresult = mysql_store_result( sql );
  if ( !gresult ) {
    Pl_Err_System( Create_Allocate_Atom( "trouble in sql_store_result." ) );
  }
  return ( gresult ? TRUE : FALSE );
}

/** initiates a result set retrieval but does not actually read
 * the result set into the client.
 */
Bool GPCDECL sql_use_result( int * gpref, int * gpres ) {
  MYSQL * sql = NULL;
  MYSQL_RES * gresult = NULL;
  sql = (MYSQL *) gpref;
  *gpres = (int) gresult = mysql_use_result( sql );
  if ( !gresult ) {
    Pl_Err_System( Create_Allocate_Atom( "trouble in sql_store_result." ) );
  }
  return ( gresult ? TRUE : FALSE );
}

/** Frees the memory allocated for a result set.
 */
Bool GPCDECL sql_free_result( int * gpres ) {
  MYSQL_RES * gresult = NULL;
  gresult = (MYSQL_RES *) gpres;
  mysql_free_result( gresult );
  return TRUE;
}

/** Retrieves the next row of a result set. 
 */
Bool GPCDECL sql_fetch_row( int * gpres, PlTerm * gplist, int * gprow) { 
  MYSQL_RES * gresult = NULL;
  MYSQL_ROW grow = NULL;
  unsigned int num_fields;
  unsigned int i;
  unsigned long *glengths;
  PlTerm * gpatom;
  gresult = (MYSQL_RES *) gpres;
  printf("gresult = %p\n", gresult );
  num_fields = mysql_num_fields( gresult );
  printf("num_fields = %d\n", num_fields );
  gpatom =  (PlTerm *)malloc( num_fields * sizeof(PlTerm) );
  if( !gpatom ) {
    Pl_Err_System( Create_Allocate_Atom( "malloc_failed" ) );
    return FALSE;
  }
  if ( ( grow = mysql_fetch_row( gresult ) ) ) {
    glengths = mysql_fetch_lengths( gresult );
    for(i = num_fields; i > 0; i--) {
      int j = i - 1;
      printf( "grow[%d] = %s\n", i, grow[j] );
      gpatom[j] = Mk_String( grow[j] );
    }
    *gplist = Mk_Proper_List( num_fields, gpatom );
  } else {
    *gplist = Mk_List( 0 );
  }
  free( gpatom );
  return ( grow ? TRUE: FALSE );
}

Bool GPCDECL sql_error(  int * gpref, PlTerm * error ) {
  MYSQL * sql = NULL;
  PlTerm element;
  char * value;
  sql = (MYSQL *) gpref;
  if ( ( value = mysql_error( sql ) ) ) {
    printf( "sql_error %s\n", value );
    element = Mk_String( value ); 
    *error = Mk_Proper_List( 1, &element );
  }
  return TRUE;
}

Bool GPCDECL sql_info(  int * gpref, PlTerm * error ) {
  MYSQL * sql = NULL;
  PlTerm element;
  char * value;  
  sql = (MYSQL *) gpref;
  value = mysql_info( sql );
  printf( "sql_info %s\n", value );
  element = Mk_String( value ); 
  *error = Mk_Proper_List( 1, &element );
  return TRUE;
}
