/***************************************************************************
                          muscle_c.c  -  description
                             -------------------
    begin                : Thu Apr 11 2002
    copyright            : (C) 2002 by Renaud Mariana
    email                : rmariana@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <string.h>
#include <winscard.h>

#include "gprolog.h"

void 
raise_sys_error(LONG rv)
{
	Pl_Err_System(Create_Atom(pcsc_stringify_error(rv)));
}

Bool
scard_establish_context_C(char *pcHost, long* hContext)
{
  LONG rv;

	Set_C_Bip_Name("scard_establish_context", 2);
	 rv = SCardEstablishContext( SCARD_SCOPE_GLOBAL, pcHost, NULL, hContext );
  if ( rv != SCARD_S_SUCCESS ) {
		raise_sys_error(rv);
  }

  return TRUE;			/* succeed */	
}

Bool
scard_list_readers_C(long hContext, PlTerm list)
{
  PlTerm op[128];
  LPCSTR mszGroups;
  DWORD dwReaders;
  LPSTR mszReaders;
  int n = 0, p;
  LONG rv;


	Set_C_Bip_Name("scard_list_readers", 2);
  mszGroups = 0;
  rv = SCardListReaders( hContext, mszGroups, 0, &dwReaders );
 
	if ( rv != SCARD_S_SUCCESS ) {
		raise_sys_error(rv);
  }
  
	mszReaders = (char *)malloc(sizeof(char) * dwReaders);
  
	SCardListReaders( hContext, mszGroups, mszReaders, &dwReaders );
	
	if ( rv != SCARD_S_SUCCESS ) {
		free(mszReaders);
		raise_sys_error(rv);
  }
	
  p = 0;

  while (strlen(mszReaders + p) > 0) {
		op[n] = Mk_String(mszReaders+p);
		/*
no test on return  Mk_Atom
		*/
    p += strlen(mszReaders + p) + 1;
		n++;
  }

	free(mszReaders);

  return Un_Proper_List_Check(n, op, list);
}


Bool 
scard_connect_C(long hContext, char *readerName, long* hCard, PlTerm prefPro)
{
  LONG rv;
	DWORD dwPref;

	Set_C_Bip_Name("scard_connect", 4);
  rv = SCardConnect(hContext, readerName, 
		    SCARD_SHARE_SHARED,  SCARD_PROTOCOL_T0|SCARD_PROTOCOL_T1, 
		    hCard, &dwPref);

  if ( rv != SCARD_S_SUCCESS ) {
    SCardReleaseContext( hContext );
		raise_sys_error(rv);
  }

  return Un_String_Check((dwPref == SCARD_PROTOCOL_T0)?"t0":"t1", prefPro);
}

Bool 
scard_get_status_change_C(long hContext, char *readerName, long XorState, long* Evt)
{
  SCARD_READERSTATE_A rgReaderState;
	LONG rv;

	rgReaderState.szReader       = readerName;
  rgReaderState.dwCurrentState = XorState;
	rv = SCardGetStatusChange( hContext, INFINITE, &rgReaderState, 1 );

  	
  if ( rv != SCARD_S_SUCCESS ) {
		raise_sys_error(rv);
  }

	*Evt = rgReaderState.dwEventState;

  return TRUE;			/* succeed */
}

Bool 
scard_status_C(long hCard, long* state, PlTerm atrL)
{
  LONG rv;
	DWORD dwProtocol, cbAtrLen, dwReaders = MAX_READERNAME;
  char mszReaders[MAX_READERNAME];
	BYTE bAtr[MAX_ATR_SIZE];
	PlTerm apduB[MAX_ATR_SIZE];
	int i;

	Set_C_Bip_Name("scard_status", 3);
  rv = SCardStatus(hCard, mszReaders, &dwReaders, state, &dwProtocol, bAtr, &cbAtrLen);

  if ( rv != SCARD_S_SUCCESS ) {
		raise_sys_error(rv);
  }
	
	for (i=0; i < cbAtrLen; i++) {
		apduB[i] = Mk_Byte(bAtr[i]);		
	}
	 
	return Un_Proper_List_Check(i, apduB, atrL);
}

Bool 
scard_disconnect_C(long hCard)
{
  LONG rv;
	rv = SCardDisconnect( hCard, SCARD_RESET_CARD );

  if ( rv != SCARD_S_SUCCESS ) {
		raise_sys_error(rv);
  }

  return TRUE;			/* succeed */
}

Bool
scard_release_context_C(long hContext)
{
  LONG rv;

	Set_C_Bip_Name("scard_release_context", 1);
  rv = 	SCardReleaseContext( hContext );

  if ( rv != SCARD_S_SUCCESS ) {
		raise_sys_error(rv);
  }

  return TRUE;			/* succeed */
}

#include <sys/time.h>
#include <sys/resource.h>

Bool 
scard_transmit_C(long hCard, char* sProtocol, PlTerm apduInL, PlTerm apduOutL, long* real_time)
{
  LONG rv;
  BYTE data[MAX_BUFFER_SIZE];
  DWORD dwSendLength, dwRecvLength= MAX_BUFFER_SIZE;
  SCARD_IO_REQUEST sRecvPci;
  struct timeval tv;
  PlTerm term[MAX_BUFFER_SIZE];
  int i;
  

  Set_C_Bip_Name("scard_transmit", 6);
  dwSendLength = Rd_Proper_List(apduInL, term);
  
  
  for (i=0; i < dwSendLength; i++) {
    data[i] = Rd_Byte_Check(term[i])&0xff;
  }
  
  gettimeofday(&tv, NULL);
  *real_time = (tv.tv_sec * 1000) + (tv.tv_usec / 1000);
 
  if ( strcasecmp( sProtocol,"t1")  == 0 ) {
    
    rv = SCardTransmit( hCard, SCARD_PCI_T1, data, dwSendLength, 
			&sRecvPci, data, &dwRecvLength );
  } 
  else {
		
    rv = SCardTransmit( hCard, SCARD_PCI_T0, data, dwSendLength, 
			&sRecvPci, data, &dwRecvLength );
  }

  gettimeofday(&tv, NULL);
  *real_time = (tv.tv_sec * 1000) + (tv.tv_usec / 1000) - *real_time;

  if ( rv != SCARD_S_SUCCESS ) {
    raise_sys_error(rv);
  }
		
  for (i=0; i < dwRecvLength; i++) {
    term[i] = Mk_Byte(data[i]);
  }
  
  return Un_Proper_List_Check(i, term, apduOutL);
}
