/***************************************************************************
                          kbeardirlister.cpp  -  description
                             -------------------
    begin                : fre mar 8 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qdir.h>
#include <qfile.h>
#include <qtimer.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kmessagebox.h>
#include <klocale.h>
#include <kio/job.h>
#include <kio/jobclasses.h>
#include <kuserprofile.h>
#include <kmessagebox.h>
#include <kguiitem.h>
#include <kdirlister.h>
#include <kdeversion.h>
#include <kapplication.h>
#include <kdirwatch.h>
#include <kstandarddirs.h>
#include <kconfig.h>
#include <kio/slave.h>
#include <kio/scheduler.h>
#include <kparts/componentfactory.h>
#include <ktrader.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbeardirlister.h"
#include "kbearlistjob.h"
#include "kbeardeletejob.h"
#include "kbearfilecopyjob.h"
#include "kbearconnectionmanager.h"

//-----------------------------------------------
KBearDirLister::KBearDirLister( QObject* parent, const char* name, const Connection& c )
	:	QObject( parent, name ),
		m_dirLister( 0L ), m_slave( 0L ), m_listJob( 0L ),
		m_statJob( 0L ), 	m_connection( c ), m_useFilter( false ),
		m_isLocal( false ), m_showingDotFiles( false ),
		m_mime( QString::null ), m_state( DISCONNECTED ),
		m_viewMode( 0 ), m_tempFile( 0L )
{
	KURL url = m_connection.url();
	m_isLocal = url.isLocalFile();
	m_filterList.setAutoDelete( true );
	connect( connectionManager, SIGNAL( slaveKilled( KIO::Slave* ) ),
				this, SLOT( slotSlaveKilled( KIO::Slave* ) ) );

}
//-----------------------------------------------
KBearDirLister::~KBearDirLister(){
	if( m_tempFile ) {
		QFile::remove( m_tempFile->prettyURL() );
		delete m_tempFile;
	}
	if( m_dirLister )
		delete m_dirLister;
	if( m_slave )
		connectionManager->closeConnection( (unsigned long)this );
	kdDebug()<<"KBearDirLister::~KBearDirLister()"<<endl;
}
//-----------------------------------------------
void KBearDirLister::openURL( const KURL& url, bool reload ) {
	kdDebug()<<"KBearDirLister::openURL() url="<<url.prettyURL()<<" reload="<<reload<<" state="<<m_state<<endl;
	// this method should only be called for directories
	m_url = url;
	m_state |= LISTING;

	if( m_state & DISCONNECTED ) {
		kdDebug()<<"KBearDirLister::openURL() DISCONNECTED url="<<url.prettyURL()<<" reload="<<reload<<endl;
		openConnection();
	}
	else if( m_state & CONNECTED ) {
		if( m_isLocal ) {
			kdDebug()<<"KBearDirLister::openURL() CONNECTED url="<<url.prettyURL()<<" reload="<<reload<<endl;
			m_dirLister->openURL( m_url, false, reload );
		}
		else {
			listRemoteDir( m_url );
		}
	}
}
//-----------------------------------------------
void KBearDirLister::openConnection() {
	kdDebug()<<"KBearDirLister::openConnection() url="<<m_connection.url().prettyURL()<<endl;
	m_state = m_state & ~DISCONNECTED; 
	slotDisconnectSlaveInfo();
	m_state |= CONNECTING;
	if( m_isLocal ) {
		setDirLister();
		return;
	}
	m_slave = connectionManager->openNewConnection( (unsigned long)this, m_connection, true );
	if( m_slave ) {
		connect( m_slave, SIGNAL( infoMessage( const QString& ) ),
					this, SIGNAL( infoMessage( const QString& ) ) );
		connect( m_slave, SIGNAL( error( int, const QString&) ),
				this, SLOT( slotSlaveError( int, const QString& ) ) );
//		connect( m_slave, SIGNAL( connected() ), SIGNAL( connected() ) );
		connect( m_slave, SIGNAL( connected() ), this, SLOT( slotSlaveConnected() ) );
		connect( m_slave, SIGNAL( slaveDied( KIO::Slave* ) ), this, SLOT( slotSlaveDied() ) );
	}
	else {
		m_state = m_state & ~CONNECTING;
		m_state |= DISCONNECTED;
	}
}
//-----------------------------------------------
KIO::Job* KBearDirLister::deleteFiles( const KURL::List urls, bool shred, bool showProgress ) {
	KIO::Job* job;
	m_state |= DELETING;

	if( m_isLocal ) {
		job = KIO::del( urls, shred, showProgress );
		if( ! job )
			return 0L;
	}
	else {
		kdDebug()<<"KBearDirLister::deleteFiles singleconnection="<<m_connection.singleConnection()<<endl;
		job = (KBearDeleteJob*)connectionManager->del( (unsigned long)this ,urls, shred, showProgress );
	}
	connect( job, SIGNAL( infoMessage( KIO::Job*, const QString& ) ),
				this, SLOT( slotInfoMessage( KIO::Job*, const QString& ) ) );
	connect( job, SIGNAL( result( KIO::Job*) ), this, SLOT( slotResult( KIO::Job*) ) );
	connect( job, SIGNAL( result( KIO::Job*) ), SIGNAL( deleteFinished() ) );
	KURL::List::ConstIterator it = urls.begin();
	for( ; it != urls.end(); ++it )
		emit deleteItem( new KFileItem( KFileItem::Unknown, KFileItem::Unknown, (*it) ) );
	return job;
}
//-----------------------------------------------
void KBearDirLister::statLink() {
	statURL( m_statURL );
}
//-----------------------------------------------
void KBearDirLister::statURL( const KURL& url ) {
	// first we need to find out what state we're in
	m_statURL = url;
	m_state |= STATING;
	if( m_state & DISCONNECTED ) {
		kdDebug()<<"KBearDirLister::statURL() DISCONNECTED url="<<url.prettyURL()<<endl;
		openConnection();
	}
	else if( m_state & CONNECTED ) {
		kdDebug()<<"KBearDirLister::statURL() CONNECTED url="<<url.prettyURL()<<endl;
		m_statJob = KIO::stat( m_statURL, false, 0, false );
		if( ! m_isLocal ) { // if remote we need to attach the job to the slave
			connectionManager->attachJob( (unsigned long)this, m_statJob );
		}
		connect( m_statJob, SIGNAL( infoMessage( KIO::Job*, const QString& ) ),
					this, SLOT( slotInfoMessage( KIO::Job*, const QString& ) ) );
		connect( m_statJob, SIGNAL( result( KIO::Job* ) ), this, SLOT( slotResult( KIO::Job* ) ) );
		connect( m_statJob, SIGNAL( redirection( KIO::Job*, const KURL& ) ), this, SLOT( slotStatRedirection( KIO::Job*, const KURL& ) ) );
	}
/*
	if( m_statJob ) {
		disconnect( m_statJob, 0, 0, 0 );
		m_statJob = 0L;
	}
	m_statURL = url;
	if( ! m_isLocal && ( ! m_slave || ! m_slave->isAlive() || ! m_slave->isConnected() ) ) {
		openConnection();
		connect( m_slave, SIGNAL( connected() ), this, SLOT( slotPendingStat() ) );
		return;
	}
	disconnect( m_slave, SIGNAL( connected() ), this, SLOT( slotPendingStat() ) );
	m_statJob = KIO::stat( m_statURL, false, 0, false );
	if( ! m_isLocal ) { // if remote we need to attach the job to the slave
		connectionManager->attachJob( (unsigned long)this, m_statJob );
	}
	connect( m_statJob, SIGNAL( infoMessage( KIO::Job*, const QString& ) ),
				this, SLOT( slotInfoMessage( KIO::Job*, const QString& ) ) );
	connect( m_statJob, SIGNAL( result( KIO::Job* ) ), this, SLOT( slotResult( KIO::Job* ) ) );
	connect( m_statJob, SIGNAL( redirection( KIO::Job*, const KURL& ) ), this, SLOT( slotStatRedirection( KIO::Job*, const KURL& ) ) );
*/
}
//-----------------------------------------------
void KBearDirLister::mkdir( const KURL& newDir ) {
	m_state |= MAKING_DIR;
	KIO::SimpleJob* job = KIO::mkdir( newDir );
	if( ! m_isLocal ) { // if remote we need to attach the job to the slave
		connectionManager->attachJob( (unsigned long)this, job );
	}
	connect( job, SIGNAL( infoMessage( KIO::Job*, const QString& ) ),
				this, SLOT( slotInfoMessage( KIO::Job*, const QString& ) ) );
	connect( job, SIGNAL( result( KIO::Job* ) ), this, SLOT( slotResult( KIO::Job* ) ) );
	connect( job, SIGNAL( result( KIO::Job* ) ), SIGNAL( reload() ) );
}
//-----------------------------------------------
void KBearDirLister::setNameFilter(const QString& nameFilter) {
	kdDebug()<<"KBearDirLister::setNameFilter() filter="<<nameFilter<<endl;
	m_useFilter = ( nameFilter != "*" && nameFilter != "");

	if( ! m_useFilter )
		return;
	m_filterList.clear();
	// Split on white space
	QStringList list = QStringList::split( ' ', nameFilter );
	for( QStringList::Iterator it = list.begin(); it != list.end(); ++it )
		m_filterList.append( new QRegExp(*it, true, true ) );
}
//-----------------------------------------------
void KBearDirLister::setShowingDotFiles( bool show ) {
	m_showingDotFiles = show;
	if( m_isLocal ) {
		m_dirLister->setShowingDotFiles( show );
		m_dirLister->emitChanges();
	}
/*
	else {
		emit clear();
	}
*/
}
//-----------------------------------------------
void KBearDirLister::stop() {
	kdDebug()<<"KBearDirLister::stop()"<<endl;
	if( m_state & GETTING_PREVIEW ) {
		m_previewConnect = "stopped";  // we need this so we don't get stuck in loop waiting for preview connect
	}
	else if( m_state & GETTING_MIME ) {
		m_mime = "stopped";                  // or preview mime
	}
	else if( m_state & LISTING && m_listJob ) {
		disconnect( m_listJob, SIGNAL( infoMessage( KIO::Job*, const QString& ) ), this, 0 );
		disconnect( m_listJob, SIGNAL( result( KIO::Job* ) ), this, 0 );
	}
	else if( m_state & STATING && m_statJob ) {
		disconnect( m_statJob, SIGNAL( infoMessage( KIO::Job*, const QString& ) ), this, 0 );
		disconnect( m_statJob, SIGNAL( result( KIO::Job* ) ), this, 0 );
	}
/*
	m_previewConnect = "stopped";  // we need this so we don't get stuck in loop waiting for preview connect
	m_mime = "stopped";                  // or preview mime
*/
	if( m_isLocal )
		m_dirLister->stop();
	else if( m_slave ) {
/*		if( m_slave->isAlive() )
			m_slave->kill();
*/
		connectionManager->closeConnection( (unsigned long)this );
		emit infoMessage( "internal" + i18n("Connection closed") );
		slotDisconnectSlaveInfo();
	}
/*
	if(  m_listJob )
		disconnect( m_listJob, SIGNAL( infoMessage( KIO::Job *, const QString& ) ), this, 0 );
	if(  m_statJob )
		disconnect( m_statJob, SIGNAL( infoMessage( KIO::Job *, const QString& ) ), this, 0 );
	if(  m_slave )
		disconnect( m_slave, SIGNAL( infoMessage( const QString& ) ), this, 0 );
*/
	m_slave = 0L;
	m_listJob = 0L;
	m_statJob = 0L;
	m_state = DISCONNECTED;
	emit finishedLoading();
}
//-----------------------------------------------
/*KParts::ReadOnlyPart**/void KBearDirLister::getPreviewPart( const KURL& url, QWidget* parent ) {
	kdDebug()<<"KBearDirLister::getPreviewPart url="<<url.prettyURL()<<endl;
	m_state |= GETTING_PREVIEW;
	m_previewURL = url;
	m_mime = QString::null;
	m_partViewer = 0L;
	m_partViewerWidget = parent;
	if( m_isLocal ) {
		m_mime = KMimeType::findByURL( url )->name();
		m_partViewer = getPreviewPartInternal();
		kdDebug()<<"KBearDirLister::getPreviewPart local mime="<<m_mime<<" part="<<m_partViewer<<endl;
		emit previewPart ( m_partViewer, m_previewURL );
//		if( m_partViewer )
//			m_partViewer->openURL( m_previewURL );
	}
	else if( ! m_slave || ! m_slave->isAlive() || ! m_slave->isConnected() ) {
		kdDebug()<<"KBearDirLister::getPreviewPart No Slave"<<endl;
		openConnection();
/*
			m_previewConnect = QString::null;
			while( m_previewConnect == QString::null )
				kapp->processEvents();
			if( m_previewConnect == "stopped" ) // if user stopped
				return (KParts::ReadOnlyPart*)1;
*/
	}
	else {
		determineMimetype();

/*
		// This is fragile, we will be stuck here until we receive a mime type or an error occure
		while( m_mime == QString::null )
			kapp->processEvents();

		kdDebug()<<"KBearDirLister::getPreviewPart remote mime="<<m_mime<<" part="<<m_partViewer<<endl;
*/
	}
/*
	m_state = m_state & ~GETTING_PREVIEW;
	return m_partViewer;
*/
}
//-----------------------------------------------
// END PUBLIC PART
//-----------------------------------------------
void KBearDirLister::determineMimetype() {
	m_state |= GETTING_MIME;
	KIO::TransferJob* job = KIO::get( m_previewURL, false, false );
	connectionManager->attachJob( (unsigned long)this, job );
	connect( job, SIGNAL( mimetype( KIO::Job*, const QString& ) ),
				this, SLOT( slotMimeType( KIO::Job*, const QString& ) ) );
	connect( job, SIGNAL( infoMessage( KIO::Job*, const QString& ) ),
				this, SLOT( slotInfoMessage( KIO::Job*, const QString& ) ) );
	connect( job, SIGNAL( result( KIO::Job*) ), this, SLOT( slotResult( KIO::Job* ) ) );
	emit started();
}
//-----------------------------------------------
KParts::ReadOnlyPart* KBearDirLister::getPreviewPartInternal() {
	kdDebug()<<"KBearDirLister::getPreviewPartInternal() mime in="<<m_mime<<endl;
	// first we need to find out if user want ReadOnly, ReadWrite or want to be asked

	getPreviewMode();
	if( m_viewMode == 2 ) { // Ask
		int ret = KMessageBox::questionYesNoCancel( 0L, i18n( "Do you want to open the file in read only mode or in read/write mode ?"),
													i18n("Select view mode..."), KGuiItem(i18n("Read only")), KGuiItem(i18n("Read/write")) );
		if( ret == KMessageBox::Cancel )
			m_partViewer = (KParts::ReadOnlyPart*)1;
		else if( ret == KMessageBox::No )
			m_viewMode = 1; // ReadWrite
	}

//#if (KDE_VERSION < 305) || !defined(KDE_VERSION)
	QObject* obj = 0L;
	if( m_viewMode == 1 ) { // ReadWrite
		obj = KParts::ComponentFactory::
							createInstanceFromQuery<KParts::ReadWritePart>
							( m_mime, QString::null, m_partViewerWidget, "PreviewPart" );
	}
	if( ! obj ) { // ReadOnly
		obj = KParts::ComponentFactory::
							createInstanceFromQuery<KParts::ReadOnlyPart>
							( m_mime, QString::null, m_partViewerWidget, "PreviewPart" );
	}
	if( obj )
		m_partViewer = dynamic_cast<KParts::ReadOnlyPart*>( obj );
/*
#else
	if( viewMode == 1 ) { // ReadWrite
		m_partViewer = KParts::ComponentFactory::
							createPartInstanceFromQuery<KParts::ReadWritePart>
							( mime, QString::null, m_partViewerWidget, "PreviewPart", parent() );
	}
	if( ! m_partViewer ) { // ReadOnly
		m_partViewer = KParts::ComponentFactory::
							createPartInstanceFromQuery<KParts::ReadOnlyPart>
							( mime, QString::null, m_partViewerWidget, "PreviewPart", parent() );
	}
#endif
*/
	return m_partViewer;
}
//-----------------------------------------------
void KBearDirLister::slotDisconnectSlaveInfo() {
	if( m_slave ) {
		disconnect( m_slave, SIGNAL( infoMessage( const QString& ) ),
					this, SIGNAL( infoMessage( const QString& ) ) );
	}
}
//-----------------------------------------------
void KBearDirLister::slotSlaveConnected() {
	kdDebug()<<"KBearDirLister::slotSlaveConnected()"<<endl;
	disconnect( m_slave, SIGNAL( infoMessage( const QString& ) ),
				this, SIGNAL( infoMessage( const QString& ) ) );
	m_state = m_state & ~CONNECTING;
	m_state = m_state & ~DISCONNECTED;
	m_state |= CONNECTED;
	disconnect( m_slave, SIGNAL( connected() ), this, SLOT( slotSlaveConnected() ) );
	disconnect( m_slave, SIGNAL( error( int, const QString&) ),
				this, SLOT( slotSlaveError( int, const QString& ) ) );
	if( m_state & STATING ) {
		statURL( m_statURL );
	}
	else if( m_state & LISTING ) {
		listRemoteDir( m_url );
	}
	else if( m_state & GETTING_PREVIEW ) {
		determineMimetype();
	}
//	disconnect( m_slave, SIGNAL( connected() ), this, SIGNAL( connected() ) );
	emit connected();
}
/*
//-----------------------------------------------
void KBearDirLister::slotPendingPreview() {
	kdDebug()<<"KBearDirLister::slotPendingPreview()"<<endl;
	m_previewConnect = "connected";
}
*/
//-----------------------------------------------
void KBearDirLister::getPreviewMode() {
	QString oldGroup = kapp->config()->group();
	kapp->config()->setGroup("General");
	m_viewMode = kapp->config()->readUnsignedNumEntry( "Preview Mode", 0 );
	kapp->config()->setGroup( oldGroup );
}
/*
//-----------------------------------------------
void KBearDirLister::slotMimeResult( KIO::Job* job ) {
	kdDebug()<<"KBearDirLister::slotMimeResult() job="<<job<<endl;
	if( job->error() ) {
		QStringList list = job->detailedErrorStrings();
		KMessageBox::detailedError( 0L, list[1], list[2], list[0] );
	}
	m_mime = "error";
}
*/
//-----------------------------------------------
void KBearDirLister::slotMimeType( KIO::Job* job, const QString& mime ) {
	kdDebug()<<"KBearDirLister::slotMimeType() mime="<<mime<<" state="<<m_state<<endl;
	m_mime = mime;
	m_state = m_state & ~GETTING_MIME;
	m_partViewer = getPreviewPartInternal();
	if( m_partViewer ) {
		connectionManager->putOnHold( (unsigned long)this );
		// now we need to find out what type of part we got
		if( m_partViewer->inherits( "KParts::ReadWritePart" ) || m_partViewer->inherits( "KHTMLPart" ) ) {
			kdDebug()<<"KBearDirLister::slotMimeType() get ReadWritePart mime="<<mime<<" state="<<m_state<<endl;
			m_state = m_state & ~GETTING_PREVIEW;
			connect( m_slave, SIGNAL( infoMessage( const QString& ) ),
 						this, SIGNAL( infoMessage( const QString& ) ) );
			m_viewMode = 1;
			emit previewPart( m_partViewer, m_previewURL );
//			emit finishedLoading();
//			m_partViewer->openURL( m_previewURL );
		}
		else {
			kdDebug()<<"KBearDirLister::slotMimeType() get ReadOnly mime="<<mime<<" state="<<m_state<<endl;
			m_viewMode = 0;
			if( m_tempFile ) {
				QFile::remove( m_tempFile->prettyURL() );				
				delete m_tempFile;
			}
			QString file = m_previewURL.fileName();
			m_tempFile = new KURL( locateLocal( "tmp", file ) );
			kdDebug()<<"KBearDirLister::slotMimeType tempfile="<<m_tempFile->prettyURL()<<endl;
			KIO::Job* job  = KIO::file_copy( m_previewURL, *m_tempFile, -1, true, false, false );
			connect( job, SIGNAL( percent( KIO::Job*, unsigned long ) ),
						this, SIGNAL( progress( KIO::Job*, unsigned long ) ) );
			connect( job, SIGNAL( infoMessage( KIO::Job*, const QString& ) ),
						this, SLOT( slotInfoMessage( KIO::Job*, const QString& ) ) );
			connect( job, SIGNAL( result( KIO::Job*) ), this, SLOT( slotResult( KIO::Job* ) ) );
		}
	}
	else {
		static_cast<KIO::SimpleJob*>( job )->slaveDone();
//		connectionManager->putOnHold( (unsigned long)this );
//		KIO::Scheduler::publishSlaveOnHold();
		m_state = m_state & ~GETTING_PREVIEW;
		emit previewPart( 0L, m_previewURL );
		emit finishedLoading();
	}
}
//-----------------------------------------------
void KBearDirLister::slotStatRedirection( KIO::Job*, const KURL& url ) {
	kdDebug()<<"KBearDirLister::slotStatRedirection() url="<<url.prettyURL()<<endl;
	m_statURL = url;
}
//-----------------------------------------------
void KBearDirLister::slotSlaveError( int error , const QString& errStr ) {
	kdDebug()<<"KBearDirLister::slotSlaveError() error="<<error<<" errStr="<<errStr<<endl;
	if( error ) {
		disconnect( m_slave, SIGNAL( error( int, const QString&) ),
					this, SLOT( slotSlaveError( int, const QString& ) ) );
		connectionManager->closeConnection( (unsigned long)this );		
		m_slave  = 0L;
		emit gotError( error );
		if( ! errStr.isEmpty() )
			KMessageBox::error( 0L, KIO::buildErrorString( error, errStr) );
	}
	m_state = DISCONNECTED;
}
//-----------------------------------------------
void KBearDirLister::slotSlaveDied() {
	kdDebug()<<"KBearDirLister::slotSlaveDied()"<<endl;
	m_state = DISCONNECTED;
}
//-----------------------------------------------
void KBearDirLister::slotResult( KIO::Job* job ) {
	kdDebug()<<"KBearDirLister::slotResult() job="<<job<<" error="<<job->error()<<" state="<<m_state<<endl;
	int error = job->error();
	unsigned int oldState = m_state;
	if( (m_state & STATING_LINK) || (m_state & STATING) ) {
		if( ! (m_state & STATING_LINK) )
			m_statLinkURL = m_statURL; // we need to store the original requested URL

		m_state = m_state & ~STATING;
		m_state = m_state & ~STATING_LINK;
		const KIO::UDSEntry entry = m_statJob->statResult();
		m_statJob = 0L;
		if( ! error ) {
			if( entry.isEmpty() ) {
				return;
			}
			KFileItem fileItem( entry, m_statURL );
			if( fileItem.isLink() ) { // if it's a link we don't know if it point to a dir or file
				m_state |= STATING_LINK;
				kdDebug()<<"KBearDirLister::slotResult linkDest="<<fileItem.linkDest()<<endl;
				m_statURL.setPath( fileItem.linkDest() );
				QTimer::singleShot( 0, this, SLOT( statLink() ) );
				return;
			}
			else if( fileItem.isDir() ) {
				if( m_statLinkURL != m_statURL )
					fileItem.setURL( m_statLinkURL );
				emit openDir( &fileItem );
			}
			else if( fileItem.isFile() ) {
				if( m_statLinkURL != m_statURL )
					fileItem.setURL( m_statLinkURL );
				emit openFile( &fileItem );
			}
			m_statURL = KURL();
			m_statLinkURL = KURL();
		}
	}
	else if( m_state & LISTING ) {
		m_state = m_state & ~LISTING;
		m_listJob = 0L;
		emit finishedLoading();
		emit completed( m_url );
	}
	else if( m_state & GETTING_MIME ) {
		kdDebug()<<"KBearDirLister::slotResult GETTING_MIME"<<endl;
		m_state = m_state & ~GETTING_MIME;
		m_state = m_state & ~GETTING_PREVIEW;
		m_mime = "error";
		if( error ) {
			if( m_tempFile ) {
				emit finishedLoading();
				QFile::remove( m_tempFile->prettyURL() );
				delete m_tempFile;
				m_tempFile = 0L;
			}
		}
		else
			slotMimeType( job, m_mime );
	}
	else if( m_state & GETTING_PREVIEW ) {
		m_state = m_state & ~GETTING_PREVIEW;
		if( ! error ) {
			kdDebug()<<"KBearDirLister::slotResult open in preview url="<<m_tempFile->prettyURL()<<endl;
			emit previewPart( m_partViewer, *m_tempFile );
			//m_partViewer->openURL( m_tempFile->prettyURL() );
		}
		else if( m_tempFile ) {
			emit finishedLoading();
			QFile::remove( m_tempFile->prettyURL() );
			delete m_tempFile;
			m_tempFile = 0L;
		}
	}
	else if( m_state & MAKING_DIR ) {
		m_state = m_state & ~MAKING_DIR;
	}
	else if( m_state & DELETING ) {
		m_state = m_state & ~DELETING;
	}
	if( m_slave && ! m_slave->isAlive() ) {
		if( ! (oldState & DELETING && ! m_connection.singleConnection() ) )
			 m_state = DISCONNECTED;
	}
	if( error ) {
		QStringList list = job->detailedErrorStrings();
		KMessageBox::detailedError( 0L, list[1], list[2], list[0] );
	}
}
/*
//-----------------------------------------------
void KBearDirLister::slotPendingList() {
	kdDebug()<<"KBearDirLister::slotPendingList()"<<endl;
	disconnect( m_slave, SIGNAL( connected() ), this, SLOT( slotPendingList() ) );
	listRemoteDir( m_url );
}
//-----------------------------------------------
void KBearDirLister::slotPendingStat() {
	kdDebug()<<"KBearDirLister::slotPendingStat()"<<endl;
	disconnect( m_slave, SIGNAL( connected() ), this, SLOT( slotPendingStat() ) );
	statURL( m_statURL );
}
*/
//-----------------------------------------------
void KBearDirLister::listRemoteDir( const KURL& url ) {
	kdDebug()<<"KBearDirLister::listRemoteDir() url="<<url.prettyURL()<<endl;
	if( ! m_slave || ! m_slave->isAlive() || ! m_slave->isConnected() )
		m_state = DISCONNECTED;

	m_state |= LISTING;

	if( m_state & DISCONNECTED ) {
		openConnection();
	}
	else if( m_state & CONNECTED ) {
//		emit clear();
		emit started();
		emit started( url );
		m_listJob = KBearListJob::listDir( (unsigned long)this, url, false, true );
		connectionManager->attachJob( (unsigned long)this, m_listJob );
		connect( m_listJob, SIGNAL( entries( KIO::Job *, const KIO::UDSEntryList & ) ),
					this, SLOT( slotEntries( KIO::Job *, const KIO::UDSEntryList & ) ) );
		connect( m_listJob, SIGNAL( result( KIO::Job * ) ), this, SLOT( slotResult( KIO::Job * ) ) );
		connect( m_listJob, SIGNAL( redirection( KIO::Job *, const KURL & ) ),
					this, SLOT( slotRedirection( KIO::Job*, const KURL& ) ) );
		connect( m_listJob, SIGNAL( infoMessage( KIO::Job *, const QString& ) ),
					this, SLOT( slotInfoMessage( KIO::Job *, const QString& ) ) );
		connect( m_listJob, SIGNAL( percent( KIO::Job *, unsigned long ) ),
					this, SLOT( slotPercent( KIO::Job *, unsigned long ) ) );
		connect( m_listJob, SIGNAL( speed( KIO::Job *, unsigned long ) ),
					this, SLOT( slotSpeed( KIO::Job *, unsigned long ) ) );
	}
/*
	if( m_listJob ) {
		disconnect( m_listJob, 0, 0, 0 );
		emit finishedLoading();
		QApplication::sendPostedEvents();
		m_listJob = 0L;
	}
	if( ! m_isLocal && ( ! m_slave || ! m_slave->isAlive() || ! m_slave->isConnected() ) ) {
		openConnection();
		connect( m_slave, SIGNAL( connected() ), this, SLOT( slotPendingList() ) );
		return;
	}
	emit clear();
	emit started();
	m_listJob = KBearListJob::listDir( (unsigned long)this, url, false, true );
	connectionManager->attachJob( (unsigned long)this, m_listJob );
	connect( m_listJob, SIGNAL( entries( KIO::Job *, const KIO::UDSEntryList & ) ),
				this, SLOT( slotEntries( KIO::Job *, const KIO::UDSEntryList & ) ) );
	connect( m_listJob, SIGNAL( result( KIO::Job * ) ), this, SLOT( slotResult( KIO::Job * ) ) );
	connect( m_listJob, SIGNAL( redirection( KIO::Job *, const KURL & ) ),
				this, SLOT( slotRedirection( KIO::Job*, const KURL& ) ) );
	connect( m_listJob, SIGNAL( infoMessage( KIO::Job *, const QString& ) ),
				this, SLOT( slotInfoMessage( KIO::Job *, const QString& ) ) );
	connect( m_listJob, SIGNAL( percent( KIO::Job *, unsigned long ) ),
				this, SLOT( slotPercent( KIO::Job *, unsigned long ) ) );
	connect( m_listJob, SIGNAL( speed( KIO::Job *, unsigned long ) ),
				this, SLOT( slotSpeed( KIO::Job *, unsigned long ) ) );
*/
}
//-----------------------------------------------
void KBearDirLister::slotRedirection( KIO::Job* job, const KURL& url ) {
	slotRedirection( static_cast<KBearListJob*>( job )->url(), url );
}
//-----------------------------------------------
void KBearDirLister::slotRedirection( const KURL& oldurl , const KURL& newurl ) {
	kdDebug()<<"KBearDirLister::slotRedirection() oldurl="<<oldurl.prettyURL()<<" newurl="<<newurl.prettyURL()<<endl;
	emit redirection( oldurl, newurl );
	emit redirection( newurl );
	m_url = newurl;
}
//-----------------------------------------------
void KBearDirLister::slotPercent( KIO::Job*, unsigned long pcnt ) {
	emit progress( static_cast<int>(pcnt) );
}
//-----------------------------------------------
void KBearDirLister::slotSpeed( KIO::Job*, unsigned long s ) {
	emit speed( static_cast<int>(s) );
}
//-----------------------------------------------
void KBearDirLister::slotInfoMessage( KIO::Job*, const QString& message ) {
	emit infoMessage( message );
}
//-----------------------------------------------
void KBearDirLister::slotEntries( KIO::Job* job, const KIO::UDSEntryList& entryList ) {
	if( job != m_listJob )
		return;
	static const QString& dot = KGlobal::staticQString(".");
	static const QString& dotdot = KGlobal::staticQString("..");

	KURL url = static_cast<KIO::ListJob*>(job)->url();
	url.adjustPath(-1);
	
	KIO::UDSEntryListConstIterator it = entryList.begin();
	KIO::UDSEntryListConstIterator end = entryList.end();
	KFileItemList fileItems;
	
	for( ; it != end; ++it ) {
		QString name;

		// find out about the name
		KIO::UDSEntry::ConstIterator entit = (*it).begin();
		for( ; entit != (*it).end(); ++entit ) {
			 if( (*entit).m_uds == KIO::UDS_NAME ) {
				name = (*entit).m_str;
				break;
			}
		}
		Q_ASSERT( !name.isEmpty() );
		if( name.isEmpty() )
			continue;
		if( name != dot && name != dotdot ) {
			KFileItem* item = new KFileItem( *it, url, true, true );
			Q_ASSERT( item );
			if( name.left(1) == "." && ! m_showingDotFiles )
				emit deleteItem( item );
			else
				fileItems.append( item );
		}
	}
	slotNewItems( fileItems );
}
//-----------------------------------------------
void KBearDirLister::slotNewItems( const KFileItemList& items ) {
	KFileItemListIterator it( items );
	KFileItemList list;
	QString name;
	for( ; it.current(); ++it ) {
		name = it.current()->text();
		if( ! m_useFilter || matchesNameFilter( name ) )
			list.append( it.current() );
	}
	emit newItems( list );
}
//-----------------------------------------------
bool KBearDirLister::matchesNameFilter( const QString& name ) const {
	for( QPtrListIterator<QRegExp> it( m_filterList ); it.current(); ++it )	{
		if ( it.current()->exactMatch( name )/* != -1*/ )
			return true;
	}

	return false;
}
//-----------------------------------------------
void KBearDirLister::setDirLister() {
	kdDebug()<<"KBearDirLister::setDirLister()"<<endl;
	if( m_dirLister ) // sanity check
		delete m_dirLister;

	m_dirLister = new KDirLister;
	m_dirLister->setAutoUpdate( true );

	connect( m_dirLister, SIGNAL( percent( int ) ), SIGNAL( progress( int ) ) );
	connect( m_dirLister, SIGNAL( started( const KURL& ) ), SIGNAL( started() ) );
	connect( m_dirLister, SIGNAL( newItems( const KFileItemList &) ), this, SLOT( slotNewItems( const KFileItemList &) ) );
	connect( m_dirLister, SIGNAL( completed() ), SIGNAL(finishedLoading() ) );
	connect( m_dirLister, SIGNAL( canceled() ), SIGNAL(finishedLoading() ) );
	connect( m_dirLister, SIGNAL( deleteItem( KFileItem* ) ), SIGNAL( deleteItem( KFileItem* ) ) );
	connect( m_dirLister, SIGNAL( redirection( const KURL&, const KURL& ) ),
				this, SLOT( slotRedirection( const KURL&, const KURL& ) ) );
	connect( m_dirLister, SIGNAL( infoMessage( const QString& ) ), SIGNAL( infoMessage( const QString& ) ) );
	connect( m_dirLister, SIGNAL( clear() ), SIGNAL( clear() ) );
	connect( m_dirLister, SIGNAL( speed(int) ), SIGNAL( speed(int) ) );
	m_state = m_state & ~CONNECTING;
	m_state |= CONNECTED;
	emit connected();	
}
//-----------------------------------------------
void KBearDirLister::slotSlaveKilled( KIO::Slave* slave ) {
	if( slave == m_slave )
		slotSlaveDied();
}
//-----------------------------------------------
#ifndef NO_INCLUDE_MOCFILES
#include "kbeardirlister.moc"
#endif
