/***************************************************************************
                          kbeardirsynchpart.h  -  description
                             -------------------
    begin                : mn okt 14 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARDIRSYNCHPART_H
#define KBEARDIRSYNCHPART_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qwidget.h>
#include <qptrlist.h>
#include <qlabel.h>
#include <qcolor.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klistview.h>
#include <kurl.h>
#include <kpushbutton.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "../../base/kbearpart.h"
#include "dirsynchtreeview.h"
#include "dirsynchtreeviewitem.h"
#include "../../base/connection.h"

class KAction;
class DirSynchTreeBranch;
class KFileTreeView;
class Transfer;

/**
  *@author Bjrn Sahlstrm
  */

class KBearDirSynchPart : public KBearPart  {
	Q_OBJECT
public: 
	/** */
	KBearDirSynchPart( QWidget* parentWidget, const char* widgetName,
						QObject* parent, const char* name, const QStringList& lst=QStringList() );
	/** */
	virtual ~KBearDirSynchPart();
	/** */
	static KAboutData* createAboutData();
	/** */
	virtual void openConnection( const Connection& );
public slots:
	/**  */
	virtual bool openURL( const KURL& url );
protected slots:
	/**  */
	void slotSynchAll();
	/**  */
	void slotSynchFromLocal();
	/**  */
	void slotSynchFromRemote();
	/**  */
	void slotSynchSelectedFromLocal();
	/**  */
	void slotSynchSelectedFromRemote();
protected:
	/** */
	virtual bool openFile() { return true; }
private slots:
	void slotInfoMessage( KIO::Job*, const QString& );
	void slotConfigureDirSynch();
	void slotSynchResult( KIO::Job* job );
	void slotSelectionChanged( QListViewItem* );
	void slotStartLoading();
	void slotFinishedLoading( KFileTreeBranch* branch );
	void slotCollapsed( QListViewItem* );
	void slotExpanded( QListViewItem* );
	void reparseConfiguration();
	bool quizDelete( const KURL::List& urls );
private:
	DirSynchTreeViewItem* findCorrespondingItem( QListViewItem* item ) {
		return findCorrespondingItem( dynamic_cast<DirSynchTreeViewItem*>( item ) );
	}

	DirSynchTreeViewItem* findCorrespondingItem( KFileTreeViewItem* item ) {
		return findCorrespondingItem( dynamic_cast<DirSynchTreeViewItem*>( item ) );
	}

	DirSynchTreeViewItem* findCorrespondingItem( DirSynchTreeViewItem* );

	DirSynchTreeViewItem* findCorrespondingItemAbove( QListViewItem* item ) {
		return findCorrespondingItemAbove( dynamic_cast<DirSynchTreeViewItem*>( item ) );
	}

	DirSynchTreeViewItem* findCorrespondingItemAbove( KFileTreeViewItem* item ) {
		return findCorrespondingItemAbove( dynamic_cast<DirSynchTreeViewItem*>( item ) );
	}

	DirSynchTreeViewItem* findCorrespondingItemAbove( DirSynchTreeViewItem* );

	DirSynchTreeViewItem* findCorrespondingItemBelow( QListViewItem* item ) {
		return findCorrespondingItemBelow( dynamic_cast<DirSynchTreeViewItem*>( item ) );
	}

	DirSynchTreeViewItem* findCorrespondingItemBelow( KFileTreeViewItem* item ) {
		return findCorrespondingItemBelow( dynamic_cast<DirSynchTreeViewItem*>( item ) );
	}

	DirSynchTreeViewItem* findCorrespondingItemBelow( DirSynchTreeViewItem* );

	void openRemoteBranch();
	void openLocalBranch();
	void setActionsEnabled( bool enable );
	void setSelectedActionsEnabled( bool enabled);
	void setDiff( DirSynchTreeViewItem*, DirSynchTreeViewItem* );
	void checkDiff();
	void setupActions();
	void setupWidget();
	void selectChildren( QListView*, QListViewItem* );
	void clearDiff();
private:
	enum DiffType {
		Modified = 0,
		SizePermissions = 1
	};
	enum Action {
		FROM_LOCAL,
		FROM_REMOTE,
		SELECTED_FROM_LOCAL,
		SELECTED_FROM_REMOTE
	};
	enum State{
		COPYING,
		DELETING
	};
	KPushButton* m_synchAllButton;
	KPushButton* m_synchAllFromRemoteButton;
	KPushButton* m_synchAllFromLocalButton;
	KPushButton* m_synchFromRemoteButton;
	KPushButton* m_synchFromLocalButton;
	KPushButton* m_doneButton;
	KFileTreeView* m_localView;
	KFileTreeView* m_remoteView;
	QLabel* m_localDirLbl;
	QLabel* m_remoteDirLbl;
	KAction* m_synchAllAction;
	KAction* m_synchFromLocalAction;
	KAction* m_synchFromRemoteAction;
	KAction* m_synchSelFromLocalAction;
	KAction* m_synchSelFromRemoteAction;
	DirSynchTreeBranch* m_localBranch;
	DirSynchTreeBranch* m_remoteBranch;
	bool m_localBranchFinished;
	bool m_remoteBranchFinished;
	bool m_isWorking;
	KURL::List m_deleteList;
	QPtrList<DirSynchTreeViewItem> m_touchList;
	QString m_selectedTouchPath;
	Transfer* m_copyTransfer;
	QColor m_diffColor;
	QColor m_missingRemoteColor;
	QColor m_missingLocalColor;
	unsigned int m_diffRule;
	unsigned int m_action;
	unsigned int m_state;
	bool m_warnDelete;
	int m_timeDiff;
};

#endif
