/***************************************************************************
                          transferqueue.cpp  -  description
                             -------------------
    begin                : lr feb 9 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "transferqueue.h"

//-----------------------------------------------
TransferQueue::TransferQueue( QObject* parent, const char* name)
	: QObject( parent, name )
{
	setAutoDelete( true );
}
//-----------------------------------------------
TransferQueue::~TransferQueue(){
}
//-----------------------------------------------
void TransferQueue::remove( Transfer* transfer ){
	if( count() == 0 || ! transfer )
		return;
	Transfer* headAtStart = head();
	Transfer* t = 0L;
	bool removed = false;
	do {
		t = QPtrQueue<Transfer>::dequeue();  // call original dequeue to prevent signals to be emitted
		if( t && t != transfer )
			QPtrQueue<Transfer>::enqueue( t ); // call original enqueue to prevent signals to be emitted
		else
			removed = true;
		
	}while( headAtStart != head() && count() > 1 );
	if( removed )
		emit transferRemoved( transfer );
}
//-----------------------------------------------
void TransferQueue::enqueue( Transfer* transfer ){
	QPtrQueue<Transfer>::enqueue( transfer );
	emit transferAdded();
}
//-----------------------------------------------
Transfer* TransferQueue::dequeue(){
	Transfer* t = QPtrQueue<Transfer>::dequeue();
	emit transferRemoved( t );
	return t;
}
//-----------------------------------------------
#ifndef NO_INCLUDE_MOCFILES
#include "transferqueue.moc"
#endif
