/*
 * Copyright 1999-2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.commons.jxpath.xml;

import java.io.InputStream;

import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.commons.jxpath.JXPathException;

/**
 * An implementation of the XMLParser interface that produces a DOM Document.
 *
 * @author Dmitri Plotnikov
 * @version $Revision: 1.6 $ $Date: 2004/02/29 14:17:37 $
 */
public class DOMParser extends XMLParser2 {

    public Object parseXML(InputStream stream) {
        try {
            DocumentBuilderFactory factory =
                    DocumentBuilderFactory.newInstance();
            
            factory.setValidating(isValidating());
            factory.setNamespaceAware(isNamespaceAware());
            factory.setIgnoringElementContentWhitespace(
                    isIgnoringElementContentWhitespace());
            factory.setExpandEntityReferences(isExpandEntityReferences());
            factory.setIgnoringComments(isIgnoringComments());
            factory.setCoalescing(isCoalescing());
            return factory.newDocumentBuilder().parse(stream);
        }
        catch (Exception ex) {
            throw new JXPathException("DOM parser error", ex);
        }
    }
}