#! /usr/bin/env python

import sys, os, shutil, string, md5, struct, time
from pyqt_memaid.ann import *



##############################################################################
#
# Write item.
#
##############################################################################

def write_item(e, category, outfile, offset=0):
    
    id = e.id
    if id == 0:
        digest = md5.new(e.q + e.a + time.ctime()).digest()
        id = struct.unpack('L', digest[0:4])[0]
    
    print >> outfile, "<item id=\""+str(id) + "\"" \
                 + " tm_t_rpt=\""+str(e.tm_t_rpt+offset) + "\"" \
                 + " stm_t_rpt=\""+str(e.stm_t_rpt+offset) + "\"" \
                 + " l_ivl=\""+str(e.l_ivl) + "\"" \
                 + " rl_l_ivl=\""+str(e.rl_l_ivl) + "\""  \
                 + " ivl=\""+str(e.ivl) + "\"" \
                 + " rp=\""+str(e.rp) + "\"" \
                 + " gr=\""+str(e.gr) + "\">"
    print >> outfile, " <cat><![CDATA["+category+"]]></cat>"
    print >> outfile, " <Q><![CDATA["+e.q+"]]></Q>"
    print >> outfile, " <A><![CDATA["+e.a+"]]></A>"
    print >> outfile, "</item>"



##############################################################################
#
# Write category.
#
##############################################################################

def write_category(category, outfile):
    print >> outfile, """<category scheduled="1" drill_badly_known="1">"""
    print >> outfile, " <name><![CDATA["+category+"]]></name>"
    print >> outfile, "</category>"



##############################################################################
#
# Main.
#
##############################################################################

args = sys.argv[1:]

if len(sys.argv) != 4 and len(sys.argv) != 5 :
    print "Usage: python convert.py [-append] <txt file> <category> <xml file>"
    print
    print "E.g. to combine two old databases into one xml file with different",
    print "categories:"
    print
    print "  python convert.py math/elements.txt math items.xml"
    print "  python convert.py -append bio/elements.txt bio items.xml"
    sys.exit(-1)

append = False
if "-append" in args:
    append = True
    args.remove("-append")

path = os.path.dirname(os.path.abspath(args[0]))
category = args[1]
xml_fname = args[2]

if append == False:

    ##########################################################################
    #
    # No append.
    #
    ##########################################################################

    status = ma_init(path)

    DIR_NOT_ACCESSIBLE = 0x08  
    MEMAID_ALREADY_RUNNING = 0x010
    
    if (status & DIR_NOT_ACCESSIBLE) != 0 or \
       (status & MEMAID_ALREADY_RUNNING) != 0:
        print "Error opening file."
        sys.exit(-1)

    outfile = file(xml_fname,'w')
    
    print >> outfile, """<?xml version="1.0"?>"""
    print >> outfile, "<memaid core_version=\"8\" time_of_start=\""\
                      + str(get_tm_strt())+"\">"

    write_category(category, outfile)
    
    e = ma_iterate_list(None)
    while e:
        write_item(e, category, outfile)
        e = ma_iterate_list(e)

    print >> outfile, """</memaid>"""

    ma_deinit()

    outfile.close()

else:

    ##########################################################################
    #
    # Append.
    #
    ##########################################################################
   
    # Get start date in existing xml file and calculate offset.

    xmlfile = file(xml_fname, 'r')
    xmlfile.readline()
    start_date_1 = long(xmlfile.readline().split("\"")[3])
    xmlfile.close()

    status = ma_init(path)

    DIR_NOT_ACCESSIBLE = 0x08  
    MEMAID_ALREADY_RUNNING = 0x010
    
    if (status & DIR_NOT_ACCESSIBLE) != 0 or \
       (status & MEMAID_ALREADY_RUNNING) != 0:
        print "Error opening file."
        sys.exit(-1)
        
    start_date_2 = get_tm_strt()
    offset = long(round((start_date_2 - start_date_1) / 60. / 60. / 24.))

    # Write header.

    tmp_fname = "_elements.tmp"
    tmpfile = file(tmp_fname, 'w')
    print >> tmpfile, """<?xml version="1.0"?>"""

    start_date = start_date_1
    if offset < 0:
        start_date = start_date_2
        
    print >> tmpfile, "<memaid core_version=\"8\" " \
          + "time_of_start=\""+str(start_date)+"\">"    

    # Write new category.

    write_category(category, tmpfile)
    
    # Write old categories and old items.
    
    xmlfile = file(xml_fname, 'r')
    xmlfile.readline()
    xmlfile.readline()

    line = xmlfile.readline()
    while line:

        if offset < 0: # The xml records need to be modified. 
            to_find = "tm_t_rpt=\"" 
            i = string.find(line, to_find)
            if i != -1:
                remainder = string.split(line[i+len(to_find):], "\"")
                new_line = line[:i]+to_find+str(int(remainder[0])-offset)+"\""
                new_line += string.join(remainder[1:], "\"")

                line = new_line

            to_find = "stm_t_rpt=\"" 
            i = string.find(line, to_find)
            if i != -1:
                remainder = string.split(line[i+len(to_find):], "\"")
                new_line = line[:i]+to_find+str(int(remainder[0])-offset)+"\""
                new_line += string.join(remainder[1:], "\"")

                line = new_line

        if string.find(line, "</memaid>") == -1:
            print >> tmpfile, line,
            
        line = xmlfile.readline()
    xmlfile.close()

    # Write new items.

    if offset < 0:
        offset = 0

    e = ma_iterate_list(None)
    while e:
        write_item(e, category, tmpfile, offset)
        e = ma_iterate_list(e)

    # Finalise.

    ma_deinit()
    
    print >> tmpfile, """</memaid>"""
    tmpfile.close()

    shutil.copyfile(tmp_fname,xml_fname)
    os.remove(tmp_fname)
