/*
                                  NETWOX
                             Network toolbox
                Copyright(c) 1999-2005 Laurent Constantin
                                  -----

  Main server    : http://www.laurentconstantin.com/
  Backup servers : http://go.to/laurentconstantin/
                   http://laurentconstantin.est-la.com/
                   http://laurentconstantin.free.fr/
                   http://membres.lycos.fr/lauconstantin/
  [my current email address is on the web servers]

                                  -----
  This file is part of Netwox.

  Netwox is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  version 2 as published by the Free Software Foundation.

  Netwox is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details (http://www.gnu.org/).

------------------------------------------------------------------------
*/

/*-------------------------------------------------------------*/
#include "../netwox.h"

/*-------------------------------------------------------------*/
netwib_err netwox_httpserctx_init(netwox_httpserctx *pctx)
{
  /* those can be changed by users */
  pctx->timeoutms = 60000;
  netwib_er(netwib_buf_init_ext_empty(&pctx->login));
  pctx->login.flags |= NETWIB_BUF_FLAGS_CANALLOC;
  netwib_er(netwib_buf_init_ext_empty(&pctx->realm));
  pctx->realm.flags |= NETWIB_BUF_FLAGS_CANALLOC;
  netwib_er(netwib_buf_init_ext_empty(&pctx->password));
  pctx->password.flags |= NETWIB_BUF_FLAGS_CANALLOC;
  netwib_er(netwib_buf_init_ext_empty(&pctx->rootdir));
  pctx->rootdir.flags |= NETWIB_BUF_FLAGS_CANALLOC;
  netwib_er(netwib_buf_append_text(".", &pctx->rootdir));
  pctx->pallowedclients = NULL;

  /* internally set */
  netwib_er(netwib_bufpool_init(NETWIB_TRUE, &pctx->pbufpool));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_httpserctx_close(netwox_httpserctx *pctx)
{
  netwib_er(netwib_bufpool_close(&pctx->pbufpool));
  netwib_er(netwib_buf_close(&pctx->realm));
  netwib_er(netwib_buf_close(&pctx->login));
  netwib_er(netwib_buf_close(&pctx->password));
  netwib_er(netwib_buf_close(&pctx->rootdir));

  return(NETWIB_ERR_OK);
}
