/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-2000 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    support@pftp.de
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#include "main.h"

#if !defined __RH_CYGLINT__
extern void set_tty(int);
extern void display_pa(char **, char *, char *, int);
extern char *headline;
#else
char *headline;
#endif
char tmpline[LONAME];

#define HELPLINES 102
#define PFM_HELPLINES 38
#define PAGER_HELPLINES 16
#ifdef SO_PRIORITY
#define MAX_OPT_ERRORS 14
#else
#define MAX_OPT_ERRORS 15
#endif


void help()
{
   int j=0;
   char *ctmp=NULL;
   char *helpstr[HELPLINES+1] = {
      " Server: pftp [port] [OPTIONS]                                   \n",
      "                                                                 \n",
      "    -         Remote stdin on client side is written to stdout.  \n",
      "              Files are written to disk.                         \n",
      "    -a        Overwrite all existing files.                      \n",
      "    -ANUM     Accept NUM clients at once (default: 255).         \n",
      "    -b[NUM]   Same as `-' but standard output is buffered.  NUM  \n",
      "              is the size in bytes being read and written at     \n",
      "              once.  The size defaults to 4096 bytes.            \n",
      "    -bb       Same as `-b32768'.                                 \n",
      "    -B[NUM]   Set the net buffer size in bytes to the maximum    \n",
      "              value specified by NUM, or if omitted the value of \n",
      "              the environment variable PFTPNETBUF is taken.      \n",
      "    -BB       Same as `-B65536'.                                 \n",
      "    -c hosts  Accept specified clients only.  Hosts beginning    \n",
      "              with a `.' are supposed to be domain names.        \n",
      "              If hosts are omitted the variable PFTPCLIENTS      \n",
      "              which may hold host and domain names is read.      \n",
      "    -d        Start pftp as a daemon. The number of the filter   \n",
      "              to be used is specified by the client.  The filter \n",
      "              is read from user's pftp resource file.            \n",
      "    -D=DIR    Change to directory DIR before receiving data.     \n",
      "    -f[NUM]   Use filter NUM specified in the variable           \n",
      "              PFTPSFILTER.  NUM defaults to 1.                   \n",
      "    -G        Set optimized values for Gigabit Ethernet links.   \n",
      "    -i        Start pftp from `/etc/inetd.conf'.  The number of  \n",
      "              the filter to be used is specified by the client.  \n",
      "              The filter is read from user's pftp resource file. \n",
      "    -I        Accept and set file and directory information.     \n",
      "    -m[NUM]   Receive multicasted UDP datagrams.  The payload    \n",
      "              length is set to NUM (defaults to 1472).           \n",
#if defined IPV6_ADD_MEMBERSHIP || (defined IP_ADD_MEMBERSHIP && !defined HAVE_INET6)
      "              This binary supports multicasting, your system too?\n",
#else
      "              This binary does *not* support multicasting.       \n",
#endif
      "    -mg GROUP Join multicast group GROUP.                        \n",
      "    -mi IADDR Use interface IADDR for multicasted datagrams.     \n",
      "    -o        TCP: Accept only one connection at a time.         \n",
      "    -p[NUM]   Send all received files to standard output.  NUM is\n",
      "              the size of the output buffer.  If NUM is omitted  \n",
      "              it is unbuffered by default.                       \n",
      "    -pp       Same as `-p32768'.                                 \n",
      "    -q        Run silently--existing files are skipped by default\n",
      "    -R        Automatically rename new files which already exist.\n",
      "    -r        Receive directories recursively.                   \n",
      "    -s        TCP: Skip all existing files.  UDP: Display bytes. \n",
      "    -T        Net performance test (requires `-b' or `-u').      \n",
#if defined HAVE_INET6
      "    -u[NUM]   Use UDP.  NUM is the string size (default: 1024).  \n",
#else
      "    -u[NUM]   Use UDP.  NUM is the string size (default: 1472).  \n",
#endif
      "    -v        Be a little more verbose.                          \n",
      "    -x        Exit after first connection.  Implies `-o'.        \n",
      "                                                                 \n",
      "                                                                 \n",
      " Client: pftp [port] [OPTIONS] [-l|-NUM| hostname] [files]       \n",
      "                                                                 \n",
      "    -         Send stdin unbuffered.  Standard input is          \n",
      "              incompatible with option `-l'.                     \n",
      "    -aN1aN2   Begin sending at the N1th byte of the first file...\n",
      "              See the manual page for further hints.             \n",
      "    -b[NUM]   Same as `-' except that standard input is buffered.\n",
      "              NUM is the size in bytes being read and written at \n",
      "              once.  The size defaults to 4096 bytes.            \n",
      "    -bb       Same as `-b32768'.                                 \n",
      "    -B[NUM]   Set the net buffer size in bytes to the maximum    \n",
      "              value specified by NUM, or if omitted the value of \n",
      "              the environment variable PFTPNETBUF is taken.      \n",
      "    -BB       Same as `-B65536'.                                 \n",
      "    -d[=DIR]  Same as `-i' except that you can choose a port.    \n",
      "    -e        Create a normal password with crypt().             \n",
      "    -f[NUM]   Use filter NUM specified in variable PFTPCFILTER.  \n",
      "              NUM defaults to 1.                                 \n",
      "    -F        Determine and set bandwidth of MPEG AUDIO streams. \n",
      "    -G        Set optimized values for Gigabit Ethernet links.   \n",
      "    -i[=DIR]  Send data to the daemon on port 662.  The files are\n",
      "              uploaded in the directory DIR on the remote host.  \n",
      "    -I        Send last modification time, uid, gid from files   \n",
      "              and diretories, and diretory permission bits.      \n",
      "    -j        Read file and directory names from standard input. \n",
      "    -K        Used by pftp's KDE front end, kpftp.               \n",
      "    -l        Select hostname from list and send the files       \n",
      "              specified on command line.                         \n",
      "    -L        Do not follow symbolic links. Instead send a script\n",
      "              file PFTP_MAKE_LINKS which may create all links.   \n",
      "    -m[NUM]   Send multicasted UDP datagrams.  The payload length\n",
      "              is set to NUM (defaults to 1472).                  \n",
      "    -mi IADDR Use interface IADDR for multicasted datagrams.     \n",
      "    -ml       Multicasted datagrams will be looped back.         \n",
      "    -mtNUM    Time to live (IPv4) resp. hop limit (IPv6).        \n",
#if defined HAVE_INET6
      "              This binary supports IPv4 and IPv6.                \n",
#else
      "              This binary supports IPv4 only.                    \n",
#endif
      "    -M[=FILE] Add message file FILE or if FILE is not given write\n",
      "              the file interactively. Implies `-n'.              \n",
      "    -N        Peek for new data in the upload directory.         \n",
      "    -n        Start the pftp file and directory manager.         \n",
      "    -nn       Send data to a friend and ask for subject.         \n",
      "    -n[=SUBJ] Send data [of subject SUBJ] to a friend.           \n",
      "    -NUM      NUM is the number of the host in your pftp resource\n",
      "              file.  Try `pftp -l' to see the numbers.           \n",
      "    -P[NUM]   Set datagram priority, if supported by your system.\n",
      "    -q        Run silently.                                      \n",
      "    -r        Send directories recursively.                      \n",
      "    -SNUM     UDP: Drop every NUMth datagram.                    \n",
      "    -T[NUM]   Net performance test with NUM bytes to send.       \n",
#if defined HAVE_INET6
      "    -u[NUM]   Use UDP.  NUM is the string size (default: 1024).  \n",
#else
      "    -u[NUM]   Use UDP.  NUM is the string size (default: 1472).  \n",
#endif
      "    -v        Be a little more verbose.                          \n",
      "    -w[NUM]   Set the bandwidth in bytes to NUM, or if omitted to\n",
      "              the value of the environment variable PFTPBANDWID. \n",
      "    -W        Display warranty.                                  \n"
   };
   
   MEM_CHECK((headline = (char *)calloc(SONAME, sizeof(char))));
   sprintf(headline, "*** Port-FTP Version " VERSION " Copyright (C) 1996-2000 Ben Schluricke ***"); 
   for (ctmp=headline; *ctmp; ctmp++);
   for (; ctmp - headline < _WINCOLS_; ctmp++) *ctmp = '*';
   *(ctmp-1) = ' ';
   *ctmp = '\0';
#if !defined __RH_CYGLINT__
   if (isatty(0) && isatty(1)) {
      fprintf(stdout, "[?25l[H[J");
      set_tty(2);
      memset(tmpline, ' ', _WINCOLS_ < LONAME ? _WINCOLS_: LONAME);
      *(tmpline+_WINCOLS_) = '\0';
      display_pa(helpstr, headline, tmpline, HELPLINES);  
      set_tty(0);
      fprintf(stderr, "[?25h\r                                                                       \r");
   }
   else {
#endif
      fprintf(stdout, "\n%s\n\n", headline);
      for (j=0; j <= HELPLINES; j++) fputs(*(helpstr+j), stdout);
#if !defined __RH_CYGLINT__
   }
#endif
   free(headline);
   exit(PFTP_NO_ERR);
}


void opt_err_handle(int opt_err)
{
   char *opt_err_str[MAX_OPT_ERRORS] = {
      "It makes no sense to use `-a', `-c', `-p', `-s', or `-x' with the client",
      "`-l' cannot be used with `-[b[NUM]]' or `-j'.\n** Please, use option `-NUM' instead",
      "`-r' cannot be used in standard input mode with the client",
      "No host name specified for the client",
      "You can either send data from standard input (`-[b[NUM]]')\n** or send files, but not both at once",
      "`-R' is used with the server, or with the client in combination with `-T'",
      "Cannot send UDP datagrams (`-u') to the daemon",
      "You can either overwrite (`-a') or skip (`-s') existing files",
      "Variable `PFTPCLIENTS' is unset or empty",
      "No files given on command line",
      "You can either use `-l' or `-NUM'",
      "`-G' is *not* meant for UDP based connections (`-u')",
      "You cannot use filters (`-f') for UDP based connections (`-u')",
      "You need to specify a destination directory when using `-D'",
#if !defined SO_PRIORITY
      "`-P' is only supported on the Linux Operating System"
#endif
   };
   char *progstr[3] = {
      "man",
      "pftp",
   };
   char c;

   /*
    * Output error message.
    */
   if (opt_err >= MAX_OPT_ERRORS) {
      fprintf(stderr, "** Unknown error!\n");
   }
   else if (opt_err >= 0) fprintf(stderr, "\n** %s!\n\n", *(opt_err_str+opt_err));

#if !defined __RH_CYGLINT__
   if (isatty(0) && isatty(1)) {
      fprintf(stderr, "Quit (q), help list (h), manual page (m)? ");
      set_tty(2);
      c = fgetc(stdin);
      set_tty(0);
      switch(c) {
         case 'h':
            help();
            break;
         case 'm':
            fputc('\n', stderr); 
            execvp(*progstr, progstr);
            fprintf(stderr, "** %s: %s\n", *progstr, _PFTP_ERROR_ARRAY_);
            exit(PFTP_PROG_ERR);
         case 'q':
         default:
            fprintf(stderr, "quit\n");
      }
   }
#endif
   exit(PFTP_MCLOPTION_ERR);
}


#if !defined __RH_CYGLINT__
void mhelp()
{
   char *helpstr[PFM_HELPLINES+1] = {
      "   List of commands for the file and directory manager               \n",
      "                                                                     \n",
      "     <l>, <right>     Enter directory.                               \n",
      "     <h>, <left>      Leave directory.                               \n",
      "     <j>, <down>      Go to the next entry.                          \n",
      "     <k>, <up>        Go to the previous entry.                      \n",
      "     <g>              Go to the first entry.                         \n",
      "     <G>              Go to the last entry.                          \n",
      "     <space>          Go to the next page.                           \n",
      "     <b>              Go to the previous page.                       \n",
      "     <m>              Go back to the main menu.                      \n",
      "     <C-L>            Repaint screen.                                \n",
      "     <return>         Main menu: Display the message file.           \n",
      "                      Submenu: Display the current file.             \n",
      "     <S>              Main menu: Save the current message file.      \n",
      "     <s>              Save the current file/directory recursively or \n",
      "                      if taged files exist select and save.  Within  \n",
      "                      this option the following keys are recognized: \n",
      "                      <tab>       Expand file and directory names    \n",
      "                                  and list directory entries.        \n",
      "                      <return>    Accept current file/directory.     \n",
      "                      <C-G>       Abort selection and do not save.   \n",
      "                      <C-L>       Clear screen.                      \n",
      "                      <key>       Print <key>.                       \n",
      "     <t>              Tag current file/directory recursively.        \n",
      "                      Tagged files/directories can be saved with <s>.\n",
      "     <d>              Mark current file/directory recursively as     \n",
      "                      to be deleted on exit.                         \n",
      "     <n>              Main menu: Mark current entry as new.          \n",
      "     <w>              Display warranty.                              \n",
      "     <?>              Print this help list.                          \n",
      "                                                                     \n",
      "   Meaning of the first three special characters:                    \n",
      "      I               Just incoming data.                            \n",
      "      N               New and unread data since last use of the pfm. \n",                  
      "      O               Unread data already received last time.        \n",
      "      D               File and directories will be deleted on exit.  \n",
      "      M               Remote user sent a message file with the data. \n",
      "      *               While saving tagged data can be saved at once. \n",
   };
   
   memset(tmpline, ' ', _WINCOLS_ < LONAME ? _WINCOLS_: LONAME);
   *(tmpline+_WINCOLS_) = '\0';
   fprintf(stdout, "[H[J");
   display_pa(helpstr, headline, tmpline, PFM_HELPLINES);  
}


void pager_help()
{
   char *helpstr[PAGER_HELPLINES+1] = {
      "   List of commands for the internel pager                                   \n",
      "                                                                     \n",
      "     <j>, <down>      Go to the next line.                           \n",
      "     <k>, <up>        Go to the previous line.                       \n",
      "     <g>              Go to the first line.                          \n",
      "     <G>              Go to the last line.                           \n",
      "     <space>          Go to the next page.                           \n",
      "     <b>              Go to the previous page.                       \n",
      "     <n>              Go to the next pattern match.                  \n",
      "     <N>              Go to the previous pattern match.              \n",
      "     <d>              Scroll down half a screen.                     \n",
      "     <u>              Scroll up half a screen.                       \n",
      "     </>, <s>         Search a pattern within the text.              \n",
      "     <i>              Toggle: Ignore case in searches.               \n",
      "     <?>              Print this help list.                          \n",
      "     <^L>             Refresh the screen.                            \n",
      "     <q>              Exit the pager.                                \n",
   };
   static int used = 0;

   if (!used) used = 1;
   else return;
   
   memset(tmpline, ' ', _WINCOLS_ < LONAME ? _WINCOLS_: LONAME);
   *(tmpline+_WINCOLS_) = '\0';
   fprintf(stdout, "[H[J");
   display_pa(helpstr, headline, tmpline, PAGER_HELPLINES);  
   fprintf(stdout, "[H[J");
   used = 0;
}
#endif

#define WHELPLINES 14

void warranty(void) {
   int j=0;
   char *firstline=NULL, *blankline=NULL, *ctmp=NULL;
   char *warrantystr[WHELPLINES+1] = {
      "Copyright (C) 1996-2000 Ben Schluricke                                 \n",
      "                                                                       \n",
      "This program is free software; you can redistribute it and/or modify   \n",
      "it under the terms of the GNU General Public License as published by   \n",
      "the Free Software Foundation; either version 2 of the License, or (at  \n",
      "your option) any later version.                                        \n",
      "                                                                       \n",
      "This program is distributed in the hope that it will be useful, but    \n",
      "WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-   \n",
      "ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General       \n",
      "Public License for more details.                                       \n",
      "                                                                       \n",
      "You should have received a copy of the GNU General Public License      \n",
      "along with this program; if not, write to the Free Software Foundation,\n",
      "Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                          \n"
   };

   MEM_CHECK((firstline = (char *)calloc(LONAME, sizeof(char))));
   sprintf(firstline, "****** Port-FTP Version " VERSION " Copyright (C) 1996-2000 Ben Schluricke "); 
   for (ctmp=firstline; *ctmp; ctmp++);
   for (; ctmp - firstline < _WINCOLS_; ctmp++) *ctmp = '*';
   *(ctmp-1) = ' ';
   *ctmp = '\0';
#if !defined __RH_CYGLINT__
   if (isatty(0) && isatty(1)) {
      MEM_CHECK((blankline = (char *)calloc(SONAME, sizeof(char))));
      for (ctmp=blankline; ctmp - blankline < _WINCOLS_; ctmp++) *ctmp = ' ';
      *ctmp='\r';
      *++ctmp='\0';
      fprintf(stdout, "[H[J");
      ctmp = headline;
      headline = firstline;
      display_pa(warrantystr, firstline, blankline, WHELPLINES);  
      headline = ctmp;
      free(blankline);
   }
   else {
#endif
      fprintf(stdout, "\n%s\n\n", firstline);
      for (j=0; j <= WHELPLINES; j++) fputs(*(warrantystr+j), stdout);
      fputc('\n', stdout);
#if !defined __RH_CYGLINT__
   }
#endif
   free(firstline);
}
