<?php
/**
 * Copyright 2001 - 2002 by Gero Kohnert
 *
 * @modulegroup ADMIN
 * @module admin_sync
 * @package BASE
 */
 include 'webelements.p3';
 include 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("admin","sync");
 loadlayout();

 /**
  * display a admin sync form
  */
 class admin_sync extends layout {
   /**
    * Make a insert from a result set
    */
   Function result2insert(&$dbconn1,&$dbconn2,$t,&$r,$a) {
     global $current_user;

#   echo $r->numfields()." :".$r->numrows() ."<br>\n";
     $fc = $r->numfields();
     $b = 0;
     $upd  = "UPDATE ". $dbconn2->prefix . $t[name] ;
     $flds = "INSERT into ". $dbconn2->prefix . $t[name] ."";
     $vals = " VALUES ";
     $pre = "(";
     $upre = " SET ";
     while ( $b < $fc ) {
       $fn = strtoupper($r->fieldname($b));

       if ( !isset($t[strtolower($fn)]) ) {
         echo "SKIP ". $t[name].".". $fn ." field on source (not known in [m]table.pinc)<br>";
         $b++;
         continue;
       }
       $fn = strtoupper($r->fieldname($b));
       $ft = strtoupper($r->fieldtype($b));
       $fv = $r->get($a,$fn);
#    echo $b .": |". $fn ."|". $fv ."|". $ft ."|<br>";
     # OLD VERSIONS
       if ( ($t[name] == "products") && ( ($fn == "MANAGER") || ($fn == "SELLER") || ($fn == "MANAGER2") ) ) {
         $b++;
         continue;
       }
       if ( ($t[name] == "people") &&  ($fn == "OVERLIB") ) {
         $b++;
         continue;
       }
       if ( ($t[name] == "files") && ( ($fn == "SIZE")  ) ) {
         $b++;
         continue;
       }
       if ( ($t[name] == "people") && ( ($fn == "ADMIN") && ($fv == '')  ) ) {
         $fv = 0;
       }
       if ( ($fn == "CREATOR") && ($fv == '') ) {
         $fv = -1;
       }
       if ( ($t[name] == "people") &&  ($fn == "PW") ) {
         if ( ($dbconn1->db->crypt == 1) && ($dbconn2->db->crypt != 1) ) {
           # Create a new password
           $fv = "tutos";
           echo "MODIFYING  PASSWORD of ". $r->get($a,"login") ." to tutos<br>\n";
           $modpass = 1;
         } else if ( ($dbconn1->db->crypt != 1) && ($dbconn2->db->crypt == 1) ) {
           # encrypt previously  unencrypted password
         } else if ( ($dbconn1->db->crypt == 1) && ($dbconn1->db->crypt == 1) && ($dbconn1->gettype() == "MySQL") && ($dbconn2->gettype() != "MySQL") ) {
           # Create a new password
           $fv = "tutos";
           echo "MODIFYING  PASSWORD of ". $r->get($a,"login") ." to tutos<br>\n";
         } else if ( ($dbconn1->db->crypt == 1) && ($dbconn1->db->crypt == 1) && ($dbconn1->gettype() != "MySQL") && ($dbconn2->gettype() == "MySQL") ) {
           # Create a new password
           $fv = "tutos";
           echo "MODIFYING  PASSWORD of ". $r->get($a,"login") ." to tutos<br>\n";
         }
       }

       $upd .= $upre . $dbconn2->colname($fn) ." = ";
       if ( ($ft == "VARCHAR") || ($ft == "VARCHAR2") || ($ft == "STRING") || ($ft == "TEXT") || ($ft == "VARYING")) {
         if ( ($f == "people") &&  ($fn == "PW") ) {
           $vals .= $pre. $dbconn2->password($fv);
         } else {
           $vals .= $pre. $dbconn2->String($fv);
         }
         $upd .= $dbconn2->String($fv);
       } else if ( $ft == "BLOB" ) {
         $vals .= $pre. $dbconn2->String($fv);
         $upd .= $dbconn2->String($fv);
       } else if ( ($ft == "TIMESTAMP") || ($ft == "DATETIME") || ( ($ft == "DATE") && ($r->dbconn->getType() == "Oracle")) ) {
         $dt = new DateTime($fv);
         $vals .= $pre. $dbconn2->DateTime($dt);
         $upd .= $dbconn2->DateTime($dt);
       } else if ( $ft == "DATE" ) {
         $dt = new DateTime($fv);
         $vals .= $pre. $dbconn2->Date($dt);
         $upd .= $dbconn2->Date($dt);
       } else if ( $ft == "TIMESTAMPTZ" ) {
         $dt = new DateTime($fv);
         $vals .= $pre. $dbconn2->Date($dt);
         $upd .= $dbconn2->Date($dt);
       } else if ( eregi("^INT",$ft) || ($ft == "REAL") || eregi("^FLOAT",$ft) || ($ft == "LONG") || ($ft == "NUMBER") ) {
         if ( !is_numeric($fv) ) {
           $fv = 'null';
         }
         $vals .= $pre. $fv;
         $upd .= $fv;
       } else {
         echo "<span class=\"warn\">". $dbconn2->colname($fn)." = ". $ft ." === </span> ". $r->get($a,$b);
         echo "<br>". $flds ."......". $vals .".......";
         exit;
       } 
       $flds .= $pre. $dbconn2->colname($fn);
       $pre = ",";
       $upre = ",";
       $b++;
     }
     if ( $pre == "(" ) {
       echo "<span class=\"warn\"> no values  ???</span><br>\n";
       return;
     }
     $flds .= ")";
     $vals .= ")";

     $q[0] = $flds . $vals;
     $q[1] = $upd;

     return $q;
   }
   /* ---------------------------------------------------------------------------
    * Copy a selection of objects
    */
   Function copy_selected(&$dbconn1,&$dbconn2) {
     global $lang,$tutos,$table,$sequence;

     $msg = "";
     echo "changes since last sync (". $dbconn1->db->lastsync->getDateTime() .")<br>\n";
     $q1 = "SELECT obj_id,val_old,m_field from ". $dbconn2->prefix ."history"; 
     if ( $dbconn1->db->lastsync->notime != 1) {
       $q1 .= " WHERE m_time > ". $dbconn2->DateTime($dbconn1->db->lastsync);
     }
     $r1 = $dbconn2->Exec($q1);
     $n1 = $r1->numrows();

     $trans = array();
     $obj = array();
     $table = array();

     $new = 0;
     $del = 0;
     $a = 0;
     while ( $a < $n1) {
       $xid =  $r1->get($a,"obj_id");
       $mf = $r1->get($a,"m_field");

       if ( $mf == "created" ) {
         # ALL NEW Objects in "target" DB  will get a id for the "source" DB
         $x = getObject($dbconn2,$xid,1);
         # GET a new ID on source DB for this object
         $newid = $dbconn1->NextID();

         echo "NEW: ". $xid ." : ". $lang[$x->getType()] ." ". $x->getFullName() ." ---&gt;". $newid ." T:". $x->tablename ."<br>\n";
         $trans[$xid] = $newid;
         $table[$xid] = $x->tablename;
         $obj[$xid] = $x;
         $new++;
       } else if ( $mf == "Delete" ) {
         # DELETED Stuff
         $typ = $r1->get($a,"val_old");
         if ( $xid <  $dbconn1->db->lastid ) {
           echo "DEL: ". $xid ." : ". $typ ."<br>\n";
           $trans[$xid] = -1;
           $table[$xid] = $typ;
           $del++;
           echo "DEL: ". $xid ." : ". $typ ."<br>\n";
         } else {
           echo "DEL (was new): ". $xid ." : ". $typ ."<br>\n";
         }
       } else if ( $mf == "AdminDBSync" ) {
         # Do nothing
       } else if ( ! isset($trans[$xid]) ) {
         $x = getObject($dbconn2,$xid,1);
         $trans[$xid] = $xid;
         $table[$xid] = $x->tablename;
         $obj[$xid] = $x;
         echo "MOD: ". $xid ." : ". $lang[$x->getType()] ." ". $x->getFullName() ." ---&gt;". $mf ."T:". $x->tablename ."<br>\n";
       }

       $a++;
     }   

     foreach ($trans as $i => $f) {
       echo "TR:". $i ."->".$f."<br>\n";
     }

     # transfer the ids
     foreach($obj as $i => $f) {
       echo $i ." ". $obj[$i]->id . "<br>\n";
       if ( method_exists($obj[$i],"transfer_ids") ) {
         $obj[$i]->transfer_ids($trans);
       }
     }   

     echo "New on target: ". $new ."<br>\n";
     echo "Deleted on target: ". $del ."<br>\n";


     # NOW we walk along the trans array
     # and do what have to be done !
     foreach ($trans as $i => $f) {
       # DELETE
       if ( $f == -1 ) {
         echo "SOURCE: Delete ". $i ." : ". $dbconn1->prefix . $table[$i] ."<br>\n";
       } else if ( $f == $i ) {
         echo "SOURCE: Update ". $i ." in table ". $dbconn1->prefix . $table[$i] ."<br>\n";
         $obj[$i]->dbconn = $dbconn1;
         $obj[$i]->save();
         # READ history since last sync
         $obj[$i]->modified = array();
         $obj[$i]->modified[] = array ( "field" => "AdminDBSync" ,
                                        "old" => "" ,
                                        "new" => "",
                                        "obj_id" => $obj[$i]->id
                                       );
         $msg .= history_save($obj[$i]);
       } else {
         echo "SOURCE: Create ". $i ." as ". $f ." in table ". $table[$i] ."<br>\n";
         $obj[$i]->dbconn = $dbconn1;
         $obj[$i]->newid = $f;
         $obj[$i]->id = -2;
         $obj[$i]->save();
         # READ history
         $obj[$i]->modified = array ();
         $obj[$i]->modified[] = array ( "field" => "AdminDBSync" ,
                                        "old" => "" ,
                                        "new" => "",
                                        "obj_id" => $obj[$i]->id
                                      );
         $msg .= history_save($obj[$i]);
       }
     }
     $r1->free();

     foreach ($sequence as $i => $f) {
       # Get the Sequence and save it
       $seq =  $dbconn1->NextID($f[name]);
       echo "<b>Sequence:</b> ". $f[Desc] ." ". $f[name] ." ===> ". $seq ."\n";
       $dbconn2->setSeqID($seq,$f[name]);
     }

     $dbconn1->db->lastsync = new DateTime();
     $dbconn1->db->save();
   }
   /**
    *
    */
   Function copy_all(&$dbconn1,&$dbconn2) {
     global $lang,$tutos,$table,$sequence;

     $dbconn2->Begin("WORK");
     # delete targets
     foreach ($table as $i => $f) {
       $q = "SELECT * from ". $dbconn1->prefix . $f[name];
       $r = $dbconn1->Exec($q);
       $n = $r->numrows();
       $fc = $r->numfields();
       echo "<b>SOURCE:</b> ". $q ." ===> (". $f[Desc] .") ". $n ." Entries <br>\n";
       if ( $fc == 0 ) {
         echo $this->error( $fc ." COLUMNS ???");
         return;
       }
       $dbconn2->truncatetable($f[name]);
       echo "<b>TARGET:</b> ". $q ."<br>\n";

       $a = 0;
       while ( $a < $n ) {
         $q2 = $this->result2insert($dbconn1,$dbconn2,$table[$i],$r,$a);
         $dbconn2->Exec($q2[0]);
#       echo "&nbsp; ". $fc ."&nbsp;". $q2[0] ."<br>\n";
         flush();
         $a++;
       }
       echo " <===<br>\n";
      
       $r->free();
       flush();
     }
     foreach ($sequence as $i => $f) {
       # Get the Sequence and save it
       $seq =  $dbconn1->NextID($f[name]);
       echo "<b>Sequence:</b> ". $f[Desc] ." ". $f[name] ." ===> ". $seq ."<br>\n";
       $dbconn2->setSeqID($seq,$f[name]);
	 }

     # Create a tutos_dbs entry of the source database in the target
     # there we store the info about this action

     # Delete all other databases
     $dbconn2->truncatetable("tutos_dbs");
   
     # The database is that of dbconn1 but it should use dbconn2 for saving
     $dbconn1->db->dbconn = $dbconn2;
     # The sync happens now
     $dbconn1->db->id = -1;
     $dbconn1->db->lastid = $seq1;
     $dbconn1->db->lastsync = new DateTime();
     # copy tablename (we need the correct prefix)
     $dbconn1->db->tablename = $dbconn2->db->tablename;
     $dbconn1->db->save();

     $dbconn2->Commit("WORK");
   }
   /**
    * info 3
    */
   Function info3() {
     global $lang,$tutos;

     $db1 = new database($this->dbconn);
     $db2 = new database($this->dbconn);

     $db1->read($this->from);
     $db2->read($this->to);

     echo "<span class=\"warn\">". $lang['AdminDBSyncM'][$this->what] ."</span><p><p>\n";
     echo "connecting to databases ...<br>\n";

     flush();

     $dbconn1 = $db1->getConnection();
     $dbconn2 = $db2->getConnection();

     if ( $this->what == 1 ) {
       $this->copy_all($dbconn1,$dbconn2);
     } else if ( $this->what == 2 ) {
       $this->copy_selected($dbconn1,$dbconn2);
       $this->copy_all($dbconn1,$dbconn2);
     } else {
       echo "<span class=\"warn\">Action :". $lang['AdminDBSyncM'][$this->what] ." not yet implemented </span>\n";
     }

     echo "disconnecting from databases ...<br>\n";
     flush();
     $dbconn1->Close();
     $dbconn2->Close();
   }
   /**
    * Show infos , test input and ask to continue
    */
   Function info2() {
     global $lang,$tutos;

     $db1 = new database($this->dbconn);
     $db2 = new database($this->dbconn);

     $db1->read($this->from);
     $db2->read($this->to);

     echo "connecting to databases ...<br>\n";
     flush();

     $dbconn2 = $db2->getConnection();
     echo $db2->getFullName()." ...<br>\n";
     flush();
     $dbconn1 = $db1->getConnection();
     echo $db1->getFullName()." ...<br>\n";
     flush();

     $stop = 0;
     echo $this->DataTableStart();
     echo "<tr>\n";
     echo " <th colspan=\"3\">". $lang['AdminDBSync'] ."</th>\n";
     echo "</tr>\n";
     echo "<tr>\n";
     echo " <th>&nbsp;</th>\n";
     echo " <th>". $lang['AdminDBSource'] ."</th>\n";
     echo " <th>". $lang['AdminDBTarget'] ."</th>\n";
     echo "</tr>\n";


     echo "<tr>\n";
     echo " <td>&nbsp;</td>\n";
     echo " <td>". $db1->getLink() ."</td>\n";
     echo " <td>". $db2->getLink() ."</td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['DBLastDate']);
     echo " <td>". $db1->lastsync->getDateTime() ."</td>\n";
     echo " <td>". $db2->lastsync->getDateTime() ."</td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['DBLastID']);
     echo " <td>". $db1->lastid ."</td>\n";
     echo " <td>". $db2->lastid ."</td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['DBCurrID']);
     $seq1 =  $dbconn1->NextID();
     $seq2 =  $dbconn2->NextID();
     echo " <td>". $seq1 ."</td>\n";
     echo " <td>". $seq2 ."</td>\n";
     echo "</tr>\n";
   
     $q1 = "SELECT * from ". $dbconn1->prefix ."history where m_field = ". $dbconn1->String("created");
     if ( $db1->lastsync->notime != 1) {
       $q1 .= " AND m_time > ". $dbconn1->DateTime($db1->lastsync);
     }
     $r1 = $dbconn1->Exec($q1);

     $q2 = "SELECT * from ". $dbconn2->prefix ."history where m_field = ". $dbconn2->String("created");
     if ( $db1->lastsync->notime != 1) {
       $q2 .= " AND m_time > ". $dbconn2->DateTime($db1->lastsync);
     }
     $r2 = $dbconn2->Exec($q2);

     echo "<tr>\n";
     echo $this->showfield("History new");
     echo " <td>". $r1->numrows() ."</td>\n";
     echo " <td>". $r2->numrows() ."</td>\n";
     echo "</tr>\n";

     $q3 = "SELECT * from ". $dbconn1->prefix ."history where m_field = ". $dbconn1->String("Delete");
     if ( $db1->lastsync->notime != 1) {
       $q3 .= " AND m_time > ". $dbconn1->DateTime($db1->lastsync);
     }
     $r3 = $dbconn1->Exec($q3);
  
     $q4 = "SELECT * from ". $dbconn2->prefix ."history where m_field = ". $dbconn2->String("Delete");
     if ( $db1->lastsync->notime != 1) {
       $q4 .= " AND m_time > ". $dbconn2->DateTime($db1->lastsync);
     }
     $r4 = $dbconn2->Exec($q4);

     echo "<tr>\n";
     echo $this->showfield("History del");
     echo " <td>". $r3->numrows() ."</td>\n";
     echo " <td>". $r4->numrows() ."</td>\n";
     echo "</tr>\n";
  
     $r1->free();
     $r2->free();
     $r3->free();
     $r4->free();
     # Does this make sense ?
     if ( ($this->what != 1 ) && ($db1->lastsync->notime) ) {
       echo "<tr>\n";
       echo $this->showfield("&nbsp;");
       echo " <td colspan=\"2\"><span class=\"warn\">You must first sync before update</span></td>\n";
       echo "</tr>\n";
       $stop = 1;
     }
     # Check IDs
     # if the current source ID is below its last sync then a update sync is not possible
     # because it the source was reinstalled or something like this
     if ( ($this->what != 1 ) && ($seq1 < $db1->lastid) ) {
       echo "<tr>\n";
       echo $this->showfield("&nbsp;");
       echo " <td colspan=\"2\"><span class=\"warn\">Source out of sync (". $seq1 ." < ". $db1->lastid .")</span></td>\n";
       echo "</tr>\n";
       $stop = 1;
     }
     # if the current target ID is below its last sync then a update sync is not possible
     # because it the target was reinstalled or something like this
     if ( ($this->what != 1 ) && ($seq2 < $db1->lastid) ) {
       echo "<tr>\n";
       echo $this->showfield("&nbsp;");
       echo " <td colspan=\"2\"><span class=\"warn\">Target out of sync (". $seq2 ." < ". $db1->lastid .")</span></td>\n";
       echo "</tr>\n";
       $stop = 1;
     }


     if ( $stop == 0 ) {
       echo "<tr>\n";
       echo $this->showfield($lang['AdminDBWhat']);
       echo " <td colspan=\"2\"><span class=\"warn\">". $lang['AdminDBSyncM'][$this->what] ."</span></td>\n";
       echo "</tr>\n";

       echo "<tr>\n";
       echo " <th colspan=\"3\">\n";
       echo confirmlink("admin_sync.php?step=3&from=". $this->from ."&to=". $this->to ."&what=". $this->what ,"Are you sure ?","Are you sure");
       echo " </th>\n";
       echo "</tr>\n";
     } else {
       echo "<tr>\n";
       echo " <td colspan=\"3\">\n";
       echo makelink("admin_sync.php?step=1&from=". $this->from ."&to=". $this->to ."&what=". $this->what ,"Go back","Go back");
       echo " </td>\n";
       echo "</tr>\n";
     }
     echo $this->DataTableEnd();

     $dbconn1->Close();
     $dbconn2->Close();
   }
   /**
    * Step 0
    */
   Function info0() {
     global $lang,$tutos,$current_user;

     $dblist = readDB($this->dbconn);
     if ( count($tutos[dbname]) + count($dblist)  <= 1 ) {
       echo $this->error("You have to define more than one database");
     }

     echo "<form name=\"adminsync\" method=\"get\" action=\"admin_sync.php\">\n";
     echo $this->DataTableStart();
     echo "<tr>\n";
     echo " <th colspan=\"3\">". $lang['AdminDBSync'] ." (Step 1)</th>\n";
     echo "</tr>\n";
     echo "<tr>\n";
     echo " <th>". $lang['AdminDBSource'] ."</th>\n";
     echo " <th>". $lang['AdminDBWhat'] ."</th>\n";
     echo " <th>". $lang['AdminDBTarget'] ."</th>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo " <td>\n";
     echo "  <select size=\"". $tutos[maxshow]."\" name=\"from\">\n";
     @reset($dblist);
     while ( list ($i,$f) = @each ($dblist) ) {
       echo "<option value=\"". $i ."\"". ($this->from == $i ? " selected":"") .">". $i .": ". $f->getFullName(). ($i == $this->dbconn->db->id ? "(*)":"") ."</option>\n";
     }
     echo "  </select>\n";
     echo " </td>\n";

     echo " <td>\n";
     echo "  <select size=\"". $tutos[maxshow]."\" name=\"what\">\n";
     @reset($lang['AdminDBSyncM']);
     while ( list ($i,$f) = @each ($lang['AdminDBSyncM']) ) {
       echo "   <option value=\"". $i ."\"". ($this->what == $i ? " selected":"") .">". $lang['AdminDBSyncM'][$i]."</option>\n";
     }
     echo "  </select>\n";
     echo " </td>\n";

     echo " <td valign=\"top\">\n";
     if ( ($this->user->admin != 1) || (count($tutos[dbname]) == 1) ) {
       echo "<br>\n". $current_user->dbconn->db->getLink();
       $this->addHidden("to",$this->dbconn->db->id);
     } else {
       # show local available DBs
       echo "  <select size=\"". $tutos[maxshow]."\" name=\"to\">\n";
       @reset($dblist);
       while ( list ($i,$f) = @each ($dblist) ) {
         if ( $i < 1000 ) {
          echo "<option value=\"". $i ."\"". ($this->to == $i ? " selected":"") .">". $i .": ". $f->getFullName(). ($i == $current_user->dbconn->db->id ? "(*)":"") ."</option>\n";
         }
       }
       echo "  </select>\n";
     }
     echo " </td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     $this->addHidden("step","2");
     echo " <td colspan=\"3\"><input type=\"submit\" value=\"SYNC\" title=\"". $lang['AdminDBSync'] ."\"></td>\n";
     echo "</tr>\n";

     echo "</table>\n";
     hiddenFormElements();
     echo $this->getHidden();
     echo "</form>\n";
   }
   /**
    * info
    */
   Function info() {
     if ( $this->step == 1 ) {
       $this->info0();
     } else if ($this->step == 2) {
       $this->info2();
     } else if ($this->step == 3) {
       $this->info3();
     }
   }
   /**
    * navigate
    */
   Function navigate() {
     global $lang;

     echo "<tr><td>";
     if ( ($this->user->admin == 1) ) {
       echo menulink("database_new.php", $lang['NewEntry'],$lang['DBCreate']) ."<br>\n";
     }
     echo "</td></tr>";
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$tutos,$lang,$table,$tableidx,$sequence;

     # read the table definitions of modules
     foreach ($tutos[modules] as $r => $x) {
       @include(dirname($tutos['base'] ."/". $tutos[modules][$r][file]) ."/mtable.pinc");
     }

     $this->name = $lang['AdminDBSync'];

     if ( ! isset($_GET['step']) ) {
       $this->step = 1;
     } else {
       $this->step = $_GET['step'];
     }
     if ( !isset($_GET['from']) ) {
       $this->from = -1;
       $this->step = 1;
     } else {
       $this->from = $_GET['from'];
     }
     if ( !isset($_GET['to']) ) {
       $this->to = $this->dbconn->db->id;
       $this->step = 1;
     } else {
       $this->to = $_GET['to'];
     }
     if ( !isset($_GET['what']) ) {
       $this->what = 1;
       $this->step = 1;
     } else {
       $this->what = $_GET['what'];
     }
     if ( $this->from == $this->to ) {
       $msg .= "Source and target must be different !";
       $this->step = 1;
     }
     if ( $this->user->admin == 0 ) {
       $msg .= "Only admins are allowed to see this<br>";
       if ( $tutos[demo] == 1 ) {
         $msg .= "<span class=\"warn\">exceptionally enabled for this demo</span><br>\n";
         $this->step = min($this->step,2);
       } else {
         $this->stop = true;
       }
     }

     $x = database::getOverviewLink($this->user);
     $this->addmenu($x);
   }
 }

 # SyncModes
# $lang['AdminDBSyncM'][3] = "copy selected new (since last sync) from target to source, then copy all";
 
 $l = new admin_sync($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: admin_sync.php,v 1.31 2003/02/15 16:59:08 gokohnert Exp $
    $Author: gokohnert $
-->
