<?php
/**
 * Copyright 1999/2000 by Gero Kohnert
 *
 * @modulegroup bug
 * @module bug_show
 * @package bug
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'bug.pinc';
 include_once 'product.pinc';
 include_once 'task.pinc';
 include_once 'timetrack.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("bug","del");

 $gotourl = "bug_overview.php";
 $msg = "";

 $b = new bug($dbconn);

 if ( !isset($_GET['id']) ) {
   $msg .= sprintf($lang['Err0040'],$lang[$b->getType()]);
 } else {
   $b->read($_GET['id']);
   $gotourl = $b->parent->getUrl();
 }
 if ( ! $b->del_ok() ) {
   $msg .= sprintf($lang['Err0023'],$lang[$b->getType()]);
   $gotourl = $b->getUrl();
 }
 if ($msg == "") {
   $dbconn->Begin("WORK");
   $msg .= $b->delete();
   $dbconn->Commit("WORK");
 }
 $gotourl = addUrlParameter($gotourl,"msg=". UrlEncode($msg));
 $gotourl = addSessionKey($gotourl);

 Header("Status: 302 Moved Temporarily");
 Header("Location: ". getBaseUrl() . $gotourl);
 $dbconn->Close();
/*
 *   CVS Info:  $Id: bug_del.php,v 1.18 2002/12/31 14:33:37 gokohnert Exp $
 *   $Author: gokohnert $
 */
?>
