<?php
/**
 * Copyright 1999 - 2002 by Gero Kohnert
 *
 * @modulegroup appointment
 * @module calendar
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 if ( $tutos[tasksincalendar] == 1 ) {
   include_once 'task.pinc';
 }
 include_once 'appointment.pinc';
 include_once 'product.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("appointment","show");
 loadlayout();

 /**
  * display a calendar for some weeks
  */
 class calendar extends layout {
   /**
    * Display One Weeks appointments (including s) starting with Monday or Sunday
    * t format YYYYMMDD
    *
    */
   Function Cal_Week ($t) {
     global $lang, $tutos;

     $ts = mktime(12,0,0,substr($t,4,2),substr($t,6,2),substr($t,0,4));

     /* Back to last weekstart day before ts */
     while ( Date("w",$ts) != $this->user->weekstart ) {
       $ts -= 86400;
     }

     $w0 =  (( 1 + Date("w",mktime(12,0,0,1,1, Date("Y",$ts) ) )) % 7) > 3;
     $wn = sprintf("%02d", Round( (Date("z",$ts)+7 ) / 7) );
     $yy = Date("y",$ts);
     echo " <td class=\"week\" width=\"5%\">". menulink("calendar_week.php?t=".Date("Ymd",$ts)."&amp;team=". $this->team, $wn ."/". $yy, $wn ."/". $yy ) ."</td>\n";

     /* Select appointments for this day */
     $from =  new DateTime();
     $from->setDateTimeTS($ts - 12 * 3600);
     $to = $from;
     $to->addDays(7);

     $this->user->callist = array();
     appointment::readCal($this->user,$from,$to);
     if ( $tutos[tasksincalendar] == 1 ) {
       task::readCal($this->user,$from,$to);
     }
     foreach($tutos[activemodules] as $i => $f) {
       $x = &new $tutos[modules][$f][name]($this->dbconn);
       $x->readCal($this->user,$from,$to);
     }

     $dd = new DateTime();
     $day = 0;
     while ( $day < 7 ) {
       # $d = strftime($lang['DateFormatStr'],$ts);
	   $dd->setDateTimeTS($ts);
       $d = $dd->getDate();
       $tref = Date("Ymd",$ts);
       $next = NextDay($ts);
       # Check for workday
       if ( ! $dd->isWorkDay($this->user) ) {
         $ts = $next;
         $day++;
         continue;
       }
       $dinfo = GetDaysInfo($ts);

       echo "<td class=\"". $dinfo[color] ."\" width=\"10%\">\n";

       if ( isset($dinfo[Desc]) ) {
         if ( $this->user->feature_ok(usecalendar,PERM_NEW) ) {
           echo " " . makelink("app_new.php?t=". $tref,$d,$lang['NewAppointInfo'],$dinfo[popinfo]) ."\n";
         } else {
           echo " " . $d ."\n";
         }
         echo "<br><span class=\"dinfo\">". $dinfo[Desc] ."</span>\n";
       } else {
         if ( $this->user->feature_ok(usecalendar,PERM_NEW) ) {
           echo " " . makelink("app_new.php?t=". $tref,$d,$lang['NewAppointInfo']) ."\n";
	     } else {
           echo " " . $d ."\n";
         }
       }
       $hastable = 0;
       $a = 0;

       $x = count( $this->user->callist );
       for ( $idx = 0 ; $idx < $x ; $idx++) {
         /* the correct day */
         if ( ! $this->user->callist[$idx]->inside($dd) ) {
           continue;
         }
         if (!cal_check_against_list($this->user->callist[$idx],$this->uids)) {
           continue;
         }

         if ( $hastable == 0 ) {
           echo "\n <table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\">\n";
           $hastable = 1;
         } else {
           echo "  <tr><td class=\"". $dinfo[color] ."\" colspan=\"3\"><img src=\"". $tutos['base'] ."/html/black.png\" width=\"100%\" height=\"1\" alt=\"--------\"></td></tr>\n";
         }
         $this->user->callist[$idx]->formatted();
         $a++;
       }

       if ( $hastable == 1 ) {
         echo "</table>\n";
       }
       while ( $a < 2 ) {
         echo " <br>\n";
         $a++;
       }

       echo "</td>\n";

       /* Next Day */
       $day++;
       $ts = $next;
     }

     return(Date("Ymd",$ts));
   }
   /**
    * the data display part
    */
   Function info() {
     global $tutos , $lang;

     $cols = 1;

     $weeks = $this->user->get_prefweeks();
	 for ( $i = 0;$i<=6;$i++ ) {
       if ($this->user->isWorkDay($i)) {
         $cols++;
	   }
	 }

     $ts = mktime(0,0,0,substr($this->t,4,2),substr($this->t,6,2),substr($this->t,0,4));
     $last_week = Date("Ymd",$ts -  7 * 86400);
     $next_week = Date("Ymd",$ts +  7 * 86400);
     $last_month = Date("Ymd",$ts -  28 * 86400);
     $next_month = Date("Ymd",$ts +  28 * 86400);

     # Display for current time
	 $this->addHidden("t",$this->t);
     if ( $this->id > 0 ) {
       $this->addHidden("id",$this->id);
     }

     echo "<form action=\"calendar.php\" method=\"GET\">\n";
     echo "<table class=\"single\" cellpadding=\"3\" cellspacing=\"0\" width=\"100%\" border=\"0\">\n";
     echo "<tr>\n";
     echo " <th class=\"navigate\" align=\"left\" colspan=\"3\" rowspan=\"2\" nowrap>\n";
     echo "&nbsp;". $lang['forphrase'] ."\n";
     cal_options($this->team,$this->teamname);
     echo " </th>\n";

     echo "  <td nowrap class=\"navigate\" colspan=\"".( $cols - 3) ."\" align=\"center\">\n";
     echo menulink("calendar.php?t=". $last_week,$this->theme->getImage(left,'list').$lang['lastweek'],$lang['lastweek']);
     echo "&nbsp;&nbsp;&nbsp;";
     echo menulink("calendar.php?t=". $this->t ,$lang['reload']);
     echo "&nbsp;&nbsp;&nbsp;";
     echo menulink("calendar.php?t=". $next_week,$lang['nextweek'].$this->theme->getImage(right,'list'),$lang['nextweek']);
     echo "</td>\n";
     echo " </tr>\n";

     echo " <tr>\n";
     echo "  <td nowrap class=\"navigate\" colspan=\"". ( $cols - 3)."\" align=\"center\">\n";
     echo menulink("calendar.php?t=". $last_month,$this->theme->getImage(left,'list').$this->theme->getImage(left,'list').$lang['minus4weeks'],$lang['minus4weeks']);
     echo "&nbsp;&nbsp;&nbsp;";
     if ( $this->user->feature_ok(usecalendar,PERM_NEW) ) {
       echo menulink("app_new.php?t=".$this->t,$lang['NewAppoint'],$lang['NewAppointInfo']);
     } else {
       echo "&nbsp;";
     }
     echo "&nbsp;&nbsp;&nbsp;";
     echo menulink("calendar.php?t=". $next_month,$lang['plus4weeks'].$this->theme->getImage(right,'list').$this->theme->getImage(right,'list'),$lang['plus4weeks']);
     echo "  </td>\n";
     echo " </tr>\n";

     echo " <tr>\n";
     echo "  <th>". $lang['week'] ."</th>\n";
     if ( $this->user->weekstart == 0 ) {
       if ($this->user->isWorkDay(0)) {
         echo "  <th>". $lang['Day0'] ."</th>\n";
       }
     }
	 for ( $i = 1;$i<=6;$i++ ) {
       if ($this->user->isWorkDay($i)) {
         echo "  <th>". $lang['Day'.$i] ."</th>\n";
       }
	 }
     if ( $this->user->weekstart != 0 ) {
       if ($this->user->isWorkDay(0)) {
         echo "  <th>". $lang['Day0'] ."</th>\n";
       }
     }

     $t2 = $this->t;
     for ($i = 0; $i < $weeks; $i++) {
       echo " </tr><tr>\n";
       $t2 = $this->cal_Week($t2);
     }

     echo " </tr>\n";
     echo "</table>\n";
     hiddenFormElements();
	 echo $this->getHidden();
     echo "</form>\n";
   }
   /**
    *
    */
   Function navigate() {
   }
   /**
    *
    */
   Function prepare() {
     global $lang;

     $this->name = $lang['Calendar'];
     $this->teamname = "";
     $this->t = Date("Ymd");
     $this->id = -1;

     if ( isset($_GET['t']) ) {
       $this->t = $_GET['t'];
     }
     /* Show a calendar containing Appointment id */
     if ( isset($_GET['id']) ) {
       $this->id = $_GET['id'];
       $query = "SELECT id,a_start FROM ". $this->dbconn->prefix ."calendar where id =". $this->id;
       check_dbacl( $query, $this->user->id);
       $result = $this->dbconn->Exec($query);
       if ( 1 != $result->numrows()) {
         echo $this->error ( sprintf($lang['Err0040'],$lang['Appointment']) );
         $this->id = -1;
       } else {
         $d = $result->getDateTime(0, "a_start");
         $this->t = $d->getYYYYMMDD();
       }
       $result->free();
     }

     $this->uids = cal_parse_options($this->user,$this->teamname);
     $this->team = $this->user->get_prefteam();

     # menu
     $m = appointment::getSelectLink($this->user);
	 $m[category][] = "obj";
     $this->addmenu($m);
     $m = appointment::getAddLink($this->user,$this->user);
     $this->addMenu($m);
   }
 }

 $l = new calendar($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: calendar.php,v 1.71.2.1 2003/07/14 19:23:26 gokohnert Exp $
    $Author: gokohnert $
-->
