<?php
/* Display a PNG Gantt.
 * This file needs to just do that, cause the content-type will be set to
 * image/png.
 *
 * This fonctionnality needs the JpGraph tool, a PHP4 Chart librairie,
 * released under the GPL.
 *
 * $Author: gokohnert $
 *
 * $Id: gantt_png.php,v 1.21 2003/02/28 16:25:30 gokohnert Exp $
 */

include_once 'webelements.p3';
include_once 'permission.p3';
include_once 'task.pinc';
include_once 'product.pinc';
include_once 'timetrack.pinc';
include_once 'bug.pinc';

/* Check if user is allowed to use it */
check_user();
session_write_close();

function get_bar(&$task, $n, $depth) {
  global $font;

  $name  = $task->name;
  $start = $task->s_start->getYYYYMMDD();
  $end   = $task->s_end->getYYYYMMDD();
  $vol   = $task->volume_done;
  $comp  = $task->getcompletion();

  for ($i = 1; $i < $depth; $i++) {
    $name = "  ".$name;
  }
  $bar = new GanttBar($n, $name, $start, $end,
              sprintf("[%.0f %%]", $comp), 0.5);

  if ( $comp > 100.0 ) {
    $comp = 100.0;
    # TODO  make it red or so
    # http://www.aditus.nu/jpgraph/manual/ref/

    $bar->SetColor("red");
    #$bar->SetFillColor("white");
    $bar->SetPattern(BAND_RDIAG, "red");
    #$bar->progress->SetPattern(BAND_RDIAG, "red"); 
  }
  /* Outline first level tasks */
  $bar->title->SetFont($font, FS_NORMAL, 8); 
  if( $depth == 1 ) {
    $bar->title->SetFont($font, FS_BOLD, 8);
  }
  $bar->progress->Set($comp/100.0);
  return $bar;
}

/* Recursive adding of project tasks */
function addTasks(&$parent, &$graph, &$count, $depth) {
  if ( $parent->getType() == "task" ) {
    $graph->Add(get_bar($parent, $count++, $depth));
  }

  $parent->readTasks();
  @reset($parent->tasklist);
  while( list($i, $f) = @each($parent->tasklist) ) {
    $graph = addTasks($f, $graph, $count, $depth+1);
  }
  return $graph;
}

Function draw_gantt(&$parent) {
  global $lang , $font, $tutos;

  task_calc($parent);

  // Standard calls to create a new graph
  $graph = new GanttGraph();
  //$graph->SetShadow();
  $graph->SetBox();
  // Titles for chart
  $graph->title->Set($lang['TaskGantt']." ". $lang['forphrase'] ." " .
             html_entity_decode($parent->getFullName()) );

  $graph->title->SetFont($font,FS_BOLD,12);

  // For illustration we enable all headers. 
  $graph->ShowHeaders(GANTT_HMONTH | GANTT_HDAY | GANTT_HWEEK);

  $graph->scale->week->SetStyle(WEEKSTYLE_FIRSTDAY);
  $graph->scale->month->SetStyle(MONTHSTYLE_LONGNAMEYEAR4);

  /* TODO: we could use locale */
  // $graph->scale->SetDateLocale("fr_FR");

  // Change the scale font 
  $graph->scale->week->SetFont(FF_FONT0);
  $graph->scale->year->SetFont(FF_ARIAL,FS_BOLD,12);

  $count = 0;
  $graph = addTasks($parent, $graph, $count, 0);

  // Add a vertical line for the current day
  $vline = new GanttVLine(strftime("%Y-%m-%d", time()));
  $vline->SetDayOffset(0.5);
  $graph->Add($vline);

  $graph->Stroke();
}
# we try both places
if (file_exists (getcwd()."/".$tutos['base']."/php/". $tutos[jpgraph]."/jpgraph.php") ) {
  include $tutos[jpgraph]."/jpgraph.php";
  include $tutos[jpgraph]."/jpgraph_gantt.php";
} else {
  include $tutos[jpgraph]."/src/jpgraph.php";
  include $tutos[jpgraph]."/src/jpgraph_gantt.php";
}
#
# If we use a non western laguage encoding force the use of truetype fonts
#
if ($lang['content_encoding'] != "iso-8859-1") {
  $font = FF_ARIAL;
} else {
  $font = FF_FONT1;
}

if ( isset($_GET['id']) ) {
  $obj = GetObject($dbconn,$_GET['id']);
  $stop = 0;
} else {
  $msg = $lang['Err0048'];
  $stop = 1;
  $obj = $id;
}
if ($stop == 0) {
  draw_gantt($obj);
} else {
  echo $msg;
}

$dbconn->Close();

?>
