<?php
/*
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 *   CVS Info:  $Id: graph_bars.php,v 1.23 2003/03/01 23:04:26 gokohnert Exp $
 *   $Author: gokohnert $
 *
 */


 include "webelements.p3";
 include "permission.p3";

 check_user();
 session_write_close();
 $dbconn->Close();

 function basic (&$f,&$t0,&$t1) {
   Header("Expires: 0");
   Header("Pragma: no-cache");
   Header("content-type: image/png");

   @reset($f);
   $x2 = count($f) * 110;

   if ( $x2 == 0 ) {
     $x2 = 10;
   }
   if ( count($t1) > 0 ) {
     $png = ImageCreate( $x2 , 142);
   } else {
     $png = ImageCreate( $x2 , 130);
   }
   $c['black'] = ImageColorAllocate($png,0,0,0);
   $c['white'] = ImageColorAllocate($png,255,255,255);
   $c['def']   = ImageColorAllocate($png,125,125,125);
   # red
   $c[1] = ImageColorAllocate($png,255,0,0);
   # green
   $c[2] = ImageColorAllocate($png,0,255,0);
   # blue
   $c[3] = ImageColorAllocate($png,0,0,255);
   # yellow
   $c[4] = ImageColorAllocate($png,255,255,0);

   ImageFill($png,0,0,$c['white']);
   ImageLine($png,5,115,$x2 - 5,115,$c['black']);
   ImageDashedLine($png,5,65,$x2 - 5,65,$c['black']);
   ImageLine($png,5,15,$x2 - 5,15,$c['black']);

   @reset($f);
   $x = 0;
   $col = 1;
   while ( list ($i,$val) = @each ($f) ) {
     if ( $col > 4 ) {
       $col = 1;
     }
     if ( $c[$col] == "" ) {
       $cc = $c['def'];
     } else {
       $cc = $c[$col];
     }
     $col++;

     # Shadow
     ImageFilledRectangle($png,$x + 13 ,112 - $val ,$x + 103,112,$c['black']);
     ImageFilledRectangle($png,$x + 12 ,113 - $val ,$x + 102,113,$c['black']);
     ImageFilledRectangle($png,$x + 11 ,114 - $val ,$x + 101,114,$c['black']);
     # Bar
     ImageFilledRectangle($png,$x + 10 ,115 - $val ,$x + 100,115,$cc);

     # Label
     if ( isset($t0[$i]) ) {
       ImageString($png, 3 ,$x + 10,117,$t0[$i] ,$c['black']);
     } else {
       ImageString($png, 3 ,$x + 10,117,$i ,$c['black']);
     }
     # Addtional Text
     if ( isset($t1[$i]) ) {
       ImageString($png, 3 ,$x + 10,127,$t1[$i],$c['black']);
     }
     # Value
     if ( $val > 90 ) {
       ImageString($png, 3 ,$x + 13,115 - $val,$val ."%",$c['white']);
     } else {
       ImageString($png, 3 ,$x + 13,98 - $val,$val ."%",$c['black']);
     }
     $x += 110;
   }

   // send the image
   ImagePNG($png);
   ImageDestroy($png);
 }

 function pie (&$f,&$t0,&$t1) {
   global $font;

   $r = array();
   $i = 0;
   while(isset($t0[$i])) {
     $r[$i] = $t0[$i] ." (". $t1[$i] .")";
     $i++;
   }
   $graph = new PieGraph(400,200);
   $graph->img->SetAntiAliasing();
   $graph->legend->Pos(0.02,0.02);
   $graph->legend->SetFont($font,FS_NORMAL,8);
   if (isset($_GET['title'])) {
     $graph->title->Set($_GET['title']);
     $graph->title->SetFont($font,FS_BOLD,12);
     $graph->legend->Pos(0.02,0.12);
   }
   $p1 = new PiePlot($f);
   $p1->value->SetFont($font,FS_NORMAL,8);
   $p1->SetSize(0.35);
   $p1->SetCenter(0.30,0.5);
   $p1->SetLegends($r);
   $graph->Add($p1);
   $graph->Stroke();
 }

 function bar (&$f,&$t0,&$t1) {
   global $font;

   $graph = new Graph(600,300);
   $graph->img->SetAntiAliasing();
   $graph->img->SetMargin(90,40,30,100);
   $graph->SetScale("textlin");

   $graph->xaxis->SetTickLabels($t0);
   $graph->xaxis->SetLabelAngle(90);
   $graph->xaxis->SetFont($font,FS_NORMAL,8);

   if (isset($_GET['title'])) {
     $graph->title->Set($_GET['title']);
     $graph->title->SetFont($font,FS_BOLD,12);
   }
   if (isset($_GET['ytitle'])) {
     $graph->yaxis->title->SetFont($font,FS_BOLD);
     $graph->yaxis->SetTitleMargin(65);
     $graph->yaxis->title->Set($_GET['ytitle']);
   }
   $p1 = new BarPlot($f);
   $p1->value->Show(true);
   $p1->SetColor("orange");
   $p1->SetFillColor("orange");

   $graph->Add($p1);

   $graph->Stroke();
 }



 #
 $f = $_GET['f'];
 $t0 = $_GET['t0'];
 if ( isset ($_GET['t1']) ) {
   $t1 = $_GET['t1'];
 } else {
   $t1 = array();
 }

 if ( ! file_exists (getcwd()."/".$tutos['base'] ."/php/". $tutos[jpgraph]."/jpgraph.php") 
     && file_exists (getcwd()."/".$tutos['base'] ."/php/". $tutos[jpgraph]."/src/jpgraph.php") ) {
   $tutos[jpgraph] .= "/src";
 }

 if (isset($_GET['type'])) {
   require_once $tutos[jpgraph]."/jpgraph.php";
   require_once $tutos[jpgraph]."/jpgraph_pie.php";
   require_once $tutos[jpgraph]."/jpgraph_pie3d.php";
   require_once $tutos[jpgraph]."/jpgraph_bar.php";
   #
   # If we use a non western laguage encoding force the use of truetype fonts
   #
   if ($lang['content_encoding'] != "iso-8859-1") {
     $font = FF_ARIAL;
   } else {
     $font = FF_FONT1;
   }
   if ( $_GET['type'] == "pie" ) {
     pie($f,$t0,$t1);
   } elseif ( $_GET['type'] == "bar" ) {
     bar($f,$t0,$t1);
   }
 } else {
   basic($f,$t0,$t1);
 }
?>
