<?php
/*
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * Help System
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("help","show");
 loadlayout();


 /**
  * display
  */
 class tutos_help extends layout {
   /**
    *
    */
   Function load_lang_file($dir,$p) {
     global $tutos,$lang;

     # try direct with language preset
     if ( isset($_GET['lg']) ) {
       echo "<!-- try: ". $dir."/".$p ."_". $_GET['lg'] .".html -->\n";
       if ( file_exists(getcwd()."/".$dir ."/". $p ."_". $_GET['lg'] .".html") ) {
         include $dir."/".$p ."_". $_GET['lg'] .".html";
         return true;
       }
     }
     # try direct with language of current_user
     if ( isset($current_user->lang) && ($current_user->lang != "auto") ) {
       echo "<!-- try: ".  $dir."/".$p ."_". $current_user->lang .".html -->\n";
       if ( file_exists(getcwd()."/".$dir ."/". $p ."_". $current_user->lang .".html") ) {
         include $dir."/".$p ."_". $current_user->lang .".html";
         return true;
       }
     }

     # next try with preferred language of browser
	 $langs = "";
	 if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
       $langs = $_SERVER['HTTP_ACCEPT_LANGUAGE'];
	 }
     $tok = trim(strtok($langs,","));
     while($tok) {
       if ( strpos($tok,";") > 0) {
         $tok = substr($tok,0,strpos($tok,";"));
       }
       $tok = strtolower($tok);
       echo "<!--  try: ".  $dir."/".$p ."_". $tok .".html -->\n";
       if ( file_exists(getcwd()."/".$dir ."/". $p ."_". $tok .".html") ) {
         include $dir."/".$p ."_". $tok .".html";
         return true;
       }
       $tok = trim(strtok(","));
     }

     # try direct
     echo "<!-- try: ". $dir."/".$p .".html -->\n";
     if ( file_exists(getcwd()."/".$dir ."/". $p .".html") ) {
       include $dir."/".$p .".html";
       return true;
     }

     return false;
   }
   /**
    * the data display part
    */
   Function info() {
     global $tutos;

     if ( $this->load_lang_file(".",$this->p) ) {
     } else 
     if ( $this->load_lang_file($tutos['base'] ."/html/help",$this->p) ) {
     } else 
     if ( $this->load_lang_file($tutos['base'] ."/html/help","index") ) {
     } else {
       echo "File ". $this->p ." not found";
     }
   }
   /**
    *
    */
   Function navigate() {
     global $lang, $tutos;

     echo "<tr><td nowrap>";
     echo menulink("help.php?p=index","Index","Index") ."<br>";
     echo menulink("help.php?p=glossary","Glossar","Glossar") ."<br>";
     if ( file_exists(getcwd()."/".$tutos['base'] ."/documentation/book0/user.html") ) {
       echo menulink($tutos['base'] ."/documentation/book0/user.html","Users Guide","Users Guide") ."<br>";
     }
     if ( $this->user->isAdmin()) {
       if ( file_exists(getcwd()."/".$tutos['base'] ."/documentation/book0/admin.html") ) {
         echo menulink($tutos['base'] ."/documentation/book0/admin.html","Admin Guide","Admin Guide") ."<br>";
       }
     }
     echo "</td></tr>";
   }
   /**
    *
    */
   Function prepare() {
     global $tutos,$lang;

     $this->name = $lang['Help'];
     if ( ! isset($_GET['p']) ) {
       $this->p = "index";
     } else {
       $this->p = $_GET['p'];
     }
     foreach ($tutos[modules] as $r => $x) {
       loadmodule($r);
     }

   }
 }

 $l = new tutos_help($current_user);
 $l->display();
 @$dbconn->Close();
?>
<!--
    CVS Info:  $Id: help.php,v 1.15.2.1 2003/04/08 17:34:10 gokohnert Exp $
    $Author: gokohnert $
-->
