<?php
/*
 * Copyright 1999 - 2002 by Gero Kohnert
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'appointment.pinc';
 include_once 'product.pinc';
 include_once 'task.pinc';
 include_once 'timetrack.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('product','overview');
 loadlayout();

 /**
  * show a overview of user-resources and appointmens
  */
 class res_cal extends layout {
   /**
    * display the info
    */
   Function info() {
     global $tutos, $lang;

     echo $this->start->getLinkDateTime() ." - ". $this->end->getLinkDateTime();

     $month = Date("m/Y",$this->start->ts);
     $m = Date("m",$this->start->ts);
     $y = Date("Y",$this->start->ts);
     $cols = Date("j",$this->end->ts);

     echo $this->OverviewTableStart();
     echo "<tr>\n";
     echo " <th rowspan=\"2\">". $lang['AdrName'] ."</th>\n";
     echo " <th colspan=\"". $cols ."\">";

     $last = "res_cal.php?id=". $this->base->id ;
     $t = MkTime(0,0,0,($m -1),Date("d",$this->start->ts),$y);
     $last = addUrlParameter($last,"start=". Date("Ymd",$t));

     $next = "res_cal.php?id=". $this->base->id;
     $t = MkTime(0,0,0,($m +1),Date("d",$this->start->ts),$y);
     $next = addUrlParameter($next,"start=". Date("Ymd",$t));


     echo  makelink($last,$this->theme->getImage(left,'list'),$lang['ResCal']);
     echo  "&nbsp;". sprintf($lang['ResCalDetail'],menulink($this->base->getUrl(),$this->base->getFullName()),$month) ."&nbsp;";
     echo  makelink($next,$this->theme->getImage(right,'list'),$lang['ResCal']);
     echo " </th>\n";
     echo "</tr>\n";
     echo "<tr>\n";
     for ($i = 1; $i <= $cols; $i++) {
       $t = MkTime(0,0,0,$m,$i,$y);
       $dinfo = GetDaysInfo($t);
       echo " <td class=\"". $dinfo[color] ."\">". sprintf("%02d",$i) ."</td>\n";
     }
     echo "</tr>\n";

     $q2 = "SELECT * from ". $this->dbconn->prefix ."calendar ";
     $q2 = $q2 ." WHERE repeat = 0 ";
     $q2 = $q2 ."  AND  ( (a_start < " . $this->dbconn->Date($this->end) ." AND a_start   >= " . $this->dbconn->Date($this->start) .") ";
     $q2 = $q2 ."    OR   (a_end < " . $this->dbconn->Date($this->end) ." AND a_end   >= " . $this->dbconn->Date($this->start) .") ";
     $q2 = $q2 ."    OR   (a_start < " . $this->dbconn->Date($this->start) ." AND a_end   >= " . $this->dbconn->Date($this->end) .") ";
     $q2 = $q2 ." )";
     $q2 = $q2 ." ORDER by a_start";

     $result2 = $this->dbconn->Exec($q2);
     $n2 = $result2->numrows();

     $a = 0;
     $applist = array();
     while ( $a < $n2 ) {
       $app = new appointment($this->dbconn);
       $app->read_result($result2,$a);
       if ( ! $app->see_ok() ) {
         $a++;
         continue;
       }
       $app->read_participants();

       $applist[$app->id] = &$app;
       unset($app);
       $a++;
     }
     $result2->free();

     @reset($this->uids);
     $line = 0;
     while ( list ($i,$f) = @each ($this->uids) ) {
       $line++;
       $maxr = 0;
       $q1 = "SELECT t.* from ". $this->dbconn->prefix ."tasks t,". $this->dbconn->prefix ."taskworker w";
       $q1 = $q1 ." WHERE ( t.id = w.t_id) and (w.w_id =  ". $f->id ." or w.w_id = ". $this->base->id .")";
       $q1 = $q1 ."   AND ( (s_start < " . $this->dbconn->Date($this->end) ." AND s_start   >= " . $this->dbconn->Date($this->start) .") ";
       $q1 = $q1 ."    OR   (s_end < " . $this->dbconn->Date($this->end) ." AND s_end   >= " . $this->dbconn->Date($this->start) .") ";
       $q1 = $q1 ."    OR   (s_start < " . $this->dbconn->Date($this->start) ." AND s_end   >= " . $this->dbconn->Date($this->end) .") ";
       $q1 = $q1 ." )";
       $q1 = $q1 ." ORDER by s_start";

       $result1 = $this->dbconn->Exec($q1);
       $n1 = $result1->numrows();

       echo "<!-- $n1 $n2 -->\n";

       # Reset Fields  / Field index is day in month
       for ($r = 0; $r < ($n1 + $n2) ; $r++) {
         for ($d = 1; $d <= $cols; $d++) {
           $xarr[$d][$r] = -1;
         }
       }

       # Fill Fields
       # Task Entries
       $a = 0;
       while ( $a < $n1 ) {
         $task = new task($this->dbconn);
         $task->read_result($result1,$a);

         if ( ! $task->see_ok() ) {
           $a++;
           continue;
         }
       # Mark all fields covered by this task
         $m1 = Date("m/Y",$task->s_start->ts);
         $d1 = Date("j",$task->s_start->ts);
         $m2 = Date("m/Y",$task->s_end->ts);
         $d2 = Date("j",$task->s_end->ts);
         if ( $m1 != $month ) {
           $d1 = 1;
         }
         if ( $m2 != $month ) {
           $d2 = $cols;
         }
         for ($d = $d1; $d <= $d2; $d++) {
           $r = 0;
           while ($xarr[$d][$r] > 0) {
             $r++;
           }
           $xarr[$d][$r] = $task->id;
           $obj[$task->id] = &$task;
           $maxr = Max($maxr,$r);
         }

         $a++;
         unset($task);
       }
       $result1->free();

       echo "<!-- $n1 $n2 $maxr -->\n";

       # Calendar Entries
       @reset($applist);
       while ( list ($i,$app) = @each ($applist) ) {
         @reset($app->participant);
         $found = 0;
         while ( list ($i2,$f2) = @each ($app->participant) ) {
           if ( $i2 == $f->id ) {
             $found++;
             break;
           }
           if ( $i2 == $this->base->id ) {
             $found++;
             break;
           }
         }
         if ( $found == 0 ) {
           $a++;
           continue;
         }
         # Mark all fields covered by this task
         $m1 = Date("m/Y",$app->start->ts);
         $d1 = Date("j",$app->start->ts);
         $m2 = Date("m/Y",$app->end->ts);
         $d2 = Date("j",$app->end->ts);
         if ( $m1 != $month ) {
           $d1 = 1;
         }
         if ( $m2 != $month ) {
           $d2 = $cols;
         }
         for ($d = $d1; $d <= $d2; $d++) {
           $r = 0;
           while ($xarr[$d][$r] > 0) {
             $r++;
           }
           $xarr[$d][$r] = $i;
           $obj[$app->id] = &$applist[$i];
           $maxr = Max($maxr,$r);
         }
       }

       echo $this->OverviewRowStart($line);

       if ( ($n1 + $n2) > 0 ) {
         echo "  <td rowspan=\"". ($maxr +1) ."\">". $f->getLink($f->getShortname()) ."</td>\n";
       } else {
         echo "  <td>". $f->getLink($f->getShortname()) ."</td>\n";
         echo "  <td colspan=\"". $cols ."\">&nbsp;</td>\n";
       }
       echo "<!-- $n1 $n2 $maxr -->\n";

       for ($r = 0; $r < ($n1 + $n2); $r++) {
         if ( $r > $maxr ) {
           continue;
         }

         if ( $r > 0 ) {
           echo $this->OverviewRowStart($line);
         }
         $day = 1;
         $old = $xarr[$day][$r];
         $colspan = 0;

         while ( $day <= $cols ) {
           if ( $xarr[$day][$r] != $old ) {
             echo "  <td colspan=\"".$colspan ."\"";
             if ( $old < 0 ) {
               echo ">&nbsp;";
             } else {
               if ( $obj[$old]->getType() == "task" ) {
                 echo " class=\"task". $obj[$old]->state ."\">".$obj[$old]->getLink() ." (". $obj[$old]->volume ." ". $lang['hours'] .")" ;
               } else {
                 if ( $obj[$old]->descr == "" ) {
                   $obj[$old]->descr = $lang['AppLoc'][$obj[$old]->outside];
                 }
                 if ( $obj[$old]->mod_allow == 3 ) {
                   echo " class=\"privapp\">".$obj[$old]->getLink($obj[$old]->descr) ;
                 } else {
                   echo " class=\"app\">".$obj[$old]->getLink($obj[$old]->descr) ;
                 }
               }
             }
             echo "</td>\n";
             $old = $xarr[$day][$r];
             $colspan = 1;
           } else {
             $colspan++;
           }
           $day++;
         }
         if ( $old < 0 ) {
           echo "  <td colspan=\"". $colspan ."\">&nbsp;</td>\n";
         } else {
           echo "  <td colspan=\"".$colspan ."\"";
           if ( $old < 0 ) {
             echo ">&nbsp;";
           } else {
             if ( $obj[$old]->getType() == "task" ) {
               echo " class=\"task". $obj[$old]->state ."\">".$obj[$old]->getLink() ." (". $obj[$old]->volume ." ". $lang['hours'] .")";
             } else {
               if ( $obj[$old]->mod_allow == 3 ) {
                 echo " class=\"privapp\">".$obj[$old]->getLink($obj[$old]->descr) ;
               } else {
                 echo " class=\"app\">".$obj[$old]->getLink($obj[$old]->descr) ;
               }
             }
           }
           echo "</td>\n";
         }
         echo $this->OverviewRowEnd($line);
       }
     }
     echo $this->OverviewTableEnd();
   }
   /**
    * naviagte
    */
   Function navigate() {
     global $lang;

     echo "<tr><td>";

     $link = addUrlParameter($this->link,"format=paper");
     echo menulink($link,$lang['Printable'],$lang['PrintableInfo']);

     echo "</td></tr>";
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['ResCal'];
     $this->link = "res_cal.php";
     $this->uids = array();
     if ( isset($_GET['id']) ) {
       $this->link = addUrlParameter($this->link,"id=".$_GET['id']);
       if ($_GET['id'] == 0 ) {
         $this->base = new team($this->dbconn);
         $this->base->read(0);
       } else {
         $this->base = GetObject($this->dbconn,$_GET['id']);
       }
       if ( $this->base->gettype() == "team" ) {
         $this->base->read_member();
         @reset($this->base->member);
         while ( list ($i,$f) = @each ($this->base->member) ) {
           $this->uids[$i] = $f;
         }
       } else if ( $this->base->gettype() == "address" ) {
         $this->uids[$this->base->id] = $this->base;
       }
     } else {
       $this->base = $this->user;
       $this->uids[$this->base->id] = $this->base;
     }
     if ( isset($_GET['start']) ) {
       $this->start = new DateTime($_GET['start']);
     } else {
       $t = MkTime(0,0,0,Date("m"),1,Date("Y"));
       $this->start = new DateTime();
       $this->start->setDateTimeTS($t);
     }
     if ( isset($_GET['end']) ) {
       $this->end = new DateTime($_GET['end']);
     } else {
       $t = $this->start->getTimeStamp();
       $x = Date("m",$t);
       while ( $x == Date("m",$t) ) {
         $t += 86400;
       }
       $t = MkTime(0,0,0,Date("m",$t),Date("d",$t),Date("Y",$t));
       $t -= 1;
       $this->end = new DateTime();
       $this->end->setDateTimeTS($t);
     }
     $this->link = addUrlParameter($this->link,"start=".Date("Ymd",$this->start->ts));
     $this->link = addUrlParameter($this->link,"end=".Date("Ymd",$this->end->ts));

   }
 }

 $l = new res_cal($current_user);
 $l->display();
 $dbconn->Close();

?>
<!--
    CVS Info:  $Id: res_cal.php,v 1.28.2.1 2003/08/02 14:39:11 gokohnert Exp $
    $Author: gokohnert $
-->
