<?php
/**
 * Copyright 1999 - 2002 by Gero Kohnert
 *
 * @modulegroup task
 * @module task_gantt
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'task.pinc';
 include_once 'product.pinc';
 include_once 'timetrack.pinc';
 include_once 'bug.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("task","show");
 loadlayout();

 /**
  * display 
  */
 class task_gantt extends layout {
   /**
    * the data display part
    */
   Function info() {
     global $lang;

     echo $this->DataTableStart();
     echo "<tr><td><img src=\"". addsessionkey("gantt_png.php?id=".$this->obj->id) ."\"></td></tr>";
     echo $this->DataTableEnd();
   }
   /**
    * navigate
    */
   Function navigate() {
     global $lang;

     echo "<tr><td>";
     echo menulink("task_overview.php?id=". $this->obj->id, $lang['TaskOverview']);
     echo "<br>\n";

     if( $this->obj != -1 ) {
       echo "<br>\n";
       echo $lang[$this->obj->getType()]." ".menulink($this->obj->getURL(), $this->obj->getFullName());
       echo "<br>\n";
     }
     echo "</td></tr>";
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['TaskGantt'];
     if ( isset($_GET['id']) ) {
       $this->obj = GetObject($this->dbconn,$_GET['id']);
     } else {
       $msg .= $lang['Err0048'];
       $this->stop = true;
       $this->obj = $this->user;
     }
   }
 }

 $l = new task_gantt($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
 CVS Info: $Id: task_gantt.php,v 1.13 2002/12/31 14:33:39 gokohnert Exp $
 $Author: gokohnert $
 -->
