<?php
/**
 * Copyright 2003 by Gero Kohnert
 *
 * create a new product or modify an existing one
 *
 * @modulegroup url
 * @module url_select
 * @package url
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('team','select');
 loadlayout();

 /**
  * search for a team
  */
 class team_select extends layout {
   /**
    * display the info
    */
   Function info() {
     global $lang,$tutos;

     echo "<br><br><center>\n";

     echo "<form name=\"teamsearch\" method=\"get\" action=\"team_overview.php\">\n";
     DoubleTableStart();

     echo "<tr>\n";
     echo " <th colspan=\"3\">". $lang['SearchForTeam'] ."</th>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['TeamName']);
     echo " <td align=\"center\">&nbsp;<input type=\"text\" value=\"\" name=\"name\"></td>\n";
     echo " <td align=\"center\">\n";
     echo " <input type=\"submit\" value=\"". $lang['Search'] ."\"></td>\n";
     echo "</tr>\n";

     DoubleTableEnd();
     hiddenFormElements();
     echo $this->getHidden();
     echo "</form>\n";
     echo "</center>\n";
     echo $this->setfocus("teamsearch.name");
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['TeamSearch'];
     if ( $this->user->feature_ok(useteams,PERM_NEW) ) {
       $x = array( url => "team_new.php",
                   text => $lang['NewEntry'],
                   info => $lang['TeamCreateI'],
                   category => array("team","new","obj")
                 );
       $this->addMenu($x);
     }
   }
 }

 $l = new team_select($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: team_select.php,v 1.1.2.1 2003/07/31 17:56:14 gokohnert Exp $
    $Author: gokohnert $
-->
