from base64 import encodestring, decodestring
from urllib import quote, unquote
from OFS.SimpleItem import Item
from OFS.PropertyManager import PropertyManager
from AccessControl.User import domainSpecMatch
from string import split,lower
import Globals, Acquisition
from Products.PlugIns import PlugIn
from Globals import HTMLFile, MessageDialog


class LoginMethod(PlugIn):

    """A way of getting credentials from a request - default
    implementation is basic auth"""

    def findLogin(self, manager, request, auth, user=None, roles=None):
        # parse request/auth, retrieve user from manager,
        # and authenticate user, returning user (or None if failed)
        pass
      
    def credentialsChanged(self, manager, user, name, credentials):
        # if using cookies or other schemes which require action
        # when a user changes their password, etc., this method
        # can be implemented to receive notice of the change.
        pass  

    def logoutCurrentUser(self, manager, name):
        # Do whatever is necessary to log out the current
        # user; clear cookie or whatever
        pass

    def _loggedIn(self,request):
        if not request.has_key('LOGIN_METHODS'):
            lm=[]
            request.set('LOGIN_METHODS',lm)
        else:
            lm=request['LOGIN_METHODS']
        lm.append(self.id)


    # Class Metadata
    
    __plugin_kind__ = 'Login Method'
  
    icon = 'misc_/LoginManager/loginmethod'
  



































manage_addRemoteUserLoginForm = HTMLFile('addRemoteUserLogin', globals())

def manage_addRemoteUserLogin(
    self, id='REMOTE_USER Login', title='', REQUEST=None):
  
    """Add a REMOTE_USER login method"""
    ob = RemoteUserLogin(id, title)
    return self.Destination()._installPlugIn(ob, "REMOTE_USER Login Method added.", REQUEST)
		

class RemoteUserLogin(LoginMethod, PropertyManager):
    """Use REMOTE_USER environment variable to authenticate user.
    If user has login domains set, then they must also match."""
    
    def findLogin(self, manager, request, auth, user=None, roles=None):
        if user: return user
        if not request.has_key('REMOTE_USER'): return None
        user = manager.getItem(request['REMOTE_USER'])
        if user is not None:
            # Check domains, instead of using user.authenticate()
            domains = user.getDomains()
            if not domains or domainSpecMatch(domains, request):
                self._loggedIn(request)
                return user

    # Class Metadata
    
    meta_type='REMOTE_USER Login Method'
    
    manage_options = (
        {'label':'Properties',	  'action':'manage_propertiesForm'},
    )









manage_addBasicAuthLoginForm = HTMLFile('addBasicAuthLogin', globals())

def manage_addBasicAuthLogin(
    self, id='Basic Auth Login', title='', REQUEST=None):
  
    """Add a Basic Auth Loginmethod"""
    ob = BasicAuth(id,title)
    return self.Destination()._installPlugIn(ob, "Basic Auth Login Method added.", REQUEST)
		

class BasicAuth(LoginMethod, PropertyManager):

    """Basic Authorization provider"""
    
    def findLogin(self, manager, request, auth, user=None, roles=None):
        if user: return user
        if not auth or lower(auth[:6]) != 'basic ': return None

        try:
            [name, password] = split(decodestring(split(auth)[-1]),
                ':',1)
        except: return None
        
        user = manager.getItem(name)

        if user is not None and user.authenticate(password,request):
            self._loggedIn(request)
            return user
            
        return None

    def logoutCurrentUser(self, manager, name):
        self.REQUEST.RESPONSE.setStatus('Unauthorized','User Logged Out')

    # Class Metadata

    meta_type='HTTP_AUTHORIZATION/Basic Login Method'
    manage_options = (
        {'label':'Properties',      'action':'manage_propertiesForm'},
    )

manage_addBasicCookieLoginForm = HTMLFile('addBasicCookieLogin', globals())

def manage_addBasicCookieLogin(
    self, id='Basic Cookie Login', title='', REQUEST=None):
  
    """Add a Basic Cookie login method"""
    ob = BasicCookieLogin(id,title)
    return self.Destination()._installPlugIn(ob,"Basic Cookie Login Method added.",REQUEST)


class BasicCookieLogin(BasicAuth):

    """__ac-style cookie logins using basic auth string as cookie"""

    manage_main = manage_propertiesForm = HTMLFile('www/BasicCookieProps', globals())

    def manage_properties(self, title='',
        CookieName='__ac', CookiePath='/', CookieDomain='', SecureCookie=0,
        LoginField='__ac_name', PasswordField='__ac_password',
        REQUEST=None):
        """Change Properties"""
        self.CookieName, self.CookiePath = CookieName, CookiePath
        self.CookieDomain, self.SecureCookie = CookieDomain, SecureCookie
        self.LoginField, self.PasswordField = LoginField, PasswordField
        if REQUEST is not None:
            return self.manage_main(self, REQUEST, update_menu=1)
      
    def clearCookie(self, request):
        d = { 'path' : self.CookiePath }
        if self.CookieDomain:
            d['domain'] = self.CookieDomain
        if self.SecureCookie:
            d['secure'] = 1

        expireCookie = request['RESPONSE'].expireCookie
        apply(expireCookie, (self.CookieName,), d)

    def setCookie(self, request, name, password):
        token = encodestring('%s:%s' % (name, password))
        d = { 'path' : self.CookiePath }
        if self.CookieDomain:
            d['domain'] = self.CookieDomain
        if self.SecureCookie:
            d['secure'] = 1
        
        setCookie = request['RESPONSE'].setCookie
        apply(setCookie, (self.CookieName, quote(token)), d)


    def credentialsChanged(self, manager, user, name, credentials):
        # update cookie automatically if user changes password
        if self.REQUEST.AUTHENTICATED_USER.getUserName()==name:
            self.setCookie(self.REQUEST, name, credentials)

    def logoutCurrentUser(self, manager, name):
        self.clearCookie(self.REQUEST)

    def findLogin(self, manager, request, auth, user=None, roles=None):    
        if user: return user
        cookies = getattr(request,'cookies',None)
        if cookies is None: return
        cname = self.CookieName
        cookie = cookies.get(cname,None)
        if cookie is not None:
            user = BasicAuth.findLogin.im_func(
                self, manager, request, 'basic '+unquote(cookie)
            )                
            if user is not None:
                try:
                    del cookies[cname]
                    del request.other[cname]
                except: pass
        else:
            get     = request.get
            name     = get(self.LoginField)
            password = get(self.PasswordField)
            if name is None or password is None: return
            
            user = manager.getItem(name)
            
            if user is not None:
                if user.authenticate(password,request):
                    self.setCookie(request, name, password)
                    self._loggedIn(request)
                    del request.form[self.LoginField]
                    del request.form[self.PasswordField]
                    try:
                        del request.other[self.LoginField]
                        del request.other[self.PasswordField]
                    except: pass
                else:
                    user = None
                
        #if user is None:
        #    self.clearCookie(request)

        return user

    # Class Metadata
    
    meta_type='HTTP_COOKIE/Basic Auth Login Method'

    CookieName = '__ac'
    CookiePath = '/'
    CookieDomain = ''
    SecureCookie = 0

    LoginField = '__ac_name'
    PasswordField = '__ac_password'

    manage_options = (
        {'label':'Properties',      'action':'manage_propertiesForm'},
    )
