#################################################################################
#                                                                               #
#                       copyright (c) 2003 Ingeniweb SARL                       #
#                                                                               #
#################################################################################

"""PloneArticleTool main class"""

from string import find
from Products.CMFCore.utils import UniqueObject, _getAuthenticatedUser, _checkPermission
from Products.CMFCore.utils import getToolByName, _dtmldir
from OFS.Folder import Folder
from Globals import InitializeClass, DTMLFile, MessageDialog, ImageFile, \
     PersistentMapping
from Acquisition import aq_base
from AccessControl.User import nobody
from AccessControl import ClassSecurityInfo
from Products.CMFCore.CMFCorePermissions import *
from Products.CMFCore.ActionProviderBase import ActionProviderBase

from global_symbols import *

import sys

def addPloneArticleTool(self,REQUEST={}):
    """
    Factory method for the PloneArticle Tool
    """
    id='portal_article'
    pat=PloneArticleTool()
    self._setObject(id, pat, set_owner=0)
    getattr(self, id)._post_init()
    if REQUEST:
        return REQUEST.RESPONSE.redirect(self.absolute_url() + '/manage_main')

class PloneArticleTool(UniqueObject, Folder, ActionProviderBase):
    """
    PloneArticleTool tool
    """

    id = 'portal_article'
    meta_type = 'PloneArticle Tool'
    _actions = []
    security = ClassSecurityInfo()

    manage_options=(
        ({
        'label': 'Content',
        'action': 'manage_main',
        },
         { 'label' : 'Overview'
           , 'action' : 'manage_overview'
           },) +
        ActionProviderBase.manage_options +
        Folder.manage_options
        )

    #
    #   ZMI methods
    #
    #security.declareProtected(ManagePortal, 'manage_overview' )
    #manage_overview = DTMLFile('dtml/PlonePopollTool_overview', globals())

    def __init__(self):
        # Properties to be edited by site manager
        self.safeEditProperty(self, 'max_attachment_size', 0, data_type='int')
        self.safeEditProperty(self, 'max_image_size', 0, data_type='int')
        self.safeEditProperty(self, 'preview_activated', 1, data_type='boolean')
        self.safeEditProperty(self, 'site_text_formats', 'getAvailableTextFormats', data_type='multiple selection')
        self.safeEditProperty(self, 'site_models', 'getAvailableModels', data_type='multiple selection')
        self.safeEditProperty(self, 'lock_support', 0, data_type='boolean')
        self._updateProperty('site_text_formats', ['html',])

    def _post_init(self):
        """
        _post_init(self) => called from manage_add method, acquired within ZODB (__init__ is not)
        """
        self._updateProperty('site_models', self.getAvailableModels())

    def hasLockSupport(self,):
        """
        Return the lock support availability
        """
        return getattr(self, "lock_support", 0)

    def getMaxAttachmentSize(self):
        """ Return the max size of attachments"""
        try:
            max_attachment_size=self.max_attachment_size
        except:
            max_attachment_size=0
        return max_attachment_size

    def setMaxAttachmentSize(self, max_attachment_size):
        """ Set the max size of attachments"""
        if max_attachment_size>0:
            self.max_attachment_size=int(max_attachment_size)
        else:
            self.max_attachment_size=0

    def getMaxImageSize(self):
        """ Return the max size of images"""
        try:
            max_image_size=self.max_image_size
        except:
            max_image_size=0
        return max_image_size

    def setMaxImageSize(self, max_image_size):
        """ Set the max size of images"""
        self.max_image_size = max_image_size

    def isPreviewActivated(self):
        """ Returns 1 of preview is set, otherwise 0"""
        try:
            preview_activated=self.preview_activated
        except:
            preview_activated=1
        return preview_activated

    def activatePreview(self):
        """ Sets the preview """
        self.preview_activated=1

    def desactivatePreview(self):
        """ Sets the preview """
        self.preview_activated=0

    def getAvailableTextFormats(self):
        """ get the availeble text formats """
        return ['html', 'plain', 'structured-text']

    def getSiteTextFormats(self):
        """ return the text formats for this site """
        try:
            site_text_formats=self.site_text_formats
        except:
            site_text_formats = ['html',]
        return site_text_formats

    def setSiteTextFormats(self, site_text_formats):
        """ set the site text formats"""
        checked_text_formats=[]
        available_text_formats=self.getAvailableTextFormats()
        for text_format in site_text_formats:
            if text_format in available_text_formats:
                checked_text_formats.append(text_format)
            else:
                raise ValueError
        self.safeEditProperty(self, 'site_text_formats', checked_text_formats, data_type='lines')

    # Copied from CMFPlone/migrations/migration_util.py
    def safeEditProperty(self, obj, key, value, data_type='string'):
        """ An add or edit function, surprisingly useful :) """
        if obj.hasProperty(key):
            obj._updateProperty(key, value)
        else:
            obj._setProperty(key, value, data_type)

    def checkImageSize(self, image):
        image_size = len(image.read()) / 1024
        max_image_size = self.getMaxImageSize()
        if not max_image_size or image_size<=max_image_size:
            return 1
        else:
            return 0

    def checkAttachmentSize(self, attachment):
        attachment_size = len(attachment.read()) / 1024
        max_attachment_size = self.getMaxAttachmentSize()
        if not max_attachment_size or attachment_size<=max_attachment_size:
            return 1
        else:
            return 0

    def getAvailableModels(self,):
        """
        getAvailableModels(self,) => list of strings

        Search portal_skins for all page templates that can be used as a model
        """
        # Plone1 Vs. Plone2 criterias
        search_term = '"PloneArticleModel"'
        if self._isPlone2():
            search_term = '"Plone2ArticleModel"'

        # Find the templates
        portal_skins = getToolByName(self, "portal_skins")
        templates = portal_skins.ZopeFind(portal_skins,
                                          obj_searchterm = search_term,
                                          search_sub = 1,)

        # Reduce & return the list
        models = {}
        for (path, obj) in templates:
            models[obj.getId()]=1

        return models.keys()

    def getSiteModels(self):
        """ return the text formats for this site """
        models=list(self.site_models)
        models.sort()
        return models

    def setSiteModels(self, site_models):
        """ set the site models"""
        checked_models=[]
        available_models=self.getAvailableModels()
        for model in site_models:
            if model in available_models:
                checked_models.append(model)
            else:
                raise ValueError
        self.safeEditProperty(self, 'site_models', checked_models, data_type='lines')

    security.declarePrivate('_isPlone2')
    def _isPlone2(self,):
        portal_url = getToolByName(self, 'portal_url')
        if 'portal_form_controller' in portal_url.getPortalObject().objectIds():
            return 1
        return 0

InitializeClass(PloneArticleTool)
