/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.31
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace OSGeo.OGR {

using System;
using System.Runtime.InteropServices;

class OgrPINVOKE {

  protected class SWIGExceptionHelper {

    public delegate void ExceptionDelegate(string message);
    public delegate void ExceptionArgumentDelegate(string message, string paramName);

    static ExceptionDelegate applicationDelegate = new ExceptionDelegate(SetPendingApplicationException);
    static ExceptionDelegate arithmeticDelegate = new ExceptionDelegate(SetPendingArithmeticException);
    static ExceptionDelegate divideByZeroDelegate = new ExceptionDelegate(SetPendingDivideByZeroException);
    static ExceptionDelegate indexOutOfRangeDelegate = new ExceptionDelegate(SetPendingIndexOutOfRangeException);
    static ExceptionDelegate invalidCastDelegate = new ExceptionDelegate(SetPendingInvalidCastException);
    static ExceptionDelegate invalidOperationDelegate = new ExceptionDelegate(SetPendingInvalidOperationException);
    static ExceptionDelegate ioDelegate = new ExceptionDelegate(SetPendingIOException);
    static ExceptionDelegate nullReferenceDelegate = new ExceptionDelegate(SetPendingNullReferenceException);
    static ExceptionDelegate outOfMemoryDelegate = new ExceptionDelegate(SetPendingOutOfMemoryException);
    static ExceptionDelegate overflowDelegate = new ExceptionDelegate(SetPendingOverflowException);
    static ExceptionDelegate systemDelegate = new ExceptionDelegate(SetPendingSystemException);

    static ExceptionArgumentDelegate argumentDelegate = new ExceptionArgumentDelegate(SetPendingArgumentException);
    static ExceptionArgumentDelegate argumentNullDelegate = new ExceptionArgumentDelegate(SetPendingArgumentNullException);
    static ExceptionArgumentDelegate argumentOutOfRangeDelegate = new ExceptionArgumentDelegate(SetPendingArgumentOutOfRangeException);

    [DllImport("ogr_wrap", EntryPoint="SWIGRegisterExceptionCallbacks_Ogr")]
    public static extern void SWIGRegisterExceptionCallbacks_Ogr(
                                ExceptionDelegate applicationDelegate,
                                ExceptionDelegate arithmeticDelegate,
                                ExceptionDelegate divideByZeroDelegate, 
                                ExceptionDelegate indexOutOfRangeDelegate, 
                                ExceptionDelegate invalidCastDelegate,
                                ExceptionDelegate invalidOperationDelegate,
                                ExceptionDelegate ioDelegate,
                                ExceptionDelegate nullReferenceDelegate,
                                ExceptionDelegate outOfMemoryDelegate, 
                                ExceptionDelegate overflowDelegate, 
                                ExceptionDelegate systemExceptionDelegate);

    [DllImport("ogr_wrap", EntryPoint="SWIGRegisterExceptionArgumentCallbacks_Ogr")]
    public static extern void SWIGRegisterExceptionCallbacksArgument_Ogr(
                                ExceptionArgumentDelegate argumentDelegate,
                                ExceptionArgumentDelegate argumentNullDelegate,
                                ExceptionArgumentDelegate argumentOutOfRangeDelegate);

    static void SetPendingApplicationException(string message) {
      SWIGPendingException.Set(new System.ApplicationException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingArithmeticException(string message) {
      SWIGPendingException.Set(new System.ArithmeticException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingDivideByZeroException(string message) {
      SWIGPendingException.Set(new System.DivideByZeroException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingIndexOutOfRangeException(string message) {
      SWIGPendingException.Set(new System.IndexOutOfRangeException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingInvalidCastException(string message) {
      SWIGPendingException.Set(new System.InvalidCastException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingInvalidOperationException(string message) {
      SWIGPendingException.Set(new System.InvalidOperationException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingIOException(string message) {
      SWIGPendingException.Set(new System.IO.IOException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingNullReferenceException(string message) {
      SWIGPendingException.Set(new System.NullReferenceException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingOutOfMemoryException(string message) {
      SWIGPendingException.Set(new System.OutOfMemoryException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingOverflowException(string message) {
      SWIGPendingException.Set(new System.OverflowException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingSystemException(string message) {
      SWIGPendingException.Set(new System.SystemException(message, SWIGPendingException.Retrieve()));
    }

    static void SetPendingArgumentException(string message, string paramName) {
      SWIGPendingException.Set(new System.ArgumentException(message, paramName, SWIGPendingException.Retrieve()));
    }
    static void SetPendingArgumentNullException(string message, string paramName) {
      Exception e = SWIGPendingException.Retrieve();
      if (e != null) message = message + " Inner Exception: " + e.Message;
      SWIGPendingException.Set(new System.ArgumentNullException(paramName, message));
    }
    static void SetPendingArgumentOutOfRangeException(string message, string paramName) {
      Exception e = SWIGPendingException.Retrieve();
      if (e != null) message = message + " Inner Exception: " + e.Message;
      SWIGPendingException.Set(new System.ArgumentOutOfRangeException(paramName, message));
    }

    static SWIGExceptionHelper() {
      SWIGRegisterExceptionCallbacks_Ogr(
                                applicationDelegate,
                                arithmeticDelegate,
                                divideByZeroDelegate,
                                indexOutOfRangeDelegate,
                                invalidCastDelegate,
                                invalidOperationDelegate,
                                ioDelegate,
                                nullReferenceDelegate,
                                outOfMemoryDelegate,
                                overflowDelegate,
                                systemDelegate);

      SWIGRegisterExceptionCallbacksArgument_Ogr(
                                argumentDelegate,
                                argumentNullDelegate,
                                argumentOutOfRangeDelegate);
    }
  }

  protected static SWIGExceptionHelper swigExceptionHelper = new SWIGExceptionHelper();

  public class SWIGPendingException {
    [ThreadStatic]
    private static Exception pendingException = null;
    private static int numExceptionsPending = 0;

    public static bool Pending {
      get {
        bool pending = false;
        if (numExceptionsPending > 0)
          if (pendingException != null)
            pending = true;
        return pending;
      } 
    }

    public static void Set(Exception e) {
      if (pendingException != null)
        throw new ApplicationException("FATAL: An earlier pending exception from unmanaged code was missed and thus not thrown (" + pendingException.ToString() + ")", e);
      pendingException = e;
      lock(typeof(OgrPINVOKE)) {
        numExceptionsPending++;
      }
    }

    public static Exception Retrieve() {
      Exception e = null;
      if (numExceptionsPending > 0) {
        if (pendingException != null) {
          e = pendingException;
          pendingException = null;
          lock(typeof(OgrPINVOKE)) {
            numExceptionsPending--;
          }
        }
      }
      return e;
    }
  }


  protected class SWIGStringHelper {

    public delegate string SWIGStringDelegate(string message);
    static SWIGStringDelegate stringDelegate = new SWIGStringDelegate(CreateString);

    [DllImport("ogr_wrap", EntryPoint="SWIGRegisterStringCallback_Ogr")]
    public static extern void SWIGRegisterStringCallback_Ogr(SWIGStringDelegate stringDelegate);

    static string CreateString(string cString) {
      return cString;
    }

    static SWIGStringHelper() {
      SWIGRegisterStringCallback_Ogr(stringDelegate);
    }
  }

  static protected SWIGStringHelper swigStringHelper = new SWIGStringHelper();


  [DllImport("ogr_wrap", EntryPoint="CSharp_OGRERR_NONE_get")]
  public static extern int OGRERR_NONE_get();

  [DllImport("ogr_wrap", EntryPoint="CSharp_OGRERR_NOT_ENOUGH_DATA_get")]
  public static extern int OGRERR_NOT_ENOUGH_DATA_get();

  [DllImport("ogr_wrap", EntryPoint="CSharp_OGRERR_NOT_ENOUGH_MEMORY_get")]
  public static extern int OGRERR_NOT_ENOUGH_MEMORY_get();

  [DllImport("ogr_wrap", EntryPoint="CSharp_OGRERR_UNSUPPORTED_GEOMETRY_TYPE_get")]
  public static extern int OGRERR_UNSUPPORTED_GEOMETRY_TYPE_get();

  [DllImport("ogr_wrap", EntryPoint="CSharp_OGRERR_UNSUPPORTED_OPERATION_get")]
  public static extern int OGRERR_UNSUPPORTED_OPERATION_get();

  [DllImport("ogr_wrap", EntryPoint="CSharp_OGRERR_CORRUPT_DATA_get")]
  public static extern int OGRERR_CORRUPT_DATA_get();

  [DllImport("ogr_wrap", EntryPoint="CSharp_OGRERR_FAILURE_get")]
  public static extern int OGRERR_FAILURE_get();

  [DllImport("ogr_wrap", EntryPoint="CSharp_OGRERR_UNSUPPORTED_SRS_get")]
  public static extern int OGRERR_UNSUPPORTED_SRS_get();

  [DllImport("ogr_wrap", EntryPoint="CSharp_wkb25DBit_get")]
  public static extern int wkb25DBit_get();

  [DllImport("ogr_wrap", EntryPoint="CSharp_ogrZMarker_get")]
  public static extern int ogrZMarker_get();

  [DllImport("ogr_wrap", EntryPoint="CSharp_OGRNullFID_get")]
  public static extern int OGRNullFID_get();

  [DllImport("ogr_wrap", EntryPoint="CSharp_OGRUnsetMarker_get")]
  public static extern int OGRUnsetMarker_get();

  [DllImport("ogr_wrap", EntryPoint="CSharp_OLCRandomRead_get")]
  public static extern string OLCRandomRead_get();

  [DllImport("ogr_wrap", EntryPoint="CSharp_OLCSequentialWrite_get")]
  public static extern string OLCSequentialWrite_get();

  [DllImport("ogr_wrap", EntryPoint="CSharp_OLCRandomWrite_get")]
  public static extern string OLCRandomWrite_get();

  [DllImport("ogr_wrap", EntryPoint="CSharp_OLCFastSpatialFilter_get")]
  public static extern string OLCFastSpatialFilter_get();

  [DllImport("ogr_wrap", EntryPoint="CSharp_OLCFastFeatureCount_get")]
  public static extern string OLCFastFeatureCount_get();

  [DllImport("ogr_wrap", EntryPoint="CSharp_OLCFastGetExtent_get")]
  public static extern string OLCFastGetExtent_get();

  [DllImport("ogr_wrap", EntryPoint="CSharp_OLCCreateField_get")]
  public static extern string OLCCreateField_get();

  [DllImport("ogr_wrap", EntryPoint="CSharp_OLCTransactions_get")]
  public static extern string OLCTransactions_get();

  [DllImport("ogr_wrap", EntryPoint="CSharp_OLCDeleteFeature_get")]
  public static extern string OLCDeleteFeature_get();

  [DllImport("ogr_wrap", EntryPoint="CSharp_OLCFastSetNextByIndex_get")]
  public static extern string OLCFastSetNextByIndex_get();

  [DllImport("ogr_wrap", EntryPoint="CSharp_ODsCCreateLayer_get")]
  public static extern string ODsCCreateLayer_get();

  [DllImport("ogr_wrap", EntryPoint="CSharp_ODsCDeleteLayer_get")]
  public static extern string ODsCDeleteLayer_get();

  [DllImport("ogr_wrap", EntryPoint="CSharp_ODrCCreateDataSource_get")]
  public static extern string ODrCCreateDataSource_get();

  [DllImport("ogr_wrap", EntryPoint="CSharp_ODrCDeleteDataSource_get")]
  public static extern string ODrCDeleteDataSource_get();

  [DllImport("ogr_wrap", EntryPoint="CSharp_UseExceptions")]
  public static extern void UseExceptions();

  [DllImport("ogr_wrap", EntryPoint="CSharp_DontUseExceptions")]
  public static extern void DontUseExceptions();

  public class StringListMarshal : IDisposable {
    public readonly IntPtr[] _ar;
    public StringListMarshal(string[] ar) {
      _ar = new IntPtr[ar.Length+1];
      for (int cx = 0; cx < ar.Length; cx++) {
	      _ar[cx] = System.Runtime.InteropServices.Marshal.StringToHGlobalAnsi(ar[cx]);
      }
      _ar[ar.Length] = IntPtr.Zero;
    }
    public virtual void Dispose() {
	  for (int cx = 0; cx < _ar.Length-1; cx++) {
          System.Runtime.InteropServices.Marshal.FreeHGlobal(_ar[cx]);
      }
      GC.SuppressFinalize(this);
    }
  }


  [DllImport("ogr_wrap", EntryPoint="CSharp_Envelope_MinX_set")]
  public static extern void Envelope_MinX_set(HandleRef jarg1, double jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Envelope_MinX_get")]
  public static extern double Envelope_MinX_get(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Envelope_MaxX_set")]
  public static extern void Envelope_MaxX_set(HandleRef jarg1, double jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Envelope_MaxX_get")]
  public static extern double Envelope_MaxX_get(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Envelope_MinY_set")]
  public static extern void Envelope_MinY_set(HandleRef jarg1, double jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Envelope_MinY_get")]
  public static extern double Envelope_MinY_get(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Envelope_MaxY_set")]
  public static extern void Envelope_MaxY_set(HandleRef jarg1, double jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Envelope_MaxY_get")]
  public static extern double Envelope_MaxY_get(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_new_Envelope")]
  public static extern IntPtr new_Envelope();

  [DllImport("ogr_wrap", EntryPoint="CSharp_delete_Envelope")]
  public static extern void delete_Envelope(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Driver_name_get")]
  public static extern string Driver_name_get(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Driver_CreateDataSource")]
  public static extern IntPtr Driver_CreateDataSource(HandleRef jarg1, string jarg2, IntPtr[] jarg3);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Driver_CopyDataSource")]
  public static extern IntPtr Driver_CopyDataSource(HandleRef jarg1, HandleRef jarg2, string jarg3, IntPtr[] jarg4);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Driver_Open")]
  public static extern IntPtr Driver_Open(HandleRef jarg1, string jarg2, int jarg3);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Driver_DeleteDataSource")]
  public static extern int Driver_DeleteDataSource(HandleRef jarg1, string jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Driver_TestCapability")]
  public static extern bool Driver_TestCapability(HandleRef jarg1, string jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Driver_GetName")]
  public static extern string Driver_GetName(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_DataSource_name_get")]
  public static extern string DataSource_name_get(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_delete_DataSource")]
  public static extern void delete_DataSource(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_DataSource_GetRefCount")]
  public static extern int DataSource_GetRefCount(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_DataSource_GetSummaryRefCount")]
  public static extern int DataSource_GetSummaryRefCount(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_DataSource_GetLayerCount")]
  public static extern int DataSource_GetLayerCount(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_DataSource_GetDriver")]
  public static extern IntPtr DataSource_GetDriver(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_DataSource_GetName")]
  public static extern string DataSource_GetName(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_DataSource_DeleteLayer")]
  public static extern int DataSource_DeleteLayer(HandleRef jarg1, int jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_DataSource_CreateLayer")]
  public static extern IntPtr DataSource_CreateLayer(HandleRef jarg1, string jarg2, HandleRef jarg3, int jarg4, IntPtr[] jarg5);

  [DllImport("ogr_wrap", EntryPoint="CSharp_DataSource_CopyLayer")]
  public static extern IntPtr DataSource_CopyLayer(HandleRef jarg1, HandleRef jarg2, string jarg3, IntPtr[] jarg4);

  [DllImport("ogr_wrap", EntryPoint="CSharp_DataSource_GetLayerByIndex")]
  public static extern IntPtr DataSource_GetLayerByIndex(HandleRef jarg1, int jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_DataSource_GetLayerByName")]
  public static extern IntPtr DataSource_GetLayerByName(HandleRef jarg1, string jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_DataSource_TestCapability")]
  public static extern bool DataSource_TestCapability(HandleRef jarg1, string jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_DataSource_ExecuteSQL")]
  public static extern IntPtr DataSource_ExecuteSQL(HandleRef jarg1, string jarg2, HandleRef jarg3, string jarg4);

  [DllImport("ogr_wrap", EntryPoint="CSharp_DataSource_ReleaseResultSet")]
  public static extern void DataSource_ReleaseResultSet(HandleRef jarg1, HandleRef jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Layer_GetRefCount")]
  public static extern int Layer_GetRefCount(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Layer_SetSpatialFilter")]
  public static extern void Layer_SetSpatialFilter(HandleRef jarg1, HandleRef jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Layer_SetSpatialFilterRect")]
  public static extern void Layer_SetSpatialFilterRect(HandleRef jarg1, double jarg2, double jarg3, double jarg4, double jarg5);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Layer_GetSpatialFilter")]
  public static extern IntPtr Layer_GetSpatialFilter(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Layer_SetAttributeFilter")]
  public static extern int Layer_SetAttributeFilter(HandleRef jarg1, string jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Layer_ResetReading")]
  public static extern void Layer_ResetReading(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Layer_GetName")]
  public static extern string Layer_GetName(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Layer_GetGeometryColumn")]
  public static extern string Layer_GetGeometryColumn(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Layer_GetFIDColumn")]
  public static extern string Layer_GetFIDColumn(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Layer_GetFeature")]
  public static extern IntPtr Layer_GetFeature(HandleRef jarg1, int jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Layer_GetNextFeature")]
  public static extern IntPtr Layer_GetNextFeature(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Layer_SetNextByIndex")]
  public static extern int Layer_SetNextByIndex(HandleRef jarg1, int jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Layer_SetFeature")]
  public static extern int Layer_SetFeature(HandleRef jarg1, HandleRef jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Layer_CreateFeature")]
  public static extern int Layer_CreateFeature(HandleRef jarg1, HandleRef jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Layer_DeleteFeature")]
  public static extern int Layer_DeleteFeature(HandleRef jarg1, int jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Layer_SyncToDisk")]
  public static extern int Layer_SyncToDisk(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Layer_GetLayerDefn")]
  public static extern IntPtr Layer_GetLayerDefn(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Layer_GetFeatureCount")]
  public static extern int Layer_GetFeatureCount(HandleRef jarg1, int jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Layer_GetExtent")]
  public static extern int Layer_GetExtent(HandleRef jarg1, HandleRef jarg2, int jarg3);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Layer_TestCapability")]
  public static extern bool Layer_TestCapability(HandleRef jarg1, string jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Layer_CreateField")]
  public static extern int Layer_CreateField(HandleRef jarg1, HandleRef jarg2, int jarg3);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Layer_StartTransaction")]
  public static extern int Layer_StartTransaction(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Layer_CommitTransaction")]
  public static extern int Layer_CommitTransaction(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Layer_RollbackTransaction")]
  public static extern int Layer_RollbackTransaction(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Layer_GetSpatialRef")]
  public static extern IntPtr Layer_GetSpatialRef(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Layer_GetFeaturesRead")]
  public static extern long Layer_GetFeaturesRead(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_delete_Feature")]
  public static extern void delete_Feature(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_new_Feature")]
  public static extern IntPtr new_Feature(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_GetDefnRef")]
  public static extern IntPtr Feature_GetDefnRef(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_SetGeometry")]
  public static extern int Feature_SetGeometry(HandleRef jarg1, HandleRef jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_SetGeometryDirectly")]
  public static extern int Feature_SetGeometryDirectly(HandleRef jarg1, HandleRef jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_GetGeometryRef")]
  public static extern IntPtr Feature_GetGeometryRef(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_Clone")]
  public static extern IntPtr Feature_Clone(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_Equal")]
  public static extern bool Feature_Equal(HandleRef jarg1, HandleRef jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_GetFieldCount")]
  public static extern int Feature_GetFieldCount(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_GetFieldDefnRef__SWIG_0")]
  public static extern IntPtr Feature_GetFieldDefnRef__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_GetFieldDefnRef__SWIG_1")]
  public static extern IntPtr Feature_GetFieldDefnRef__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_GetFieldAsString__SWIG_0")]
  public static extern string Feature_GetFieldAsString__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_GetFieldAsString__SWIG_1")]
  public static extern string Feature_GetFieldAsString__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_GetFieldAsInteger__SWIG_0")]
  public static extern int Feature_GetFieldAsInteger__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_GetFieldAsInteger__SWIG_1")]
  public static extern int Feature_GetFieldAsInteger__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_GetFieldAsDouble__SWIG_0")]
  public static extern double Feature_GetFieldAsDouble__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_GetFieldAsDouble__SWIG_1")]
  public static extern double Feature_GetFieldAsDouble__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_IsFieldSet__SWIG_0")]
  public static extern bool Feature_IsFieldSet__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_IsFieldSet__SWIG_1")]
  public static extern bool Feature_IsFieldSet__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_GetFieldIndex")]
  public static extern int Feature_GetFieldIndex(HandleRef jarg1, string jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_GetFID")]
  public static extern int Feature_GetFID(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_SetFID")]
  public static extern int Feature_SetFID(HandleRef jarg1, int jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_DumpReadable")]
  public static extern void Feature_DumpReadable(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_UnsetField__SWIG_0")]
  public static extern void Feature_UnsetField__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_UnsetField__SWIG_1")]
  public static extern void Feature_UnsetField__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_SetField__SWIG_0")]
  public static extern void Feature_SetField__SWIG_0(HandleRef jarg1, int jarg2, string jarg3);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_SetField__SWIG_1")]
  public static extern void Feature_SetField__SWIG_1(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_SetField__SWIG_2")]
  public static extern void Feature_SetField__SWIG_2(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_SetField__SWIG_3")]
  public static extern void Feature_SetField__SWIG_3(HandleRef jarg1, string jarg2, int jarg3);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_SetField__SWIG_4")]
  public static extern void Feature_SetField__SWIG_4(HandleRef jarg1, int jarg2, double jarg3);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_SetField__SWIG_5")]
  public static extern void Feature_SetField__SWIG_5(HandleRef jarg1, string jarg2, double jarg3);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_SetField__SWIG_6")]
  public static extern void Feature_SetField__SWIG_6(HandleRef jarg1, int jarg2, int jarg3, int jarg4, int jarg5, int jarg6, int jarg7, int jarg8, int jarg9);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_SetField__SWIG_7")]
  public static extern void Feature_SetField__SWIG_7(HandleRef jarg1, string jarg2, int jarg3, int jarg4, int jarg5, int jarg6, int jarg7, int jarg8, int jarg9);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_SetFrom")]
  public static extern int Feature_SetFrom(HandleRef jarg1, HandleRef jarg2, int jarg3);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_GetStyleString")]
  public static extern string Feature_GetStyleString(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_SetStyleString")]
  public static extern void Feature_SetStyleString(HandleRef jarg1, string jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_GetFieldType__SWIG_0")]
  public static extern int Feature_GetFieldType__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Feature_GetFieldType__SWIG_1")]
  public static extern int Feature_GetFieldType__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_delete_FeatureDefn")]
  public static extern void delete_FeatureDefn(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_new_FeatureDefn")]
  public static extern IntPtr new_FeatureDefn(string jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_FeatureDefn_GetName")]
  public static extern string FeatureDefn_GetName(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_FeatureDefn_GetFieldCount")]
  public static extern int FeatureDefn_GetFieldCount(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_FeatureDefn_GetFieldDefn")]
  public static extern IntPtr FeatureDefn_GetFieldDefn(HandleRef jarg1, int jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_FeatureDefn_GetFieldIndex")]
  public static extern int FeatureDefn_GetFieldIndex(HandleRef jarg1, string jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_FeatureDefn_AddFieldDefn")]
  public static extern void FeatureDefn_AddFieldDefn(HandleRef jarg1, HandleRef jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_FeatureDefn_GetGeomType")]
  public static extern int FeatureDefn_GetGeomType(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_FeatureDefn_SetGeomType")]
  public static extern void FeatureDefn_SetGeomType(HandleRef jarg1, int jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_FeatureDefn_GetReferenceCount")]
  public static extern int FeatureDefn_GetReferenceCount(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_delete_FieldDefn")]
  public static extern void delete_FieldDefn(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_new_FieldDefn")]
  public static extern IntPtr new_FieldDefn(string jarg1, int jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_FieldDefn_GetName")]
  public static extern string FieldDefn_GetName(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_FieldDefn_GetNameRef")]
  public static extern string FieldDefn_GetNameRef(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_FieldDefn_SetName")]
  public static extern void FieldDefn_SetName(HandleRef jarg1, string jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_FieldDefn_GetFieldType")]
  public static extern int FieldDefn_GetFieldType(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_FieldDefn_SetType")]
  public static extern void FieldDefn_SetType(HandleRef jarg1, int jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_FieldDefn_GetJustify")]
  public static extern int FieldDefn_GetJustify(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_FieldDefn_SetJustify")]
  public static extern void FieldDefn_SetJustify(HandleRef jarg1, int jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_FieldDefn_GetWidth")]
  public static extern int FieldDefn_GetWidth(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_FieldDefn_SetWidth")]
  public static extern void FieldDefn_SetWidth(HandleRef jarg1, int jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_FieldDefn_GetPrecision")]
  public static extern int FieldDefn_GetPrecision(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_FieldDefn_SetPrecision")]
  public static extern void FieldDefn_SetPrecision(HandleRef jarg1, int jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_FieldDefn_GetFieldTypeName")]
  public static extern string FieldDefn_GetFieldTypeName(HandleRef jarg1, int jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_CreateGeometryFromWkb")]
  public static extern IntPtr CreateGeometryFromWkb(int jarg1, IntPtr jarg2, HandleRef jarg3);

  [DllImport("ogr_wrap", EntryPoint="CSharp_CreateGeometryFromWkt")]
  public static extern IntPtr CreateGeometryFromWkt(HandleRef jarg1, HandleRef jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_CreateGeometryFromGML")]
  public static extern IntPtr CreateGeometryFromGML(string jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_CreateGeometryFromJson")]
  public static extern IntPtr CreateGeometryFromJson(string jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_delete_Geometry")]
  public static extern void delete_Geometry(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_new_Geometry")]
  public static extern IntPtr new_Geometry(int jarg1, string jarg2, int jarg3, IntPtr jarg4, string jarg5);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_ExportToWkt")]
  public static extern int Geometry_ExportToWkt(HandleRef jarg1, out string jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_ExportToGML")]
  public static extern string Geometry_ExportToGML(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_ExportToKML")]
  public static extern string Geometry_ExportToKML(HandleRef jarg1, string jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_ExportToJson")]
  public static extern string Geometry_ExportToJson(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_AddPoint")]
  public static extern void Geometry_AddPoint(HandleRef jarg1, double jarg2, double jarg3, double jarg4);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_AddPoint_2D")]
  public static extern void Geometry_AddPoint_2D(HandleRef jarg1, double jarg2, double jarg3);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_AddGeometryDirectly")]
  public static extern int Geometry_AddGeometryDirectly(HandleRef jarg1, HandleRef jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_AddGeometry")]
  public static extern int Geometry_AddGeometry(HandleRef jarg1, HandleRef jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_Clone")]
  public static extern IntPtr Geometry_Clone(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_GetGeometryType")]
  public static extern int Geometry_GetGeometryType(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_GetGeometryName")]
  public static extern string Geometry_GetGeometryName(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_GetArea")]
  public static extern double Geometry_GetArea(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_GetPointCount")]
  public static extern int Geometry_GetPointCount(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_GetX")]
  public static extern double Geometry_GetX(HandleRef jarg1, int jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_GetY")]
  public static extern double Geometry_GetY(HandleRef jarg1, int jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_GetZ")]
  public static extern double Geometry_GetZ(HandleRef jarg1, int jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_GetPoint")]
  public static extern void Geometry_GetPoint(HandleRef jarg1, int jarg2, double[] jarg3);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_GetPoint_2D")]
  public static extern void Geometry_GetPoint_2D(HandleRef jarg1, int jarg2, double[] jarg3);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_GetGeometryCount")]
  public static extern int Geometry_GetGeometryCount(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_SetPoint")]
  public static extern void Geometry_SetPoint(HandleRef jarg1, int jarg2, double jarg3, double jarg4, double jarg5);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_SetPoint_2D")]
  public static extern void Geometry_SetPoint_2D(HandleRef jarg1, int jarg2, double jarg3, double jarg4);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_GetGeometryRef")]
  public static extern IntPtr Geometry_GetGeometryRef(HandleRef jarg1, int jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_GetBoundary")]
  public static extern IntPtr Geometry_GetBoundary(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_ConvexHull")]
  public static extern IntPtr Geometry_ConvexHull(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_Buffer")]
  public static extern IntPtr Geometry_Buffer(HandleRef jarg1, double jarg2, int jarg3);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_Intersection")]
  public static extern IntPtr Geometry_Intersection(HandleRef jarg1, HandleRef jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_Union")]
  public static extern IntPtr Geometry_Union(HandleRef jarg1, HandleRef jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_Difference")]
  public static extern IntPtr Geometry_Difference(HandleRef jarg1, HandleRef jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_SymmetricDifference")]
  public static extern IntPtr Geometry_SymmetricDifference(HandleRef jarg1, HandleRef jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_Distance")]
  public static extern double Geometry_Distance(HandleRef jarg1, HandleRef jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_Empty")]
  public static extern void Geometry_Empty(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_IsEmpty")]
  public static extern bool Geometry_IsEmpty(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_IsValid")]
  public static extern bool Geometry_IsValid(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_IsSimple")]
  public static extern bool Geometry_IsSimple(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_IsRing")]
  public static extern bool Geometry_IsRing(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_Intersect")]
  public static extern bool Geometry_Intersect(HandleRef jarg1, HandleRef jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_Equal")]
  public static extern bool Geometry_Equal(HandleRef jarg1, HandleRef jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_Disjoint")]
  public static extern bool Geometry_Disjoint(HandleRef jarg1, HandleRef jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_Touches")]
  public static extern bool Geometry_Touches(HandleRef jarg1, HandleRef jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_Crosses")]
  public static extern bool Geometry_Crosses(HandleRef jarg1, HandleRef jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_Within")]
  public static extern bool Geometry_Within(HandleRef jarg1, HandleRef jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_Contains")]
  public static extern bool Geometry_Contains(HandleRef jarg1, HandleRef jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_Overlaps")]
  public static extern bool Geometry_Overlaps(HandleRef jarg1, HandleRef jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_TransformTo")]
  public static extern int Geometry_TransformTo(HandleRef jarg1, HandleRef jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_Transform")]
  public static extern int Geometry_Transform(HandleRef jarg1, HandleRef jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_GetSpatialReference")]
  public static extern IntPtr Geometry_GetSpatialReference(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_AssignSpatialReference")]
  public static extern void Geometry_AssignSpatialReference(HandleRef jarg1, HandleRef jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_CloseRings")]
  public static extern void Geometry_CloseRings(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_FlattenTo2D")]
  public static extern void Geometry_FlattenTo2D(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_GetEnvelope")]
  public static extern void Geometry_GetEnvelope(HandleRef jarg1, HandleRef jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_Centroid")]
  public static extern IntPtr Geometry_Centroid(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_WkbSize")]
  public static extern int Geometry_WkbSize(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_GetCoordinateDimension")]
  public static extern int Geometry_GetCoordinateDimension(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_SetCoordinateDimension")]
  public static extern void Geometry_SetCoordinateDimension(HandleRef jarg1, int jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_GetDimension")]
  public static extern int Geometry_GetDimension(HandleRef jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Geometry_ExportToWkb")]
  public static extern int Geometry_ExportToWkb(HandleRef jarg1, int jarg2, IntPtr jarg3, int jarg4);

  [DllImport("ogr_wrap", EntryPoint="CSharp_GetDriverCount")]
  public static extern int GetDriverCount();

  [DllImport("ogr_wrap", EntryPoint="CSharp_GetOpenDSCount")]
  public static extern int GetOpenDSCount();

  [DllImport("ogr_wrap", EntryPoint="CSharp_SetGenerate_DB2_V72_BYTE_ORDER")]
  public static extern int SetGenerate_DB2_V72_BYTE_ORDER(int jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_RegisterAll")]
  public static extern void RegisterAll();

  [DllImport("ogr_wrap", EntryPoint="CSharp_GetOpenDS")]
  public static extern IntPtr GetOpenDS(int jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_Open")]
  public static extern IntPtr Open(string jarg1, int jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_OpenShared")]
  public static extern IntPtr OpenShared(string jarg1, int jarg2);

  [DllImport("ogr_wrap", EntryPoint="CSharp_GetDriverByName")]
  public static extern IntPtr GetDriverByName(string jarg1);

  [DllImport("ogr_wrap", EntryPoint="CSharp_GetDriver")]
  public static extern IntPtr GetDriver(int jarg1);
}

}
