/*
 * Copyright (C) 2006, 2007 Apple Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef WebScriptObject_H
#define WebScriptObject_H

#include "WebKit.h"

class WebScriptObject : public IWebScriptObject
{
public:
    WebScriptObject();
    virtual ~WebScriptObject();

    // IUnknown
    virtual HRESULT STDMETHODCALLTYPE QueryInterface(REFIID riid, void** ppvObject);
    virtual ULONG STDMETHODCALLTYPE AddRef(void);
    virtual ULONG STDMETHODCALLTYPE Release(void);

    // IWebScriptObject
    virtual HRESULT STDMETHODCALLTYPE throwException(
        /* [in] */ BSTR exceptionMessage,
        /* [retval][out] */ BOOL *result);

    virtual HRESULT STDMETHODCALLTYPE callWebScriptMethod(
        /* [in] */ BSTR name,
        /* [size_is][in] */ const VARIANT args[  ],
        /* [in] */ int cArgs,
        /* [retval][out] */ VARIANT *result);

    virtual HRESULT STDMETHODCALLTYPE evaluateWebScript(
        /* [in] */ BSTR script,
        /* [retval][out] */ VARIANT *result);

    virtual HRESULT STDMETHODCALLTYPE removeWebScriptKey(
        /* [in] */ BSTR name);

    virtual HRESULT STDMETHODCALLTYPE stringRepresentation(
        /* [retval][out] */ BSTR* stringRepresentation);

    virtual HRESULT STDMETHODCALLTYPE webScriptValueAtIndex(
        /* [in] */ unsigned int index,
        /* [retval][out] */ VARIANT *result);

    virtual HRESULT STDMETHODCALLTYPE setWebScriptValueAtIndex(
        /* [in] */ unsigned int index,
        /* [in] */ VARIANT val);

    virtual HRESULT STDMETHODCALLTYPE setException(
        /* [in] */ BSTR description);

protected:
    ULONG m_refCount;
};

#endif
