#ifndef __MDLDAPCONFIG_H
#define __MDLDAPCONFIG_H 1

#ifdef __cplusplus
extern "C" {
#endif

#define LDAP_DEFAULT_PORT 389

#define LDAP_DEFAULT_SEARCH_METHOD "mail"
#define LDAP_DEFAULT_MAIL_ATTR "mail"
#define LDAP_DEFAULT_UID_ATTR "uid"
#define LDAP_DEFAULT_UIDNUMBER_ATTR "uidnumber"
#define LDAP_DEFAULT_GIDNUMBER_ATTR "gidnumber"
#define LDAP_DEFAULT_MAILDIR_ATTR "maildir"
#define LDAP_DEFAULT_HOMEDIRECTORY_ATTR "homedirectory"
#define LDAP_DEFAULT_QUOTA_ATTR "quota"
#define LDAP_DEFAULT_TIMEOUT 5

typedef struct {
  char *hostname;
  unsigned short port;
  char *basedn;
  char *binddn;
  char *bindpw;
  char *filter;

  char *search_method;
  char *mail_attr;
  char *uid_attr;
  char *uidnumber_attr;
  char *gidnumber_attr;
  char *maildir_attr;
  char *homedirectory_attr;
  char *quota_attr;

  int default_uidnumber;
  int default_gidnumber;

  int timeout;
} mdldapconfig;

mdldapconfig *get_ldap_config(char *configfile);

#ifdef __cplusplus
}
#endif

#endif
