/*
** Copyright 1998 - 1999 Double Precision, Inc.  See COPYING for
** distribution information.
*/

#if	HAVE_CONFIG_H
#include	"config.h"
#endif
#include	"rfc2045.h"
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	<stdio.h>
#include	<stdlib.h>
#include	<time.h>
#include	"numlib/numlib.h"

/* $Id: rfc2045mkboundary.c,v 1.7 2001/03/07 23:05:52 mrsam Exp $ */

#if	HAS_GETHOSTNAME

#else

extern int gethostname(char *, size_t);
#endif

extern void rfc2045_enomem();

char *rfc2045_mk_boundary(struct rfc2045 *s, int fd)
{
char	hostnamebuf[256];
pid_t	mypid;
char	pidbuf[NUMBUFSIZE];
time_t	mytime;
char	timebuf[NUMBUFSIZE];
static size_t	cnt=0;
char	cntbuf[NUMBUFSIZE];
char	*p;
int	rc;

	hostnamebuf[sizeof(hostnamebuf)-1]=0;
	if (gethostname(hostnamebuf, sizeof(hostnamebuf)-1))
		hostnamebuf[0]=0;
	mypid=getpid();
	time(&mytime);
	str_pid_t(mypid, pidbuf);
	str_time_t(mytime, timebuf);
	for (;;)
	{
		char tempbuf[NUMBUFSIZE];

		str_size_t(++cnt, tempbuf);
		sprintf(cntbuf, "%4s", tempbuf);
		for (p=cntbuf; *p == ' '; *p++ = '0')
			;
		p=malloc(strlen(hostnamebuf)+strlen(pidbuf)
			 +strlen(timebuf)+strlen(cntbuf)+11);
		if (!p)
		{
			rfc2045_enomem();
			return (NULL);
		}

		sprintf(p, "=_%s-%s-%s-%s", hostnamebuf,
			pidbuf, timebuf, cntbuf);
		if ((rc=rfc2045_try_boundary(s, fd, p)) == 0)
			break;
		free(p);
		if (rc < 0)
			return (NULL);
	}
	return (p);
}
