/*
SMS Server Tools
Copyright (C) 2000-2002 Stefan Frings

This program is free software unless you got it under another license directly
from the author. You can redistribute it and/or modify it under the terms of 
the GNU General Public License as published by the Free Software Foundation.
Either version 2 of the License, or (at your option) any later version.

http://www.isis.de/members/~s.frings
mailto:s.frings@mail.isis.de
*/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include "extras.h"
#include "cfgfile.h"
#include "smsd_cfg.h"
#include "stats.h"
#include "version.h"
#include "blacklist.h"


void initcfg()
{
  int i;
  int j;
  delaytime=10;
  blocktime=60*60;
  errorsleeptime=10;
  eventhandler[0]=0;
  strcpy(d_spool,"/var/spool/sms/outgoing");
  strcpy(d_incoming,"/var/spool/sms/incoming");
  strcpy(d_failed,"/var/spool/sms/failed");
  logfile[0]=0;
  d_sent[0]=0;
  d_stats[0]=0;
  stats_interval=0;
  for (i=0; i<PROVIDER; i++)
  {
    queues[i].name[0]=0;
    queues[i].directory[0]=0;
    for (j=0; j<NUMS; j++)
      queues[i].numbers[j][0]=0;  
  }
  for (i=0; i<DEVICES; i++)
  {
    devices[i].name[0]=0;
    devices[i].device[0]=0;
    devices[i].incoming=0;
    devices[i].pin[0]=0;
    devices[i].smsc[0]=0;
    devices[i].baudrate=19200;
    devices[i].cs_convert=0;
    devices[i].initstring[0]=0;
    devices[i].eventhandler[0]=0;
    devices[i].report=0;
    strcpy(devices[i].mode,"new");
    for (j=0; j<PROVIDER; j++)
      devices[i].queues[j][0]=0;
  }
}

void readcfg()
{
  FILE* File;
  char devices_list[256];
  char name[32];
  char value[256];
  char tmp[256];
  char device_name[32];
  int result;
  int i,j;
  File=fopen(configfile,"r");
  if (File)
  {  
    /* read global parameter */
    result=getline(File,name,sizeof(name),value,sizeof(value));
    while (result==1)
    {
      if (strcmp(name,"devices")==0)
        strcpy(devices_list,value);
      else if (strcmp(name,"spool")==0)
        strcpy(d_spool,value);
      else if (strcmp(name,"stats")==0)
        strcpy(d_stats,value);
      else if (strcmp(name,"failed")==0)
        strcpy(d_failed,value);
      else if (strcmp(name,"incoming")==0)
        strcpy(d_incoming,value);
      else if (strcmp(name,"sent")==0)
        strcpy(d_sent,value);
      else if (strcmp(name,"mypath")==0)
        strcpy(mypath,value);
      else if (strcmp(name,"delaytime")==0)
        delaytime=atoi(value);
      else if (strcmp(name,"blocktime")==0)
        blocktime=atoi(value);
      else if (strcmp(name,"stats_interval")==0)
        stats_interval=atoi(value);
      else if (strcmp(name,"errorsleeptime")==0)
        errorsleeptime=atoi(value);
      else if (strcmp(name,"eventhandler")==0)
        strcpy(eventhandler,value);
      else if (strcmp(name,"blacklist")==0)
        strcpy(blacklist,value);
      else if (strcmp(name,"logfile")==0)
        strcpy(logfile,value);	
      else if (strcmp(name,"loglevel")==0)
        loglevel=atoi(value);	
      else
        fprintf(stderr,"Unknown variable in config file: %s\n",name);
      result=getline(File,name,sizeof(name),value,sizeof(value));
    }
    if (result==-1)
      fprintf(stderr,"Syntax Error in config file: %s\n",value);
    /* read queue-settings */
    if (!gotosection(File,"queues"))
      fprintf(stderr,"Could not find [queues] in config file.\n");
    i=0;
    result=getline(File,name,sizeof(name),value,sizeof(value));
    while ((result==1) && (i<PROVIDER))
    {
      strcpy(queues[i].name,name);
      strcpy(queues[i].directory,value);
      i++;
      result=getline(File,name,sizeof(name),value,sizeof(value));
    }
    if (result==-1)
      fprintf(stderr,"Syntax Error in config file: %s\n",value);
    /* read provider-settings */
    if (!gotosection(File,"provider"))
      fprintf(stderr,"Could not find [provider] in config file.\n");
    result=getline(File,name,sizeof(name),value,sizeof(value));
    while (result==1)
    {
      i=getqueue(name,tmp);
      if (i>=0)
      {
        for (j=1; j<=NUMS; j++)
	{
	  if (getsubparam(value,j,tmp,sizeof(tmp)))
	  {
	    strcpy(queues[i].numbers[j-1],tmp);
	  }    
	  else
	    break;
	}
      }
      else
        fprintf(stderr,"Error in config file: missing queue for %s.\n",name);
      result=getline(File,name,sizeof(name),value,sizeof(value));
    }
    if (result==-1)
      fprintf(stderr,"Syntax Error in config file: %s\n",value);
    /* read device-settings */
    for (i=0; i<DEVICES; i++)
    {
      if (getsubparam(devices_list,i+1,device_name,sizeof(device_name)))
      {
        if (!gotosection(File,device_name))
	  fprintf(stderr,"Could not find device [%s] in config file.\n",device_name);
	strcpy(devices[i].name,device_name);
        result=getline(File,name,sizeof(name),value,sizeof(value));
	while (result==1)
	{
	  if (strcmp(name,"device")==0)
	    strcpy(devices[i].device,value);
	  else if (strcmp(name,"queues")==0)
	  {
	    for (j=1; j<=NUMS; j++)
	      if (getsubparam(value,j,tmp,sizeof(tmp)))
	        strcpy(devices[i].queues[j-1],tmp);
  	      else
	        break;
	  }
	  else if (strcmp(name,"incoming")==0)
	    devices[i].incoming=yesno(value);
	  else if (strcmp(name,"cs_convert")==0)
	    devices[i].cs_convert=yesno(value);
	  else if (strcmp(name,"pin")==0)
	    strcpy(devices[i].pin,value);
	  else if (strcmp(name,"mode")==0)
	    strcpy(devices[i].mode,value);
	  else if (strcmp(name,"smsc")==0)
	    strcpy(devices[i].smsc,value);
	  else if (strcmp(name,"baudrate")==0)
	    devices[i].baudrate=atoi(value);
	  else if (strcmp(name,"init")==0)
	    strcpy(devices[i].initstring,value);
	  else if (strcmp(name,"eventhandler")==0)
    	    strcpy(devices[i].eventhandler,value);
	  else if (strcmp(name,"report")==0)
    	    devices[i].report=yesno(value);    
	  else
	    fprintf(stderr,"Unknown variable in config file [%s]: %s\n",device_name,name);
	  result=getline(File,name,sizeof(name),value,sizeof(value));
	}
        if (result==-1)
          fprintf(stderr,"Syntax Error in config file: %s\n",value);
      }
      else
        break;
    }
    fclose(File);
  }
  else
    fprintf(stderr,"Cannot open config file for read.\n");
}

void printcfg()
{
  int i,j;
  printf("configfile = %s\n",configfile);
  printf("d_spool = %s\n",d_spool);
  printf("d_failed = %s\n",d_failed);
  printf("d_incoming = %s\n",d_incoming);
  printf("d_sent = %s\n",d_sent);
  printf("mypath = %s\n",mypath);
  printf("logfile = %s\n",logfile);
  printf("loglevel = %i\n",loglevel);
  printf("delaytime = %i\n",delaytime);
  printf("blocktime = %i\n",blocktime);
  printf("errorsleeptime = %i\n",errorsleeptime);
  printf("stats = %s\n",d_stats);  
  printf("stats_interval = %i\n",stats_interval);  
  printf("blacklist = %s\n",blacklist);  
  for (i=0; i<PROVIDER; i++)
  {
    if (queues[i].name[0]==0)
      break;
    printf("--- Queue %i\n",i);
    printf("name = %s\n",queues[i].name);
    printf("directory = %s\n",queues[i].directory);
    for (j=0; j<NUMS; j++)
    {
      if (queues[i].numbers[j][0]==0)
        break;
      printf("numbers[%i] = %s\n",j,queues[i].numbers[j]);
    }
  }
  for (i=0; i<DEVICES; i++)
  {
    if (devices[i].name[0]==0)
      break;
    printf("--- Device %i\n",i);
    printf("name = %s\n",devices[i].name);
    printf("device = %s\n",devices[i].device);
    printf("pin = %s\n",devices[i].pin);
    printf("mode = %s\n",devices[i].mode);    
    printf("smsc = %s\n",devices[i].smsc);
    printf("incoming = %i\n",devices[i].incoming);
    printf("report = %i\n",devices[i].report);    
    printf("baudrate = %i\n",devices[i].baudrate);
    printf("cs_convert = %i\n",devices[i].cs_convert);
    printf("initstring = %s\n",devices[i].initstring);    
    printf("eventhandler = %s\n",devices[i].eventhandler);    
    for (j=0; j<PROVIDER; j++)
    {
      if (devices[i].queues[j][0]==0)
        break;
      printf("queues[%i] = %s\n",j,devices[i].queues[j]);
    }  
  }  
}

int getqueue(char* name, char* directory)
{
  int i;
  int j;
  if (is_number(name))
  { /* search queue by number  */
    i=0;
    while (queues[i].name[0] && (i<PROVIDER))
    {
      j=0;
      while (queues[i].numbers[j][0] && (j<NUMS))
      {
        if (!strncmp(queues[i].numbers[j],name,strlen(queues[i].numbers[j])))
	{
	  if (directory)
  	    strcpy(directory,queues[i].directory);
	  return i;
	}
	j++;
      }
      i++;
    }
  }
  else
  { /* search queue by name */
    i=0;
    while (queues[i].name[0] && (i<PROVIDER))
    {
      if (!strcmp(name,queues[i].name))
      {
        strcpy(directory,queues[i].directory);
        return i;
      }
      i++;
    }
  }
  /* not found */
  directory[0]=0;
  return -1;
}

int getdevice(char* name)
{
  int i=0;
  while (devices[i].name[0] && (i<DEVICES))
  {
    if (!strcmp(name,devices[i].name))
      return i;
    i++;
  }
  return -1;
}

void help()
{
  printf("smsd spools incoming and outgoing sms.\n\n");
  printf("Usage:\n");
  printf("         smsd [options]\n\n");
  printf("Options:\n");
  printf("         -cx set config file to x\n");
  printf("         -d  debug mode (does not really send SMS\n");
  printf("             also useful to check the config file)\n");
  printf("         -h  this help\n");
  printf("         -s  display status monitor\n");
  printf("         -V  print copyright and version\n\n");
  printf("All other options are set by the file /etc/smsd.conf.\n\n");
  printf("Output is written to stdout, errors are written to stderr.\n\n");
  exit(0);
}

void parsearguments(int argc,char** argv)
{
  int result;
  strcpy(configfile,"/etc/smsd.conf");
  debug=0;
  printstatus=0;

  do
  {
    result=getopt(argc,argv,"sdhc:V");
    switch (result)
    {
      case 'h': help(); 
                break;
      case 'd': debug=1;
                break;
      case 'c': strcpy(configfile,optarg);
                break;
      case 's': printstatus=1;
                break;
      case 'V': printf("Version %s, Copyright (c) 2000-2002 by Stefan Frings, s.frings@mail.isis.de\n",smsd_version);
                exit(0);
    }
  }
  while (result>0);
}

