
/* File ctype-czech.c for MySQL. Implements Czech sorting. Defines
	my_strcoll and my_strxfrm. Also defines value
	MY_STRXFRM_MULTIPLY to have value 4 -- this is the ratio that
	the buffers should be longer than the original string when
	doing my_strxfrm.

	Author: (c) Jan Pazdziora, adelton@fi.muni.cz, 1997

	The original of this file can be found at
	http://www.fi.muni.cz/~adelton/l10n/cssort

	Please send me all bug reports or suggestions.
*/

#define uchar unsigned char


#undef DEBUG_CZECH_SORT
#ifdef DEBUG_CZECH_SORT
#include <stdio.h>
#endif


uchar * CZ_SORT_TABLE[] = {
	"\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\043\044\045\046\047\050\051\052\053\054\000\000\000\000\000\000\000\003\004\377\007\010\011\012\013\015\016\017\020\022\023\024\025\026\027\031\033\034\035\036\037\040\041\000\000\000\000\000\000\003\004\377\007\010\011\012\013\015\016\017\020\022\023\024\025\026\027\031\033\034\035\036\037\040\041\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\003\000\021\000\020\032\000\000\032\032\033\042\000\042\042\000\003\000\021\000\020\032\000\000\032\032\033\042\000\042\042\027\003\003\003\003\020\006\006\006\010\010\010\010\015\015\007\007\023\023\024\024\024\024\000\030\034\034\034\034\040\033\000\027\003\003\003\003\020\006\006\006\010\010\010\010\015\015\007\007\023\023\024\024\024\024\000\030\034\034\034\034\040\033\000",
	"\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\106\107\110\111\112\113\114\115\116\117\000\000\000\000\000\000\000\003\011\377\016\021\026\027\030\032\035\036\037\043\044\047\054\055\056\061\065\070\075\076\077\100\102\000\000\000\000\000\000\003\011\377\016\021\026\027\030\032\035\036\037\043\044\047\054\055\056\061\065\070\075\076\077\100\102\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\010\000\042\000\041\063\000\000\062\064\066\104\000\103\105\000\010\000\042\000\041\063\000\000\062\064\066\104\000\103\105\057\004\005\007\006\040\014\015\013\022\025\024\023\033\034\017\020\046\045\050\051\053\052\000\060\072\071\074\073\101\067\000\057\004\005\007\006\040\014\015\013\022\025\024\023\033\034\017\020\046\045\050\051\053\052\000\060\072\071\074\073\101\067\000",
	"\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\212\213\214\215\216\217\220\221\222\223\000\000\000\000\000\000\000\004\020\377\032\040\052\054\056\063\071\073\075\105\107\115\127\131\133\141\151\157\171\173\175\177\203\000\000\000\000\000\000\003\017\377\031\037\051\053\055\062\070\072\074\104\106\114\126\130\132\140\150\156\170\172\174\176\202\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\103\000\101\145\000\000\143\147\153\207\000\205\211\000\015\000\102\000\100\144\000\000\142\146\152\206\000\204\210\135\006\010\014\012\077\026\030\024\042\050\046\044\065\067\034\036\113\111\117\121\125\123\000\137\163\161\167\165\201\155\000\134\005\007\013\011\076\025\027\023\041\047\045\043\064\066\033\035\112\110\116\120\124\122\000\136\162\160\166\164\200\154\000",
	"\264\265\266\267\270\271\272\273\274\002\276\277\300\301\302\303\304\305\306\307\310\311\312\313\314\315\316\317\320\321\322\323\002\230\232\253\324\252\251\234\240\241\261\260\225\262\224\235\212\213\214\215\216\217\220\221\222\223\231\226\244\257\245\227\250\004\020\377\032\040\052\054\056\063\071\073\075\105\107\115\127\131\133\141\151\157\171\173\175\177\203\242\237\243\254\255\233\003\017\377\031\037\051\053\055\062\070\072\074\104\106\114\126\130\132\140\150\156\170\172\174\176\202\246\236\247\256\325\264\265\266\267\270\271\272\273\274\275\276\277\300\301\302\303\304\305\306\307\310\311\312\313\314\315\316\317\320\321\322\323\326\016\327\103\330\101\145\331\332\143\147\153\207\333\205\211\334\015\335\102\336\100\144\337\340\142\146\152\206\341\204\210\135\006\010\014\012\077\026\030\024\042\050\046\044\065\067\034\036\113\111\117\121\125\123\263\137\163\161\167\165\201\155\342\134\005\007\013\011\076\025\027\023\041\047\045\043\064\066\033\035\112\110\116\120\124\122\343\136\162\160\166\164\200\154\344",
};
uchar CZ_SORT_VALUE_CH[] = {
	(uchar)'\014',	(uchar)'\031',	(uchar)'\061',	(uchar)'\061',
	};
uchar CZ_SORT_VALUE_C[] = {
	(uchar)'\005',	(uchar)'\012',	(uchar)'\022',	(uchar)'\022',
	};
uchar CZ_SORT_VALUE_Ch[] = {
	(uchar)'\014',	(uchar)'\031',	(uchar)'\060',	(uchar)'\060',
	};
uchar CZ_SORT_VALUE_c[] = {
	(uchar)'\005',	(uchar)'\012',	(uchar)'\021',	(uchar)'\021',
	};
uchar CZ_SORT_VALUE_ch[] = {
	(uchar)'\014',	(uchar)'\031',	(uchar)'\057',	(uchar)'\057',
	};


#define ADD_TO_RESULT(dest, len, totlen, value)				\
	if ((totlen) < (len)) { dest[totlen] = value; } (totlen++);

#define NEXT_CMP_VALUE(src, p, store, pass, value)			\
	while (1)		/* we will make a loop */		\
		{							\
		if (!(*p))	/* when we are at the end of string */	\
			{	/* return either 0 for end of string */	\
					/* or 1 for end of pass */	\
			if (pass == 3)	{ value = 0; break; }		\
			if (pass == 0)	p = store;			\
			else		p = src;			\
			value = 1; pass++; break;			\
			}						\
					/* not at end of string */	\
		value = CZ_SORT_TABLE[pass][*p];			\
									\
		if (value == 0)	{ p++; continue; } /* ignore value */	\
		if ((value == 2) && (pass <= 1))	/* space */	\
			{						\
			uchar * tmp;					\
			while (*p && (CZ_SORT_TABLE[pass][*p] == 2))	\
				p++;		/* skip all spaces */	\
			tmp = p;					\
			if (pass == 0)	pass = 1;			\
			else		pass = 0;			\
			p = store; store = tmp;				\
			break;						\
			}						\
		if (value == 255)					\
			{						\
			char ch = *p;					\
			char nextch = *(p + 1);				\
			if (ch == 'c')					\
				{					\
				if (nextch == 'h')			\
					{				\
					value = CZ_SORT_VALUE_ch[pass];	\
					p++;				\
					}				\
				else value = CZ_SORT_VALUE_c[pass];	\
				}					\
			else if (ch == 'C')				\
				{					\
				if (nextch == 'h')			\
					{				\
					value = CZ_SORT_VALUE_Ch[pass];	\
					p++;				\
					}				\
				else if (nextch == 'H')			\
					{				\
					value = CZ_SORT_VALUE_Ch[pass];	\
					p++;				\
					}				\
				else value = CZ_SORT_VALUE_C[pass];	\
				}					\
			}						\
		p++;							\
		break;							\
		}


#define NEXT_CMP_VALUE_WITH_LEN(src, p, store, pass, value, len)	\
	while (1)		/* we will make a loop */		\
		{							\
		if ((p - src) >= len)	/* when we are at the end of string */	\
			{	/* return either 0 for end of string */	\
					/* or 1 for end of pass */	\
			if (pass == 3)	{ value = 0; break; }		\
			if (pass == 0)	p = store;			\
			else		p = src;			\
			value = 1; pass++; break;			\
			}						\
					/* not at end of string */	\
		value = CZ_SORT_TABLE[pass][*p];			\
									\
		if (value == 0)	{ p++; continue; } /* ignore value */	\
		if ((value == 2) && (pass <= 1))	/* space */	\
			{						\
			uchar * tmp;					\
			while (*p && (CZ_SORT_TABLE[pass][*p] == 2))	\
				p++;		/* skip all spaces */	\
			tmp = p;					\
			if (pass == 0)	pass = 1;			\
			else		pass = 0;			\
			p = store; store = tmp;				\
			break;						\
			}						\
		if (value == 255)					\
			{						\
			char ch = *p;					\
			char nextch;					\
			if ((p - src) < len) nextch = *(p + 1);		\
			else nextch = '\x0';				\
			if (ch == 'c')					\
				{					\
				if (nextch == 'h')			\
					{				\
					value = CZ_SORT_VALUE_ch[pass];	\
					p++;				\
					}				\
				else value = CZ_SORT_VALUE_c[pass];	\
				}					\
			else if (ch == 'C')				\
				{					\
				if (nextch == 'h')			\
					{				\
					value = CZ_SORT_VALUE_Ch[pass];	\
					p++;				\
					}				\
				else if (nextch == 'H')			\
					{				\
					value = CZ_SORT_VALUE_Ch[pass];	\
					p++;				\
					}				\
				else value = CZ_SORT_VALUE_C[pass];	\
				}					\
			}						\
		p++;							\
		break;							\
		}



#define OLD_NEXT_CMP_VALUE(src, p, store, pass, value)			\
	while (*p && ((value = CZ_SORT_TABLE[pass][*p]) == 0))		\
		p++;				/* skip ignores */	\
	if (*p)								\
		{							\
		if ((value == 2) && (pass <= 1))			\
			{			/* end of word */	\
			uchar * tmp;					\
			value = 2;					\
			while (*p && (CZ_SORT_TABLE[pass][*p] <= 2))	\
				p++;					\
			tmp = p;					\
			if (pass == 0)	pass = 1; 			\
			else		pass = 0;			\
			p = store; store = tmp;				\
			}						\
		else if (value == 255)					\
			{						\
			char ch = *p;					\
			char nextch;					\
			p++;						\
			nextch = *p;					\
			if (ch == 'c')					\
				{					\
				if (nextch == 'h')			\
					value = CZ_SORT_VALUE_ch[pass];	\
				else					\
					{				\
					value = CZ_SORT_VALUE_c[pass];	\
					p--;				\
					}				\
				}					\
			else if (ch == 'C')				\
				{					\
				if (nextch == 'h')			\
					value = CZ_SORT_VALUE_Ch[pass];	\
				else if (nextch == 'H')			\
					value = CZ_SORT_VALUE_CH[pass];	\
				else					\
					{				\
					value = CZ_SORT_VALUE_C[pass];	\
						p--;			\
					}				\
				}					\
			else	p--;					\
			p++;						\
			}						\
		else							\
			p++;						\
		}							\
	else								\
		value = 0;

#define OLD_NEXT_CMP_VALUE_WITH_LEN(src, p, store, pass, value, len)	\
	while (((p-src) < len) && ((value = CZ_SORT_TABLE[pass][*p]) == 0))	\
		p++;				/* skip ignores */	\
	if ((p-src) < len)						\
		{							\
		if ((value == 2) && (pass <= 1))			\
			{			/* end of word */	\
			uchar * tmp;					\
			value = 2;					\
			while (((p-src) < len) && (CZ_SORT_TABLE[pass][*p] <= 2))	\
				p++;					\
			tmp = p;					\
			if (pass == 0)	pass = 1; 			\
			else		pass = 0;			\
			p = store; store = tmp;				\
			}						\
		else if (value == 255)					\
			{						\
			char ch = *p;					\
			char nextch;					\
			p++;						\
			nextch = *p;					\
			if ((p-src) < len) nextch = '\x0';		\
			if (ch == 'c')					\
				{					\
				if (nextch == 'h')			\
					value = CZ_SORT_VALUE_ch[pass];	\
				else					\
					{				\
					value = CZ_SORT_VALUE_c[pass];	\
					p--;				\
					}				\
				}					\
			else if (ch == 'C')				\
				{					\
				if (nextch == 'h')			\
					value = CZ_SORT_VALUE_Ch[pass];	\
				else if (nextch == 'H')			\
					value = CZ_SORT_VALUE_CH[pass];	\
				else					\
					{				\
					value = CZ_SORT_VALUE_C[pass];	\
						p--;			\
					}				\
				}					\
			else	p--;					\
			p++;						\
			}						\
		else							\
			p++;						\
		}							\
	else								\
		value = 0;


unsigned int MY_STRXFRM_MULTIPLY=4;

/* This is original strcoll, with Czech sorting. */
int my_strcoll(uchar * s1, uchar * s2)
	{
	int v1, v2;
	uchar * p1, * p2, * store1, * store2;
	int pass1 = 0, pass2 = 0;
	int diff;

	p1 = s1;	p2 = s2;
	store1 = s1;	store2 = s2;

	do
		{
		NEXT_CMP_VALUE(s1, p1, store1, pass1, v1);
		NEXT_CMP_VALUE(s2, p2, store2, pass2, v2);
		diff = v1 - v2;
		if (diff != 0)		return diff;
		}
	while (v1);
	return 0;
	}

/* This is "strnncoll" that expects length of strings to be compared */
int my_strnncoll(uchar * s1, int len1, uchar * s2, int len2)
	{
	int v1, v2;
	uchar * p1, * p2, * store1, * store2;
	int pass1 = 0, pass2 = 0;
	int diff;

	p1 = s1;	p2 = s2;
	store1 = s1;	store2 = s2;

#ifdef DEBUG_CZECH_SORT
fprintf(stderr, "My_strnncoll:\nS1 %-*.*s, s2 %-*.*s; Len1 %d, len2 %d\n", len1, len1, s1, len2, len2, s2, len1, len2);
/* fprintf(stderr, "My_strnncoll:\nLen1 %d, len2 %d\n", len1, len2); */
#endif

	do
		{
		NEXT_CMP_VALUE_WITH_LEN(s1, p1, store1, pass1, v1, len1);
		NEXT_CMP_VALUE_WITH_LEN(s2, p2, store2, pass2, v2, len2);
		diff = v1 - v2;

#ifdef DEBUG_CZECH_SORT
fprintf(stderr, "Dist1 %d, dist2 %d; v1 %d, v2 %d; pass1 %d, pass2 %d; diff %d\n", (p1 - s1), (p2 - s2), v1, v2, pass1, pass2, diff);
#endif

		if (diff != 0)		return diff;
		}
	while (v1);
	return 0;
	}

/* This is in fact the original 4-pass strxfrm suited for correct
Czech sorting */

int my_strnxfrm(uchar * dest, uchar * src, int len, int srclen)
	{
	int value;
	uchar * p, * store;
	int pass = 0;
	int totlen = 0;
	p = src;	store = src;

#ifdef DEBUG_CZECH_SORT
fprintf(stderr, "My_strnxfrm:\nString %-*.*s; len %d\n", src, srclen, srclen, srclen);
#endif

	do
		{
		NEXT_CMP_VALUE_WITH_LEN(src, p, store, pass, value, srclen);
		ADD_TO_RESULT(dest, len, totlen, value);

#ifdef DEBUG_CZECH_SORT
fprintf(stderr, "Dist %d; value %d; pass %d\n", (p - src), value, pass);
#endif

		}
	while (value);
	return totlen;
	}

int my_strxfrm(uchar * dest, uchar * src, int len)
	{
	int value;
	uchar * p, * store;
	int pass = 0;
	int totlen = 0;
	p = src;	store = src;

	do
		{
		NEXT_CMP_VALUE(src, p, store, pass, value);
		ADD_TO_RESULT(dest, len, totlen, value);
		}
	while (value);
	return totlen;
	}

/*
	Neformln popis algoritmu:

	prochzme etzec zleva doprava
	konec etzce poznme podle *p == 0
	pokud jsme doli na konec etzce pi prchodu 0, nejdeme na
		zatek, ale na uloenou pozici, protoe prvn a druh
		prchod b souasn
	konec vstupu (prchodu) ozname na vstupu hodnotou 1

	nateme hodnotu z tdc tabulky
	jde-li o hodnotu ignorovat (0), skome na dal prchod
	jde-li o hodnotu konec slova (2) a je to prchod 0 nebo 1,
		peskome vechny dal 0 -- 2 a prohodme
		prchody
	jde-li o kompozitn znak (255), otestujeme, zda nsleduje
		sprvn do dvojice, dohledme sprvnou hodnotu
	
	na konci pipojme znak 0
 */

unsigned int my_sort_prefix_length(char * str, unsigned int length)
{
  int value = 0;
  char * p = str;
  while ((p - str) < length)
  {
    value = CZ_SORT_TABLE[0][*p];
    if ((value <= 1) || (value == 255))
      return value;
    p++;
  }
  return value;
}

#define REAL_MYSQL
#ifdef REAL_MYSQL
/* This is a latin2 file */

/*
 * File generated by cset
 * (C) Abandoned 1997 Zarko Mocnik <zarko.mocnik@dem.si>
 *
 * definition table reworked by Jaromir Dolecek <dolecek@ics.muni.cz>
 */
#include <global.h>
#include "m_string.h"

uchar NEAR ctype_czech[257] = {
0,
 32, 32, 32, 32, 32, 32, 32, 32, 32, 40, 40, 40, 40, 40, 32, 32,
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
 72, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
132,132,132,132,132,132,132,132,132,132, 16, 16, 16, 16, 16, 16,
 16,129,129,129,129,129,129,  1,  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 16, 16, 16, 16,
 16,130,130,130,130,130,130,  2,  2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, 16, 16, 16, 16, 32,
 32, 32, 32, 32, 32, 32, 32, 32, 40, 40, 40, 40, 40, 32, 32, 32,
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 72,
  1, 16,  1, 16,  1,  1, 16,  0,  0,  1,  1,  1,  1, 16,  1,  1,
 16,  2, 16,  2, 16,  2,  2, 16, 16,  2,  2,  2,  2, 16,  2,  2,
  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
 16,  1,  1,  1,  1,  1,  1, 16,  1,  1,  1,  1,  1,  1,  1, 16,
  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2, 16,  2,  2,  2,  2,  2,  2,  2, 16,
};

uchar NEAR to_lower_czech[] = {
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
 64, 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,
112,113,114,115,116,117,118,119,120,121,122, 91, 92, 93, 94, 95,
 96, 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,
112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
177,161,179,163,181,182,166,167,168,185,186,187,188,173,190,191,
176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
208,241,242,243,244,245,246,215,248,249,250,251,252,253,254,223,
224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,
};

uchar NEAR to_upper_czech[] = {
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
 96, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90,123,124,125,126,127,
128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
176,160,178,162,180,164,165,183,184,169,170,171,172,189,174,175,
192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
240,209,210,211,212,213,214,247,216,217,218,219,220,221,222,255,
};

uchar NEAR sort_order_czech[] = {
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
 64, 65, 71, 72, 76, 78, 83, 84, 85, 86, 90, 91, 92, 96, 97,100,
105,106,107,110,114,117,122,123,124,125,127,131,132,133,134,135,
136, 65, 71, 72, 76, 78, 83, 84, 85, 86, 90, 91, 92, 96, 97,100,
105,106,107,110,114,117,122,123,124,125,127,137,138,139,140,  0,
  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16,
 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,255,
 66,255, 93,255, 94,111,255,255,255,112,113,115,128,255,129,130,
255, 66,255, 93,255, 94,111,255,255,112,113,115,128,255,129,130,
108, 67, 68, 69, 70, 95, 73, 75, 74, 79, 81, 82, 80, 89, 87, 77,
255, 98, 99,101,102,103,104,255,109,119,118,120,121,126,116,255,
108, 67, 68, 69, 70, 95, 73, 75, 74, 79, 81, 82, 80, 89, 88, 77,
255, 98, 99,101,102,103,104,255,109,119,118,120,121,126,116,255,
};

#endif

