#!/my/gnu/bin/perl

# This is a test with stores big records in a blob

$host= shift || "";
$test_db="test";

use Mysql;
$|= 1;				# Autoflush

$table="test_$$";
$rows=6;

print "Connection to database $test_db\n";

$dbh = Mysql->Connect($host) || die "Can't connect: $Mysql::db_errstr\n";
$dbh->SelectDB($test_db) || die "Can't use database $test_db: $Mysql::db_errstr\n";

print "Creating table $table\n";

($dbh->Query("\
CREATE TABLE $table (
  auto int(5) unsigned NOT NULL DEFAULT '0' auto_increment,
  text blob,
  PRIMARY KEY (auto))"))  or die $Mysql::db_errstr;

print "Inserting $rows records\n";

for ($i=0 ; $i < $rows ; $i++)
{
  $tmp= chr(65+$i) x ($i*10000+1);
  $dbh->Query("insert into $table (text) values ('$tmp')") or die $Mysql::db_errstr;
}

print "Testing records\n";

$sth=$dbh->Query("select * from $table");

die "Didn't get all rows from server" if ($sth->numrows != $rows);

for ($i=0 ; $i < $rows ; $i++)
{
  @row = $sth->FetchRow();
# print $row[0]," ",length($row[1]),"\n";
  die "Record $i had wrong data in blob" if ($row[1] ne (chr(65+$i)) x ($i*10000+1));
}

$dbh->Query("drop table $table") or die $Mysql::db_errstr;

print "Test ok\n";
exit 0;
