#ifndef _XIRCDCCCHATFRAME_H
#define _XIRCDCCCHATFRAME_H

#include <xResources.h>
#include "xMultiLineFrame.h"
#include "xIrcDccSocket.h"
#include "xDialog.h"

class xIrcDccChatFrame : public xDialog
{
   Q_OBJECT

public:
   xIrcDccChatFrame(xWidgetResInfo *pPRes, QWidget *pParent = NULL,
                    const char *pName = NULL);
   struct sockaddr_in socketName() { return(pSocket->socketName()); };
   connectTo(const char *pNetAddr = NULL);
   xSocketTCP *socket();
   accept();

signals:
   void connStatus(int err);
   void connProgress(const char *);
   void connFailed(int err);
   void connGood(int sock);
   void textOut(const char *);
   void textSelected(xMultiLineTextSelection txt);
   void initiateDCCChat(xIrcDccChatFrame*);

protected slots:
   virtual void gotKeyboardInput();
   virtual void buttonPressed(int btn);
   virtual void socketIn(char *pData);
   void haveTextSelection(xMultiLineTextSelection);

private slots:
   void sockStatus(int err);
   void failedConnection(int err);
   void goodConnection(int sock);
   void socketClosed();

protected:
   enum btnCodes { btnClose, btnClear };
   virtual void resizeEvent(QResizeEvent *pEvt);

private:
   void closeFrame();
   void clearLine();
   void parseMsgSpecial(const char *pStr);
   void procCommand(char *pStr);

   QString           socketData;
   QString           strSocket;
   xIrcDccSocket     *pSocket;
   xPshBtnFrame      *pButtons;
   xMultiLineFrame   *pMsgFrame;
   xEdit             *pEdit;
   int               resizeCnt;
   xWidgetResInfo    *wdtRes;
};

#endif
