/*
** Copyright (C) 1995, 1996  Joseph Croft <jcroft@unicomp.net>  
** xIrcDispatchEntry.h Message Dispatch Entry class used for keeping commands
** and thier responses going to the right widgets.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef "_xIRCMSGDISPATCHENTRY_H"
#define "_xIRCMSGDISPATCHENTRY_H"

#include "xIrcSocket.h"

class xIrcMsgDispatchEntry
{
   Q_OBJECT

public:
   xIrcMsgDispatchEntry(QWidget *p_Widget, const char *p_Slot,
                         xIrcMessage *p_Msg, bool &accepted);
   ~xIrcMsgDispatchEntry();
   bool is(xIrcMessage *pMsg);
   bool dispatchResponse(xIrcMessage *pMsg);

signals:
   void gotResponse(pMsg);

private:
   QString     slot;
   xIrcMessage msg;
   QWidget     *pWidget;
   int         *pResponseList;
};

